/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.GroupNode;
import TES4Gecko.Main;
import TES4Gecko.Plugin;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginNode;
import TES4Gecko.PluginRecord;
import TES4Gecko.RecordNode;
import TES4Gecko.StatusDialog;
import TES4Gecko.WorkerDialog;
import TES4Gecko.WorkerTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTask
extends WorkerTask {
    private PluginNode pluginNodeA;
    private Map<Integer, RecordNode> recordMapA;
    private PluginNode pluginNodeB;
    private Map<Integer, RecordNode> recordMapB;

    public CompareTask(StatusDialog statusDialog, PluginNode pluginNodeA, PluginNode pluginNodeB) {
        super(statusDialog);
        this.pluginNodeA = pluginNodeA;
        this.pluginNodeB = pluginNodeB;
    }

    public static boolean comparePlugins(JFrame parent, PluginNode pluginNodeA, PluginNode pluginNodeB) {
        boolean completed = false;
        String text = "Comparing '" + pluginNodeA.getPlugin().getName() + "' and '" + pluginNodeB.getPlugin().getName() + "'";
        StatusDialog statusDialog = new StatusDialog(parent, text, "Compare Plugins");
        CompareTask worker = new CompareTask(statusDialog, pluginNodeA, pluginNodeB);
        statusDialog.setWorker(worker);
        worker.start();
        statusDialog.showDialog();
        if (statusDialog.getStatus() == 1) {
            completed = true;
        } else {
            JOptionPane.showMessageDialog(parent, "Unable to compare plugins", "Compare Plugins", 1);
        }
        return completed;
    }

    @Override
    public void run() {
        boolean completed = false;
        int currentProgress = 0;
        int processedCount = 0;
        try {
            int newProgress;
            GroupNode groupNode;
            this.recordMapA = this.buildRecordMap(this.pluginNodeA);
            int totalCount = this.pluginNodeA.getChildCount();
            this.recordMapB = this.buildRecordMap(this.pluginNodeB);
            totalCount += this.pluginNodeB.getChildCount();
            this.pluginNodeA.setDistinctPaths(new ArrayList<TreePath>(100));
            int groupCount = this.pluginNodeA.getChildCount();
            int i = 0;
            while (i < groupCount) {
                groupNode = (GroupNode)this.pluginNodeA.getChildAt(i);
                this.compareGroupChildren(this.pluginNodeA, groupNode, this.recordMapB);
                if (CompareTask.interrupted()) {
                    throw new InterruptedException("Request canceled");
                }
                if ((newProgress = ++processedCount * 100 / totalCount) > currentProgress + 5) {
                    currentProgress = newProgress;
                    this.getStatusDialog().updateProgress(currentProgress);
                }
                ++i;
            }
            this.pluginNodeB.setDistinctPaths(new ArrayList<TreePath>(100));
            groupCount = this.pluginNodeB.getChildCount();
            i = 0;
            while (i < groupCount) {
                groupNode = (GroupNode)this.pluginNodeB.getChildAt(i);
                this.compareGroupChildren(this.pluginNodeB, groupNode, this.recordMapA);
                if (CompareTask.interrupted()) {
                    throw new InterruptedException("Request canceled");
                }
                if ((newProgress = ++processedCount * 100 / totalCount) > currentProgress + 5) {
                    currentProgress = newProgress;
                    this.getStatusDialog().updateProgress(currentProgress);
                }
                ++i;
            }
            completed = true;
        }
        catch (InterruptedException exc) {
            WorkerDialog.showMessageDialog(this.getStatusDialog(), "Request canceled", "Interrupted", 0);
        }
        catch (Throwable exc) {
            Main.logException("Exception while comparing plugins", exc);
        }
        this.getStatusDialog().closeDialog(completed);
    }

    private Map<Integer, RecordNode> buildRecordMap(PluginNode pluginNode) {
        Plugin plugin = pluginNode.getPlugin();
        HashMap<Integer, RecordNode> recordMap = new HashMap<Integer, RecordNode>(plugin.getRecordCount());
        int count = pluginNode.getChildCount();
        int i = 0;
        while (i < count) {
            TreeNode node = pluginNode.getChildAt(i);
            if (!(node instanceof GroupNode)) {
                throw new UnsupportedOperationException("Top-level node is not a group");
            }
            this.mapGroupRecords((GroupNode)node, recordMap);
            ++i;
        }
        return recordMap;
    }

    private void mapGroupRecords(GroupNode groupNode, Map<Integer, RecordNode> recordMap) {
        int count = groupNode.getChildCount();
        int i = 0;
        while (i < count) {
            TreeNode node = groupNode.getChildAt(i);
            if (node instanceof GroupNode) {
                this.mapGroupRecords((GroupNode)node, recordMap);
            } else if (node instanceof RecordNode) {
                RecordNode recordNode = (RecordNode)node;
                PluginRecord record = recordNode.getRecord();
                if (!record.isIgnored()) {
                    recordMap.put(new Integer(record.getFormID()), recordNode);
                }
            } else {
                throw new UnsupportedOperationException("Child node is not a group or record node");
            }
            ++i;
        }
    }

    private void compareGroupChildren(PluginNode pluginNode, GroupNode groupNode, Map<Integer, RecordNode> recordMap) {
        boolean expandGroup = false;
        List<TreePath> distinctPaths = pluginNode.getDistinctPaths();
        int distinctCount = distinctPaths.size();
        int childCount = groupNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            TreeNode node = groupNode.getChildAt(i);
            if (node instanceof GroupNode) {
                this.compareGroupChildren(pluginNode, (GroupNode)node, recordMap);
            } else if (node instanceof RecordNode) {
                RecordNode recordNode = (RecordNode)node;
                PluginRecord record = recordNode.getRecord();
                if (record.isIgnored()) {
                    recordNode.setDistinct(true);
                } else {
                    RecordNode cmpNode = recordMap.get(new Integer(record.getFormID()));
                    if (cmpNode == null || !recordNode.equals(cmpNode)) {
                        recordNode.setDistinct(true);
                    } else {
                        TreeNode[] cmpPath;
                        TreeNode[] path = recordNode.getPath();
                        if (path.length != (cmpPath = cmpNode.getPath()).length) {
                            recordNode.setDistinct(true);
                        } else {
                            int j = 0;
                            while (j < path.length) {
                                if (!(path[j] instanceof GroupNode)) break;
                                PluginGroup group = ((GroupNode)path[j]).getGroup();
                                byte[] groupLabel = group.getGroupLabel();
                                PluginGroup cmpGroup = ((GroupNode)cmpPath[j]).getGroup();
                                byte[] cmpGroupLabel = cmpGroup.getGroupLabel();
                                if (group.getGroupType() != cmpGroup.getGroupType() || groupLabel[0] != cmpGroupLabel[0] || groupLabel[1] != cmpGroupLabel[1] || groupLabel[2] != cmpGroupLabel[2] || groupLabel[3] != cmpGroupLabel[3]) {
                                    recordNode.setDistinct(true);
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                }
                if (recordNode.isDistinct()) {
                    expandGroup = true;
                    TreeNode parentNode = recordNode;
                    while ((parentNode = parentNode.getParent()) != null) {
                        GroupNode parentGroup;
                        if (!(parentNode instanceof GroupNode) || (parentGroup = (GroupNode)parentNode).isDistinct()) break;
                        parentGroup.setDistinct(true);
                    }
                }
            }
            ++i;
        }
        if (expandGroup && distinctPaths.size() == distinctCount) {
            Object[] pathNodes = groupNode.getPath();
            TreePath treePath = new TreePath(pathNodes);
            distinctPaths.add(treePath);
        }
    }
}

