/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.CellMusicDialog;
import TES4Gecko.ComparisonCode;
import TES4Gecko.DialogueTypeCode;
import TES4Gecko.DisplayPlugin;
import TES4Gecko.DisplaySubrecordDialog;
import TES4Gecko.ESPFileFilter;
import TES4Gecko.EditDialog;
import TES4Gecko.EmotionCode;
import TES4Gecko.FormAdjust;
import TES4Gecko.FormInfo;
import TES4Gecko.FunctionCode;
import TES4Gecko.FunctionInfo;
import TES4Gecko.GroupNode;
import TES4Gecko.Main;
import TES4Gecko.Master;
import TES4Gecko.Plugin;
import TES4Gecko.PluginColorMap;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginNode;
import TES4Gecko.PluginRecord;
import TES4Gecko.PluginSubrecord;
import TES4Gecko.RecordNode;
import TES4Gecko.SaveTask;
import TES4Gecko.SerializedElement;
import TES4Gecko.TextFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.DataFormatException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayDialog
extends DisplayPlugin
implements ActionListener,
TreeExpansionListener {
    private Plugin plugin;
    private PluginNode pluginNode;
    private File pluginFile;
    private DefaultTreeModel pluginTreeModel;
    private JTree pluginTree;
    private boolean pluginModified = false;
    private int masterCount;
    private JTextField searchField;
    private FormInfo searchFormInfo;
    private JCheckBox copyReferencesField;
    private JButton savePluginBtn;
    private JButton saveClipboardBtn;
    private JButton saveClipboardAsBtn;
    private JButton clearClipboardBtn;
    private JButton findBtn;
    private JButton findNextBtn;
    private JLabel clipboardFileLabel;
    private int pluginHighFormID = 0;
    private int clipboardHighFormID = 0;
    private final String dumpDialogueHeader = "TES4GECKO DIALOGUE DUMP";
    private final String commentStart = "//";
    private final String masterModReportHeader = "TES4GECKO MASTER ALTERATION REPORT";
    private final String formIDReportHeader = "TES4GECKO FORM ID REPORT";
    private final String noDialogueStr = "[No dialogue]";
    private final String HELLOSeparatorStr = "ABOVE HERE ARE GREETINGS THAT CAN LINK TO OTHER GREETINGS";
    private List<PluginRecord> raceList = null;
    private MouseListener mlClipboard;
    private MouseListener mlPlugin;

    public DisplayDialog(JFrame parent, File pluginFile, PluginNode pluginNode) {
        super(parent, "Display " + pluginFile.getName());
        this.pluginFile = pluginFile;
        this.pluginNode = pluginNode;
        this.plugin = pluginNode.getPlugin();
        List<FormInfo> formList = this.plugin.getFormList();
        pluginNode.setFormAdjust(new FormAdjust());
        List<String> masterList = this.plugin.getMasterList();
        ArrayList<String> clipboardMasterList = new ArrayList<String>(this.plugin.getMasterList());
        this.masterCount = masterList.size();
        String pluginName = pluginFile.getName();
        if (this.plugin.isMaster()) {
            clipboardMasterList.add(pluginName);
        }
        this.clipboardFile = new File(String.valueOf(pluginFile.getParent()) + Main.fileSeparator + "Gecko Clipboard.esp");
        this.clipboard = new Plugin(this.clipboardFile, this.plugin.getCreator(), this.plugin.getSummary(), clipboardMasterList);
        this.clipboard.setVersion(this.plugin.getVersion());
        this.clipboard.createInitialGroups();
        int formCount = 0;
        for (FormInfo formInfo : formList) {
            if (formInfo.getFormID() >>> 24 < this.masterCount) continue;
            ++formCount;
        }
        this.clipboardHighFormID = this.pluginHighFormID = this.highestFormID(this.plugin);
        String highFormID = String.format("%08X", this.pluginHighFormID);
        JLabel countLabel = new JLabel("<html>Plugin record count: " + formList.size() + "<br>Plugin form ID count: " + formCount + " [" + String.format("%X", formCount) + " hex]" + "<br>Plugin high form ID (hex): " + highFormID + "</html>");
        JPanel countPane = new JPanel();
        countPane.setBackground(Main.backgroundColor);
        countPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        countPane.add(countLabel);
        countPane.setPreferredSize(new Dimension(200, 30));
        Object[] masterNames = new Object[]{"Index", "Master"};
        Object[][] masterData = new Object[this.masterCount][2];
        int i = 0;
        while (i < this.masterCount) {
            masterData[i][0] = String.format("%02X", i);
            masterData[i][1] = masterList.get(i);
            ++i;
        }
        PluginColorMap.setColorMap(masterList.size());
        JTable masterTable = new JTable(masterData, masterNames);
        masterTable.setColumnSelectionAllowed(false);
        masterTable.setRowSelectionAllowed(false);
        masterTable.getColumnModel().getColumn(0).setMaxWidth(45);
        masterTable.setAutoResizeMode(3);
        masterTable.setPreferredScrollableViewportSize(new Dimension(200, masterTable.getRowHeight() * Math.max(this.masterCount, 1)));
        masterTable.setDefaultRenderer(Object.class, new PluginColorTableRenderer());
        JScrollPane masterScrollPane = new JScrollPane(masterTable);
        masterScrollPane.getViewport().setBackground(Main.backgroundColor);
        JLabel searchLabel = new JLabel("General Search");
        searchLabel.setHorizontalAlignment(0);
        searchLabel.setAlignmentX(0.5f);
        this.searchField = new JTextField(20);
        this.searchField.setActionCommand("find editor id");
        this.searchField.addActionListener(this);
        JPanel buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        buttonPane.add(Box.createGlue());
        this.findBtn = new JButton("Find");
        this.findBtn.setActionCommand("find editor id");
        this.findBtn.addActionListener(this);
        buttonPane.add(this.findBtn);
        buttonPane.add(Box.createHorizontalStrut(10));
        this.findNextBtn = new JButton("Find Next");
        this.findNextBtn.setActionCommand("find next editor id");
        this.findNextBtn.addActionListener(this);
        buttonPane.add(this.findNextBtn);
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                int key = evt.getKeyCode();
                if (key != 10) {
                    DisplayDialog.this.findNextBtn.setEnabled(false);
                } else {
                    DisplayDialog.this.findBtn.doClick();
                }
            }
        });
        buttonPane.add(Box.createGlue());
        JRadioButton editIDBtn = new JRadioButton("Editor ID", true);
        JRadioButton formIDBtn = new JRadioButton("Form ID", false);
        JRadioButton nameIDBtn = new JRadioButton("Item Name", false);
        JRadioButton XYCoordBtn = new JRadioButton("XY Coordinates", false);
        JRadioButton ownerBtn = new JRadioButton("Ownership", false);
        JRadioButton refBaseBtn = new JRadioButton("Ref Base ID", false);
        JRadioButton responseTextBtn = new JRadioButton("Response Text", false);
        JRadioButton scriptTextBtn = new JRadioButton("Script Text", false);
        JRadioButton questRefBtn = new JRadioButton("Quest Ref ID", false);
        JRadioButton landTexBtn = new JRadioButton("Land Tex ID", false);
        formIDBtn.setBackground(Main.backgroundColor);
        editIDBtn.setBackground(Main.backgroundColor);
        nameIDBtn.setBackground(Main.backgroundColor);
        XYCoordBtn.setBackground(Main.backgroundColor);
        ownerBtn.setBackground(Main.backgroundColor);
        refBaseBtn.setBackground(Main.backgroundColor);
        responseTextBtn.setBackground(Main.backgroundColor);
        scriptTextBtn.setBackground(Main.backgroundColor);
        questRefBtn.setBackground(Main.backgroundColor);
        landTexBtn.setBackground(Main.backgroundColor);
        ButtonGroup bgroup = new ButtonGroup();
        editIDBtn.setActionCommand("set editor id search");
        editIDBtn.addActionListener(this);
        bgroup.add(editIDBtn);
        formIDBtn.setActionCommand("set form id search");
        formIDBtn.addActionListener(this);
        bgroup.add(formIDBtn);
        nameIDBtn.setActionCommand("set name id search");
        nameIDBtn.addActionListener(this);
        bgroup.add(nameIDBtn);
        XYCoordBtn.setActionCommand("set XY coordinate search");
        XYCoordBtn.addActionListener(this);
        bgroup.add(XYCoordBtn);
        ownerBtn.setActionCommand("set owner id search");
        ownerBtn.addActionListener(this);
        bgroup.add(ownerBtn);
        refBaseBtn.setActionCommand("set ref base id search");
        refBaseBtn.addActionListener(this);
        bgroup.add(refBaseBtn);
        responseTextBtn.setActionCommand("set response text search");
        responseTextBtn.addActionListener(this);
        bgroup.add(responseTextBtn);
        scriptTextBtn.setActionCommand("set script text search");
        scriptTextBtn.addActionListener(this);
        bgroup.add(scriptTextBtn);
        questRefBtn.setActionCommand("set quest ref id search");
        questRefBtn.addActionListener(this);
        bgroup.add(questRefBtn);
        landTexBtn.setActionCommand("set land tex id search");
        landTexBtn.addActionListener(this);
        bgroup.add(landTexBtn);
        JPanel searchChoicePane = new JPanel(new GridLayout(5, 2));
        searchChoicePane.setBackground(Main.backgroundColor);
        searchChoicePane.add(editIDBtn);
        searchChoicePane.add(formIDBtn);
        searchChoicePane.add(nameIDBtn);
        searchChoicePane.add(XYCoordBtn);
        searchChoicePane.add(ownerBtn);
        searchChoicePane.add(refBaseBtn);
        searchChoicePane.add(responseTextBtn);
        searchChoicePane.add(scriptTextBtn);
        searchChoicePane.add(questRefBtn);
        searchChoicePane.add(landTexBtn);
        JPanel searchFieldPane = new JPanel();
        searchFieldPane.setLayout(new BoxLayout(searchFieldPane, 0));
        searchFieldPane.setBackground(Main.backgroundColor);
        searchFieldPane.add(Box.createHorizontalStrut(7));
        searchFieldPane.add(this.searchField);
        searchFieldPane.add(Box.createHorizontalStrut(7));
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new BoxLayout(searchPane, 1));
        searchPane.setBackground(Main.backgroundColor);
        searchPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        searchPane.add(searchLabel);
        searchPane.add(searchChoicePane);
        searchPane.add(searchFieldPane);
        searchPane.add(buttonPane);
        searchPane.setMaximumSize(new Dimension(200, 80));
        this.copyReferencesField = new JCheckBox("Copy referenced items", this.copyReferences);
        this.copyReferencesField.setBackground(Main.backgroundColor);
        this.copyReferencesField.setActionCommand("copy references");
        this.copyReferencesField.addActionListener(this);
        JPanel copyReferencesPanel = new JPanel(new GridLayout(2, 1));
        copyReferencesPanel.setBackground(Main.backgroundColor);
        copyReferencesPanel.add(this.copyReferencesField);
        JPanel sidePane = new JPanel();
        sidePane.setLayout(new BoxLayout(sidePane, 1));
        sidePane.setBackground(Main.backgroundColor);
        sidePane.add(Box.createGlue());
        sidePane.add(countPane);
        sidePane.add(Box.createVerticalStrut(25));
        sidePane.add(masterScrollPane);
        sidePane.add(Box.createVerticalStrut(25));
        sidePane.add(searchPane);
        sidePane.add(Box.createVerticalStrut(25));
        sidePane.add(Box.createVerticalStrut(25));
        sidePane.add(copyReferencesPanel);
        sidePane.add(Box.createGlue());
        this.pluginTreeModel = new DefaultTreeModel(pluginNode);
        this.pluginTree = new JTree(this.pluginTreeModel);
        this.pluginTree.setCellRenderer(new DisplayCellRenderer());
        this.pluginTree.setScrollsOnExpand(true);
        this.pluginTree.setExpandsSelectedPaths(true);
        this.pluginTree.addTreeExpansionListener(this);
        this.pluginTree.setLargeModel(true);
        JScrollPane pluginScrollPane = new JScrollPane(this.pluginTree);
        pluginScrollPane.setHorizontalScrollBarPolicy(32);
        pluginScrollPane.setVerticalScrollBarPolicy(22);
        pluginScrollPane.setPreferredSize(new Dimension(300, 500));
        JPanel labelPane = new JPanel();
        labelPane.setBackground(Main.backgroundColor);
        labelPane.add(new JLabel(pluginFile.getName()));
        buttonPane = new JPanel(new GridLayout(3, 2, 5, 5));
        buttonPane.setBackground(Main.backgroundColor);
        JButton button = new JButton("Toggle Ignore");
        button.setActionCommand("toggle ignore");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Copy to Clipboard");
        button.setActionCommand("copy record");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Display Subrecord");
        button.setActionCommand("display subrecord");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Delete Subrecord");
        button.setActionCommand("delete subrecord");
        button.addActionListener(this);
        buttonPane.add(button);
        button = new JButton("Display Subrecord As Bytes");
        button.setActionCommand("display subrecord as bytes");
        button.addActionListener(this);
        buttonPane.add(button);
        this.savePluginBtn = new JButton("Save Plugin");
        this.savePluginBtn.setActionCommand("save plugin");
        this.savePluginBtn.addActionListener(this);
        buttonPane.add(this.savePluginBtn);
        JPanel pluginPane = new JPanel();
        pluginPane.setLayout(new BoxLayout(pluginPane, 1));
        pluginPane.setBackground(Main.backgroundColor);
        pluginPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        pluginPane.add(labelPane);
        pluginPane.add(pluginScrollPane);
        pluginPane.add(Box.createVerticalStrut(10));
        pluginPane.add(buttonPane);
        this.setPluginModified(false);
        PluginNode rootNode = new PluginNode(this.clipboard);
        List<PluginGroup> groupList = this.clipboard.getGroupList();
        for (PluginGroup group : groupList) {
            GroupNode groupNode = new GroupNode(group);
            rootNode.insert(groupNode);
        }
        this.clipboardTreeModel = new DefaultTreeModel(rootNode);
        this.clipboardTree = new JTree(this.clipboardTreeModel);
        this.clipboardTree.setScrollsOnExpand(true);
        this.clipboardTree.setSelectionModel(null);
        this.clipboardTree.addTreeExpansionListener(this);
        JScrollPane clipboardScrollPane = new JScrollPane(this.clipboardTree);
        clipboardScrollPane.setHorizontalScrollBarPolicy(32);
        clipboardScrollPane.setVerticalScrollBarPolicy(22);
        clipboardScrollPane.setPreferredSize(new Dimension(300, 500));
        labelPane = new JPanel();
        labelPane.setBackground(Main.backgroundColor);
        this.clipboardFileLabel = new JLabel(this.clipboardFile.getName());
        labelPane.add(this.clipboardFileLabel);
        buttonPane = new JPanel(new GridLayout(3, 2, 5, 5));
        buttonPane.setBackground(Main.backgroundColor);
        this.saveClipboardBtn = new JButton("Save Clipboard To Default");
        this.saveClipboardBtn.setActionCommand("save clipboard to default");
        this.saveClipboardBtn.addActionListener(this);
        buttonPane.add(this.saveClipboardBtn);
        this.clearClipboardBtn = new JButton("Clear Clipboard");
        this.clearClipboardBtn.setActionCommand("clear clipboard");
        this.clearClipboardBtn.addActionListener(this);
        buttonPane.add(this.clearClipboardBtn);
        this.saveClipboardAsBtn = new JButton("Save Clipboard To New");
        this.saveClipboardAsBtn.setActionCommand("save clipboard to new");
        this.saveClipboardAsBtn.addActionListener(this);
        buttonPane.add(this.saveClipboardAsBtn);
        buttonPane.add(Box.createGlue());
        buttonPane.add(Box.createGlue());
        buttonPane.add(Box.createGlue());
        JPanel clipboardPane = new JPanel();
        clipboardPane.setLayout(new BoxLayout(clipboardPane, 1));
        clipboardPane.setBackground(Main.backgroundColor);
        clipboardPane.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, Color.BLACK));
        clipboardPane.add(labelPane);
        clipboardPane.add(clipboardScrollPane);
        clipboardPane.add(Box.createVerticalStrut(10));
        clipboardPane.add(buttonPane);
        this.setClipboardModified(false);
        this.setClipboardCleared(true);
        JPanel treePane = new JPanel();
        treePane.setLayout(new BoxLayout(treePane, 0));
        treePane.setBackground(Main.backgroundColor);
        treePane.add(sidePane);
        treePane.add(Box.createHorizontalStrut(15));
        treePane.add(pluginPane);
        treePane.add(Box.createHorizontalStrut(15));
        treePane.add(clipboardPane);
        buttonPane = new JPanel();
        buttonPane.setBackground(Main.backgroundColor);
        button = new JButton("Done");
        button.setActionCommand("done");
        button.addActionListener(this);
        buttonPane.add(button);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setOpaque(true);
        contentPane.setBackground(Main.backgroundColor);
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.add(treePane);
        contentPane.add(Box.createVerticalStrut(15));
        contentPane.add(buttonPane);
        contentPane.setPreferredSize(new Dimension(975, 650));
        this.setContentPane(contentPane);
        this.addWindowListener(new DialogWindowListener());
        this.mlClipboard = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                JMenuItem item;
                JPopupMenu popup;
                String actionString;
                if (e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isShiftDown()) {
                    return;
                }
                if (e.getButton() != 3) {
                    return;
                }
                int selRow = DisplayDialog.this.clipboardTree.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = DisplayDialog.this.clipboardTree.getPathForLocation(e.getX(), e.getY());
                if (selPath.getLastPathComponent() instanceof PluginNode) {
                    PluginNode plNode = (PluginNode)selPath.getLastPathComponent();
                    if (plNode == null) {
                        return;
                    }
                    Plugin thisPlugin = (Plugin)plNode.getUserObject();
                    if (thisPlugin == null) {
                        return;
                    }
                    String actionString2 = "Popup:Clipboard:PLUG:";
                    JPopupMenu popup2 = new JPopupMenu();
                    JMenuItem item2 = new JMenuItem("Prepare for Lip Synch");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":PrepareLipSynch");
                    popup2.add(item2);
                    popup2.show(DisplayDialog.this.clipboardTree, e.getX(), e.getY());
                }
                if (selPath.getLastPathComponent() instanceof GroupNode) {
                    String recordType = "NotHandled";
                    GroupNode groupNode = (GroupNode)selPath.getLastPathComponent();
                    if (groupNode == null) {
                        return;
                    }
                    PluginGroup pluginGroup = (PluginGroup)groupNode.getUserObject();
                    if (pluginGroup == null) {
                        return;
                    }
                    if (pluginGroup.getGroupType() == 0) {
                        recordType = pluginGroup.getGroupRecordType();
                    }
                    if (pluginGroup.getGroupType() == 7) {
                        recordType = "INFO";
                    }
                    actionString = "Popup:Clipboard:GRUP:" + recordType;
                    if (recordType.equals("DIAL")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Remove selected conditions from responses");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":RemoveCondition");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Remove extraneous quest references");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":RemoveExcessQSTIs");
                        popup.add(item);
                        popup.show(DisplayDialog.this.clipboardTree, e.getX(), e.getY());
                    }
                }
                if (selPath.getLastPathComponent() instanceof RecordNode) {
                    RecordNode recNode = (RecordNode)selPath.getLastPathComponent();
                    if (recNode == null) {
                        return;
                    }
                    PluginRecord pluginRec = (PluginRecord)recNode.getUserObject();
                    if (pluginRec == null) {
                        return;
                    }
                    String pluginRecType = pluginRec.getRecordType();
                    actionString = "Popup:Clipboard:" + pluginRec.getRecordType() + ":" + pluginRec.getFormID();
                    if (pluginRecType.equals("QUST")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Change quest editor ID");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ChangeEditorID");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Change quest form ID (Quest only)");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ChangeFormIDs:QuestOnly");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Change quest form ID (with related INFOS)");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ChangeFormIDs:RelatedInfos");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Change quest form ID (with INFOS & unshared DIALs)");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ChangeFormIDs:UnsharedDials");
                        popup.add(item);
                        popup.show(DisplayDialog.this.clipboardTree, e.getX(), e.getY());
                    }
                    if (pluginRecType.equals("REGN")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Change region editor ID");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ChangeEditorID");
                        popup.add(item);
                        popup.show(DisplayDialog.this.clipboardTree, e.getX(), e.getY());
                    }
                    if (pluginRecType.equals("WRLD")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Change worldspace editor ID");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ChangeEditorID");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Change worldspace form IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ChangeFormIDs");
                        popup.add(item);
                        popup.show(DisplayDialog.this.clipboardTree, e.getX(), e.getY());
                    }
                    if ((pluginRecType.equals("CELL") || pluginRecType.equals("REFR") || pluginRecType.equals("ACRE") || pluginRecType.equals("ACHR")) && pluginRec.hasSubrecordOfType("EDID")) {
                        String recDesc = "";
                        if (pluginRecType.equals("CELL")) {
                            recDesc = "cell";
                        }
                        if (pluginRecType.equals("REFR")) {
                            recDesc = "reference";
                        }
                        if (pluginRecType.equals("ACRE")) {
                            recDesc = "NPC reference";
                        }
                        if (pluginRecType.equals("ACHR")) {
                            recDesc = "creature reference";
                        }
                        JPopupMenu popup3 = new JPopupMenu();
                        JMenuItem item3 = new JMenuItem("Change " + recDesc + " editor ID");
                        item3.addActionListener(DisplayDialog.this);
                        item3.setActionCommand(String.valueOf(actionString) + ":ChangeEditorID");
                        popup3.add(item3);
                        popup3.show(DisplayDialog.this.clipboardTree, e.getX(), e.getY());
                    }
                }
            }
        };
        this.clipboardTree.addMouseListener(this.mlClipboard);
        this.mlPlugin = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                JMenuItem item;
                JPopupMenu popup;
                String actionString;
                if (e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isShiftDown()) {
                    return;
                }
                if (e.getButton() != 3) {
                    return;
                }
                int selRow = DisplayDialog.this.pluginTree.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = DisplayDialog.this.pluginTree.getPathForLocation(e.getX(), e.getY());
                if (selPath.getLastPathComponent() instanceof PluginNode) {
                    PluginNode plNode = (PluginNode)selPath.getLastPathComponent();
                    if (plNode == null) {
                        return;
                    }
                    Plugin thisPlugin = (Plugin)plNode.getUserObject();
                    if (thisPlugin == null) {
                        return;
                    }
                    String actionString2 = "Popup:Plugin:PLUG:";
                    JPopupMenu popup2 = new JPopupMenu();
                    JMenuItem item2 = new JMenuItem("New Form ID Report");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":FormIDReport");
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Master Alteration Report (append)");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":MasterModReport:Append");
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Master Alteration Report (replace)");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":MasterModReport:Replace");
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Toggle ignore on references with given base IDs");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":ToggleRefs:" + selRow);
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Replace reference base IDs");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":ReplaceBaseRefs:" + selRow);
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Replace landscape texture IDs");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":ReplaceLTEXRefs:" + selRow);
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Execute NVIDIA/ATI \"fog fix\"");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":FogFix:" + selRow);
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Change music type for all exterior cells");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":ChangeMusic:" + selRow);
                    popup2.add(item2);
                    popup2.addSeparator();
                    item2 = new JMenuItem("Dump dialogue for entire plugin");
                    item2.addActionListener(DisplayDialog.this);
                    item2.setActionCommand(String.valueOf(actionString2) + ":DumpPluginDialogue:" + selRow);
                    popup2.add(item2);
                    popup2.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                }
                if (selPath.getLastPathComponent() instanceof GroupNode) {
                    String recordType = "NotHandled";
                    GroupNode groupNode = (GroupNode)selPath.getLastPathComponent();
                    if (groupNode == null) {
                        return;
                    }
                    PluginGroup pluginGroup = (PluginGroup)groupNode.getUserObject();
                    if (pluginGroup == null) {
                        return;
                    }
                    if (pluginGroup.getGroupType() == 0) {
                        recordType = pluginGroup.getGroupRecordType();
                    }
                    if (pluginGroup.getGroupType() == 7) {
                        recordType = "INFO";
                    }
                    if (pluginGroup.getGroupType() == 1) {
                        recordType = "WORLDSPACE";
                    }
                    if (pluginGroup.getGroupType() == 6) {
                        recordType = "CELLCONTENTS";
                    }
                    actionString = "Popup:Plugin:GRUP:" + recordType;
                    if (recordType.equals("DIAL")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Read dialogue from file");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReadDialogue");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Remove extraneous quest references");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":RemoveExcessQSTIs");
                        popup.add(item);
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                    if (recordType.equals("CELL")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Show all interior cells");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ShowCells:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Toggle ignore on references with given base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ToggleRefs:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Replace reference base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReplaceBaseRefs:" + selRow);
                        popup.add(item);
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                    if (recordType.equals("WORLDSPACE")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Show all exterior cells in worldspace");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ShowCells:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Toggle ignore on references with given base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ToggleRefs:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Replace reference base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReplaceBaseRefs:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Replace landscape texture IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReplaceLTEXRefs:" + selRow);
                        popup.add(item);
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                    if (recordType.equals("CELLCONTENTS")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Toggle ignore on references with given base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ToggleRefs:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Replace reference base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReplaceBaseRefs:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Replace landscape texture IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReplaceLTEXRefs:" + selRow);
                        popup.add(item);
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                }
                if (selPath.getLastPathComponent() instanceof RecordNode) {
                    JMenuItem item3;
                    String itemString;
                    RecordNode recNode = (RecordNode)selPath.getLastPathComponent();
                    if (recNode == null) {
                        return;
                    }
                    PluginRecord pluginRec = (PluginRecord)recNode.getUserObject();
                    if (pluginRec == null) {
                        return;
                    }
                    boolean isSelected = DisplayDialog.this.pluginTree.isPathSelected(selPath);
                    actionString = "Popup:Plugin:" + pluginRec.getRecordType() + ":" + pluginRec.getFormID();
                    if (pluginRec.getRecordType().equals("NPC_")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Dump NPC dialogue to file (append)");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":DumpDialogue:Append");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Dump NPC dialogue to file (replace)");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":DumpDialogue:Replace");
                        popup.add(item);
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                    if (pluginRec.getRecordType().equals("QUST")) {
                        popup = new JPopupMenu();
                        itemString = isSelected ? "Deselect" : "Select";
                        itemString = String.valueOf(itemString) + " quest and associated INFOs";
                        item3 = new JMenuItem(itemString);
                        item3.addActionListener(DisplayDialog.this);
                        item3.setActionCommand(String.valueOf(actionString) + ":SelectInfos:" + (isSelected ? "Deselect" : "Select"));
                        popup.add(item3);
                        popup.addSeparator();
                        item3 = new JMenuItem("Dump quest dialogue to file (append)");
                        item3.addActionListener(DisplayDialog.this);
                        item3.setActionCommand(String.valueOf(actionString) + ":DumpDialogue:Append");
                        popup.add(item3);
                        popup.addSeparator();
                        item3 = new JMenuItem("Dump Quest dialogue to file (replace)");
                        item3.addActionListener(DisplayDialog.this);
                        item3.setActionCommand(String.valueOf(actionString) + ":DumpDialogue:Replace");
                        popup.add(item3);
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                    if (pluginRec.getRecordType().equals("REGN")) {
                        popup = new JPopupMenu();
                        item = new JMenuItem("Toggle ignore on references with given base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ToggleRefs:");
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Replace reference base IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReplaceBaseRefs:" + selRow);
                        popup.add(item);
                        popup.addSeparator();
                        item = new JMenuItem("Replace landscape texture IDs");
                        item.addActionListener(DisplayDialog.this);
                        item.setActionCommand(String.valueOf(actionString) + ":ReplaceLTEXRefs:" + selRow);
                        popup.add(item);
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                    if (pluginRec.getRecordType().equals("WRLD")) {
                        popup = new JPopupMenu();
                        itemString = isSelected ? "Deselect" : "Select";
                        itemString = String.valueOf(itemString) + " worldspace and associated " + (isSelected ? "objects" : "regions");
                        item3 = new JMenuItem(itemString);
                        item3.addActionListener(DisplayDialog.this);
                        item3.setActionCommand(String.valueOf(actionString) + ":SelectRegions:" + (isSelected ? "Deselect" : "Select"));
                        popup.add(item3);
                        if (!isSelected) {
                            popup.addSeparator();
                            itemString = isSelected ? "Deselect" : "Select";
                            itemString = String.valueOf(itemString) + " worldspace and associated " + (isSelected ? "objects" : "child WLRDs");
                            item3 = new JMenuItem(itemString);
                            item3.addActionListener(DisplayDialog.this);
                            item3.setActionCommand(String.valueOf(actionString) + ":SelectWRLDs:" + (isSelected ? "Deselect" : "Select"));
                            popup.add(item3);
                        }
                        popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                    }
                    if (pluginRec.getRecordType().equals("CELL")) {
                        popup = new JPopupMenu();
                        if (pluginRec.hasSubrecordOfType("XCLC") && selPath.getPath().length == 6) {
                            GroupNode groupNode = (GroupNode)selPath.getPath()[2];
                            if (groupNode == null) {
                                return;
                            }
                            PluginGroup pluginGroup = (PluginGroup)groupNode.getUserObject();
                            if (pluginGroup.getGroupType() != 1) {
                                return;
                            }
                            String WSNodeStr = String.format("%08X", pluginGroup.getGroupParentID());
                            String itemString2 = isSelected ? "Deselect" : "Select";
                            itemString2 = String.valueOf(itemString2) + " cell with persistent references";
                            JMenuItem item4 = new JMenuItem(itemString2);
                            item4.addActionListener(DisplayDialog.this);
                            item4.setActionCommand(String.valueOf(actionString) + ":SelectPersistentRefs:" + (isSelected ? "Deselect:" : "Select:") + WSNodeStr);
                            popup.add(item4);
                            popup.show(DisplayDialog.this.pluginTree, e.getX(), e.getY());
                        }
                    }
                }
            }
        };
        this.pluginTree.addMouseListener(this.mlPlugin);
        if (Main.debugMode) {
            System.out.printf(String.valueOf(pluginFile.getName()) + ": Version " + this.plugin.getVersion() + " loaded with highest FormID used = " + String.format("%08X", this.pluginHighFormID) + "\n", new Object[0]);
        }
    }

    public static void showDialog(JFrame parent, File pluginFile, PluginNode pluginNode) {
        DisplayDialog dialog = new DisplayDialog(parent, pluginFile, pluginNode);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            String action = ae.getActionCommand();
            if (action.startsWith("Popup")) {
                this.popupEventHandler(action);
                return;
            }
            if (action.equals("save plugin")) {
                if (this.pluginModified && SaveTask.savePlugin(this, this.pluginFile, this.plugin)) {
                    this.setPluginModified(false);
                    this.pluginNode = new PluginNode(this.plugin);
                    this.pluginNode.setFormAdjust(new FormAdjust());
                    this.pluginNode.buildNodes(null);
                    this.pluginTree.setModel(new DefaultTreeModel(this.pluginNode));
                }
            } else if (action.equals("save clipboard to default")) {
                if (this.clipboardModified && SaveTask.savePlugin(this, this.clipboardFile, this.clipboard)) {
                    this.setClipboardModified(false);
                    this.validateTree(this.clipboardTree);
                    this.clipboardFileLabel.setText(this.clipboardFile.getName());
                }
            } else if (action.equals("save clipboard to new")) {
                File saveFile;
                if (this.clipboardModified && (saveFile = this.getClipboardSaveFile()) != null && SaveTask.savePlugin(this, saveFile, this.clipboard)) {
                    this.setClipboardModified(false);
                    this.validateTree(this.clipboardTree);
                    ((DefaultTreeModel)this.clipboardTree.getModel()).nodeStructureChanged((PluginNode)this.clipboardTree.getModel().getRoot());
                    this.clipboardFileLabel.setText(saveFile.getName());
                }
            } else if (action.equals("clear clipboard")) {
                if (this.removeAllObjects(this.clipboard) != 0) {
                    this.setClipboardModified(false);
                    this.setClipboardCleared(true);
                    this.clipboardHighFormID = this.pluginHighFormID;
                    this.clipboard.setPluginFile(this.clipboardFile);
                    this.validateTree(this.clipboardTree);
                    ((DefaultTreeModel)this.clipboardTree.getModel()).nodeStructureChanged((PluginNode)this.clipboardTree.getModel().getRoot());
                    this.clipboardFileLabel.setText(this.clipboardFile.getName());
                }
            } else if (action.equals("copy record")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.copyRecords(this.pluginTree);
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.setClipboardModified(this.clipboardModified);
                if (this.clipboardModified) {
                    this.setClipboardCleared(false);
                }
            } else if (action.equals("display subrecord")) {
                this.displaySubrecordData();
            } else if (action.equals("display subrecord as bytes")) {
                this.displaySubrecordDataAsBytes();
            } else if (action.equals("delete subrecord")) {
                this.deleteSubrecords();
            } else if (action.equals("toggle ignore")) {
                if (this.toggleIgnore(this.pluginTree)) {
                    this.setPluginModified(true);
                }
            } else if (action.equals("set form id search")) {
                this.findBtn.setActionCommand("find form id");
                this.searchField.setActionCommand("find form id");
                this.findNextBtn.setEnabled(false);
            } else if (action.equals("set editor id search")) {
                this.findBtn.setActionCommand("find editor id");
                this.searchField.setActionCommand("find editor id");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next editor id");
            } else if (action.equals("set name id search")) {
                this.findBtn.setActionCommand("find name id");
                this.searchField.setActionCommand("find name id");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next name id");
            } else if (action.equals("set owner id search")) {
                this.findBtn.setActionCommand("find owner id");
                this.searchField.setActionCommand("find owner id");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next owner id");
            } else if (action.equals("set ref base id search")) {
                this.findBtn.setActionCommand("find ref base id");
                this.searchField.setActionCommand("find ref base id");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next ref base id");
            } else if (action.equals("set XY coordinate search")) {
                this.findBtn.setActionCommand("find XY coordinates");
                this.searchField.setActionCommand("find XY coordinates");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next XY coordinates");
            } else if (action.equals("set response text search")) {
                this.findBtn.setActionCommand("find response text");
                this.searchField.setActionCommand("find response text");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next response text");
            } else if (action.equals("set script text search")) {
                this.findBtn.setActionCommand("find script text");
                this.searchField.setActionCommand("find script text");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next script text");
            } else if (action.equals("set quest ref id search")) {
                this.findBtn.setActionCommand("find quest ref id");
                this.searchField.setActionCommand("find quest ref id");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next quest ref id");
            } else if (action.equals("set land tex id search")) {
                this.findBtn.setActionCommand("find land tex id");
                this.searchField.setActionCommand("find land tex id");
                this.findNextBtn.setEnabled(false);
                this.searchFormInfo = null;
                this.findNextBtn.setActionCommand("find next land tex id");
            } else if (action.equals("find editor id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findEditorID(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next editor id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findEditorID(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find name id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findNameID(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next name id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findNameID(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find response text")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findResponseText(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next response text")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findResponseText(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find script text")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findScriptText(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next script text")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findScriptText(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find owner id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findOwnerID(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next owner id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findOwnerID(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find ref base id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findRefBaseID(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next ref base id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findRefBaseID(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find quest ref id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findQuestRefID(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next quest ref id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findQuestRefID(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find land tex id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findLandTexID(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next land tex id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findLandTexID(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find XY coordinates")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findXYCoordinates(false));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find next XY coordinates")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findNextBtn.setEnabled(this.findXYCoordinates(true));
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("find form id")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.findFormID();
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (action.equals("copy references")) {
                this.copyReferences = this.copyReferencesField.isSelected();
            } else if (action.equals("done")) {
                this.closeDialog();
                this.setVisible(false);
                this.pluginTree.clearSelection();
                this.clipboardTree.clearSelection();
                this.removeAllObjects(this.clipboard);
                this.removeAllObjects(this.plugin);
                EditDialog.removeAllComponents(this);
                this.clipboardTree.removeMouseListener(this.mlClipboard);
                this.pluginTree.removeMouseListener(this.mlPlugin);
                this.removeAllUserObjects(this.clipboardTree);
                this.removeAllUserObjects(this.pluginTree);
                this.mlClipboard = null;
                this.mlPlugin = null;
                this.clipboardTree.removeTreeExpansionListener(this);
                this.clipboardTree.setModel(null);
                this.clipboardTree = null;
                this.pluginTree.removeTreeExpansionListener(this);
                this.pluginTree.setModel(null);
                this.pluginTree = null;
                this.pluginTreeModel = null;
                this.dispose();
            }
        }
        catch (Throwable exc) {
            Main.logException("Exception while processing action event", exc);
        }
    }

    private void removeAllUserObjects(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.removeAllUserObjects(root);
    }

    private void removeAllUserObjects(TreeNode node) {
        ((DefaultMutableTreeNode)node).setUserObject(null);
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.removeAllUserObjects(n);
            }
        }
    }

    private void findFormID() {
        int formID;
        String text = this.searchField.getText().trim();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return;
        }
        try {
            formID = Integer.parseInt(text, 16);
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, "You must enter a hex number for the form ID", "Enter search term", 0);
            return;
        }
        FormInfo formInfo = null;
        formInfo = this.plugin.getFormMap().get(new Integer(formID));
        if (formInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
        } else {
            this.pluginTree.clearSelection();
            RecordNode recordNode = formInfo.getRecordNode();
            TreePath treePath = new TreePath(recordNode.getPath());
            this.pluginTree.setSelectionPath(treePath);
            this.pluginTree.scrollPathToVisible(treePath);
        }
    }

    private boolean findEditorID(boolean resume) {
        String asteriskLikeWindows;
        String text;
        String text2;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text2 = (text = this.searchField.getText().trim()).replaceAll(asteriskLikeWindows = "([\\w\\s])(\\*)", "$1.$2")).startsWith("*")) {
            text2 = "." + text2;
        }
        if (text2 == null || text2.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        Pattern p = null;
        try {
            p = Pattern.compile(text2, 2);
        }
        catch (PatternSyntaxException exc) {
            JOptionPane.showMessageDialog(this, "'" + text2 + "' is not a valid regular expression", "Invalid regular expression", 0);
        }
        if (p == null) {
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            Matcher m;
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String editorID = formInfo.getEditorID();
            if (editorID == null || editorID.length() <= 0 || !(m = p.matcher(editorID)).matches()) continue;
            this.searchFormInfo = formInfo;
            break;
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findNameID(boolean resume) {
        String asteriskLikeWindows;
        String text;
        String text2;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text2 = (text = this.searchField.getText().trim()).replaceAll(asteriskLikeWindows = "([\\w\\s])(\\*)", "$1.$2")).startsWith("*")) {
            text2 = "." + text2;
        }
        if (text2 == null || text2.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        Pattern p = null;
        try {
            p = Pattern.compile(text2, 2);
        }
        catch (PatternSyntaxException exc) {
            JOptionPane.showMessageDialog(this, "'" + text2 + "' is not a valid regular expression", "Invalid regular expression", 0);
        }
        if (p == null) {
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            Matcher m;
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String nameID = "";
            try {
                Object plugRec = formInfo.getSource();
                if (plugRec != null && plugRec instanceof PluginRecord) {
                    nameID = ((PluginRecord)plugRec).getSubrecord("FULL").getDisplayData();
                }
            }
            catch (Exception plugRec) {
                // empty catch block
            }
            if (nameID == null || nameID.length() <= 0 || !(m = p.matcher(nameID)).matches()) continue;
            this.searchFormInfo = formInfo;
            break;
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findResponseText(boolean resume) {
        String asteriskLikeWindows;
        String text;
        String text2;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text2 = (text = this.searchField.getText().trim()).replaceAll(asteriskLikeWindows = "([\\w\\s])(\\*)", "$1.$2")).startsWith("*")) {
            text2 = "." + text2;
        }
        if (text2 == null || text2.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        Pattern p = null;
        try {
            p = Pattern.compile(text2, 2);
        }
        catch (PatternSyntaxException exc) {
            JOptionPane.showMessageDialog(this, "'" + text2 + "' is not a valid regular expression", "Invalid regular expression", 0);
        }
        if (p == null) {
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        block4: for (FormInfo formInfo : formList) {
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String responseText = "";
            if (!formInfo.getRecordType().equalsIgnoreCase("INFO")) continue;
            try {
                Object plugRec = formInfo.getSource();
                if (plugRec == null || !(plugRec instanceof PluginRecord)) continue;
                List<PluginSubrecord> responseList = ((PluginRecord)plugRec).getAllSubrecords("NAM1");
                for (PluginSubrecord response : responseList) {
                    Matcher m;
                    responseText = response.getDisplayData();
                    if (responseText == null || responseText.length() <= 0 || !(m = p.matcher(responseText)).matches()) continue;
                    this.searchFormInfo = formInfo;
                    continue block4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findScriptText(boolean resume) {
        String asteriskLikeWindows;
        String text;
        String text2;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text2 = (text = this.searchField.getText().trim()).replaceAll(asteriskLikeWindows = "([\\w\\s])(\\*)", "$1.$2")).startsWith("*")) {
            text2 = "." + text2;
        }
        if (text2 == null || text2.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        Pattern p = null;
        try {
            p = Pattern.compile(text2, 2);
        }
        catch (PatternSyntaxException exc) {
            JOptionPane.showMessageDialog(this, "'" + text2 + "' is not a valid regular expression", "Invalid regular expression", 0);
        }
        if (p == null) {
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        block4: for (FormInfo formInfo : formList) {
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String responseText = "";
            if (!formInfo.getRecordType().equalsIgnoreCase("SCPT") && !formInfo.getRecordType().equalsIgnoreCase("QUST") && !formInfo.getRecordType().equalsIgnoreCase("INFO")) continue;
            try {
                Object plugRec = formInfo.getSource();
                if (plugRec == null || !(plugRec instanceof PluginRecord)) continue;
                List<PluginSubrecord> responseList = ((PluginRecord)plugRec).getAllSubrecords("SCTX");
                for (PluginSubrecord response : responseList) {
                    Matcher m;
                    responseText = response.getDisplayData();
                    if (responseText == null || responseText.length() <= 0 || !(m = p.matcher(responseText)).matches()) continue;
                    this.searchFormInfo = formInfo;
                    continue block4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findOwnerID(boolean resume) {
        int ownerID;
        String text;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text = this.searchField.getText().trim()) == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        try {
            ownerID = Integer.parseInt(text, 16);
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, "You must enter a hex number for the owner ID", "Enter search term", 0);
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String ownerIDstr = "";
            Integer ownerIDint = null;
            try {
                Object plugRec = formInfo.getSource();
                if (plugRec != null && plugRec instanceof PluginRecord) {
                    ownerIDstr = ((PluginRecord)plugRec).getSubrecord("XOWN").getDisplayData();
                    ownerIDint = Integer.parseInt(ownerIDstr, 16);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ownerIDint == null || ownerIDint <= 0 || ownerIDint != ownerID) continue;
            this.searchFormInfo = formInfo;
            break;
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findRefBaseID(boolean resume) {
        int refBaseID;
        String text;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text = this.searchField.getText().trim()) == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        try {
            refBaseID = Integer.parseInt(text, 16);
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, "You must enter a hex number for the ref base ID", "Enter search term", 0);
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String refBaseIDstr = "";
            Integer refBaseIDint = null;
            if (!formInfo.getRecordType().equalsIgnoreCase("REFR") && !formInfo.getRecordType().equalsIgnoreCase("ACRE") && !formInfo.getRecordType().equalsIgnoreCase("ACHR")) continue;
            try {
                Object plugRec = formInfo.getSource();
                if (plugRec != null && plugRec instanceof PluginRecord) {
                    refBaseIDstr = ((PluginRecord)plugRec).getSubrecord("NAME").getDisplayData();
                    refBaseIDint = Integer.parseInt(refBaseIDstr, 16);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (refBaseIDint == null || refBaseIDint <= 0 || refBaseIDint != refBaseID) continue;
            this.searchFormInfo = formInfo;
            break;
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findLandTexID(boolean resume) {
        int landTexID;
        String text;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text = this.searchField.getText().trim()) == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        try {
            landTexID = Integer.parseInt(text, 16);
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, "You must enter a hex number for the landscape texture ID", "Enter search term", 0);
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            Object plugRec;
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            if (!formInfo.getRecordType().equalsIgnoreCase("LAND") || (plugRec = formInfo.getSource()) == null || !(plugRec instanceof PluginRecord) || !this.findLandTexIDInLANDRec((PluginRecord)plugRec, landTexID)) continue;
            this.searchFormInfo = formInfo;
            break;
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findQuestRefID(boolean resume) {
        int refBaseID;
        String text;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text = this.searchField.getText().trim()) == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        try {
            refBaseID = Integer.parseInt(text, 16);
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, "You must enter a hex number for the quest ref ID", "Enter search term", 0);
            return false;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String refBaseIDstr = "";
            Integer refBaseIDint = null;
            if (!formInfo.getRecordType().equalsIgnoreCase("DIAL") && !formInfo.getRecordType().equalsIgnoreCase("INFO")) continue;
            try {
                Object plugRec = formInfo.getSource();
                if (plugRec == null || !(plugRec instanceof PluginRecord)) continue;
                boolean foundQuestID = false;
                List<PluginSubrecord> subList = ((PluginRecord)plugRec).getAllSubrecords("QSTI");
                for (PluginSubrecord subrec : subList) {
                    refBaseIDstr = subrec.getDisplayData();
                    refBaseIDint = Integer.parseInt(refBaseIDstr, 16);
                    if (refBaseIDint == null || refBaseIDint <= 0 || refBaseIDint != refBaseID) continue;
                    this.searchFormInfo = formInfo;
                    foundQuestID = true;
                    break;
                }
                if (!foundQuestID) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private boolean findXYCoordinates(boolean resume) {
        String text;
        if (!resume) {
            this.searchFormInfo = null;
        }
        if ((text = this.searchField.getText().trim()) == null || text.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a search term", "Enter search term", 0);
            return false;
        }
        Integer xcoord = null;
        Integer ycoord = null;
        try {
            String[] coords = text.split(",");
            if (coords.length != 2) {
                throw new NumberFormatException("Wrong number of coordinates");
            }
            xcoord = Integer.parseInt(coords[0].trim());
            ycoord = Integer.parseInt(coords[1].trim());
        }
        catch (NumberFormatException exc) {
            ycoord = null;
            xcoord = null;
        }
        if (xcoord == null || ycoord == null) {
            JOptionPane.showMessageDialog(this, "You must enter two integers in the form X, Y; the comma is required.", "Enter search term", 0);
            return false;
        }
        String XYSearch = xcoord + ", " + ycoord;
        List<FormInfo> formList = this.plugin.getFormList();
        for (FormInfo formInfo : formList) {
            if (this.searchFormInfo != null) {
                if (this.searchFormInfo != formInfo) continue;
                this.searchFormInfo = null;
                continue;
            }
            String XY = "";
            if (!formInfo.getRecordType().equalsIgnoreCase("CELL")) continue;
            try {
                Object plugRec = formInfo.getSource();
                if (plugRec != null && plugRec instanceof PluginRecord) {
                    XY = ((PluginRecord)plugRec).getSubrecord("XCLC").getDisplayData();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (XY == null || XY.length() <= 0 || !XYSearch.equalsIgnoreCase(XY)) continue;
            this.searchFormInfo = formInfo;
            break;
        }
        if (this.searchFormInfo == null) {
            JOptionPane.showMessageDialog(this, "No match found for '" + text + "'", "No match found", 0);
            return false;
        }
        this.pluginTree.clearSelection();
        RecordNode recordNode = this.searchFormInfo.getRecordNode();
        TreePath treePath = new TreePath(recordNode.getPath());
        this.pluginTree.setSelectionPath(treePath);
        this.pluginTree.scrollPathToVisible(treePath);
        return true;
    }

    private void closeDialog() {
        int selection;
        if (this.pluginModified && (selection = JOptionPane.showConfirmDialog(this, "The plugin has been modified. Do you want to save the changes?", "Plugin Modified", 0, 3)) == 0) {
            SaveTask.savePlugin(this, this.pluginFile, this.plugin);
        }
        if (this.clipboardModified && (selection = JOptionPane.showConfirmDialog(this, "The clipboard has been modified. Do you want to save the changes?", "Clipboard Modified", 0, 3)) == 0) {
            SaveTask.savePlugin(this, this.clipboardFile, this.clipboard);
        }
    }

    private void setPluginModified(boolean isModified) {
        this.pluginModified = isModified;
        this.savePluginBtn.setEnabled(isModified);
    }

    private void setClipboardModified(boolean isModified) {
        this.clipboardModified = isModified;
        this.saveClipboardBtn.setEnabled(isModified);
        this.saveClipboardAsBtn.setEnabled(isModified);
    }

    private void setClipboardCleared(boolean isCleared) {
        this.clipboardCleared = isCleared;
        this.clearClipboardBtn.setEnabled(!isCleared);
    }

    private void displaySubrecordData() {
        Object userObject;
        DefaultMutableTreeNode node;
        TreePath treePath;
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select a subrecord to display.", "Error", 0);
            return;
        }
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            treePath = treePathArray[n2];
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            if (!(userObject instanceof PluginSubrecord)) {
                JOptionPane.showMessageDialog(this, "Only subrecords may be displayed.", "Error", 0);
                return;
            }
            ++n2;
        }
        treePathArray = treePaths;
        n = treePaths.length;
        n2 = 0;
        while (n2 < n) {
            treePath = treePathArray[n2];
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            DisplaySubrecordDialog.showDialog(this, (PluginSubrecord)userObject);
            ++n2;
        }
    }

    private void displaySubrecordDataAsBytes() {
        Object userObject;
        DefaultMutableTreeNode node;
        TreePath treePath;
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select a subrecord to display.", "Error", 0);
            return;
        }
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            treePath = treePathArray[n2];
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            if (!(userObject instanceof PluginSubrecord)) {
                JOptionPane.showMessageDialog(this, "Only subrecords may be displayed.", "Error", 0);
                return;
            }
            ++n2;
        }
        treePathArray = treePaths;
        n = treePaths.length;
        n2 = 0;
        while (n2 < n) {
            treePath = treePathArray[n2];
            node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            userObject = node.getUserObject();
            DisplaySubrecordDialog.showDialog(this, (PluginSubrecord)userObject, true);
            ++n2;
        }
    }

    private void deleteSubrecords() throws DataFormatException, IOException, PluginException {
        TreePath treePath;
        TreePath[] treePaths = this.pluginTree.getSelectionPaths();
        if (treePaths == null) {
            JOptionPane.showMessageDialog(this, "You must select a subrecord to delete.", "Error", 0);
            return;
        }
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            treePath = treePathArray[n2];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof PluginSubrecord)) {
                JOptionPane.showMessageDialog(this, "Only subrecords may be deleted.", "Error", 0);
                return;
            }
            ++n2;
        }
        treePathArray = treePaths;
        n = treePaths.length;
        n2 = 0;
        while (n2 < n) {
            treePath = treePathArray[n2];
            DefaultMutableTreeNode subrecordNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            RecordNode recordNode = (RecordNode)subrecordNode.getParent();
            PluginRecord record = recordNode.getRecord();
            PluginSubrecord subrecord = (PluginSubrecord)subrecordNode.getUserObject();
            List<PluginSubrecord> subrecords = record.getSubrecords();
            ListIterator<PluginSubrecord> lit = subrecords.listIterator();
            while (lit.hasNext()) {
                PluginSubrecord checkSubrecord = lit.next();
                if (!checkSubrecord.equals(subrecord)) continue;
                lit.remove();
                break;
            }
            record.setSubrecords(subrecords);
            this.setPluginModified(true);
            recordNode.remove(subrecordNode);
            DefaultTreeModel model = (DefaultTreeModel)this.pluginTree.getModel();
            model.nodeStructureChanged(recordNode);
            ++n2;
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        RecordNode recordNode;
        DefaultMutableTreeNode subrecordNode;
        JTree tree = (JTree)event.getSource();
        TreePath treePath = event.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (node instanceof RecordNode && (subrecordNode = (DefaultMutableTreeNode)(recordNode = (RecordNode)node).getFirstChild()).getUserObject() == null) {
            try {
                recordNode.removeAllChildren();
                this.createRecordChildren(recordNode);
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                model.nodeStructureChanged(recordNode);
            }
            catch (Throwable exc) {
                Main.logException("Exception while creating subrecords", exc);
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private List<FormInfo> findAllInfos(Plugin pl) {
        ArrayList<FormInfo> allInfos = new ArrayList<FormInfo>();
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            if (!form.getRecordType().equals("INFO")) continue;
            allInfos.add(form);
        }
        return allInfos;
    }

    private List<FormInfo> findQuestInfos(Plugin pl, int questID) {
        ArrayList<FormInfo> questInfos = new ArrayList<FormInfo>();
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            List<PluginSubrecord> pluginSubrecs;
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("INFO") || (pluginRec = (PluginRecord)form.getSource()) == null) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            for (PluginSubrecord pluginSubrec : pluginSubrecs) {
                byte[] subrecordData;
                if (!pluginSubrec.getSubrecordType().equals("QSTI")) continue;
                try {
                    subrecordData = pluginSubrec.getSubrecordData();
                }
                catch (Exception ex) {
                    continue;
                }
                int infoQuestID = SerializedElement.getInteger(subrecordData, 0);
                if (questID != infoQuestID) continue;
                questInfos.add(form);
            }
        }
        return questInfos;
    }

    private List<FormInfo> findWRLDChildren(Plugin pl, int WSID, boolean selected, boolean regions) {
        ArrayList<FormInfo> WSInfos = new ArrayList<FormInfo>();
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("REGN") && !form.getRecordType().equals("WRLD") || selected && (regions && !form.getRecordType().equals("REGN") || !regions && !form.getRecordType().equals("WRLD")) || (pluginRec = (PluginRecord)form.getSource()) == null) continue;
            try {
                if (!pluginRec.hasSubrecordWithData("WNAM", new Integer(WSID))) continue;
                WSInfos.add(form);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return WSInfos;
    }

    private List<FormInfo> findInfosWithCondition(Plugin pl, int funcCode, int compCode, Object param1, Object param2, float compValue) {
        ArrayList<FormInfo> condInfos = new ArrayList<FormInfo>();
        byte[] byteArray1 = null;
        byte[] byteArray2 = null;
        if (!FunctionCode.isValid(funcCode) || !ComparisonCode.isValid(compCode)) {
            return condInfos;
        }
        try {
            if (param1 != null) {
                byteArray1 = PluginRecord.convertToByteArray(param1);
            }
            if (param2 != null) {
                byteArray2 = PluginRecord.convertToByteArray(param2);
            }
        }
        catch (Exception ex) {
            return condInfos;
        }
        FunctionInfo funcInfo = PluginSubrecord.getFunctionInfo(funcCode);
        if (funcInfo == null) {
            return condInfos;
        }
        if (funcInfo.isFirstReference() && param1 == null) {
            return condInfos;
        }
        if (funcInfo.isSecondReference() && param2 == null) {
            return condInfos;
        }
        boolean usesFirst = funcInfo.isFirstReference();
        boolean usesSecond = funcInfo.isSecondReference();
        List<FormInfo> allForms = pl.getFormList();
        block6: for (FormInfo form : allForms) {
            List<PluginSubrecord> pluginSubrecs;
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("INFO") || (pluginRec = (PluginRecord)form.getSource()) == null) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            for (PluginSubrecord pluginSubrec : pluginSubrecs) {
                if (!pluginSubrec.getSubrecordType().equals("CTDA")) continue;
                try {
                    byte[] subrecordData = pluginSubrec.getSubrecordData();
                    int subCompCode = (subrecordData[0] & 0xF0) >>> 4;
                    int subCompValueInt = SerializedElement.getInteger(subrecordData, 4);
                    float subCompValue = Float.intBitsToFloat(subCompValueInt);
                    int subFuncCode = SerializedElement.getInteger(subrecordData, 8);
                    if (subCompCode != compCode || subFuncCode != funcCode || subCompValue != compValue || usesFirst && SerializedElement.compareArrays(byteArray1, 0, subrecordData, 12, 4) != 0 || usesSecond && SerializedElement.compareArrays(byteArray2, 0, subrecordData, 16, 4) != 0) continue;
                    condInfos.add(form);
                    continue block6;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return condInfos;
    }

    private List<Integer> getNPCsInDialogue(Plugin pl) {
        ArrayList<Integer> NPCList = new ArrayList<Integer>();
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            List<PluginSubrecord> pluginSubrecs;
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("INFO") && !form.getRecordType().equals("QUST") || (pluginRec = (PluginRecord)form.getSource()) == null || pluginRec.isIgnored()) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            for (PluginSubrecord pluginSubrec : pluginSubrecs) {
                if (!pluginSubrec.getSubrecordType().equals("CTDA")) continue;
                try {
                    byte[] subrecordData = pluginSubrec.getSubrecordData();
                    int subFuncCode = SerializedElement.getInteger(subrecordData, 8);
                    int subParam1 = SerializedElement.getInteger(subrecordData, 12);
                    if (subFuncCode != 72 || subParam1 == 20 || NPCList.contains(subParam1)) continue;
                    NPCList.add(subParam1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return NPCList;
    }

    private List<Integer> getNPCsInFactions(Plugin pl, List<Integer> factList) {
        ArrayList<Integer> NPCList = new ArrayList<Integer>();
        PluginGroup npcGroup = pl.getTopGroup("NPC_");
        if (npcGroup == null) {
            return NPCList;
        }
        List<PluginRecord> allNPCs = npcGroup.getAllPluginRecords();
        block4: for (PluginRecord pluginRec : allNPCs) {
            List<PluginSubrecord> pluginSubrecs;
            if (pluginRec == null || pluginRec.isIgnored()) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            for (PluginSubrecord pluginSubrec : pluginSubrecs) {
                if (!pluginSubrec.getSubrecordType().equals("SNAM")) continue;
                try {
                    byte[] subrecordData = pluginSubrec.getSubrecordData();
                    int factID = SerializedElement.getInteger(subrecordData, 0);
                    if (!factList.contains(factID)) continue;
                    NPCList.add(pluginRec.getFormID());
                    continue block4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return NPCList;
    }

    private List<Integer> getFactionsInDialogue(Plugin pl) {
        ArrayList<Integer> factionList = new ArrayList<Integer>();
        ArrayList<Integer> factionsInPlugin = new ArrayList<Integer>();
        List<FormInfo> allForms = pl.getFormList();
        PluginGroup factionGroup = pl.getTopGroup("FACT");
        if (factionGroup == null) {
            return factionList;
        }
        List<PluginRecord> allFactions = factionGroup.getAllPluginRecords();
        if (allFactions.size() == 0) {
            return factionList;
        }
        for (PluginRecord fact : allFactions) {
            factionsInPlugin.add(fact.getFormID());
        }
        for (FormInfo form : allForms) {
            List<PluginSubrecord> pluginSubrecs;
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("INFO") && !form.getRecordType().equals("QUST") || (pluginRec = (PluginRecord)form.getSource()) == null || pluginRec.isIgnored()) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            for (PluginSubrecord pluginSubrec : pluginSubrecs) {
                if (!pluginSubrec.getSubrecordType().equals("CTDA")) continue;
                try {
                    byte[] subrecordData = pluginSubrec.getSubrecordData();
                    int subFuncCode = SerializedElement.getInteger(subrecordData, 8);
                    int subParam1 = SerializedElement.getInteger(subrecordData, 12);
                    if (subFuncCode != 71 || !factionsInPlugin.contains(subParam1)) continue;
                    factionList.add(subParam1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return factionList;
    }

    private int purgeFactions(Plugin pl, List<Integer> factList) {
        int formsAltered = 0;
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            List<PluginSubrecord> pluginSubrecs;
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("INFO") && !form.getRecordType().equals("QUST") && !form.getRecordType().equals("NPC_") || (pluginRec = (PluginRecord)form.getSource()) == null || pluginRec.isIgnored()) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            boolean altered = false;
            ListIterator<PluginSubrecord> lit = pluginSubrecs.listIterator();
            while (lit.hasNext()) {
                int faction;
                byte[] subrecordData;
                PluginSubrecord subrec = lit.next();
                if (!subrec.getSubrecordType().equals("CTDA") && !subrec.getSubrecordType().equals("SNAM")) continue;
                try {
                    subrecordData = subrec.getSubrecordData();
                }
                catch (Exception ex) {
                    continue;
                }
                if (subrec.getSubrecordType().equals("CTDA")) {
                    int subFuncCode = SerializedElement.getInteger(subrecordData, 8);
                    int subParam1 = SerializedElement.getInteger(subrecordData, 12);
                    if (subFuncCode == 71 && !factList.contains(subParam1)) {
                        lit.remove();
                        altered = true;
                    }
                }
                if (!subrec.getSubrecordType().equals("SNAM") || factList.contains(faction = SerializedElement.getInteger(subrecordData, 0))) continue;
                lit.remove();
                altered = true;
            }
            if (!altered) continue;
            try {
                pluginRec.setSubrecords(pluginSubrecs);
            }
            catch (Exception ex) {
                continue;
            }
            ++formsAltered;
        }
        return formsAltered;
    }

    private int removeConditionFromInfos(Plugin pl, int funcCode, Integer compCode, Object param1, Object param2, Float compValue) {
        int formsAltered = 0;
        byte[] byteArray1 = null;
        byte[] byteArray2 = null;
        if (!FunctionCode.isValid(funcCode) || compCode != null && !ComparisonCode.isValid(compCode)) {
            return formsAltered;
        }
        try {
            if (param1 != null) {
                byteArray1 = PluginRecord.convertToByteArray(param1);
            }
            if (param2 != null) {
                byteArray2 = PluginRecord.convertToByteArray(param2);
            }
        }
        catch (Exception ex) {
            return formsAltered;
        }
        FunctionInfo funcInfo = PluginSubrecord.getFunctionInfo(funcCode);
        if (funcInfo == null) {
            return formsAltered;
        }
        boolean usesFirst = funcInfo.isFirstReference() && param1 != null;
        boolean usesSecond = funcInfo.isSecondReference() && param2 != null;
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            List<PluginSubrecord> pluginSubrecs;
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("INFO") || (pluginRec = (PluginRecord)form.getSource()) == null) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            boolean subrecAltered = false;
            Iterator<PluginSubrecord> i = pluginSubrecs.iterator();
            while (i.hasNext()) {
                PluginSubrecord pluginSubrec = i.next();
                if (!pluginSubrec.getSubrecordType().equals("CTDA")) continue;
                try {
                    byte[] subrecordData = pluginSubrec.getSubrecordData();
                    int subCompCode = (subrecordData[0] & 0xF0) >>> 4;
                    int subCompValueInt = SerializedElement.getInteger(subrecordData, 4);
                    float subCompValue = Float.intBitsToFloat(subCompValueInt);
                    int subFuncCode = SerializedElement.getInteger(subrecordData, 8);
                    if (subFuncCode != funcCode || compCode != null && subCompCode != compCode || compValue != null && subCompValue != compValue.floatValue() || usesFirst && SerializedElement.compareArrays(byteArray1, 0, subrecordData, 12, 4) != 0 || usesSecond && SerializedElement.compareArrays(byteArray2, 0, subrecordData, 16, 4) != 0) continue;
                    i.remove();
                    subrecAltered = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!subrecAltered) continue;
            try {
                pluginRec.setSubrecords(pluginSubrecs);
            }
            catch (Exception ex) {
                continue;
            }
            ++formsAltered;
        }
        return formsAltered;
    }

    private int removeQuestsFromDIALs(Plugin pl, HashSet<Integer> questsToKeep) {
        int formsAltered = 0;
        if (questsToKeep == null) {
            return formsAltered;
        }
        List<PluginGroup> topGroups = pl.getGroupList();
        PluginGroup DIALGroup = null;
        for (PluginGroup group : topGroups) {
            String groupRecordType = group.getGroupRecordType();
            if (!groupRecordType.equals("DIAL")) continue;
            DIALGroup = group;
            break;
        }
        if (DIALGroup == null) {
            return formsAltered;
        }
        List<PluginRecord> recordList = DIALGroup.getRecordList();
        for (PluginRecord rec : recordList) {
            List<PluginSubrecord> subrecs;
            if (rec instanceof PluginGroup || !rec.getRecordType().equals("DIAL")) continue;
            try {
                subrecs = rec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            boolean subrecAltered = false;
            Iterator<PluginSubrecord> i = subrecs.iterator();
            while (i.hasNext()) {
                PluginSubrecord subrec = i.next();
                if (!subrec.getSubrecordType().equals("QSTI")) continue;
                try {
                    byte[] subrecordData = subrec.getSubrecordData();
                    int questID = SerializedElement.getInteger(subrecordData, 0);
                    if (questsToKeep.contains(questID)) continue;
                    i.remove();
                    subrecAltered = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!subrecAltered) continue;
            try {
                rec.setSubrecords(subrecs);
            }
            catch (Exception ex) {
                continue;
            }
            ++formsAltered;
        }
        return formsAltered;
    }

    private int cleanINFOsForLipSynch(Plugin pl, HashSet<String> fieldsToKeep, HashSet<Integer> keptCTDAFuncs) {
        int formsAltered = 0;
        List<PluginGroup> topGroups = pl.getGroupList();
        PluginGroup groupNeeded = null;
        for (PluginGroup group : topGroups) {
            String groupRecordType = group.getGroupRecordType();
            if (!groupRecordType.equals("DIAL")) continue;
            groupNeeded = group;
            break;
        }
        if (groupNeeded == null) {
            return formsAltered;
        }
        List<PluginRecord> groupList = groupNeeded.getRecordList();
        for (PluginRecord dialOrInfo : groupList) {
            if (dialOrInfo instanceof PluginGroup) {
                List<PluginRecord> infoGroup = ((PluginGroup)dialOrInfo).getRecordList();
                for (PluginRecord rec : infoGroup) {
                    try {
                        boolean bool1 = rec.removeSubrecords(fieldsToKeep, true);
                        boolean bool2 = rec.removeCTDASubrecords(keptCTDAFuncs, true);
                        if (!bool1 && !bool2) continue;
                        ++formsAltered;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!(dialOrInfo instanceof PluginRecord)) continue;
        }
        return formsAltered;
    }

    private int cleanQUSTsForLipSynch(Plugin pl, HashSet<String> fieldsToKeep, HashSet<Integer> keptCTDAFuncs) {
        int formsAltered = 0;
        PluginGroup groupNeeded = pl.getTopGroup("QUST");
        if (groupNeeded == null) {
            return formsAltered;
        }
        List<PluginRecord> questList = groupNeeded.getRecordList();
        for (PluginRecord quest : questList) {
            try {
                boolean bool1 = quest.removeSubrecords(fieldsToKeep, true);
                boolean bool2 = quest.removeCTDASubrecords(keptCTDAFuncs, true);
                if (!bool1 && !bool2) continue;
                ++formsAltered;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return formsAltered;
    }

    private int cleanGroupForLipSynch(Plugin pl, String groupName, HashSet<String> fieldsToKeep) {
        int formsAltered = 0;
        List<PluginGroup> topGroups = pl.getGroupList();
        PluginGroup groupNeeded = null;
        for (PluginGroup group : topGroups) {
            String groupRecordType = group.getGroupRecordType();
            if (!groupRecordType.equals(groupName)) continue;
            groupNeeded = group;
            break;
        }
        if (groupNeeded == null) {
            return formsAltered;
        }
        List<PluginRecord> groupList = groupNeeded.getRecordList();
        for (PluginRecord rec : groupList) {
            if (rec instanceof PluginGroup) continue;
            try {
                if (!rec.removeSubrecords(fieldsToKeep, true)) continue;
                ++formsAltered;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return formsAltered;
    }

    private List<PluginRecord> getRaceList(Plugin pl) {
        ArrayList<PluginRecord> raceList = new ArrayList<PluginRecord>();
        PluginGroup raceGroup = pl.getTopGroup("RACE");
        if (raceGroup != null) {
            List<PluginRecord> recordList = raceGroup.getRecordList();
            for (PluginRecord record : recordList) {
                if (!record.getRecordType().equals("RACE") || record.isIgnored()) continue;
                raceList.add(record);
            }
        }
        try {
            List<String> masterListInCaps = pl.getMasterList();
            Master[] masters = new Master[masterListInCaps.size()];
            int index = 0;
            for (String masterName : masterListInCaps) {
                File masterFile = new File(String.valueOf(this.pluginFile.getParent()) + Main.fileSeparator + masterName);
                Master master = new Master(masterFile);
                master.load(null);
                masters[index++] = master;
            }
            ListIterator<String> lit = masterListInCaps.listIterator();
            while (lit.hasNext()) {
                String tmpMaster = lit.next();
                lit.set(tmpMaster.toUpperCase());
            }
            int masterID = masters.length - 1;
            while (masterID > -1) {
                Master master = masters[masterID];
                List<FormInfo> formList = master.getFormList();
                List<String> masterListforMaster = master.getMasterList();
                for (FormInfo formInfo : formList) {
                    int formMasterID;
                    String recordType = formInfo.getRecordType();
                    if (!recordType.equals("RACE")) continue;
                    int newMasterID = formMasterID = (formInfo.getFormID() & 0xFF000000) >> 24;
                    if (formMasterID <= masterListforMaster.size()) {
                        String formMasterName = formMasterID == masterListforMaster.size() ? master.getName() : masterListforMaster.get(formMasterID);
                        String raceFormID = String.format("%08X", formInfo.getFormID());
                        int pluginMasterIdx = masterListInCaps.indexOf(formMasterName.toUpperCase());
                        if (pluginMasterIdx == -1) {
                            if (Main.debugMode) {
                                System.out.printf("GenerateTask: Form ID %08X is modified in <%s> from the original in <%s>;  but <%s> is not in the master list for plugin <%s>.\n", formInfo.getFormID(), master.getName(), formMasterName, formMasterName, this.plugin.getName());
                            }
                        } else {
                            newMasterID = pluginMasterIdx;
                        }
                    }
                    PluginRecord record = master.getRecord(formInfo.getFormID());
                    if (newMasterID != formMasterID) {
                        int newFormID = record.getFormID() & 0xFFFFFF | newMasterID << 24;
                        record.setFormID(newFormID);
                    }
                    if (raceList.contains(record)) continue;
                    raceList.add(record);
                }
                --masterID;
            }
        }
        catch (Throwable exc) {
            Main.logException("Exception while generating race map", exc);
        }
        return raceList;
    }

    private List<PluginRecord> getRecordList(Plugin pl, List<Integer> recIDList, String recType) {
        ArrayList<PluginRecord> retRecList = new ArrayList<PluginRecord>();
        if (recIDList == null || recIDList.isEmpty()) {
            return retRecList;
        }
        ArrayList<Integer> dupeRecIDList = new ArrayList<Integer>();
        dupeRecIDList.addAll(recIDList);
        PluginGroup recGroup = pl.getTopGroup(recType);
        if (recGroup != null) {
            List<PluginRecord> recordList = recGroup.getRecordList();
            for (PluginRecord record : recordList) {
                if (!record.getRecordType().equals(recType) || record.isIgnored() || !dupeRecIDList.contains(record.getFormID())) continue;
                retRecList.add(record);
                dupeRecIDList.remove(new Integer(record.getFormID()));
                if (!dupeRecIDList.isEmpty()) continue;
                return retRecList;
            }
        }
        try {
            List<String> masterListInCaps = pl.getMasterList();
            Master[] masters = new Master[masterListInCaps.size()];
            int index = 0;
            for (String masterName : masterListInCaps) {
                File masterFile = new File(String.valueOf(this.pluginFile.getParent()) + Main.fileSeparator + masterName);
                Master master = new Master(masterFile);
                master.load(null);
                masters[index++] = master;
            }
            ListIterator<String> lit = masterListInCaps.listIterator();
            while (lit.hasNext()) {
                String tmpMaster = lit.next();
                lit.set(tmpMaster.toUpperCase());
            }
            int masterID = masters.length - 1;
            while (masterID > -1) {
                Master master = masters[masterID];
                List<FormInfo> formList = master.getFormList();
                List<String> masterListforMaster = master.getMasterList();
                for (FormInfo formInfo : formList) {
                    int formMasterID;
                    String recordType = formInfo.getRecordType();
                    if (!recordType.equals(recType)) continue;
                    int newMasterID = formMasterID = (formInfo.getFormID() & 0xFF000000) >> 24;
                    String npcFormID = String.format("%08X", formInfo.getFormID());
                    if (formMasterID <= masterListforMaster.size()) {
                        String formMasterName = formMasterID == masterListforMaster.size() ? master.getName() : masterListforMaster.get(formMasterID);
                        int pluginMasterIdx = masterListInCaps.indexOf(formMasterName.toUpperCase());
                        if (pluginMasterIdx == -1) {
                            if (Main.debugMode) {
                                System.out.printf("GenerateTask: Form ID %08X is modified in <%s> from the original in <%s>;  but <%s> is not in the master list for plugin <%s>.\n", formInfo.getFormID(), master.getName(), formMasterName, formMasterName, this.plugin.getName());
                            }
                        } else {
                            newMasterID = pluginMasterIdx;
                        }
                    }
                    PluginRecord record = master.getRecord(formInfo.getFormID());
                    if (newMasterID != formMasterID) {
                        int newFormID = record.getFormID() & 0xFFFFFF | newMasterID << 24;
                        record.setFormID(newFormID);
                    }
                    if (retRecList.contains(record) || !recIDList.contains(record.getFormID())) continue;
                    retRecList.add(record);
                    dupeRecIDList.remove(new Integer(record.getFormID()));
                    if (!dupeRecIDList.isEmpty()) continue;
                    return retRecList;
                }
                --masterID;
            }
        }
        catch (Throwable exc) {
            Main.logException("Exception while generating NPC list", exc);
        }
        return retRecList;
    }

    private int addFakeVoiceRaces(JTree plTree) {
        int ARGONIAN_ID = 2049;
        int BRETON_ID = 2050;
        int DREMORA_ID = 2064;
        int HIGHELF_ID = 2062;
        int IMPERIAL_ID = 2063;
        int NORD_ID = 2066;
        int REDGUARD_ID = 2068;
        int ARGONIAN_SI_ID = 147433;
        int BRETON_SI_ID = 140540;
        int DREMORA_SI_ID = 229392;
        int HIGHELF_SI_ID = 102916;
        int IMPERIAL_SI_ID = 2311;
        int NORD_SI_ID = 140541;
        int REDGUARD_SI_ID = 3395;
        int DARKSEDUCER_SI_ID = 73870;
        int GOLDENSAINT_SI_ID = 73871;
        int SHEOGORATH_SI_ID = 340110;
        int[] IDArray = new int[]{ARGONIAN_ID, BRETON_ID, DREMORA_ID, HIGHELF_ID, IMPERIAL_ID, NORD_ID, REDGUARD_ID, ARGONIAN_SI_ID, BRETON_SI_ID, DREMORA_SI_ID, HIGHELF_SI_ID, IMPERIAL_SI_ID, NORD_SI_ID, REDGUARD_SI_ID, DARKSEDUCER_SI_ID, GOLDENSAINT_SI_ID, SHEOGORATH_SI_ID};
        HashMap<Integer, String> EDIDMap = new HashMap<Integer, String>();
        HashMap<Integer, String> FULLMap = new HashMap<Integer, String>();
        HashMap<Integer, String> DESCMap = new HashMap<Integer, String>();
        EDIDMap.put(ARGONIAN_ID, "ArgonianFakeVoice");
        EDIDMap.put(BRETON_ID, "BretonFakeVoice");
        EDIDMap.put(DREMORA_ID, "DremoraFakeVoice");
        EDIDMap.put(HIGHELF_ID, "HighElfFakeVoice");
        EDIDMap.put(IMPERIAL_ID, "ImperialFakeVoice");
        EDIDMap.put(NORD_ID, "NordFakeVoice");
        EDIDMap.put(REDGUARD_ID, "RedguardFakeVoice");
        EDIDMap.put(ARGONIAN_SI_ID, "ArgonianSIFakeVoice");
        EDIDMap.put(BRETON_SI_ID, "BretonSIFakeVoice");
        EDIDMap.put(DREMORA_SI_ID, "DremoraSIFakeVoice");
        EDIDMap.put(HIGHELF_SI_ID, "HighElfSIFakeVoice");
        EDIDMap.put(IMPERIAL_SI_ID, "ImperialSIFakeVoice");
        EDIDMap.put(NORD_SI_ID, "NordSIFakeVoice");
        EDIDMap.put(REDGUARD_SI_ID, "RedguardSIFakeVoice");
        EDIDMap.put(DARKSEDUCER_SI_ID, "DarkSeducerSIFakeVoice");
        EDIDMap.put(GOLDENSAINT_SI_ID, "GoldenSaintSIFakeVoice");
        EDIDMap.put(SHEOGORATH_SI_ID, "SheogorathSIFakeVoice");
        FULLMap.put(ARGONIAN_ID, "Argonian");
        FULLMap.put(BRETON_ID, "Breton");
        FULLMap.put(DREMORA_ID, "Dremora");
        FULLMap.put(HIGHELF_ID, "High Elf");
        FULLMap.put(IMPERIAL_ID, "Imperial");
        FULLMap.put(NORD_ID, "Nord");
        FULLMap.put(REDGUARD_ID, "Redguard");
        FULLMap.put(ARGONIAN_SI_ID, "Argonian");
        FULLMap.put(BRETON_SI_ID, "Breton");
        FULLMap.put(DREMORA_SI_ID, "Dremora");
        FULLMap.put(HIGHELF_SI_ID, "High Elf");
        FULLMap.put(IMPERIAL_SI_ID, "Imperial");
        FULLMap.put(NORD_SI_ID, "Nord");
        FULLMap.put(REDGUARD_SI_ID, "Redguard");
        FULLMap.put(DARKSEDUCER_SI_ID, "Dark Seducer");
        FULLMap.put(GOLDENSAINT_SI_ID, "Golden Saint");
        FULLMap.put(SHEOGORATH_SI_ID, "Sheogorath");
        DESCMap.put(ARGONIAN_ID, "Argonian Fake Voice. ONLY FOR LIP FILE GENERATION");
        DESCMap.put(BRETON_ID, "Breton Fake Voice. ONLY FOR LIP FILE GENERATION");
        DESCMap.put(DREMORA_ID, "Dremora Fake Voice. ONLY FOR LIP FILE GENERATION");
        DESCMap.put(HIGHELF_ID, "High Elf Fake Voice. ONLY FOR LIP FILE GENERATION");
        DESCMap.put(IMPERIAL_ID, "Imperial Fake Voice. ONLY FOR LIP FILE GENERATION");
        DESCMap.put(NORD_ID, "Nord Fake Voice. ONLY FOR LIP FILE GENERATION");
        DESCMap.put(REDGUARD_ID, "Redguard Fake Voice. ONLY FOR LIP FILE GENERATION");
        DESCMap.put(ARGONIAN_SI_ID, "Argonian Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(BRETON_SI_ID, "Breton Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(DREMORA_SI_ID, "Dremora Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(HIGHELF_SI_ID, "High Elf Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(IMPERIAL_SI_ID, "Imperial Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(NORD_SI_ID, "Nord Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(REDGUARD_SI_ID, "Redguard Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(DARKSEDUCER_SI_ID, "Dark Seducer Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(GOLDENSAINT_SI_ID, "Golden Saint Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        DESCMap.put(SHEOGORATH_SI_ID, "Sheogorath Fake Voice (SI Only). ONLY FOR LIP FILE GENERATION");
        ArrayList<PluginRecord> fakeVoiceRecords = new ArrayList<PluginRecord>();
        int i = 0;
        while (i < IDArray.length) {
            block14: {
                byte[] VNAMData;
                ArrayList<PluginSubrecord> subrecords = new ArrayList<PluginSubrecord>(4);
                byte[] FULLbytes = ((String)FULLMap.get(IDArray[i])).getBytes();
                byte[] FULLsubrecordData = new byte[FULLbytes.length + 1];
                System.arraycopy(FULLbytes, 0, FULLsubrecordData, 0, FULLbytes.length);
                FULLsubrecordData[FULLbytes.length] = 0;
                byte[] DESCbytes = ((String)DESCMap.get(IDArray[i])).getBytes();
                byte[] DESCsubrecordData = new byte[DESCbytes.length + 1];
                System.arraycopy(DESCbytes, 0, DESCsubrecordData, 0, DESCbytes.length);
                DESCsubrecordData[DESCbytes.length] = 0;
                PluginSubrecord FULLSubrecord = new PluginSubrecord("RACE", "FULL", FULLsubrecordData);
                subrecords.add(FULLSubrecord);
                PluginSubrecord DESCSubrecord = new PluginSubrecord("RACE", "DESC", DESCsubrecordData);
                subrecords.add(DESCSubrecord);
                if (IDArray[i] == BRETON_ID) {
                    VNAMData = new byte[8];
                    SerializedElement.setInteger(0, VNAMData, 0);
                    SerializedElement.setInteger(IMPERIAL_ID, VNAMData, 4);
                    PluginSubrecord pluginSubrecord = new PluginSubrecord("RACE", "VNAM", VNAMData);
                    subrecords.add(pluginSubrecord);
                }
                if (IDArray[i] == BRETON_SI_ID) {
                    VNAMData = new byte[8];
                    SerializedElement.setInteger(0, VNAMData, 0);
                    SerializedElement.setInteger(IMPERIAL_SI_ID, VNAMData, 4);
                    PluginSubrecord pluginSubrecord = new PluginSubrecord("RACE", "VNAM", VNAMData);
                    subrecords.add(pluginSubrecord);
                }
                PluginRecord record = new PluginRecord("RACE", IDArray[i]);
                try {
                    record.setSubrecords(subrecords);
                    record.setEditorID((String)EDIDMap.get(IDArray[i]));
                }
                catch (Exception exception) {
                    break block14;
                }
                fakeVoiceRecords.add(record);
            }
            ++i;
        }
        int formsAltered = 0;
        PluginNode rootNode = (PluginNode)plTree.getModel().getRoot();
        List<FormInfo> formList = rootNode.getPlugin().getFormList();
        int childCount = rootNode.getChildCount();
        List<Object> groupList = new ArrayList();
        PluginGroup groupRace = null;
        DefaultMutableTreeNode raceNode = null;
        int i2 = 0;
        while (i2 < childCount) {
            GroupNode parentNode = (GroupNode)rootNode.getChildAt(i2);
            if (parentNode.getGroup().getGroupRecordType().equals("RACE")) {
                raceNode = parentNode;
                groupRace = parentNode.getGroup();
                groupList = parentNode.getGroup().getRecordList();
            }
            ++i2;
        }
        if (groupRace == null || raceNode == null) {
            return formsAltered;
        }
        int raceCount = raceNode.getChildCount();
        HashSet<Integer> customRaceIDs = new HashSet<Integer>();
        for (PluginRecord pluginRecord : groupList) {
            if (pluginRecord instanceof PluginGroup) continue;
            customRaceIDs.add(pluginRecord.getFormID());
        }
        for (PluginRecord pluginRecord : fakeVoiceRecords) {
            if (customRaceIDs.contains(pluginRecord.getFormID())) continue;
            RecordNode recordNode = new RecordNode(pluginRecord);
            try {
                this.createRecordChildren(recordNode);
            }
            catch (Exception ex) {
                continue;
            }
            raceNode.add(recordNode);
            groupList.add(pluginRecord);
            formList.add(new FormInfo(pluginRecord, pluginRecord.getRecordType(), pluginRecord.getFormID(), pluginRecord.getEditorID()));
            ++formsAltered;
        }
        if (formsAltered != 0) {
            int[] nArray = new int[formsAltered];
            int i3 = 0;
            while (i3 < formsAltered) {
                nArray[i3] = raceCount + i3;
                ++i3;
            }
            ((DefaultTreeModel)plTree.getModel()).nodesWereInserted(raceNode, nArray);
        }
        return formsAltered;
    }

    private int addRecordsToGroup(JTree plTree, String topGroup, List<PluginRecord> records) {
        int formsAltered = 0;
        PluginNode rootNode = (PluginNode)plTree.getModel().getRoot();
        List<FormInfo> formList = rootNode.getPlugin().getFormList();
        int childCount = rootNode.getChildCount();
        List<Object> groupList = new ArrayList();
        PluginGroup groupNeeded = null;
        DefaultMutableTreeNode neededNode = null;
        int i = 0;
        while (i < childCount) {
            GroupNode parentNode = (GroupNode)rootNode.getChildAt(i);
            if (parentNode.getGroup().getGroupRecordType().equals(topGroup)) {
                neededNode = parentNode;
                groupNeeded = parentNode.getGroup();
                groupList = parentNode.getGroup().getRecordList();
            }
            ++i;
        }
        if (groupNeeded == null || neededNode == null) {
            return formsAltered;
        }
        int recCount = neededNode.getChildCount();
        for (PluginRecord svRec : records) {
            RecordNode recordNode = new RecordNode(svRec);
            try {
                this.createRecordChildren(recordNode);
            }
            catch (Exception ex) {
                continue;
            }
            neededNode.add(recordNode);
            if (groupList.contains(svRec)) continue;
            groupList.add(svRec);
            formList.add(new FormInfo(svRec, svRec.getRecordType(), svRec.getFormID(), svRec.getEditorID()));
            ++formsAltered;
        }
        if (formsAltered != 0) {
            int[] indices = new int[formsAltered];
            int i2 = 0;
            while (i2 < formsAltered) {
                indices[i2] = recCount + i2;
                ++i2;
            }
            ((DefaultTreeModel)plTree.getModel()).nodesWereInserted(neededNode, indices);
        }
        return formsAltered;
    }

    private int removeNonLipSynchObjects(Plugin pl) {
        PluginRecord pluginRec;
        int formsRemoved = 0;
        HashSet<String> keepThese = new HashSet<String>();
        HashSet<Integer> questFormIDs = new HashSet<Integer>();
        HashSet<Integer> keptDIALs = new HashSet<Integer>();
        HashSet<Integer> keptINFOs = new HashSet<Integer>();
        keepThese.add("DIAL");
        keepThese.add("INFO");
        keepThese.add("QUST");
        keepThese.add("RACE");
        keepThese.add("NPC_");
        keepThese.add("FACT");
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            if (form.getRecordType().equals("QUST") && (pluginRec = (PluginRecord)form.getSource()) != null && !pluginRec.isIgnored()) {
                questFormIDs.add(form.getFormID());
            }
            if (keepThese.contains(form.getRecordType()) || (pluginRec = (PluginRecord)form.getSource()) == null) continue;
            pluginRec.setIgnore(true);
            ++formsRemoved;
        }
        Iterator<FormInfo> iterator = questFormIDs.iterator();
        while (iterator.hasNext()) {
            int questID = (Integer)((Object)iterator.next());
            List<FormInfo> questDIALs = this.findQuestDials(pl, questID);
            for (FormInfo form2 : questDIALs) {
                keptDIALs.add(form2.getFormID());
            }
            List<FormInfo> questINFOs = this.findQuestInfos(pl, questID);
            for (FormInfo form3 : questINFOs) {
                keptINFOs.add(form3.getFormID());
            }
        }
        for (FormInfo form : allForms) {
            if (form.getRecordType().equals("DIAL") && !keptDIALs.contains(form.getFormID())) {
                pluginRec = (PluginRecord)form.getSource();
                if (pluginRec == null || pluginRec.isIgnored()) continue;
                pluginRec.setIgnore(true);
                ++formsRemoved;
                continue;
            }
            if (!form.getRecordType().equals("INFO") || keptINFOs.contains(form.getFormID()) || (pluginRec = (PluginRecord)form.getSource()) == null || pluginRec.isIgnored()) continue;
            pluginRec.setIgnore(true);
            ++formsRemoved;
        }
        List<PluginGroup> groupList = pl.getGroupList();
        for (PluginGroup group : groupList) {
            group.removeIgnoredRecords();
        }
        return formsRemoved;
    }

    private int removeRecordsNotOnList(Plugin pl, List<Integer> NPCIDList, String recType) {
        int formsRemoved = 0;
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            PluginRecord pluginRec;
            if (!form.getRecordType().equals(recType) || form.getFormID() == 20 || (pluginRec = (PluginRecord)form.getSource()) == null || pluginRec.isIgnored() || NPCIDList.contains(form.getFormID())) continue;
            pluginRec.setIgnore(true);
            ++formsRemoved;
        }
        List<PluginGroup> groupList = pl.getGroupList();
        for (PluginGroup group : groupList) {
            group.removeIgnoredRecords();
        }
        return formsRemoved;
    }

    private int removeAllObjects(Plugin pl) {
        int formsRemoved = 0;
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            PluginRecord pluginRec = (PluginRecord)form.getSource();
            if (pluginRec == null) continue;
            pluginRec.setIgnore(true);
            ++formsRemoved;
        }
        List<PluginGroup> groupList = pl.getGroupList();
        for (PluginGroup group : groupList) {
            group.removeIgnoredRecords();
        }
        pl.resetFormList();
        pl.resetFormMap();
        return formsRemoved;
    }

    private int reduceLipSynchObjects(Plugin pl) {
        int formsAltered = 0;
        HashSet<String> keptRACEFields = new HashSet<String>();
        HashSet<String> keptINFOFields = new HashSet<String>();
        HashSet<String> keptQUSTFields = new HashSet<String>();
        HashSet<String> keptNPCFields = new HashSet<String>();
        HashSet<String> keptFACTFields = new HashSet<String>();
        HashSet<Integer> questFormIDs = new HashSet<Integer>();
        ArrayList<Integer> factionFormIDs = new ArrayList<Integer>();
        HashSet<Integer> keptCTDAFuncs = new HashSet<Integer>();
        keptRACEFields.add("EDID");
        keptRACEFields.add("FULL");
        keptRACEFields.add("DESC");
        keptRACEFields.add("VNAM");
        keptQUSTFields.add("EDID");
        keptQUSTFields.add("FULL");
        keptQUSTFields.add("CTDA");
        keptINFOFields.add("QSTI");
        keptINFOFields.add("PNAM");
        keptINFOFields.add("TRDT");
        keptINFOFields.add("NAM1");
        keptINFOFields.add("NAM2");
        keptINFOFields.add("CTDA");
        keptNPCFields.add("EDID");
        keptNPCFields.add("FULL");
        keptNPCFields.add("ACBS");
        keptNPCFields.add("RNAM");
        keptNPCFields.add("SNAM");
        keptFACTFields.add("EDID");
        keptFACTFields.add("FULL");
        keptCTDAFuncs.add(72);
        keptCTDAFuncs.add(70);
        keptCTDAFuncs.add(69);
        keptCTDAFuncs.add(71);
        PluginGroup QUSTGroup = null;
        PluginGroup FACTGroup = null;
        List<PluginGroup> groupList = pl.getGroupList();
        for (PluginGroup group : groupList) {
            String string = group.getGroupRecordType();
            if (string.equals("QUST")) {
                QUSTGroup = group;
            }
            if (!string.equals("FACT")) continue;
            FACTGroup = group;
        }
        if (QUSTGroup == null) {
            return formsAltered;
        }
        List<PluginRecord> recordList = QUSTGroup.getRecordList();
        List<Object> factList = FACTGroup == null ? new ArrayList() : FACTGroup.getRecordList();
        for (PluginRecord pluginRecord : recordList) {
            if (pluginRecord instanceof PluginGroup || !pluginRecord.getRecordType().equals("QUST")) continue;
            questFormIDs.add(pluginRecord.getFormID());
        }
        for (PluginRecord pluginRecord : factList) {
            if (pluginRecord instanceof PluginGroup || !pluginRecord.getRecordType().equals("FACT")) continue;
            factionFormIDs.add(pluginRecord.getFormID());
        }
        formsAltered += this.removeQuestsFromDIALs(pl, questFormIDs);
        formsAltered += this.cleanINFOsForLipSynch(pl, keptINFOFields, keptCTDAFuncs);
        formsAltered += this.cleanQUSTsForLipSynch(pl, keptQUSTFields, keptCTDAFuncs);
        formsAltered += this.cleanGroupForLipSynch(pl, "RACE", keptRACEFields);
        formsAltered += this.cleanGroupForLipSynch(pl, "NPC_", keptNPCFields);
        formsAltered += this.cleanGroupForLipSynch(pl, "FACT", keptFACTFields);
        return formsAltered += this.purgeFactions(pl, factionFormIDs);
    }

    private int changeQuestTopics(Plugin pl, int oldQID, int newQID, int lastFormID, boolean cloneDIALs) throws DataFormatException, IOException, PluginException {
        boolean changed;
        PluginRecord pluginRec;
        List<FormInfo> allQuestDials = this.findQuestDials(pl, oldQID);
        int dialFormIDsUsed = 0;
        int infoFormIDsUsed = 0;
        int lastFormIDUsed = lastFormID;
        for (FormInfo form : allQuestDials) {
            pluginRec = (PluginRecord)form.getSource();
            if (cloneDIALs && this.dialToBeCloned(pluginRec, oldQID)) {
                int oldDialID = pluginRec.getFormID();
                PluginGroup topicGroup = this.findTopicGroup(pl, oldDialID);
                if (topicGroup == null) {
                    if (!Main.debugMode) continue;
                    System.out.printf("changeQuestTopics: No INFO group found for DIAL record [%08X]\n", oldDialID);
                    continue;
                }
                pluginRec.setFormID(++lastFormIDUsed);
                String oldName = pluginRec.getEditorID();
                try {
                    FormInfo dialFormInfo = pl.getFormMap().get(oldDialID);
                    pluginRec.setFormID(lastFormIDUsed);
                    dialFormInfo.setFormID(lastFormIDUsed);
                    dialFormInfo.setMergedFormID(lastFormIDUsed);
                    pluginRec.setEditorID(String.valueOf(oldName) + "GECKO");
                    dialFormInfo.setEditorID(String.valueOf(oldName) + "GECKO");
                    dialFormInfo.setMergedEditorID(String.valueOf(oldName) + "GECKO");
                    pl.getFormMap().remove(oldDialID);
                    pl.getFormMap().put(new Integer(lastFormIDUsed), dialFormInfo);
                    pluginRec.setEditorID(String.valueOf(oldName) + "GECKO");
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
                if (Main.debugMode) {
                    System.out.printf("Dialogue Form ID Change: Changed DIAL record with form ID %08X and name " + (String)oldName + " to ID %08X and name %s \n", oldDialID, pluginRec.getFormID(), pluginRec.getEditorID());
                }
                int oldGroupID = topicGroup.getGroupParentID();
                topicGroup.setGroupParentID(lastFormIDUsed);
                if (Main.debugMode) {
                    System.out.printf("INFO Group Parent Change: Changed parent form ID %08X to parent form ID %08X \n", oldGroupID, topicGroup.getGroupParentID());
                }
                if ((changed = pluginRec.changeSubrecord("QSTI", new Integer(oldQID), new Integer(newQID))) && Main.debugMode) {
                    System.out.printf("changeQuestTopics: Changed QSTI Subrecord with value %08X to value %08X in DIAL record [%08X]\n", oldQID, newQID, pluginRec.getFormID());
                }
                ++dialFormIDsUsed;
                continue;
            }
            boolean changed2 = pluginRec.addAdditionalSubrecord("QSTI", new Integer(newQID));
            if (!changed2 || !Main.debugMode) continue;
            System.out.printf("changeQuestTopics: Added QSTI Subrecord with value %08X to DIAL record " + pluginRec.getEditorID() + " [%08X]\n", newQID, pluginRec.getFormID());
        }
        List<FormInfo> allQuestInfos = this.findQuestInfos(pl, oldQID);
        ArrayList<Integer> oldForms = new ArrayList<Integer>(allQuestInfos.size());
        ArrayList<Integer> newForms = new ArrayList<Integer>(allQuestInfos.size());
        for (FormInfo form : allQuestInfos) {
            int oldFormID = form.getFormID();
            oldForms.add(new Integer(form.getFormID()));
            newForms.add(new Integer(++lastFormIDUsed));
            pluginRec = (PluginRecord)form.getSource();
            pluginRec.setFormID(lastFormIDUsed);
            form.setFormID(lastFormIDUsed);
            form.setMergedFormID(lastFormIDUsed);
            pl.getFormMap().remove(oldFormID);
            pl.getFormMap().put(new Integer(lastFormIDUsed), form);
            changed = pluginRec.changeSubrecord("QSTI", new Integer(oldQID), new Integer(newQID));
            if (changed && Main.debugMode) {
                System.out.printf("changeQuestTopics: Changed QSTI Subrecord with value %08X to value %08X in INFO record [%08X]\n", oldQID, newQID, pluginRec.getFormID());
            }
            ++infoFormIDsUsed;
        }
        List<FormInfo> allInfos = this.findAllInfos(pl);
        block4: for (FormInfo form : allInfos) {
            pluginRec = (PluginRecord)form.getSource();
            int i = 0;
            while (i < infoFormIDsUsed) {
                boolean changed3 = pluginRec.changeSubrecord("PNAM", oldForms.get(i), newForms.get(i));
                if (changed3 && Main.debugMode) {
                    System.out.printf("changeQuestTopics: Changed PNAM Subrecord with value %08X to value %08X in INFO record [%08X]\n", oldForms.get(i), newForms.get(i), pluginRec.getFormID());
                }
                if (changed3) continue block4;
                ++i;
            }
        }
        return dialFormIDsUsed + infoFormIDsUsed;
    }

    private List<FormInfo> findQuestDials(Plugin pl, int questID) {
        ArrayList<FormInfo> questDials = new ArrayList<FormInfo>();
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            List<PluginSubrecord> pluginSubrecs;
            PluginRecord pluginRec;
            if (!form.getRecordType().equals("DIAL") || (pluginRec = (PluginRecord)form.getSource()) == null) continue;
            try {
                pluginSubrecs = pluginRec.getSubrecords();
            }
            catch (Exception ex) {
                continue;
            }
            for (PluginSubrecord pluginSubrec : pluginSubrecs) {
                byte[] subrecordData;
                if (!pluginSubrec.getSubrecordType().equals("QSTI")) continue;
                try {
                    subrecordData = pluginSubrec.getSubrecordData();
                }
                catch (Exception ex) {
                    continue;
                }
                int infoQuestID = SerializedElement.getInteger(subrecordData, 0);
                if (questID != infoQuestID) continue;
                questDials.add(form);
            }
        }
        return questDials;
    }

    private int highestFormID(Plugin pl) {
        List<FormInfo> allForms = pl.getFormList();
        int highFormID = allForms.get(0).getFormID();
        for (FormInfo form : allForms) {
            int formID = form.getFormID();
            if (formID <= highFormID) continue;
            highFormID = formID;
        }
        return highFormID;
    }

    private int modifyWorldspace(Plugin pl, PluginRecord pluginRec, int highFormID) {
        int tmpHighFormID = highFormID;
        int numNewFormIDs = 0;
        int oldWSID = pluginRec.getFormID();
        String oldName = pluginRec.getEditorID();
        ++tmpHighFormID;
        ++numNewFormIDs;
        PluginGroup WRLDGroup = pl.getTopGroup("WRLD");
        if (WRLDGroup == null) {
            return 0;
        }
        List<PluginRecord> recList = WRLDGroup.getRecordList();
        PluginRecord worldspace = null;
        PluginGroup worldGroup = null;
        boolean wsFound = false;
        int i = 0;
        while (i < recList.size()) {
            worldspace = recList.get(i);
            worldGroup = (PluginGroup)recList.get(i + 1);
            if (worldspace.getFormID() == pluginRec.getFormID()) {
                wsFound = true;
                break;
            }
            i += 2;
        }
        if (!wsFound) {
            return 0;
        }
        HashMap<Integer, Integer> formIDsChanged = new HashMap<Integer, Integer>();
        try {
            oldWSID = worldspace.getFormID();
            worldspace.setFormID(tmpHighFormID);
            worldspace.setEditorID(String.valueOf(oldName) + "GECKO");
            formIDsChanged.put(oldWSID, tmpHighFormID);
            worldGroup.setGroupParentID(tmpHighFormID++);
            ++numNewFormIDs;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        if (Main.debugMode) {
            System.out.printf("Worldspace Form ID Change: Changed WRLD record with form ID %08X and name " + oldName + " to ID %08X and name %s \n", oldWSID, worldspace.getFormID(), worldspace.getEditorID());
        }
        List<PluginRecord> regionsInWS = pl.getRegionsInWorldspace(oldWSID);
        HashMap<Integer, Integer> regionIDsChanged = new HashMap<Integer, Integer>();
        for (PluginRecord region : regionsInWS) {
            try {
                int oldRegionID = region.getFormID();
                region.setFormID(tmpHighFormID);
                Iterator oldRegionName = region.getEditorID();
                region.setEditorID(String.valueOf(oldRegionName) + "GECKO");
                region.changeSubrecord("WNAM", oldWSID, worldspace.getFormID());
                formIDsChanged.put(oldRegionID, tmpHighFormID);
                regionIDsChanged.put(oldRegionID, tmpHighFormID++);
                ++numNewFormIDs;
                if (!Main.debugMode) continue;
                System.out.printf("Region Form ID Change: Changed REGN record with form ID %08X and name " + oldRegionName + " to ID %08X and name %s \n", oldRegionID, region.getFormID(), region.getEditorID());
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
        List<PluginRecord> worldGroupList = worldGroup.getRecordList();
        ArrayList<PluginGroup> blockList = new ArrayList<PluginGroup>();
        for (PluginRecord wgList : worldGroupList) {
            if (!(wgList instanceof PluginGroup)) {
                int oldID = wgList.getFormID();
                wgList.setFormID(tmpHighFormID);
                formIDsChanged.put(oldID, tmpHighFormID);
                ++numNewFormIDs;
                continue;
            }
            switch (((PluginGroup)wgList).getGroupType()) {
                case 6: {
                    HashMap<Integer, Integer> formIDMap = this.modifyCellGroup((PluginGroup)wgList, tmpHighFormID);
                    tmpHighFormID += formIDMap.size() + 1;
                    numNewFormIDs += formIDMap.size();
                    formIDsChanged.putAll(formIDMap);
                    break;
                }
                case 4: {
                    blockList.add((PluginGroup)wgList);
                }
            }
        }
        for (PluginGroup block : blockList) {
            List<PluginRecord> subBlockList = block.getRecordList();
            for (PluginRecord subBlock : subBlockList) {
                List<PluginRecord> cellList = ((PluginGroup)subBlock).getRecordList();
                for (PluginRecord cell : cellList) {
                    if (cell instanceof PluginGroup) {
                        HashMap<Integer, Integer> formIDMap = this.modifyCellGroup((PluginGroup)cell, tmpHighFormID);
                        tmpHighFormID += formIDMap.size() + 1;
                        numNewFormIDs += formIDMap.size();
                        formIDsChanged.putAll(formIDMap);
                    }
                    if (!cell.getRecordType().equals("CELL")) continue;
                    int oldID = cell.getFormID();
                    cell.setFormID(tmpHighFormID);
                    formIDsChanged.put(oldID, tmpHighFormID);
                    ++numNewFormIDs;
                    PluginSubrecord editorID = null;
                    try {
                        editorID = cell.getSubrecord("EDID");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (editorID != null) {
                        String newEDID = editorID.getDisplayData();
                        try {
                            cell.setEditorID(String.valueOf(newEDID) + "GECKO");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        PluginSubrecord regionData = cell.getSubrecord("XCLR");
                        if (regionData == null) continue;
                        byte[] oldSubData = regionData.getSubrecordData();
                        int[] regionArray = SerializedElement.getIntegerArray(oldSubData, 0);
                        ArrayList<Integer> newRegionArray = new ArrayList<Integer>();
                        int i2 = 0;
                        while (i2 < regionArray.length) {
                            Integer newRegionID = (Integer)regionIDsChanged.get(new Integer(regionArray[i2]));
                            if (newRegionID != null) {
                                newRegionArray.add(newRegionID);
                            }
                            ++i2;
                        }
                        if (newRegionArray.size() > 0) {
                            byte[] newSubData = new byte[4 * newRegionArray.size()];
                            int[] intArray = new int[newRegionArray.size()];
                            int i3 = 0;
                            while (i3 < newRegionArray.size()) {
                                intArray[i3] = (Integer)newRegionArray.get(i3);
                                ++i3;
                            }
                            SerializedElement.setIntegerArray(intArray, newSubData, 0);
                            cell.changeSubrecord("XCLR", oldSubData, newSubData);
                            continue;
                        }
                        cell.removeSubrecords("XCLR");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        List<PluginRecord> childWSs = pl.getChildWorldspaces(oldWSID);
        for (PluginRecord world : childWSs) {
            try {
                world.changeSubrecord("WNAM", oldWSID, worldspace.getFormID());
            }
            catch (Exception exception) {
                // empty catch block
            }
            numNewFormIDs += this.modifyWorldspace(pl, world, tmpHighFormID);
        }
        Set oldIDSet = formIDsChanged.keySet();
        for (Integer oldID : oldIDSet) {
            try {
                PluginRecord changedRec;
                FormInfo changedFormInfo = pl.getFormMap().get(oldID);
                String oldIDstr = String.format("%08X", oldID);
                if (changedFormInfo == null && Main.debugMode) {
                    System.out.printf("No form info for former ID " + oldIDstr + "\n", new Object[0]);
                }
                if ((changedRec = (PluginRecord)changedFormInfo.getSource()) == null && Main.debugMode) {
                    System.out.printf("No source record for former ID " + oldIDstr, new Object[0]);
                }
                changedFormInfo.setFormID(changedRec.getFormID());
                changedFormInfo.setMergedFormID(changedRec.getFormID());
                changedFormInfo.setEditorID(changedRec.getEditorID());
                changedFormInfo.setMergedEditorID(changedRec.getEditorID());
                pl.getFormMap().remove(oldID);
                pl.getFormMap().put(new Integer((Integer)formIDsChanged.get(oldID)), changedFormInfo);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
        return numNewFormIDs;
    }

    private HashMap<Integer, Integer> modifyCellGroup(PluginGroup cellGroup, int startFormID) {
        HashMap<Integer, Integer> formIDMap = new HashMap<Integer, Integer>();
        if (!(cellGroup instanceof PluginGroup) || cellGroup.getGroupType() != 6) {
            return formIDMap;
        }
        int subGroupID = startFormID;
        cellGroup.setGroupParentID(startFormID++);
        List<PluginRecord> cellList = cellGroup.getRecordList();
        for (PluginRecord cell : cellList) {
            if (cell instanceof PluginGroup) {
                ((PluginGroup)cell).setGroupParentID(subGroupID);
                List<PluginRecord> itemList = ((PluginGroup)cell).getAllPluginRecords();
                for (PluginRecord item : itemList) {
                    int oldID = item.getFormID();
                    item.setFormID(startFormID);
                    formIDMap.put(oldID, startFormID++);
                    PluginSubrecord editorID = null;
                    try {
                        editorID = item.getSubrecord("EDID");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (editorID == null) continue;
                    String newEDID = editorID.getDisplayData();
                    try {
                        item.setEditorID(String.valueOf(newEDID) + "GECKO");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            int oldID = cell.getFormID();
            cell.setFormID(startFormID);
            formIDMap.put(oldID, startFormID++);
            PluginSubrecord editorID = null;
            try {
                editorID = cell.getSubrecord("EDID");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (editorID == null) continue;
            String newEDID = editorID.getDisplayData();
            try {
                cell.setEditorID(String.valueOf(newEDID) + "GECKO");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return formIDMap;
    }

    private int modifyQuestFormID(Plugin pl, PluginRecord pluginRec, int highFormID, String howMany) {
        int tmpHighFormID = highFormID;
        int numNewFormIDs = 0;
        int oldQID = pluginRec.getFormID();
        String oldName = pluginRec.getEditorID();
        ++tmpHighFormID;
        ++numNewFormIDs;
        try {
            FormInfo questFormInfo = pl.getFormMap().get(oldQID);
            pluginRec.setFormID(tmpHighFormID);
            questFormInfo.setFormID(tmpHighFormID);
            questFormInfo.setMergedFormID(tmpHighFormID);
            pluginRec.setEditorID(String.valueOf(oldName) + "GECKO");
            questFormInfo.setEditorID(String.valueOf(oldName) + "GECKO");
            questFormInfo.setMergedEditorID(String.valueOf(oldName) + "GECKO");
            pl.getFormMap().remove(oldQID);
            pl.getFormMap().put(new Integer(tmpHighFormID), questFormInfo);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        if (Main.debugMode) {
            System.out.printf("Quest Form ID Change: Changed QUST record with form ID %08X and name " + oldName + " to ID %08X and name %s \n", oldQID, pluginRec.getFormID(), pluginRec.getEditorID());
        }
        if (howMany.equals("RelatedInfos") || howMany.equals("UnsharedDials")) {
            boolean cloneDIALs = howMany.equals("UnsharedDials");
            try {
                int numNewDialIDs = this.changeQuestTopics(pl, oldQID, tmpHighFormID, tmpHighFormID, cloneDIALs);
                numNewFormIDs += numNewDialIDs;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
        return numNewFormIDs;
    }

    private boolean dialToBeCloned(PluginRecord pluginRec, int oldQID) {
        List<PluginSubrecord> pluginSubrecs;
        int questMod;
        if (pluginRec instanceof PluginGroup || !pluginRec.getRecordType().equals("DIAL")) {
            return false;
        }
        int dialMod = pluginRec.getFormID() >>> 24;
        if (dialMod != (questMod = oldQID >>> 24)) {
            return false;
        }
        boolean foundOnlyOne = false;
        try {
            pluginSubrecs = pluginRec.getSubrecords();
        }
        catch (Exception ex) {
            return false;
        }
        for (PluginSubrecord pluginSubrec : pluginSubrecs) {
            byte[] subrecordData;
            if (!pluginSubrec.getSubrecordType().equals("QSTI")) continue;
            if (foundOnlyOne) {
                foundOnlyOne = false;
                break;
            }
            foundOnlyOne = true;
            try {
                subrecordData = pluginSubrec.getSubrecordData();
            }
            catch (Exception ex) {
                break;
            }
            int infoQuestID = SerializedElement.getInteger(subrecordData, 0);
            if (oldQID == infoQuestID) continue;
            foundOnlyOne = false;
            break;
        }
        return foundOnlyOne;
    }

    private PluginGroup findTopicGroup(Plugin pl, int dialID) {
        List<PluginGroup> topList = pl.getGroupList();
        PluginGroup returnGroup = null;
        PluginGroup dialGroup = null;
        for (PluginGroup topGroup : topList) {
            if (topGroup.getGroupType() != 0 || !topGroup.getGroupRecordType().equals("DIAL")) continue;
            dialGroup = topGroup;
            break;
        }
        if (dialGroup == null) {
            return null;
        }
        List<PluginRecord> dialList = dialGroup.getRecordList();
        for (PluginRecord infoGroup : dialList) {
            if (!(infoGroup instanceof PluginGroup) || ((PluginGroup)infoGroup).getGroupType() != 7 || ((PluginGroup)infoGroup).getGroupParentID() != dialID) continue;
            returnGroup = (PluginGroup)infoGroup;
            break;
        }
        return returnGroup;
    }

    private List<PluginGroup> findAllTopicGroups(Plugin pl) {
        List<PluginGroup> topList = pl.getGroupList();
        ArrayList<PluginGroup> returnGroups = new ArrayList<PluginGroup>();
        PluginGroup dialGroup = null;
        for (PluginGroup topGroup : topList) {
            if (topGroup.getGroupType() != 0 || !topGroup.getGroupRecordType().equals("DIAL")) continue;
            dialGroup = topGroup;
            break;
        }
        if (dialGroup == null) {
            return returnGroups;
        }
        List<PluginRecord> dialList = dialGroup.getRecordList();
        for (PluginRecord infoGroup : dialList) {
            if (!(infoGroup instanceof PluginGroup) || ((PluginGroup)infoGroup).getGroupType() != 7) continue;
            returnGroups.add((PluginGroup)infoGroup);
            break;
        }
        return returnGroups;
    }

    private void dumpNPCDialogue(Plugin pl, PluginRecord plRec, boolean append) {
        FileOutputStream outFile;
        String gender;
        int dontLeave;
        if (!plRec.getRecordType().equals("NPC_")) {
            return;
        }
        File file = this.getDialogueDumpFile("NPC_");
        if (file == null) {
            return;
        }
        if (!append && (dontLeave = JOptionPane.showConfirmDialog(this, "This will overwrite whatever data exists in the file.\n Do you wish to continue?", "Possible Content Overwrite", 2, 2)) != 0) {
            return;
        }
        if (this.raceList == null) {
            this.raceList = this.getRaceList(pl);
        }
        PluginSubrecord nameRec = null;
        PluginSubrecord raceRec = null;
        PluginSubrecord configRec = null;
        byte[] raceBytes = null;
        byte[] configBytes = null;
        try {
            nameRec = plRec.getSubrecord("FULL");
            raceRec = plRec.getSubrecord("RNAM");
            raceBytes = raceRec.getSubrecordData();
            configRec = plRec.getSubrecord("ACBS");
            configBytes = configRec.getSubrecordData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String NPCName = nameRec == null ? "Unknown" : nameRec.getDisplayData();
        String NPCRaceFormID = raceRec == null ? "of unknown race" : raceRec.getDisplayData();
        String NPCRaceEditorID = "Unknown";
        String NPCRaceName = "Unknown";
        String string = configRec == null ? "gender-unknown" : (gender = (SerializedElement.getInteger(configBytes, 0) & 1) == 0 ? "male" : "female");
        if (raceRec != null) {
            int raceID = SerializedElement.getInteger(raceBytes, 0);
            for (PluginRecord tmpRaceRec : this.raceList) {
                if (tmpRaceRec.getFormID() != raceID) continue;
                NPCRaceEditorID = tmpRaceRec.getEditorID();
                try {
                    PluginSubrecord raceNameRec = tmpRaceRec.getSubrecord("FULL");
                    if (raceNameRec == null) break;
                    NPCRaceName = raceNameRec.getDisplayData();
                }
                catch (Exception raceNameRec) {}
                break;
            }
        }
        String headerLine = "TES4GECKO DIALOGUE DUMP for NPC named " + NPCName + ", a " + gender + " " + NPCRaceName + " [race ID " + NPCRaceEditorID + "] with editor ID " + plRec.getEditorID() + " and form ID " + String.format("%08X", new Integer(plRec.getFormID())) + "\n";
        List<FormInfo> condInfos = this.findInfosWithCondition(pl, 72, 0, plRec.getFormID(), null, 1.0f);
        if (condInfos.size() == 0) {
            JOptionPane.showMessageDialog(this, "No dialogue data was found for this NPC");
            return;
        }
        try {
            outFile = new FileOutputStream(file, append);
        }
        catch (Exception ex) {
            return;
        }
        try {
            outFile.write(headerLine.getBytes());
        }
        catch (Exception ex) {
            return;
        }
        for (FormInfo form : condInfos) {
            try {
                outFile.write(this.dialogueForInfo(pl, form).getBytes());
            }
            catch (Exception ex) {
                return;
            }
        }
        try {
            outFile.close();
        }
        catch (Exception ex) {
            return;
        }
        JOptionPane.showMessageDialog(this, "Dialogue data for NPC " + plRec.getEditorID() + "\nwritten to file " + file.getName());
    }

    private void masterModReport(Plugin pl, boolean append) {
        FileOutputStream outFile;
        int dontLeave;
        File file = this.getMasterModFile();
        if (file == null) {
            return;
        }
        if (!append && (dontLeave = JOptionPane.showConfirmDialog(this, "This will overwrite whatever data exists in the file.\n Do you wish to continue?", "Possible Content Overwrite", 2, 2)) != 0) {
            return;
        }
        String headerLine = "TES4GECKO MASTER ALTERATION REPORT for plugin <" + pl.getName() + ">\n";
        List<String> alteredList = this.getAlteredList(pl);
        if (alteredList.size() == 0) {
            JOptionPane.showMessageDialog(this, "No master objects were altered in this plugin");
            return;
        }
        try {
            outFile = new FileOutputStream(file, append);
        }
        catch (Exception ex) {
            return;
        }
        try {
            outFile.write(headerLine.getBytes());
        }
        catch (Exception ex) {
            return;
        }
        for (String line : alteredList) {
            try {
                outFile.write(line.getBytes());
            }
            catch (Exception ex) {
                return;
            }
        }
        try {
            outFile.close();
        }
        catch (Exception ex) {
            return;
        }
        JOptionPane.showMessageDialog(this, "Master alteration data for plugin " + pl.getName() + "\nwritten to file " + file.getName());
    }

    private void formIDReport(Plugin pl) {
        FileOutputStream outFile;
        File file = this.getNewFormIDFile(pl.getName());
        if (file == null) {
            return;
        }
        if (Main.debugMode) {
            System.out.printf("File <" + file.getAbsolutePath() + "> selected for form ID report", new Object[0]);
        }
        String headerLine = String.valueOf("TES4GECKO FORM ID REPORT") + " for plugin <" + pl.getName() + ">\n";
        List<String> newList = this.getNewList(pl);
        if (newList.size() == 0) {
            JOptionPane.showMessageDialog(this, "No new form IDs were introduced in this plugin");
            return;
        }
        try {
            outFile = new FileOutputStream(file);
        }
        catch (Exception ex) {
            return;
        }
        try {
            outFile.write(headerLine.getBytes());
        }
        catch (Exception ex) {
            return;
        }
        for (String line : newList) {
            try {
                outFile.write(line.getBytes());
            }
            catch (Exception ex) {
                return;
            }
        }
        try {
            outFile.close();
        }
        catch (Exception ex) {
            return;
        }
        JOptionPane.showMessageDialog(this, "New form ID data for plugin " + pl.getName() + "\nwritten to file " + file.getName());
    }

    private List<String> getAlteredList(Plugin pl) {
        ArrayList<String> alteredList = new ArrayList<String>();
        List<PluginGroup> topGroups = pl.getGroupList();
        List<String> masterList = pl.getMasterList();
        int i = 0;
        while (i < masterList.size()) {
            String masterHeader = "Altered objects for mod index " + i + " [" + masterList.get(i) + "]:\n";
            boolean alteredFound = false;
            for (PluginGroup currGroup : topGroups) {
                String groupType = currGroup.getGroupRecordType();
                String groupHeader = "Object type: " + currGroup.getTypeMap().get(groupType) + "\n";
                List<Object> alteredGroup = new ArrayList();
                alteredGroup = groupType.equals("DIAL") ? this.findAlteredDIAL(currGroup, i) : (groupType.equals("CELL") ? this.findAlteredCELL(currGroup, i) : (groupType.equals("WRLD") ? this.findAlteredWRLD(currGroup, i) : this.findAlteredOther(currGroup, i)));
                if (alteredGroup.size() <= 0) continue;
                if (!alteredFound) {
                    alteredFound = true;
                    alteredList.add(masterHeader);
                }
                alteredList.add(groupHeader);
                alteredList.addAll(alteredGroup);
            }
            ++i;
        }
        return alteredList;
    }

    private List<String> getNewList(Plugin pl) {
        ArrayList<String> newList = new ArrayList<String>();
        List<PluginGroup> topGroups = pl.getGroupList();
        int currentModIndex = pl.getMasterList().size();
        boolean newFound = false;
        for (PluginGroup currGroup : topGroups) {
            String groupType = currGroup.getGroupRecordType();
            boolean isLight = groupType.equalsIgnoreCase("LIGH");
            String groupHeader = "Object type: " + currGroup.getTypeMap().get(groupType) + " [" + groupType + "]";
            ArrayList<String> newGroup = new ArrayList<String>();
            List<PluginRecord> groupList = currGroup.getRecordList();
            for (PluginRecord rec : groupList) {
                int idx;
                if (rec instanceof PluginGroup || (idx = rec.getFormID() >>> 24) != currentModIndex) continue;
                String MODBValue = ", MODB not present";
                String MODLValue = ", MODL not present";
                if (isLight) {
                    try {
                        MODBValue = ", MODB: " + rec.getSubrecord("MODB").getDisplayData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    MODLValue = ", MODL: " + rec.getSubrecord("MODL").getDisplayData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String entry = String.valueOf(String.format("%08X", rec.getFormID())) + "\t\t" + rec.getEditorID() + (isLight ? MODLValue : "") + (isLight ? MODBValue : "") + "\n";
                newGroup.add(entry);
            }
            if (newGroup.size() <= 0) continue;
            groupHeader = String.valueOf(groupHeader) + ", " + newGroup.size() + " new form IDs found.\n";
            newList.add(groupHeader);
            newList.addAll(newGroup);
        }
        return newList;
    }

    private List<String> findAlteredOther(PluginGroup group, int modIndex) {
        ArrayList<String> alteredList = new ArrayList<String>();
        String groupType = group.getGroupRecordType();
        if (groupType.equals("CELL") || groupType.equals("DIAL") || groupType.equals("WRLD")) {
            return alteredList;
        }
        List<PluginRecord> groupList = group.getRecordList();
        for (PluginRecord rec : groupList) {
            int idx = rec.getFormID() >>> 24;
            if (idx != modIndex) continue;
            String entry = "\tForm ID = " + String.format("%08X", rec.getFormID()) + "; editor ID = " + rec.getEditorID() + "\n";
            alteredList.add(entry);
        }
        return alteredList;
    }

    private List<String> findAlteredDIAL(PluginGroup group, int modIndex) {
        ArrayList<String> alteredList = new ArrayList<String>();
        String groupType = group.getGroupRecordType();
        if (!groupType.equals("DIAL")) {
            return alteredList;
        }
        List<PluginRecord> groupList = group.getRecordList();
        String dialFormID = "";
        String dialEditorID = "";
        for (PluginRecord dialOrInfo : groupList) {
            if (dialOrInfo instanceof PluginGroup) {
                List<PluginRecord> infoGroup = ((PluginGroup)dialOrInfo).getRecordList();
                for (PluginRecord rec : infoGroup) {
                    int idx2 = rec.getFormID() >>> 24;
                    if (idx2 != modIndex) continue;
                    String entry = "\t\tResponse form ID = " + String.format("%08X", rec.getFormID()) + " for topic " + dialEditorID + " [" + dialFormID + "]\n";
                    alteredList.add(entry);
                }
                continue;
            }
            if (!(dialOrInfo instanceof PluginRecord)) continue;
            dialFormID = String.format("%08X", dialOrInfo.getFormID());
            dialEditorID = dialOrInfo.getEditorID();
            int idx1 = dialOrInfo.getFormID() >>> 24;
            if (idx1 != modIndex) continue;
            String entry = "\tTopic form ID = " + dialFormID + "; editor ID = " + dialEditorID + "\n";
            alteredList.add(entry);
        }
        return alteredList;
    }

    private List<String> findAlteredCELL(PluginGroup group, int modIndex) {
        ArrayList<String> alteredList = new ArrayList<String>();
        String groupType = group.getGroupRecordType();
        if (!groupType.equals("CELL")) {
            return alteredList;
        }
        List<PluginRecord> blockList = group.getRecordList();
        for (PluginRecord block : blockList) {
            List<PluginRecord> subBlockList = ((PluginGroup)block).getRecordList();
            for (PluginRecord subBlock : subBlockList) {
                List<PluginRecord> cellList = ((PluginGroup)subBlock).getRecordList();
                for (PluginRecord cell : cellList) {
                    int idx1;
                    if (cell instanceof PluginGroup || !cell.getRecordType().equals("CELL") || (idx1 = cell.getFormID() >>> 24) != modIndex) continue;
                    String entry = "\tInterior cell form ID = " + String.format("%08X", cell.getFormID()) + "; editor ID = " + cell.getEditorID() + "\n";
                    alteredList.add(entry);
                }
            }
        }
        return alteredList;
    }

    private List<String> findAlteredWRLD(PluginGroup group, int modIndex) {
        ArrayList<String> alteredList = new ArrayList<String>();
        String groupType = group.getGroupRecordType();
        if (!groupType.equals("WRLD")) {
            return alteredList;
        }
        List<PluginRecord> recList = group.getRecordList();
        int i = 0;
        while (i < recList.size()) {
            PluginRecord world = recList.get(i);
            PluginGroup worldGroup = (PluginGroup)recList.get(i + 1);
            List<PluginRecord> worldGroupList = worldGroup.getRecordList();
            int idx = world.getFormID() >>> 24;
            if (idx == modIndex) {
                String entry = "\tWorldspace form ID = " + String.format("%08X", world.getFormID()) + "; editor ID = " + world.getEditorID() + "\n";
                alteredList.add(entry);
            }
            ArrayList<PluginGroup> blockList = new ArrayList<PluginGroup>();
            PluginGroup persistentCellGroup = null;
            for (PluginRecord pluginRecord : worldGroupList) {
                if (!(pluginRecord instanceof PluginGroup)) continue;
                switch (((PluginGroup)pluginRecord).getGroupType()) {
                    case 6: {
                        persistentCellGroup = (PluginGroup)((PluginGroup)pluginRecord).getRecordList().get(0);
                        break;
                    }
                    case 4: {
                        blockList.add((PluginGroup)pluginRecord);
                    }
                }
            }
            if (persistentCellGroup != null) {
                boolean bl = false;
                List<PluginRecord> refGroup = persistentCellGroup.getRecordList();
                for (PluginRecord ref : refGroup) {
                    boolean bl2;
                    int idx2 = ref.getFormID() >>> 24;
                    if (idx2 != modIndex) continue;
                    String refType = "R";
                    String recordType = ref.getRecordType();
                    if (recordType.equals("ACHR")) {
                        refType = "NPC r";
                    }
                    if (recordType.equals("ACRE")) {
                        refType = "Creature r";
                    }
                    String editIDStr = ref.getEditorID().equals("") ? "" : "; editor ID = " + ref.getEditorID();
                    String entry = "\t\t" + refType + "eference form ID = " + String.format("%08X", ref.getFormID()) + editIDStr + "\n";
                    if (!bl2) {
                        bl2 = true;
                        alteredList.add("\tPersistent references altered:\n");
                    }
                    alteredList.add(entry);
                }
            }
            for (PluginGroup pluginGroup : blockList) {
                List<PluginRecord> subBlockList = pluginGroup.getRecordList();
                boolean atLeastOne = false;
                for (PluginRecord subBlock : subBlockList) {
                    List<PluginRecord> cellList = ((PluginGroup)subBlock).getRecordList();
                    for (PluginRecord cell : cellList) {
                        String editIDStr;
                        if (cell instanceof PluginGroup || !cell.getRecordType().equals("CELL")) continue;
                        int idx1 = cell.getFormID() >>> 24;
                        String string = editIDStr = cell.getEditorID().equals("") ? "" : "; editor ID = " + cell.getEditorID();
                        if (idx1 != modIndex) continue;
                        String entry = "\tExterior cell form ID = " + String.format("%08X", cell.getFormID()) + editIDStr + "; coordinates = (" + this.getXCLCString(cell) + ")\n";
                        if (!atLeastOne) {
                            atLeastOne = true;
                            alteredList.add("\tExterior cells altered:\n");
                        }
                        alteredList.add(entry);
                    }
                }
            }
            i += 2;
        }
        return alteredList;
    }

    private String getXCLCString(PluginRecord rec) {
        List<PluginSubrecord> plSubrecs;
        String retStr = "Error";
        if (rec instanceof PluginGroup) {
            return retStr;
        }
        try {
            plSubrecs = rec.getSubrecords();
        }
        catch (Exception ex) {
            return retStr;
        }
        for (PluginSubrecord plSubrec : plSubrecs) {
            byte[] subrecordData;
            if (!plSubrec.getSubrecordType().equals("XCLC")) continue;
            try {
                subrecordData = plSubrec.getSubrecordData();
            }
            catch (Exception ex) {
                return retStr;
            }
            int x = SerializedElement.getInteger(subrecordData, 0);
            int y = SerializedElement.getInteger(subrecordData, 4);
            retStr = String.valueOf(x) + ", " + y;
            break;
        }
        return retStr;
    }

    private float getXCLLFogNear(PluginRecord rec) {
        List<PluginSubrecord> plSubrecs;
        float retVal = Float.NaN;
        if (rec instanceof PluginGroup) {
            return retVal;
        }
        try {
            plSubrecs = rec.getSubrecords();
        }
        catch (Exception ex) {
            return retVal;
        }
        for (PluginSubrecord plSubrec : plSubrecs) {
            byte[] subrecordData;
            if (!plSubrec.getSubrecordType().equals("XCLL")) continue;
            try {
                subrecordData = plSubrec.getSubrecordData();
            }
            catch (Exception ex) {
                return retVal;
            }
            int fogNearBits = SerializedElement.getInteger(subrecordData, 12);
            retVal = Float.intBitsToFloat(fogNearBits);
            break;
        }
        return retVal;
    }

    private boolean setXCLLFogNear(PluginRecord rec, float val) {
        boolean retBool = false;
        if (rec instanceof PluginGroup) {
            return retBool;
        }
        try {
            PluginSubrecord subXCLL = rec.getSubrecord("XCLL");
            if (subXCLL == null) {
                return retBool;
            }
            byte[] oldData = subXCLL.getSubrecordData();
            byte[] newData = new byte[oldData.length];
            System.arraycopy(oldData, 0, newData, 0, oldData.length);
            int valBits = Float.floatToIntBits(val);
            SerializedElement.setInteger(valBits, newData, 12);
            rec.changeSubrecord("XCLL", oldData, newData);
            retBool = true;
        }
        catch (Exception ex) {
            return retBool;
        }
        return retBool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readDialogue(Plugin pl) {
        int linesChanged = 0;
        File file = this.getDialogueReadFile();
        if (file == null) {
            return 0;
        }
        int dontLeave = JOptionPane.showConfirmDialog(this, "This will replace dialogue data in this plugin.\n Do you wish to continue?", "Possible Content Overwrite", 2, 2);
        if (dontLeave != 0) {
            return 0;
        }
        if (Main.debugMode) {
            System.out.printf("File <" + file.getAbsolutePath() + "> selected", new Object[0]);
        }
        BufferedReader inputStream = null;
        try {
            inputStream = new BufferedReader(new FileReader(file));
        }
        catch (Exception ex) {
            return 0;
        }
        String inLine = null;
        try {
            block6: while (true) {
                if ((inLine = inputStream.readLine()) == null) {
                    inputStream.close();
                    return linesChanged;
                }
                if (inLine.startsWith("TES4GECKO DIALOGUE DUMP") || inLine.endsWith("TAB:") || inLine.startsWith("//")) continue;
                String[] lineParts = inLine.split("\t");
                String[] fileParts = lineParts[0].split("_");
                String[] emoParts = lineParts[1].split(":");
                int plModIndex = pl.getMasterList().size();
                String dialogueLine = lineParts.length > 2 ? lineParts[2] : " ";
                String dialogueNotes = lineParts.length == 5 ? lineParts[4] : "";
                int i = plModIndex;
                while (true) {
                    if (i < 0) continue block6;
                    int formid = 0;
                    int emoLevel = 0;
                    int respNum = 0;
                    int emoType = EmotionCode.getCode(emoParts[0]);
                    try {
                        formid = Integer.parseInt(fileParts[2], 16);
                        emoLevel = Integer.parseInt(emoParts[1]);
                        respNum = Integer.parseInt(fileParts[3]);
                    }
                    catch (Exception ex) {
                        if (!Main.debugMode) continue block6;
                        System.out.printf("One of the numerical components in line <" + inLine + "> is not a number.", new Object[0]);
                        continue block6;
                    }
                    FormInfo info = pl.getFormMap().get(formid & 0xFFFFFF | i << 24);
                    if (info != null && info.getRecordType().equals("INFO")) {
                        if (!this.changeResponseInINFO(info, emoType, emoLevel, respNum, dialogueLine, dialogueNotes)) {
                            if (!Main.debugMode) continue block6;
                            System.out.printf("Error in changing response in line <" + inLine + ">.", new Object[0]);
                            continue block6;
                        }
                        ++linesChanged;
                        continue block6;
                    }
                    --i;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linesChanged;
    }

    private void dumpQuestDialogue(Plugin pl, PluginRecord plRec, boolean append) {
        this.dumpQuestDialogue(pl, plRec, append, null);
    }

    private void dumpQuestDialogue(Plugin pl, PluginRecord plRec, boolean append, File dumpFile) {
        FileOutputStream outFile;
        int dontLeave;
        File file;
        if (!plRec.getRecordType().equals("QUST")) {
            return;
        }
        if (dumpFile == null) {
            file = this.getDialogueDumpFile("QUST");
            if (file == null) {
                return;
            }
        } else {
            file = dumpFile;
        }
        if (!append && (dontLeave = JOptionPane.showConfirmDialog(this, "This will overwrite whatever data exists in the file.\n Do you wish to continue?", "Possible Content Overwrite", 2, 2)) != 0) {
            return;
        }
        String headerLine = "TES4GECKO DIALOGUE DUMP for Quest " + plRec.getEditorID() + " [" + String.format("%08X", new Integer(plRec.getFormID())) + "]\n";
        List<FormInfo> questInfos = this.findQuestInfos(pl, plRec.getFormID());
        if (questInfos.size() == 0 && dumpFile == null) {
            JOptionPane.showMessageDialog(this, "No dialogue data was found for this quest");
            return;
        }
        try {
            outFile = new FileOutputStream(file, append);
        }
        catch (Exception ex) {
            return;
        }
        try {
            outFile.write(headerLine.getBytes());
        }
        catch (Exception ex) {
            return;
        }
        int dialType = 0;
        while (dialType <= 6) {
            String dialTypeHeader = String.valueOf(DialogueTypeCode.getString(dialType).toUpperCase()) + " TAB:\n";
            boolean firstOneFound = true;
            for (FormInfo form : questInfos) {
                if (this.getInfoDialogueType(form) != dialType) continue;
                try {
                    if (firstOneFound) {
                        outFile.write(dialTypeHeader.getBytes());
                        firstOneFound = false;
                    }
                    outFile.write(this.dialogueForInfo(pl, form).getBytes());
                }
                catch (Exception ex) {
                    return;
                }
            }
            ++dialType;
        }
        try {
            outFile.close();
        }
        catch (Exception ex) {
            return;
        }
        if (dumpFile == null) {
            JOptionPane.showMessageDialog(this, "Dialogue data for quest " + plRec.getEditorID() + "\nwritten to file " + file.getName());
        }
    }

    private File getDialogueDumpFile(String recType) {
        FileOutputStream outFile = null;
        FileInputStream inFile = null;
        JFileChooser chooser = new JFileChooser(Main.pluginDirectory);
        chooser.setFileSelectionMode(2);
        String recName = "";
        if (recType.equals("NPC_")) {
            recName = "NPC";
        }
        if (recType.equals("QUST")) {
            recName = "Quest";
        }
        chooser.setDialogTitle("Select File to Dump " + recName + " Dialogue");
        chooser.setFileFilter(new TextFileFilter());
        if (chooser.showOpenDialog(this) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (!file.getName().contains(".")) {
            File newFile;
            file = newFile = new File(String.valueOf(file.getAbsolutePath()) + ".txt");
        }
        if (!file.getName().toUpperCase().endsWith(".TXT")) {
            JOptionPane.showMessageDialog(this, "Dialogue dump file \"" + file.getName() + "\" must be a text file.", "File Type Error", 0);
            return null;
        }
        if (file.exists() && (file.isDirectory() || !file.canWrite())) {
            JOptionPane.showMessageDialog(this, "Dialogue dump file \"" + file.getName() + "\" must be a writable file.", "File Type Error", 0);
            return null;
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception ex) {
                return null;
            }
        }
        try {
            String tmp;
            outFile = new FileOutputStream(file, true);
            outFile.close();
            inFile = new FileInputStream(file);
            byte[] headerTest = new byte["TES4GECKO DIALOGUE DUMP".length()];
            int bytesRead = inFile.read(headerTest);
            inFile.close();
            if (bytesRead != 0 && bytesRead != -1 && !(tmp = new String(headerTest)).equals("TES4GECKO DIALOGUE DUMP")) {
                JOptionPane.showMessageDialog(this, "Dialogue dump file \"" + file.getName() + "\" has non-dialogue dump content.", "File Type Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Dialogue dump file \"" + file.getName() + "\" cannot be opened.", "File Type Error", 0);
            return null;
        }
        return file;
    }

    private File getMasterModFile() {
        FileOutputStream outFile = null;
        FileInputStream inFile = null;
        JFileChooser chooser = new JFileChooser(Main.pluginDirectory);
        chooser.setFileSelectionMode(2);
        String recName = "";
        chooser.setDialogTitle("Select Master Alteration Report");
        chooser.setFileFilter(new TextFileFilter());
        if (chooser.showOpenDialog(this) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (!file.getName().contains(".")) {
            File newFile;
            file = newFile = new File(String.valueOf(file.getAbsolutePath()) + ".txt");
        }
        if (!file.getName().toUpperCase().endsWith(".TXT")) {
            JOptionPane.showMessageDialog(this, "Master alteration report \"" + file.getName() + "\" must be a text file.", "File Type Error", 0);
            return null;
        }
        if (file.exists() && (file.isDirectory() || !file.canWrite())) {
            JOptionPane.showMessageDialog(this, "Master alteration report \"" + file.getName() + "\" must be a writable file.", "File Type Error", 0);
            return null;
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception ex) {
                return null;
            }
        }
        try {
            String tmp;
            outFile = new FileOutputStream(file, true);
            outFile.close();
            inFile = new FileInputStream(file);
            byte[] headerTest = new byte["TES4GECKO MASTER ALTERATION REPORT".length()];
            int bytesRead = inFile.read(headerTest);
            inFile.close();
            if (bytesRead != 0 && bytesRead != -1 && !(tmp = new String(headerTest)).equals("TES4GECKO MASTER ALTERATION REPORT")) {
                JOptionPane.showMessageDialog(this, "Master alteration report \"" + file.getName() + "\" has unrelated content.", "File Type Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Master alteration report \"" + file.getName() + "\" cannot be opened.", "File Type Error", 0);
            return null;
        }
        return file;
    }

    private File getNewFormIDFile(String pluginName) {
        String formIDFileName = String.valueOf(Main.pluginDirectory) + Main.fileSeparator + pluginName + ".IDList";
        File file = new File(formIDFileName);
        if (file.exists() && (file.isDirectory() || !file.canWrite())) {
            JOptionPane.showMessageDialog(this, "Form ID report \"" + file.getName() + "\" must be a writable file.", "File Type Error", 0);
            return null;
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception ex) {
                return null;
            }
        } else {
            int selection = JOptionPane.showConfirmDialog(this, "<html>The file <i>" + file.getName() + "</i> already exists. Do you wish to overwrite?", "Form ID Report File", 0, 3);
            if (selection != 0) {
                return null;
            }
        }
        return file;
    }

    private File getDialogueReadFile() {
        byte[] headerTest;
        File file;
        block8: {
            FileInputStream inFile = null;
            JFileChooser chooser = new JFileChooser(Main.pluginDirectory);
            chooser.setFileSelectionMode(2);
            chooser.setDialogTitle("Select File to Read Dialogue");
            chooser.setFileFilter(new TextFileFilter());
            if (chooser.showOpenDialog(this) != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
            if (!file.getName().toUpperCase().endsWith(".TXT")) {
                JOptionPane.showMessageDialog(this, "Dialogue read file \"" + file.getName() + "\" must be a text file.", "File Type Error", 0);
                return null;
            }
            if (file.exists() && (file.isDirectory() || !file.canRead())) {
                JOptionPane.showMessageDialog(this, "Dialogue read file \"" + file.getName() + "\" must be a readable file.", "File Type Error", 0);
                return null;
            }
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, "Dialogue read file \"" + file.getName() + "\" must exist.", "File Type Error", 0);
                return null;
            }
            try {
                inFile = new FileInputStream(file);
                headerTest = new byte["TES4GECKO DIALOGUE DUMP".length()];
                int bytesRead = inFile.read(headerTest);
                inFile.close();
                if (bytesRead != 0 && bytesRead != -1) break block8;
                JOptionPane.showMessageDialog(this, "Dialogue read file \"" + file.getName() + "\" is empty.", "File Type Error", 0);
                return null;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Dialogue read file \"" + file.getName() + "\" cannot be opened.", "File Type Error", 0);
                return null;
            }
        }
        String tmp = new String(headerTest);
        if (!tmp.equals("TES4GECKO DIALOGUE DUMP")) {
            JOptionPane.showMessageDialog(this, "Dialogue read file \"" + file.getName() + "\" has non-dialogue read content.", "File Type Error", 0);
            return null;
        }
        return file;
    }

    private File getClipboardSaveFile() {
        FileOutputStream outFile = null;
        JFileChooser chooser = new JFileChooser(Main.pluginDirectory);
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle("Select Clipboard Save Destination");
        chooser.setFileFilter(new ESPFileFilter());
        if (chooser.showOpenDialog(this) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (!file.getName().contains(".")) {
            File newFile;
            file = newFile = new File(String.valueOf(file.getAbsolutePath()) + ".esp");
        }
        if (!file.getName().toUpperCase().endsWith(".ESP")) {
            JOptionPane.showMessageDialog(this, "Clipboard save file \"" + file.getName() + "\" must be an ESP file.", "File Type Error", 0);
            return null;
        }
        if (file.exists() && (file.isDirectory() || !file.canRead())) {
            JOptionPane.showMessageDialog(this, "Clipboard save file \"" + file.getName() + "\" must be a readable file.", "File Type Error", 0);
            return null;
        }
        if (file.exists() && !file.getName().toUpperCase().equals("GECKO CLIPBOARD.ESP")) {
            JOptionPane.showMessageDialog(this, "Clipboard save file \"" + file.getName() + "\" is not named\n" + "\"Gecko Clipboard.esp\" and therefore will not be overwritten.", "File Type Error", 0);
            return null;
        }
        try {
            outFile = new FileOutputStream(file, true);
            outFile.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Clipboard save file \"" + file.getName() + "\" cannot be opened.", "File Type Error", 0);
            return null;
        }
        return file;
    }

    private String dialogueForInfo(Plugin pl, FormInfo form) {
        List<PluginSubrecord> plSubrecs;
        String retStr = "";
        String questEditorID = "";
        String dialEditorID = "";
        if (!form.getRecordType().equals("INFO")) {
            return retStr;
        }
        PluginRecord plRec = (PluginRecord)form.getSource();
        if (plRec == null) {
            return retStr;
        }
        PluginGroup plGroup = (PluginGroup)plRec.getParent();
        if (plGroup == null) {
            return retStr;
        }
        int dialFormID = SerializedElement.getInteger(plGroup.getGroupLabel(), 0);
        FormInfo parentDial = pl.getFormMap().get(dialFormID);
        dialEditorID = parentDial == null ? "DID" + String.format("%08X", new Integer(plGroup.getFormID())) : parentDial.getEditorID();
        try {
            plSubrecs = plRec.getSubrecords();
        }
        catch (Exception ex) {
            return retStr;
        }
        for (PluginSubrecord plSubrec : plSubrecs) {
            byte[] subrecordData;
            if (plSubrec.getSubrecordType().equals("QSTI")) {
                try {
                    subrecordData = plSubrec.getSubrecordData();
                }
                catch (Exception ex) {
                    return retStr;
                }
                int parentQuestID = SerializedElement.getInteger(subrecordData, 0);
                FormInfo parentQuest = pl.getFormMap().get(new Integer(parentQuestID));
                if (parentQuest == null) {
                    questEditorID = "QID" + String.format("%08X", parentQuestID);
                    continue;
                }
                questEditorID = parentQuest.getEditorID();
                continue;
            }
            if (plSubrec.getSubrecordType().equals("TRDT")) {
                try {
                    subrecordData = plSubrec.getSubrecordData();
                }
                catch (Exception ex) {
                    return retStr;
                }
                int emotionCode = SerializedElement.getInteger(subrecordData, 0);
                int emotionValue = SerializedElement.getInteger(subrecordData, 4);
                byte responseNum = subrecordData[12];
                retStr = String.valueOf(retStr) + questEditorID + "_" + dialEditorID + "_" + String.format("%08X", form.getFormID() & 0xFFFFFF) + "_" + responseNum + "\t" + EmotionCode.getString(emotionCode) + ":" + emotionValue + "\t";
                continue;
            }
            if (plSubrec.getSubrecordType().equals("NAM1")) {
                try {
                    subrecordData = plSubrec.getSubrecordData();
                }
                catch (Exception ex) {
                    return retStr;
                }
                String dialogueLine = "";
                if (subrecordData.length > 1) {
                    dialogueLine = new String(subrecordData, 0, subrecordData.length - 1);
                }
                if (dialogueLine.trim().equals("")) {
                    retStr = String.valueOf(retStr) + "\"[No dialogue]\"";
                    continue;
                }
                retStr = String.valueOf(retStr) + "\"" + this.hideWhitespace(dialogueLine).trim() + "\"";
                continue;
            }
            if (!plSubrec.getSubrecordType().equals("NAM2")) continue;
            try {
                subrecordData = plSubrec.getSubrecordData();
            }
            catch (Exception ex) {
                return retStr;
            }
            String prodNote = "";
            if (subrecordData.length > 1) {
                prodNote = new String(subrecordData, 0, subrecordData.length - 1);
            }
            retStr = prodNote.trim().equals("") ? String.valueOf(retStr) + "\n" : String.valueOf(retStr) + "\tPRODNOTE:\t\"" + this.hideWhitespace(prodNote).trim() + "\"\n";
        }
        return retStr;
    }

    private boolean changeResponseInINFO(FormInfo form, int emoType, int emoLevel, int respNum, String dialogueLine, String dialogueNotes) {
        List<PluginSubrecord> plSubrecs;
        boolean retVal = false;
        if (!form.getRecordType().equals("INFO")) {
            return retVal;
        }
        PluginRecord plRec = (PluginRecord)form.getSource();
        if (plRec == null) {
            return retVal;
        }
        try {
            plSubrecs = plRec.getSubrecords();
        }
        catch (Exception ex) {
            return retVal;
        }
        int TRDTRspNum = 0;
        for (PluginSubrecord plSubrec : plSubrecs) {
            byte[] subrecordData;
            String newStr;
            if (plSubrec.getSubrecordType().equals("TRDT")) {
                byte[] subrecordData2;
                try {
                    subrecordData2 = plSubrec.getSubrecordData();
                }
                catch (Exception ex) {
                    return retVal;
                }
                TRDTRspNum = subrecordData2[12];
                if (TRDTRspNum != respNum) continue;
                SerializedElement.setInteger(emoType == -1 ? 0 : emoType, subrecordData2, 0);
                SerializedElement.setInteger(emoLevel < 0 || emoLevel > 100 ? 50 : emoLevel, subrecordData2, 4);
                try {
                    plSubrec.setSubrecordData(subrecordData2);
                    continue;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (plSubrec.getSubrecordType().equals("NAM1")) {
                if (TRDTRspNum != respNum) continue;
                newStr = dialogueLine.replace('\"', ' ').trim();
                if (newStr.equals("[No dialogue]")) {
                    newStr = " ";
                }
                String cleanLine = this.unhideWhitespace(newStr);
                byte[] cleanLineBytes = cleanLine.getBytes();
                subrecordData = new byte[cleanLineBytes.length + 1];
                System.arraycopy(cleanLineBytes, 0, subrecordData, 0, cleanLineBytes.length);
                subrecordData[cleanLineBytes.length] = 0;
                try {
                    plSubrec.setSubrecordData(subrecordData);
                }
                catch (Exception ex) {
                    return false;
                }
                retVal = true;
                continue;
            }
            if (!plSubrec.getSubrecordType().equals("NAM2") || TRDTRspNum != respNum) continue;
            newStr = dialogueNotes.replace('\"', ' ').trim();
            String cleanNote = this.unhideWhitespace(newStr);
            byte[] cleanNoteBytes = cleanNote.getBytes();
            subrecordData = new byte[cleanNoteBytes.length + 1];
            System.arraycopy(cleanNoteBytes, 0, subrecordData, 0, cleanNoteBytes.length);
            subrecordData[cleanNoteBytes.length] = 0;
            try {
                plSubrec.setSubrecordData(subrecordData);
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (retVal) {
            try {
                plRec.setSubrecords(plSubrecs);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return retVal;
    }

    private String hideWhitespace(String param) {
        return param.replaceAll("\t", "[TAB]").replaceAll("\r", "[RET]").replaceAll("\n", "[NL]").replaceAll("\"", "[DQ]");
    }

    private String unhideWhitespace(String param) {
        return param.replaceAll("\\[TAB\\]", "\t").replaceAll("\\[RET\\]", "\r").replaceAll("\\[NL\\]", "\n").replaceAll("\\[DQ\\]", "\"");
    }

    private int getInfoDialogueType(FormInfo form) {
        List<PluginSubrecord> plSubrecs;
        int retVal = -1;
        if (!form.getRecordType().equals("INFO")) {
            return retVal;
        }
        PluginRecord plRec = (PluginRecord)form.getSource();
        if (plRec == null) {
            return retVal;
        }
        try {
            plSubrecs = plRec.getSubrecords();
        }
        catch (Exception ex) {
            return retVal;
        }
        for (PluginSubrecord plSubrec : plSubrecs) {
            byte[] subrecordData;
            if (!plSubrec.getSubrecordType().equals("DATA")) continue;
            try {
                subrecordData = plSubrec.getSubrecordData();
            }
            catch (Exception ex) {
                return retVal;
            }
            retVal = subrecordData[0];
        }
        return retVal;
    }

    private void selectQuestInfos(Plugin pl, PluginRecord plRec, JTree plTree, FormInfo questForm, boolean selected) {
        if (!plRec.getRecordType().equals("QUST")) {
            return;
        }
        ArrayList<TreePath> pathList = new ArrayList<TreePath>();
        pathList.add(new TreePath(questForm.getRecordNode().getPath()));
        List<FormInfo> questInfos = this.findQuestInfos(pl, questForm.getFormID());
        for (FormInfo INFOFormInfo : questInfos) {
            RecordNode recordNode = INFOFormInfo.getRecordNode();
            TreePath treePath = new TreePath(recordNode.getPath());
            pathList.add(treePath);
        }
        if (pathList.size() > 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            TreePath[] pathArray = new TreePath[pathList.size()];
            if (selected) {
                this.pluginTree.addSelectionPaths(pathList.toArray(pathArray));
            } else {
                this.pluginTree.removeSelectionPaths(pathList.toArray(pathArray));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.pluginTree.scrollPathToVisible(pathArray[0]);
        }
    }

    private void selectWRLDData(Plugin pl, PluginRecord plRec, JTree plTree, FormInfo WSForm, boolean selected, boolean regions) {
        if (!plRec.getRecordType().equals("WRLD")) {
            return;
        }
        ArrayList<TreePath> pathList = new ArrayList<TreePath>();
        pathList.add(new TreePath(WSForm.getRecordNode().getPath()));
        List<FormInfo> WRLDChildren = this.findWRLDChildren(pl, WSForm.getFormID(), selected, regions);
        for (FormInfo WRLDChild : WRLDChildren) {
            RecordNode recordNode = WRLDChild.getRecordNode();
            TreePath treePath = new TreePath(recordNode.getPath());
            pathList.add(treePath);
        }
        if (pathList.size() > 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            TreePath[] pathArray = new TreePath[pathList.size()];
            if (selected) {
                this.pluginTree.addSelectionPaths(pathList.toArray(pathArray));
            } else {
                this.pluginTree.removeSelectionPaths(pathList.toArray(pathArray));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.pluginTree.scrollPathToVisible(pathArray[0]);
        }
    }

    private void selectPersistentRefs(Plugin pl, PluginRecord plRec, JTree plTree, FormInfo cellForm, boolean selected, int WSID) {
        if (!plRec.getRecordType().equals("CELL")) {
            return;
        }
        ArrayList<TreePath> pathList = new ArrayList<TreePath>();
        pathList.add(new TreePath(cellForm.getRecordNode().getPath()));
        List<FormInfo> refInfos = this.findPersistentRefs(pl, plRec, WSID);
        for (FormInfo refFormInfo : refInfos) {
            RecordNode recordNode = refFormInfo.getRecordNode();
            TreePath treePath = new TreePath(recordNode.getPath());
            pathList.add(treePath);
        }
        if (pathList.size() > 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            TreePath[] pathArray = new TreePath[pathList.size()];
            if (selected) {
                this.pluginTree.addSelectionPaths(pathList.toArray(pathArray));
            } else {
                this.pluginTree.removeSelectionPaths(pathList.toArray(pathArray));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.pluginTree.scrollPathToVisible(pathArray[0]);
        }
    }

    private List<FormInfo> findPersistentRefs(Plugin pl, PluginRecord plRec, int WSID) {
        ArrayList<FormInfo> refList = new ArrayList<FormInfo>();
        PluginGroup WRLDGroup = pl.getTopGroup("WRLD");
        if (WRLDGroup == null) {
            return refList;
        }
        List<PluginRecord> recList = WRLDGroup.getRecordList();
        PluginGroup worldGroup = null;
        int i = 0;
        while (i < recList.size()) {
            worldGroup = (PluginGroup)recList.get(i + 1);
            if (worldGroup.getGroupParentID() == WSID) break;
            i += 2;
        }
        if (worldGroup == null) {
            return refList;
        }
        List<PluginRecord> worldGroupList = worldGroup.getRecordList();
        PluginGroup persistentCellGroup = null;
        for (PluginRecord block : worldGroupList) {
            if (!(block instanceof PluginGroup)) continue;
            switch (((PluginGroup)block).getGroupType()) {
                case 6: {
                    persistentCellGroup = (PluginGroup)((PluginGroup)block).getRecordList().get(0);
                }
            }
        }
        if (persistentCellGroup == null) {
            return refList;
        }
        String[] cellXY = this.getXCLCString(plRec).split(",");
        float cellX = Float.parseFloat(cellXY[0].trim());
        float cellY = Float.parseFloat(cellXY[1].trim());
        List<PluginRecord> refGroup = persistentCellGroup.getRecordList();
        for (PluginRecord ref : refGroup) {
            if (ref instanceof PluginGroup) continue;
            PluginSubrecord positionRotation = null;
            try {
                positionRotation = ref.getSubrecord("DATA");
            }
            catch (Exception ex) {
                continue;
            }
            if (positionRotation == null) continue;
            String[] coords = positionRotation.getDisplayData().split("[ \n:(),]+");
            float refX = Float.parseFloat(coords[1].trim());
            float refY = Float.parseFloat(coords[2].trim());
            if (!(refX >= cellX * 4096.0f) || !(refX < (cellX + 1.0f) * 4096.0f) || !(refY >= cellY * 4096.0f) || !(refY < (cellY + 1.0f) * 4096.0f)) continue;
            FormInfo refInfo = pl.getFormMap().get(ref.getFormID());
            refList.add(refInfo);
        }
        return refList;
    }

    private int toggleRefsBaseIDCellGroup(Plugin pl, PluginGroup plGroup, JTree plTree, List<Integer> baseIDList) {
        int retVal = 0;
        if (plGroup.getGroupType() != 6) {
            return retVal;
        }
        ArrayList pathList = new ArrayList();
        List<FormInfo> refInfos = this.findRefsBaseIDCellGroup(pl, plGroup, baseIDList);
        for (FormInfo refFormInfo : refInfos) {
            RecordNode recordNode = refFormInfo.getRecordNode();
            TreePath treePath = new TreePath(recordNode.getPath());
            if (!this.toggleRecordIgnore(plTree, treePath, recordNode)) continue;
            ++retVal;
        }
        return retVal;
    }

    private int replaceRefsBaseIDCellGroup(Plugin pl, PluginGroup plGroup, JTree plTree, int oldBaseID, int newBaseID) {
        int retVal = 0;
        ArrayList<Integer> singleBaseID = new ArrayList<Integer>(1);
        singleBaseID.add(oldBaseID);
        if (plGroup.getGroupType() != 6) {
            return retVal;
        }
        List<FormInfo> refInfos = this.findRefsBaseIDCellGroup(pl, plGroup, singleBaseID);
        for (FormInfo refFormInfo : refInfos) {
            PluginRecord record = (PluginRecord)refFormInfo.getSource();
            try {
                if (!record.changeSubrecord("NAME", oldBaseID, newBaseID)) continue;
                ++retVal;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    private boolean replaceLandTexIDCellGroup(Plugin pl, PluginGroup plGroup, JTree plTree, int oldLTEXID, int newLTEXID) {
        boolean retVal = false;
        if (plGroup.getGroupType() != 6) {
            return retVal;
        }
        FormInfo LANDInfo = this.findLANDRecCellGroup(pl, plGroup);
        if (LANDInfo != null) {
            PluginRecord record = (PluginRecord)LANDInfo.getSource();
            retVal = this.replaceLandTexIDInLANDRec(record, oldLTEXID, newLTEXID);
        }
        return retVal;
    }

    private boolean replaceLandTexIDInLANDRec(PluginRecord plRec, int oldLTEXID, int newLTEXID) {
        boolean retVal = false;
        if (plRec instanceof PluginGroup || !plRec.getRecordType().equals("LAND")) {
            return retVal;
        }
        try {
            List<PluginSubrecord> subrecordList = plRec.getSubrecords();
            ListIterator<PluginSubrecord> lit = subrecordList.listIterator();
            while (lit.hasNext()) {
                byte[] subrecData;
                int currLTEXID;
                PluginSubrecord checkSubrecord = lit.next();
                String subType = checkSubrecord.getSubrecordType();
                if (!subType.equals("ATXT") && !subType.equals("BTXT") || (currLTEXID = SerializedElement.getInteger(subrecData = checkSubrecord.getSubrecordData(), 0)) != oldLTEXID) continue;
                SerializedElement.setInteger(newLTEXID, subrecData, 0);
                checkSubrecord.setSubrecordData(subrecData);
                retVal = true;
            }
            if (retVal) {
                plRec.setSubrecords(subrecordList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private boolean findLandTexIDInLANDRec(PluginRecord plRec, int landTexID) {
        boolean retVal = false;
        if (plRec instanceof PluginGroup || !plRec.getRecordType().equals("LAND")) {
            return retVal;
        }
        try {
            List<PluginSubrecord> subrecordList = plRec.getSubrecords();
            ListIterator<PluginSubrecord> lit = subrecordList.listIterator();
            while (lit.hasNext()) {
                byte[] subrecData;
                int currLTEXID;
                PluginSubrecord checkSubrecord = lit.next();
                String subType = checkSubrecord.getSubrecordType();
                if (!subType.equals("ATXT") && !subType.equals("BTXT") || (currLTEXID = SerializedElement.getInteger(subrecData = checkSubrecord.getSubrecordData(), 0)) != landTexID) continue;
                retVal = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private int toggleRefsBaseIDAllInteriorCells(Plugin pl, PluginGroup plGroup, JTree plTree, List<Integer> baseIDList) {
        int retVal = 0;
        if (plGroup.getGroupType() != 0 || !plGroup.getGroupRecordType().equals("CELL")) {
            return retVal;
        }
        List<PluginRecord> intBlockList = plGroup.getRecordList();
        for (PluginRecord rec : intBlockList) {
            if (!(rec instanceof PluginGroup) || ((PluginGroup)rec).getGroupType() != 2) continue;
            PluginGroup intBlock = (PluginGroup)rec;
            List<PluginRecord> intSubBlockList = intBlock.getRecordList();
            for (PluginRecord rec2 : intSubBlockList) {
                if (!(rec2 instanceof PluginGroup) || ((PluginGroup)rec2).getGroupType() != 3) continue;
                PluginGroup intSubBlock = (PluginGroup)rec2;
                List<PluginRecord> cellList = intSubBlock.getRecordList();
                for (PluginRecord rec3 : cellList) {
                    if (!(rec3 instanceof PluginGroup) || ((PluginGroup)rec3).getGroupType() != 6) continue;
                    PluginGroup cellGroup = (PluginGroup)rec3;
                    retVal += this.toggleRefsBaseIDCellGroup(pl, cellGroup, plTree, baseIDList);
                }
            }
        }
        return retVal;
    }

    private int toggleRefsBaseIDAllCellsInWRLD(Plugin pl, PluginGroup plGroup, JTree plTree, List<Integer> baseIDList, int regionID) {
        int retVal = 0;
        if (plGroup.getGroupType() != 1) {
            return retVal;
        }
        int WSID = plGroup.getGroupParentID();
        List<PluginRecord> intBlockList = plGroup.getRecordList();
        for (PluginRecord rec : intBlockList) {
            if (!(rec instanceof PluginGroup)) continue;
            if (((PluginGroup)rec).getGroupType() == 6) {
                if (regionID > 0) continue;
                retVal += this.toggleRefsBaseIDCellGroup(pl, (PluginGroup)rec, plTree, baseIDList);
                continue;
            }
            if (((PluginGroup)rec).getGroupType() != 4) continue;
            PluginGroup extBlock = (PluginGroup)rec;
            List<PluginRecord> extSubBlockList = extBlock.getRecordList();
            for (PluginRecord rec2 : extSubBlockList) {
                if (!(rec2 instanceof PluginGroup) || ((PluginGroup)rec2).getGroupType() != 5) continue;
                PluginGroup extSubBlock = (PluginGroup)rec2;
                List<PluginRecord> cellList = extSubBlock.getRecordList();
                int i = 0;
                while (i < cellList.size()) {
                    PluginRecord cell = cellList.get(i);
                    PluginGroup cellGroup = (PluginGroup)cellList.get(i + 1);
                    if (regionID <= 0) {
                        retVal += this.toggleRefsBaseIDCellGroup(pl, cellGroup, plTree, baseIDList);
                    } else if (cell.hasSubrecordOfType("XCLR")) {
                        try {
                            String cellRegionStr = cell.getSubrecord("XCLR").getDisplayData();
                            boolean inRegion = false;
                            String[] cellRegionArray = cellRegionStr.split(",");
                            int j = 0;
                            while (j < cellRegionArray.length) {
                                int cellRegionID = Integer.parseInt(cellRegionArray[j].trim(), 16);
                                if (cellRegionID == regionID) {
                                    inRegion = true;
                                    break;
                                }
                                ++j;
                            }
                            if (inRegion) {
                                retVal += this.toggleRefsBaseIDCellGroup(pl, cellGroup, plTree, baseIDList);
                                List<FormInfo> persistentRefs = this.findPersistentRefs(pl, cell, WSID);
                                for (FormInfo form : persistentRefs) {
                                    RecordNode recordNode = form.getRecordNode();
                                    PluginRecord refRec = recordNode.getRecord();
                                    String recType = refRec.getRecordType();
                                    if (!recType.equals("REFR") && !recType.equals("ACRE") && !recType.equals("ACHR")) continue;
                                    try {
                                        TreePath treePath;
                                        int refBaseID = Integer.parseInt(rec.getSubrecord("NAME").getDisplayData(), 16);
                                        if (!baseIDList.contains(refBaseID) || !this.toggleRecordIgnore(plTree, treePath = new TreePath(recordNode.getPath()), recordNode)) continue;
                                        ++retVal;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    i += 2;
                }
            }
        }
        return retVal;
    }

    private List<FormInfo> findRefsBaseIDCellGroup(Plugin pl, PluginGroup plGroup, List<Integer> baseIDList) {
        ArrayList<FormInfo> refList = new ArrayList<FormInfo>();
        if (plGroup.getGroupType() != 6) {
            return refList;
        }
        List<PluginRecord> cellGroupList = plGroup.getRecordList();
        ArrayList<PluginRecord> cellRefList = new ArrayList<PluginRecord>();
        for (PluginRecord block : cellGroupList) {
            if (!(block instanceof PluginGroup)) continue;
            List<PluginRecord> tmpList = ((PluginGroup)block).getRecordList();
            for (PluginRecord ref : tmpList) {
                String refType = ref.getRecordType();
                if (!refType.equals("REFR") && !refType.equals("ACRE") && !refType.equals("ACHR")) continue;
                cellRefList.add(ref);
            }
        }
        for (PluginRecord ref : cellRefList) {
            if (ref instanceof PluginGroup) continue;
            int refID = ref.getFormID();
            int baseID = -1;
            try {
                baseID = Integer.parseInt(ref.getSubrecord("NAME").getDisplayData(), 16);
            }
            catch (Exception ex) {
                continue;
            }
            if (!baseIDList.contains(baseID)) continue;
            FormInfo refInfo = pl.getFormMap().get(refID);
            refList.add(refInfo);
        }
        return refList;
    }

    private FormInfo findLANDRecCellGroup(Plugin pl, PluginGroup plGroup) {
        FormInfo LANDRec = null;
        if (plGroup.getGroupType() != 6) {
            return LANDRec;
        }
        List<PluginRecord> cellGroupList = plGroup.getRecordList();
        block0: for (PluginRecord block : cellGroupList) {
            if (!(block instanceof PluginGroup)) continue;
            List<PluginRecord> tmpList = ((PluginGroup)block).getRecordList();
            for (PluginRecord ref : tmpList) {
                String refType = ref.getRecordType();
                if (!refType.equals("LAND")) continue;
                LANDRec = pl.getFormMap().get(ref.getFormID());
                break block0;
            }
        }
        return LANDRec;
    }

    private int toggleRefsBaseIDPlugin(Plugin pl, JTree plTree, List<Integer> baseIDList) {
        int retVal = 0;
        List<FormInfo> allForms = pl.getFormList();
        this.setCursor(Cursor.getPredefinedCursor(3));
        long startTime = System.currentTimeMillis();
        for (FormInfo refFormInfo : allForms) {
            RecordNode recordNode;
            TreePath treePath;
            PluginRecord plRec = (PluginRecord)refFormInfo.getSource();
            String refType = plRec.getRecordType();
            if (!refType.equals("REFR") && !refType.equals("ACRE") && !refType.equals("ACHR")) continue;
            int baseID = -1;
            try {
                baseID = Integer.parseInt(plRec.getSubrecord("NAME").getDisplayData(), 16);
            }
            catch (Exception ex) {
                continue;
            }
            if (!baseIDList.contains(baseID) || !this.toggleRecordIgnore(plTree, treePath = new TreePath((recordNode = refFormInfo.getRecordNode()).getPath()), recordNode)) continue;
            ++retVal;
        }
        long medTime = System.currentTimeMillis();
        if (Main.debugMode) {
            System.out.printf("Part 1 of selectRefsBaseIDPlugin() completed in %.2f seconds.\n", Float.valueOf((float)(medTime - startTime) / 1000.0f));
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        long endTime = System.currentTimeMillis();
        return retVal;
    }

    private int replaceRefsBaseIDPlugin(Plugin pl, JTree plTree, int oldBaseID, int newBaseID) {
        int retVal = 0;
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo refFormInfo : allForms) {
            PluginRecord plRec = (PluginRecord)refFormInfo.getSource();
            String refType = plRec.getRecordType();
            if (!refType.equals("REFR") && !refType.equals("ACRE") && !refType.equals("ACHR")) continue;
            try {
                if (!plRec.changeSubrecord("NAME", oldBaseID, newBaseID)) continue;
                ++retVal;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    private int replaceLandTexIDPlugin(Plugin pl, JTree plTree, int oldLTEXID, int newLTEXID) {
        int retVal = 0;
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo refFormInfo : allForms) {
            PluginRecord plRec = (PluginRecord)refFormInfo.getSource();
            String refType = plRec.getRecordType();
            if (!refType.equals("LAND") || !this.replaceLandTexIDInLANDRec(plRec, oldLTEXID, newLTEXID)) continue;
            ++retVal;
        }
        return retVal;
    }

    private int replaceRefsBaseIDAllInteriorCells(Plugin pl, PluginGroup plGroup, JTree plTree, int oldBaseID, int newBaseID) {
        int retVal = 0;
        if (plGroup.getGroupType() != 0 || !plGroup.getGroupRecordType().equals("CELL")) {
            return retVal;
        }
        List<PluginRecord> intBlockList = plGroup.getRecordList();
        for (PluginRecord rec : intBlockList) {
            if (!(rec instanceof PluginGroup) || ((PluginGroup)rec).getGroupType() != 2) continue;
            PluginGroup intBlock = (PluginGroup)rec;
            List<PluginRecord> intSubBlockList = intBlock.getRecordList();
            for (PluginRecord rec2 : intSubBlockList) {
                if (!(rec2 instanceof PluginGroup) || ((PluginGroup)rec2).getGroupType() != 3) continue;
                PluginGroup intSubBlock = (PluginGroup)rec2;
                List<PluginRecord> cellList = intSubBlock.getRecordList();
                for (PluginRecord rec3 : cellList) {
                    if (!(rec3 instanceof PluginGroup) || ((PluginGroup)rec3).getGroupType() != 6) continue;
                    PluginGroup cellGroup = (PluginGroup)rec3;
                    retVal += this.replaceRefsBaseIDCellGroup(pl, cellGroup, plTree, oldBaseID, newBaseID);
                }
            }
        }
        return retVal;
    }

    private int replaceRefsBaseIDAllCellsInWRLD(Plugin pl, PluginGroup plGroup, JTree plTree, int oldBaseID, int newBaseID, int regionID) {
        int retVal = 0;
        if (plGroup.getGroupType() != 1) {
            return retVal;
        }
        int WSID = plGroup.getGroupParentID();
        List<PluginRecord> intBlockList = plGroup.getRecordList();
        for (PluginRecord rec : intBlockList) {
            if (!(rec instanceof PluginGroup)) continue;
            if (((PluginGroup)rec).getGroupType() == 6) {
                if (regionID > 0) continue;
                retVal += this.replaceRefsBaseIDCellGroup(pl, (PluginGroup)rec, plTree, oldBaseID, newBaseID);
                continue;
            }
            if (((PluginGroup)rec).getGroupType() != 4) continue;
            PluginGroup extBlock = (PluginGroup)rec;
            List<PluginRecord> extSubBlockList = extBlock.getRecordList();
            for (PluginRecord rec2 : extSubBlockList) {
                if (!(rec2 instanceof PluginGroup) || ((PluginGroup)rec2).getGroupType() != 5) continue;
                PluginGroup extSubBlock = (PluginGroup)rec2;
                List<PluginRecord> cellList = extSubBlock.getRecordList();
                int i = 0;
                while (i < cellList.size()) {
                    PluginRecord cell = cellList.get(i);
                    PluginGroup cellGroup = (PluginGroup)cellList.get(i + 1);
                    if (regionID <= 0) {
                        retVal += this.replaceRefsBaseIDCellGroup(pl, cellGroup, plTree, oldBaseID, newBaseID);
                    } else if (cell.hasSubrecordOfType("XCLR")) {
                        try {
                            String cellRegionStr = cell.getSubrecord("XCLR").getDisplayData();
                            boolean inRegion = false;
                            String[] cellRegionArray = cellRegionStr.split(",");
                            int j = 0;
                            while (j < cellRegionArray.length) {
                                int cellRegionID = Integer.parseInt(cellRegionArray[j].trim(), 16);
                                if (cellRegionID == regionID) {
                                    inRegion = true;
                                    break;
                                }
                                ++j;
                            }
                            if (inRegion) {
                                retVal += this.replaceRefsBaseIDCellGroup(pl, cellGroup, plTree, oldBaseID, newBaseID);
                                List<FormInfo> persistentRefs = this.findPersistentRefs(pl, cell, WSID);
                                for (FormInfo form : persistentRefs) {
                                    RecordNode recordNode = form.getRecordNode();
                                    PluginRecord refRec = recordNode.getRecord();
                                    String recType = refRec.getRecordType();
                                    if (!recType.equals("REFR") && !recType.equals("ACRE") && !recType.equals("ACHR")) continue;
                                    try {
                                        if (!refRec.changeSubrecord("NAME", oldBaseID, newBaseID)) continue;
                                        ++retVal;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    i += 2;
                }
            }
        }
        return retVal;
    }

    private int replaceLandTexIDAllCellsInWRLD(Plugin pl, PluginGroup plGroup, JTree plTree, int oldLTEXID, int newLTEXID, int regionID) {
        int retVal = 0;
        if (plGroup.getGroupType() != 1) {
            return retVal;
        }
        int WSID = plGroup.getGroupParentID();
        List<PluginRecord> intBlockList = plGroup.getRecordList();
        for (PluginRecord rec : intBlockList) {
            if (!(rec instanceof PluginGroup) || ((PluginGroup)rec).getGroupType() == 6 || ((PluginGroup)rec).getGroupType() != 4) continue;
            PluginGroup extBlock = (PluginGroup)rec;
            List<PluginRecord> extSubBlockList = extBlock.getRecordList();
            for (PluginRecord rec2 : extSubBlockList) {
                if (!(rec2 instanceof PluginGroup) || ((PluginGroup)rec2).getGroupType() != 5) continue;
                PluginGroup extSubBlock = (PluginGroup)rec2;
                List<PluginRecord> cellList = extSubBlock.getRecordList();
                int i = 0;
                while (i < cellList.size()) {
                    PluginRecord cell = cellList.get(i);
                    PluginGroup cellGroup = (PluginGroup)cellList.get(i + 1);
                    if (regionID <= 0) {
                        retVal += this.replaceLandTexIDCellGroup(pl, cellGroup, plTree, oldLTEXID, newLTEXID) ? 1 : 0;
                    } else if (cell.hasSubrecordOfType("XCLR")) {
                        try {
                            String cellRegionStr = cell.getSubrecord("XCLR").getDisplayData();
                            boolean inRegion = false;
                            String[] cellRegionArray = cellRegionStr.split(",");
                            int j = 0;
                            while (j < cellRegionArray.length) {
                                int cellRegionID = Integer.parseInt(cellRegionArray[j].trim(), 16);
                                if (cellRegionID == regionID) {
                                    inRegion = true;
                                    break;
                                }
                                ++j;
                            }
                            if (inRegion) {
                                retVal += this.replaceLandTexIDCellGroup(pl, cellGroup, plTree, oldLTEXID, newLTEXID) ? 1 : 0;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    i += 2;
                }
            }
        }
        return retVal;
    }

    private int getStartFormID(int baseID) {
        int retVal = -1;
        String inputID = (String)JOptionPane.showInputDialog(this, "<html>Please enter the starting form ID <i>in hex</i>\n(Numbering will start at this number plus one):", "New Starting Form ID", -1, null, null, String.format("%08X", baseID));
        if (inputID == null) {
            return retVal;
        }
        try {
            retVal = Integer.parseInt(inputID, 16);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Value entered: \"" + inputID + "\" is not a valid number.", "Entry Error", 0);
            return -1;
        }
        if (retVal < baseID) {
            JOptionPane.showMessageDialog(this, "Number entered: \"" + String.format("%08X", retVal) + "\" is too small.", "Entry Error", 0);
            return -1;
        }
        return retVal;
    }

    private int enterFormID(int defaultID, String caption) {
        String inputID;
        int retVal = -1;
        String defCaption = "<html>Please enter the desired form ID <i>in hex</i>:";
        if (caption == null || caption.equals("")) {
            caption = defCaption;
        }
        if ((inputID = (String)JOptionPane.showInputDialog(this, caption, "Please Enter Form ID", -1, null, null, defaultID < 0 ? "" : String.format("%08X", defaultID))) == null) {
            return retVal;
        }
        try {
            retVal = Integer.parseInt(inputID.trim(), 16);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Value entered: \"" + inputID + "\" is not a valid number.", "Entry Error", 0);
            return -1;
        }
        return retVal;
    }

    private List<Integer> getFormIDs() {
        ArrayList<Integer> retList = new ArrayList<Integer>();
        String inputIDs = (String)JOptionPane.showInputDialog(this, "<html>Please enter the form IDs to use. These must be in hex,\nseparated by commas with optional spaces:", "Initial Form ID List", -1, null, null, null);
        if (inputIDs == null) {
            return retList;
        }
        try {
            String[] formArray = inputIDs.split(",");
            int i = 0;
            while (i < formArray.length) {
                int formID = Integer.parseInt(formArray[i].trim(), 16);
                retList.add(formID);
                ++i;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Value entered: \"" + inputIDs + "\" has invalid characters.", "Entry Error", 0);
            return new ArrayList<Integer>();
        }
        return retList;
    }

    private void popupEventHandler(String action) {
        if (action == null || !action.startsWith("Popup") || !action.contains(":")) {
            return;
        }
        String[] argList = null;
        try {
            argList = action.split(":");
        }
        catch (Exception ex) {
            return;
        }
        if (argList.length < 5) {
            return;
        }
        Plugin pl = null;
        JTree plTree = null;
        String whichJTree = argList[1];
        String recType = argList[2];
        int formID = 0;
        String groupType = "";
        if (!recType.equals("PLUG")) {
            if (recType.equals("GRUP")) {
                groupType = argList[3];
            } else {
                formID = Integer.parseInt(argList[3]);
            }
        }
        String cmd = argList[4];
        if (whichJTree.equals("Plugin")) {
            pl = this.plugin;
            plTree = this.pluginTree;
        } else {
            pl = this.clipboard;
            plTree = this.clipboardTree;
        }
        FormInfo formInfo = null;
        PluginRecord pluginRec = null;
        if (formID != 0) {
            formInfo = pl.getFormMap().get(new Integer(formID));
            pluginRec = (PluginRecord)formInfo.getSource();
        }
        if (whichJTree.equals("Clipboard")) {
            if (recType.equals("PLUG")) {
                if (cmd.equals("PrepareLipSynch")) {
                    int selection = JOptionPane.showConfirmDialog(this, "<html>This operation will reduce the clipboard plugin to the bare minimum\nrequired to load successfully in version 1.0 of the CS in order to generate\nLIP files for the dialogue under the quests copied to the clipboard. This plugin\n<html>will <b>not</b> be playable or moddable and <b><i>UNDER NO CIRCUMSTANCES</i></b> should be \nrenamed back to the name of the original plugin (" + this.plugin.getName() + ").\n" + "Do you still want to do this?", "Prepare Lip Synch Plugin", 0, 3);
                    if (selection != 0) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int formIDsRemoved = this.removeNonLipSynchObjects(pl);
                    List<Integer> NPCIDList = this.getNPCsInDialogue(pl);
                    List<Integer> factionIDList = this.getFactionsInDialogue(pl);
                    List<Integer> NPCFactionList = this.getNPCsInFactions(pl, factionIDList);
                    if (!NPCFactionList.isEmpty()) {
                        for (Integer factNPCID : NPCFactionList) {
                            if (NPCIDList.contains(factNPCID)) continue;
                            NPCIDList.add(factNPCID);
                        }
                    }
                    List<PluginRecord> raceList = this.getRaceList(pl);
                    List<PluginRecord> NPCList = null;
                    if (!NPCIDList.isEmpty()) {
                        NPCList = this.getRecordList(pl, NPCIDList, "NPC_");
                    }
                    formIDsRemoved += this.removeRecordsNotOnList(pl, NPCIDList, "NPC_");
                    List<PluginRecord> factionList = null;
                    if (!factionIDList.isEmpty()) {
                        factionList = this.getRecordList(pl, factionIDList, "FACT");
                    }
                    int racesAdded = this.addRecordsToGroup(plTree, "RACE", raceList);
                    int NPCsAdded = NPCList == null ? 0 : this.addRecordsToGroup(plTree, "NPC_", NPCList);
                    int formIDsAltered = this.reduceLipSynchObjects(pl);
                    if ((formIDsRemoved += this.removeRecordsNotOnList(pl, factionIDList, "FACT")) > 0 || formIDsAltered > 0 || racesAdded > 0 || NPCsAdded > 0) {
                        pl.setMasterList(new ArrayList<String>());
                        pl.setVersion(0.8f);
                        pl.setCreator("TES4Gecko LIP file-friendly ESP generation");
                        pl.setSummary("This plugin is derived from " + this.plugin.getName() + ". It can ONLY be used for LIP file generation.");
                        this.setClipboardModified(true);
                        PluginNode newPluginNode = new PluginNode(pl);
                        try {
                            newPluginNode.buildNodes(null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        plTree.setModel(new DefaultTreeModel(newPluginNode));
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    if (formIDsRemoved == 0 && formIDsAltered == 0 && racesAdded == 0 && NPCsAdded == 0) {
                        JOptionPane.showMessageDialog(this, "No objects were removed, altered, or added", "Object Cleaning Result", 0);
                    } else {
                        JOptionPane.showMessageDialog(this, formIDsRemoved + " objects were removed" + "; " + formIDsAltered + " objects were altered, " + racesAdded + " races were added, and " + NPCsAdded + " NPCs were added.", "Object Cleaning Result", 1);
                    }
                }
            } else if (recType.equals("GRUP")) {
                if (groupType.equals("DIAL")) {
                    if (cmd.equals("RemoveCondition")) {
                        String inputID = (String)JOptionPane.showInputDialog(this, "Please select the condition function to remove\nNote: ALL conditions that use this function will be removed:", "Function to Remove", -1, null, FunctionCode.funcCodeList, FunctionCode.funcCodeList[0]);
                        if (inputID == null) {
                            return;
                        }
                        int funcCode = FunctionCode.funcCodeMap.get(inputID);
                        int formsAltered = this.removeConditionFromInfos(pl, funcCode, null, null, null, null);
                        if (formsAltered == 0) {
                            JOptionPane.showMessageDialog(this, "No responses were changed", "Condition Removal Result", 0);
                        } else {
                            JOptionPane.showMessageDialog(this, formsAltered + " responses were changed", "Condition Removal Result", 1);
                            this.setClipboardModified(true);
                        }
                    }
                    if (cmd.equals("RemoveExcessQSTIs")) {
                        HashSet<Integer> questFormIDs = new HashSet<Integer>();
                        PluginGroup QUSTGroup = null;
                        List<PluginGroup> groupList = pl.getGroupList();
                        for (PluginGroup group : groupList) {
                            String groupRecordType = group.getGroupRecordType();
                            if (!groupRecordType.equals("QUST")) continue;
                            QUSTGroup = group;
                            break;
                        }
                        if (QUSTGroup == null) {
                            JOptionPane.showMessageDialog(this, "No DIALs were changed", "Quest Reference Removal Result", 0);
                        } else {
                            List<PluginRecord> recordList = QUSTGroup.getRecordList();
                            for (PluginRecord rec : recordList) {
                                if (rec instanceof PluginGroup || !rec.getRecordType().equals("QUST")) continue;
                                questFormIDs.add(rec.getFormID());
                            }
                            int formsAltered = this.removeQuestsFromDIALs(pl, questFormIDs);
                            if (formsAltered == 0) {
                                JOptionPane.showMessageDialog(this, "No DIALs were changed", "Quest Reference Removal Result", 0);
                            } else {
                                JOptionPane.showMessageDialog(this, formsAltered + " DIALs were changed", "Quest Reference Removal Result", 1);
                                this.setClipboardModified(true);
                            }
                        }
                    }
                }
            } else if (cmd.equals("ChangeEditorID")) {
                String inputID = (String)JOptionPane.showInputDialog(this, "Please enter the new editor ID for " + pluginRec.getEditorID() + ":", "New Editor ID", -1, null, null, pluginRec.getEditorID());
                if (inputID == null || inputID.equals("")) {
                    return;
                }
                try {
                    pluginRec.setEditorID(inputID);
                    this.setClipboardModified(true);
                    ((DefaultTreeModel)this.clipboardTree.getModel()).reload();
                }
                catch (Exception ex) {
                    return;
                }
            } else {
                int baseID;
                if (recType.equals("QUST") && cmd.equals("ChangeFormIDs")) {
                    baseID = this.getStartFormID(this.clipboardHighFormID);
                    if (baseID == -1) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int formIDsAdded = this.modifyQuestFormID(pl, pluginRec, baseID, argList[5]);
                    if (formIDsAdded > 0) {
                        this.clipboardHighFormID = baseID + formIDsAdded;
                        this.setClipboardModified(true);
                        ((DefaultTreeModel)this.clipboardTree.getModel()).reload();
                        pl.repopulateFormList();
                        pl.repopulateFormMap();
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (recType.equals("WRLD") && cmd.equals("ChangeFormIDs")) {
                    baseID = this.getStartFormID(this.clipboardHighFormID);
                    if (baseID == -1) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int formIDsModified = this.modifyWorldspace(pl, pluginRec, baseID);
                    if (formIDsModified > 0) {
                        this.clipboardHighFormID = baseID + formIDsModified;
                        this.setClipboardModified(true);
                        DefaultTreeModel model = (DefaultTreeModel)plTree.getModel();
                        model.reload();
                        JOptionPane.showMessageDialog(this, formIDsModified + " form IDs were changed", "Worldspace Form ID Result", 1);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else if (whichJTree.equals("Plugin")) {
            boolean append;
            if (recType.equals("QUST")) {
                if (cmd.equals("SelectInfos")) {
                    boolean selected = argList[5].equals("Select");
                    long startTime = System.currentTimeMillis();
                    this.selectQuestInfos(pl, pluginRec, plTree, formInfo, selected);
                    if (Main.debugMode) {
                        System.out.printf("Quest %s %s completed in %.2f seconds.\n", pluginRec.getEditorID(), selected ? "selection" : "deselection", Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
                    }
                }
                if (cmd.equals("DumpDialogue")) {
                    append = argList[5].equals("Append");
                    this.dumpQuestDialogue(pl, pluginRec, append);
                }
            }
            if (recType.equals("NPC_") && cmd.equals("DumpDialogue")) {
                append = argList[5].equals("Append");
                this.dumpNPCDialogue(pl, pluginRec, append);
            }
            if (recType.equals("REGN")) {
                Object newPluginNode;
                int numChanged;
                if (cmd.equals("ToggleRefs")) {
                    PluginGroup plGroup = pl.getWorldspaceGroupForRegion(pluginRec);
                    List<Integer> baseIDList = this.getFormIDs();
                    if (baseIDList.size() == 0) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int numToggled = this.toggleRefsBaseIDAllCellsInWRLD(pl, plGroup, plTree, baseIDList, formID);
                    if (numToggled > 0) {
                        JOptionPane.showMessageDialog(this, numToggled + " references had their ignore status changed", "Toggle Reference Ignore Result", 1);
                        this.setPluginModified(true);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (cmd.equals("ReplaceBaseRefs")) {
                    PluginGroup plGroup = pl.getWorldspaceGroupForRegion(pluginRec);
                    int oldBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID to be replaced <i>in hex</i>:");
                    if (oldBaseID < 0) {
                        return;
                    }
                    int newBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID replacement value <i>in hex</i>:");
                    if (newBaseID < 0) {
                        return;
                    }
                    if (newBaseID == oldBaseID) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    numChanged = this.replaceRefsBaseIDAllCellsInWRLD(pl, plGroup, plTree, oldBaseID, newBaseID, formID);
                    if (numChanged > 0) {
                        newPluginNode = new PluginNode(pl);
                        try {
                            ((PluginNode)newPluginNode).buildNodes(null);
                        }
                        catch (Exception groupRecordType) {
                            // empty catch block
                        }
                        plTree.setModel(new DefaultTreeModel((TreeNode)newPluginNode));
                        JOptionPane.showMessageDialog(this, numChanged + " references had their base IDs replaced", "Replace Reference Base ID", 1);
                        this.setPluginModified(true);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (cmd.equals("ReplaceLTEXRefs")) {
                    PluginGroup plGroup = pl.getWorldspaceGroupForRegion(pluginRec);
                    int oldLTEXID = this.enterFormID(-1, "<html> Please enter the landscape texture ID to be replaced <i>in hex</i>:");
                    if (oldLTEXID < 0) {
                        return;
                    }
                    int newLTEXID = this.enterFormID(-1, "<html> Please enter the landscape texture ID replacement value <i>in hex</i>:");
                    if (newLTEXID < 0) {
                        return;
                    }
                    if (newLTEXID == oldLTEXID) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    numChanged = this.replaceLandTexIDAllCellsInWRLD(pl, plGroup, plTree, oldLTEXID, newLTEXID, formID);
                    if (numChanged > 0) {
                        newPluginNode = new PluginNode(pl);
                        try {
                            ((PluginNode)newPluginNode).buildNodes(null);
                        }
                        catch (Exception groupRecordType) {
                            // empty catch block
                        }
                        plTree.setModel(new DefaultTreeModel((TreeNode)newPluginNode));
                        String plural = numChanged > 1 ? " cells" : " cell";
                        JOptionPane.showMessageDialog(this, numChanged + plural + " in region had landscape texture ID " + String.format("%08X", oldLTEXID) + " replaced with " + String.format("%08X", newLTEXID) + ".", "Replace Landscape Texture ID", 1);
                        this.setPluginModified(true);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (recType.equals("WRLD") && (cmd.equals("SelectRegions") || cmd.equals("SelectWRLDs"))) {
                boolean regions = cmd.equals("SelectRegions");
                boolean selected = argList[5].equals("Select");
                long startTime = System.currentTimeMillis();
                this.selectWRLDData(pl, pluginRec, plTree, formInfo, selected, regions);
                if (Main.debugMode) {
                    System.out.printf("WRLD %s %s completed in %.2f seconds.\n", pluginRec.getEditorID(), selected ? "selection" : "deselection", Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
                }
            }
            if (recType.equals("CELL") && cmd.equals("SelectPersistentRefs")) {
                boolean selected = argList[5].equals("Select");
                int worldID = Integer.parseInt(argList[6], 16);
                long startTime = System.currentTimeMillis();
                this.selectPersistentRefs(pl, pluginRec, plTree, formInfo, selected, worldID);
                if (Main.debugMode) {
                    System.out.printf("Persistent refs for CELL %s %s completed in %.2f seconds.\n", pluginRec.getEditorID(), selected ? "selection" : "deselection", Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
                }
            }
            if (recType.equals("GRUP")) {
                PluginNode newPluginNode;
                TreePath path22;
                TreeNode n2;
                if (groupType.equals("DIAL")) {
                    if (cmd.equals("ReadDialogue")) {
                        int linesRead = this.readDialogue(pl);
                        if (linesRead == 0) {
                            JOptionPane.showMessageDialog(this, "No lines of dialogue were changed", "Read Dialogue Result", 0);
                        } else {
                            JOptionPane.showMessageDialog(this, linesRead + " lines of dialogue were changed", "Read Dialogue Result", 1);
                            this.setPluginModified(true);
                        }
                    }
                    if (cmd.equals("RemoveExcessQSTIs")) {
                        HashSet<Integer> questFormIDs = new HashSet<Integer>();
                        PluginGroup QUSTGroup = null;
                        List<PluginGroup> groupList = pl.getGroupList();
                        for (PluginGroup group : groupList) {
                            String groupRecordType = group.getGroupRecordType();
                            if (!groupRecordType.equals("QUST")) continue;
                            QUSTGroup = group;
                            break;
                        }
                        if (QUSTGroup == null) {
                            JOptionPane.showMessageDialog(this, "No DIALs were changed", "Quest Reference Removal Result", 0);
                        } else {
                            List<PluginRecord> recordList = QUSTGroup.getRecordList();
                            for (PluginRecord rec : recordList) {
                                if (rec instanceof PluginGroup || !rec.getRecordType().equals("QUST")) continue;
                                questFormIDs.add(rec.getFormID());
                            }
                            int formsAltered = this.removeQuestsFromDIALs(pl, questFormIDs);
                            if (formsAltered == 0) {
                                JOptionPane.showMessageDialog(this, "No DIALs were changed", "Quest Reference Removal Result", 0);
                            } else {
                                JOptionPane.showMessageDialog(this, formsAltered + " DIALs were changed", "Quest Reference Removal Result", 1);
                                this.setPluginModified(true);
                            }
                        }
                    }
                }
                if (groupType.equals("CELL")) {
                    int selRow;
                    TreePath topCellPath;
                    TreeNode node;
                    if (cmd.equals("ShowCells") && (node = (TreeNode)(topCellPath = this.pluginTree.getPathForRow(selRow = Integer.parseInt(argList[5]))).getLastPathComponent()).getChildCount() >= 0) {
                        Enumeration<? extends TreeNode> e1 = node.children();
                        while (e1.hasMoreElements()) {
                            TreeNode n1 = e1.nextElement();
                            TreePath path1 = topCellPath.pathByAddingChild(n1);
                            Enumeration<? extends TreeNode> e2 = n1.children();
                            while (e2.hasMoreElements()) {
                                n2 = e2.nextElement();
                                path22 = path1.pathByAddingChild(n2);
                                this.pluginTree.expandPath(path22);
                            }
                        }
                    }
                    if (cmd.equals("ToggleRefs")) {
                        selRow = Integer.parseInt(argList[5]);
                        topCellPath = this.pluginTree.getPathForRow(selRow);
                        node = (TreeNode)topCellPath.getLastPathComponent();
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        List<Integer> baseIDList = this.getFormIDs();
                        if (baseIDList.size() == 0) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int numToggled = this.toggleRefsBaseIDAllInteriorCells(pl, plGroup, plTree, baseIDList);
                        if (numToggled > 0) {
                            JOptionPane.showMessageDialog(this, numToggled + " references had their ignore status changed", "Toggle Reference Ignore Result", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (cmd.equals("ReplaceBaseRefs")) {
                        selRow = Integer.parseInt(argList[5]);
                        topCellPath = this.pluginTree.getPathForRow(selRow);
                        node = (TreeNode)topCellPath.getLastPathComponent();
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        int oldBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID to be replaced <i>in hex</i>:");
                        if (oldBaseID < 0) {
                            return;
                        }
                        int newBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID replacement value <i>in hex</i>:");
                        if (newBaseID < 0) {
                            return;
                        }
                        if (newBaseID == oldBaseID) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int numChanged = this.replaceRefsBaseIDAllInteriorCells(pl, plGroup, plTree, oldBaseID, newBaseID);
                        if (numChanged > 0) {
                            newPluginNode = new PluginNode(pl);
                            try {
                                newPluginNode.buildNodes(null);
                            }
                            catch (Exception path22) {
                                // empty catch block
                            }
                            plTree.setModel(new DefaultTreeModel(newPluginNode));
                            JOptionPane.showMessageDialog(this, numChanged + " references had their base IDs replaced", "Replace Reference Base ID", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (groupType.equals("CELLCONTENTS")) {
                    int selRow;
                    TreePath topCellPath;
                    TreeNode node;
                    if (cmd.equals("ToggleRefs") && (node = (TreeNode)(topCellPath = this.pluginTree.getPathForRow(selRow = Integer.parseInt(argList[5]))).getLastPathComponent()) instanceof GroupNode && ((GroupNode)node).getUserObject() != null && ((PluginGroup)((GroupNode)node).getUserObject()).getGroupType() == 6) {
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        List<Integer> baseIDList = this.getFormIDs();
                        if (baseIDList.size() == 0) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int numToggled = this.toggleRefsBaseIDCellGroup(pl, plGroup, plTree, baseIDList);
                        if (numToggled > 0) {
                            JOptionPane.showMessageDialog(this, numToggled + " references had their ignore status changed", "Toggle Reference Ignore Result", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (cmd.equals("ReplaceBaseRefs") && (node = (TreeNode)(topCellPath = this.pluginTree.getPathForRow(selRow = Integer.parseInt(argList[5]))).getLastPathComponent()) instanceof GroupNode && ((GroupNode)node).getUserObject() != null && ((PluginGroup)((GroupNode)node).getUserObject()).getGroupType() == 6) {
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        int oldBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID to be replaced <i>in hex</i>:");
                        if (oldBaseID < 0) {
                            return;
                        }
                        int newBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID replacement value <i>in hex</i>:");
                        if (newBaseID < 0) {
                            return;
                        }
                        if (newBaseID == oldBaseID) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int numChanged = this.replaceRefsBaseIDCellGroup(pl, plGroup, plTree, oldBaseID, newBaseID);
                        if (numChanged > 0) {
                            newPluginNode = new PluginNode(pl);
                            try {
                                newPluginNode.buildNodes(null);
                            }
                            catch (Exception path22) {
                                // empty catch block
                            }
                            plTree.setModel(new DefaultTreeModel(newPluginNode));
                            JOptionPane.showMessageDialog(this, numChanged + " references had their base IDs replaced", "Replace Reference Base ID", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (cmd.equals("ReplaceLTEXRefs") && (node = (TreeNode)(topCellPath = this.pluginTree.getPathForRow(selRow = Integer.parseInt(argList[5]))).getLastPathComponent()) instanceof GroupNode && ((GroupNode)node).getUserObject() != null && ((PluginGroup)((GroupNode)node).getUserObject()).getGroupType() == 6) {
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        int oldLTEXID = this.enterFormID(-1, "<html> Please enter the landscape texture ID to be replaced <i>in hex</i>:");
                        if (oldLTEXID < 0) {
                            return;
                        }
                        int newLTEXID = this.enterFormID(-1, "<html> Please enter the landscape texture ID replacement value <i>in hex</i>:");
                        if (newLTEXID < 0) {
                            return;
                        }
                        if (newLTEXID == oldLTEXID) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        boolean changed = this.replaceLandTexIDCellGroup(pl, plGroup, plTree, oldLTEXID, newLTEXID);
                        if (changed) {
                            newPluginNode = new PluginNode(pl);
                            try {
                                newPluginNode.buildNodes(null);
                            }
                            catch (Exception path22) {
                                // empty catch block
                            }
                            plTree.setModel(new DefaultTreeModel(newPluginNode));
                            JOptionPane.showMessageDialog(this, "Landscape texture ID " + String.format("%08X", oldLTEXID) + " changed to " + String.format("%08X", newLTEXID) + " in this cell.", "Replace Landscape Texture ID", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (groupType.equals("WORLDSPACE")) {
                    int selRow;
                    TreePath topCellPath;
                    TreeNode node;
                    if (cmd.equals("ShowCells") && (node = (TreeNode)(topCellPath = this.pluginTree.getPathForRow(selRow = Integer.parseInt(argList[5]))).getLastPathComponent()).getChildCount() >= 0) {
                        Enumeration<? extends TreeNode> e1 = node.children();
                        while (e1.hasMoreElements()) {
                            TreeNode n1 = e1.nextElement();
                            if (!(n1 instanceof GroupNode) || ((GroupNode)n1).getUserObject() == null || ((PluginGroup)((GroupNode)n1).getUserObject()).getGroupType() != 4) continue;
                            TreePath path1 = topCellPath.pathByAddingChild(n1);
                            Enumeration<? extends TreeNode> e2 = n1.children();
                            while (e2.hasMoreElements()) {
                                n2 = e2.nextElement();
                                path22 = path1.pathByAddingChild(n2);
                                this.pluginTree.expandPath(path22);
                            }
                        }
                    }
                    if (cmd.equals("ToggleRefs")) {
                        selRow = Integer.parseInt(argList[5]);
                        topCellPath = this.pluginTree.getPathForRow(selRow);
                        node = (TreeNode)topCellPath.getLastPathComponent();
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        List<Integer> baseIDList = this.getFormIDs();
                        if (baseIDList.size() == 0) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int numToggled = this.toggleRefsBaseIDAllCellsInWRLD(pl, plGroup, plTree, baseIDList, -1);
                        if (numToggled > 0) {
                            JOptionPane.showMessageDialog(this, numToggled + " references had their ignore status changed", "Toggle Reference Ignore Result", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (cmd.equals("ReplaceBaseRefs")) {
                        selRow = Integer.parseInt(argList[5]);
                        topCellPath = this.pluginTree.getPathForRow(selRow);
                        node = (TreeNode)topCellPath.getLastPathComponent();
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        int oldBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID to be replaced <i>in hex</i>:");
                        if (oldBaseID < 0) {
                            return;
                        }
                        int newBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID replacement value <i>in hex</i>:");
                        if (newBaseID < 0) {
                            return;
                        }
                        if (newBaseID == oldBaseID) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int numChanged = this.replaceRefsBaseIDAllCellsInWRLD(pl, plGroup, plTree, oldBaseID, newBaseID, -1);
                        if (numChanged > 0) {
                            newPluginNode = new PluginNode(pl);
                            try {
                                newPluginNode.buildNodes(null);
                            }
                            catch (Exception path23) {
                                // empty catch block
                            }
                            plTree.setModel(new DefaultTreeModel(newPluginNode));
                            JOptionPane.showMessageDialog(this, numChanged + " references had their base IDs replaced", "Replace Reference Base ID", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (cmd.equals("ReplaceLTEXRefs")) {
                        selRow = Integer.parseInt(argList[5]);
                        topCellPath = this.pluginTree.getPathForRow(selRow);
                        node = (TreeNode)topCellPath.getLastPathComponent();
                        PluginGroup plGroup = (PluginGroup)((GroupNode)node).getUserObject();
                        int oldLTEXID2 = this.enterFormID(-1, "<html> Please enter the landscape texture ID to be replaced <i>in hex</i>:");
                        if (oldLTEXID2 < 0) {
                            return;
                        }
                        int newLTEXID = this.enterFormID(-1, "<html> Please enter the landscape texture ID replacement value <i>in hex</i>:");
                        if (newLTEXID < 0) {
                            return;
                        }
                        if (newLTEXID == oldLTEXID2) {
                            return;
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int numChanged = this.replaceLandTexIDAllCellsInWRLD(pl, plGroup, plTree, oldLTEXID2, newLTEXID, -1);
                        if (numChanged > 0) {
                            newPluginNode = new PluginNode(pl);
                            try {
                                newPluginNode.buildNodes(null);
                            }
                            catch (Exception path23) {
                                // empty catch block
                            }
                            plTree.setModel(new DefaultTreeModel(newPluginNode));
                            String plural = numChanged > 1 ? " cells" : " cell";
                            JOptionPane.showMessageDialog(this, numChanged + plural + " in world space had landscape texture ID " + String.format("%08X", oldLTEXID2) + " replaced with " + String.format("%08X", newLTEXID) + ".", "Replace Landscape Texture ID", 1);
                            this.setPluginModified(true);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
            if (recType.equals("PLUG")) {
                if (cmd.equals("MasterModReport")) {
                    boolean append2 = argList[5].equals("Append");
                    this.masterModReport(pl, append2);
                }
                if (cmd.equals("FormIDReport")) {
                    this.formIDReport(pl);
                }
                if (cmd.equals("ToggleRefs")) {
                    List<Integer> baseIDList = this.getFormIDs();
                    if (baseIDList.size() == 0) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int numToggled = this.toggleRefsBaseIDPlugin(pl, plTree, baseIDList);
                    if (numToggled > 0) {
                        JOptionPane.showMessageDialog(this, numToggled + " references had their ignore status changed", "Toggle Reference Ignore Result", 1);
                        this.setPluginModified(true);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (cmd.equals("ReplaceBaseRefs")) {
                    int oldBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID to be replaced <i>in hex</i>:");
                    if (oldBaseID < 0) {
                        return;
                    }
                    int newBaseID = this.enterFormID(-1, "<html> Please enter the reference base ID replacement value <i>in hex</i>:");
                    if (newBaseID < 0) {
                        return;
                    }
                    if (newBaseID == oldBaseID) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int numChanged = this.replaceRefsBaseIDPlugin(pl, plTree, oldBaseID, newBaseID);
                    if (numChanged > 0) {
                        PluginNode newPluginNode = new PluginNode(pl);
                        try {
                            newPluginNode.buildNodes(null);
                        }
                        catch (Exception oldLTEXID2) {
                            // empty catch block
                        }
                        plTree.setModel(new DefaultTreeModel(newPluginNode));
                        JOptionPane.showMessageDialog(this, numChanged + " references had their base IDs replaced", "Replace Reference Base ID", 1);
                        this.setPluginModified(true);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (cmd.equals("ReplaceLTEXRefs")) {
                    int oldLTEXID = this.enterFormID(-1, "<html> Please enter the landscape texture ID to be replaced <i>in hex</i>:");
                    if (oldLTEXID < 0) {
                        return;
                    }
                    int newLTEXID = this.enterFormID(-1, "<html> Please enter the landscape texture ID replacement value <i>in hex</i>:");
                    if (newLTEXID < 0) {
                        return;
                    }
                    if (newLTEXID == oldLTEXID) {
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    int numChanged = this.replaceLandTexIDPlugin(pl, plTree, oldLTEXID, newLTEXID);
                    if (numChanged > 0) {
                        PluginNode newPluginNode = new PluginNode(pl);
                        try {
                            newPluginNode.buildNodes(null);
                        }
                        catch (Exception oldLTEXID2) {
                            // empty catch block
                        }
                        plTree.setModel(new DefaultTreeModel(newPluginNode));
                        JOptionPane.showMessageDialog(this, numChanged + " cells in plugin had landscape texture ID " + String.format("%08X", oldLTEXID) + " replaced with " + String.format("%08X", newLTEXID) + ".", "Replace Landscape Texture ID", 1);
                        this.setPluginModified(true);
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (cmd.equals("DumpPluginDialogue")) {
                    File file;
                    PluginGroup questGroup = pl.getTopGroup("QUST");
                    if (questGroup == null || questGroup.isEmpty()) {
                        JOptionPane.showMessageDialog(this, "No quests in plugin, so no dialogue to dump", "Dump Plugin Dialogue", 1);
                    }
                    if ((file = this.getDialogueDumpFile("QUST")) == null) {
                        return;
                    }
                    List<PluginRecord> allQuests = questGroup.getAllPluginRecords();
                    boolean firstQuestDone = false;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (PluginRecord quest : allQuests) {
                        this.dumpQuestDialogue(pl, quest, firstQuestDone, file);
                        firstQuestDone = true;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(this, "All dialogue in " + pl.getName() + " dumped to " + file.getName() + " [" + allQuests.size() + " quests total]", "Dump Plugin Dialogue", 1);
                }
                if (cmd.equals("FogFix")) {
                    String plural;
                    int numCellsChanged = 0;
                    int numCellsWithXCLL = 0;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    List<FormInfo> allForms = pl.getFormList();
                    for (FormInfo recFormInfo : allForms) {
                        if (recFormInfo.getFormID() == 20) continue;
                        PluginRecord plRec = (PluginRecord)recFormInfo.getSource();
                        if (plRec == null) {
                            if (!Main.debugMode) continue;
                            System.out.printf("FormInfo %08X has no record\n", recFormInfo.getFormID());
                            continue;
                        }
                        String recordType = plRec.getRecordType();
                        if (recordType == null && Main.debugMode) {
                            System.out.printf("Record %08X has no record type\n", plRec.getFormID());
                        }
                        if (recordType == null || !recordType.equals("CELL")) continue;
                        try {
                            if (!plRec.hasSubrecordOfType("XCLL")) continue;
                            if (Main.debugMode && plRec.hasSubrecordOfType("XCLC")) {
                                System.out.printf("Record %08X has both XCLL & XCLC subrecords\n", plRec.getFormID());
                            }
                            ++numCellsWithXCLL;
                            if (this.getXCLLFogNear(plRec) != 0.0f || !this.setXCLLFogNear(plRec, 1.0E-4f)) continue;
                            if (Main.debugMode) {
                                System.out.printf("Cell ID %08X with name %s had fog fix applied.\n", plRec.getFormID(), plRec.getEditorID());
                            }
                            ++numCellsChanged;
                        }
                        catch (Exception newPluginNode) {
                            // empty catch block
                        }
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    String string = plural = numCellsWithXCLL == 1 ? " cell was" : " cells were";
                    if (numCellsChanged > 0) {
                        String plural2 = numCellsChanged == 1 ? " cell" : " cells";
                        JOptionPane.showMessageDialog(this, numCellsWithXCLL + plural + " inspected and " + numCellsChanged + plural2 + " had the fog fix applied.", "NVIDIA/ATI Fog Fix Result", 1);
                        this.setPluginModified(true);
                    } else {
                        JOptionPane.showMessageDialog(this, numCellsWithXCLL + plural + " inspected but no cells were altered.", "NVIDIA/ATI Fog Fix Result", 1);
                    }
                }
                if (cmd.equals("ChangeMusic")) {
                    String plural;
                    int numCellsChanged = 0;
                    int numCellsWithXCLC = 0;
                    String musicTypeStr = CellMusicDialog.showDialog(this);
                    if (musicTypeStr.equals("Cancel")) {
                        return;
                    }
                    byte musicType = 0;
                    if (musicTypeStr.equals("Public")) {
                        musicType = 1;
                    }
                    if (musicTypeStr.equals("Dungeon")) {
                        musicType = 2;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    List<FormInfo> allForms = pl.getFormList();
                    for (FormInfo recFormInfo : allForms) {
                        if (recFormInfo.getFormID() == 20) continue;
                        PluginRecord plRec = (PluginRecord)recFormInfo.getSource();
                        if (plRec == null) {
                            if (!Main.debugMode) continue;
                            System.out.printf("FormInfo %08X has no record\n", recFormInfo.getFormID());
                            continue;
                        }
                        String recordType = plRec.getRecordType();
                        if (recordType == null && Main.debugMode) {
                            System.out.printf("Record %08X has no record type\n", plRec.getFormID());
                        }
                        if (recordType == null || !recordType.equals("CELL")) continue;
                        try {
                            if (!plRec.hasSubrecordOfType("XCLC")) continue;
                            if (Main.debugMode && plRec.hasSubrecordOfType("XCLL")) {
                                System.out.printf("Record %08X has both XCLL & XCLC subrecords\n", plRec.getFormID());
                            }
                            ++numCellsWithXCLC;
                            if (musicType == 0 && plRec.hasSubrecordOfType("XCMT")) {
                                if (!plRec.removeSubrecords("XCMT")) continue;
                                if (Main.debugMode) {
                                    System.out.printf("Cell ID %08X had XCMT removed.\n", plRec.getFormID());
                                }
                                ++numCellsChanged;
                                continue;
                            }
                            if (musicType == 0) continue;
                            if (plRec.hasSubrecordOfType("XCMT")) {
                                byte currMusic = Byte.parseByte(plRec.getSubrecord("XCMT").getDisplayData(), 16);
                                if (currMusic == musicType || !plRec.changeSubrecord("XCMT", currMusic, musicType)) continue;
                                ++numCellsChanged;
                                continue;
                            }
                            if (!plRec.insertSubrecordAfter("XCMT", musicType, "XCLC")) continue;
                            ++numCellsChanged;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    String string = plural = numCellsWithXCLC == 1 ? " cell was" : " cells were";
                    if (numCellsChanged > 0) {
                        String plural2 = numCellsChanged == 1 ? " cell" : " cells";
                        JOptionPane.showMessageDialog(this, numCellsWithXCLC + plural + " inspected and " + numCellsChanged + plural2 + " had the music type changed.", "Music Type Change Result", 1);
                        this.setPluginModified(true);
                    } else {
                        JOptionPane.showMessageDialog(this, numCellsWithXCLC + plural + " inspected but no cells were altered.", "Music Type Change Result", 1);
                    }
                }
            }
        }
    }

    private class DialogWindowListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            DisplayDialog.this.closeDialog();
        }
    }

    private class DisplayCellRenderer
    extends DefaultTreeCellRenderer {
        public DisplayCellRenderer() {
            this.setTextSelectionColor(Color.WHITE);
            this.setTextNonSelectionColor(Color.BLACK);
            this.setBackgroundSelectionColor(Color.BLUE);
            this.setBackgroundNonSelectionColor(Color.WHITE);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            Component component = super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            if (value instanceof RecordNode) {
                int modIdx = ((RecordNode)value).getRecord().getFormID() >>> 24;
                Color bkgnd = PluginColorMap.getPluginColor(modIdx);
                this.setBackgroundNonSelectionColor(bkgnd);
            } else {
                this.setBackgroundNonSelectionColor(Color.WHITE);
            }
            return component;
        }
    }

    private class PluginColorTableRenderer
    extends DefaultTableCellRenderer {
        private PluginColorTableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String s = table.getModel().getValueAt(row, 0).toString();
            comp.setBackground(PluginColorMap.getPluginColor(s));
            return comp;
        }
    }
}

