/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.EditLeveledList;
import TES4Gecko.FormAdjust;
import TES4Gecko.FormInfo;
import TES4Gecko.Main;
import TES4Gecko.Master;
import TES4Gecko.Plugin;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginInfo;
import TES4Gecko.PluginRecord;
import TES4Gecko.PluginSubrecord;
import TES4Gecko.RegionCellDialog;
import TES4Gecko.SerializedElement;
import TES4Gecko.StatusDialog;
import TES4Gecko.WorkerDialog;
import TES4Gecko.WorkerTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.zip.DataFormatException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeTask
extends WorkerTask {
    private String[] pluginNames;
    private PluginInfo pluginInfo;
    private boolean masterMerge;
    private boolean yesToAll = false;
    private Plugin[] plugins;
    private Plugin mergedPlugin;
    private List<String> mergedMasterList;
    private int mergedMasterCount;
    private Master[] masters;
    private Map<Integer, FormInfo> mergedFormMap;
    private Map<String, FormInfo> mergedEditorMap;
    private int highFormID;
    private boolean useFloorFormID = false;
    private int floorFormID;
    Map<Integer, List<PluginRecord>> deletedINFOMap;
    private static JFrame parentWindow;

    public MergeTask(StatusDialog statusDialog, String[] pluginNames, PluginInfo pluginInfo) {
        super(statusDialog);
        this.pluginNames = pluginNames;
        this.pluginInfo = pluginInfo;
        this.masterMerge = pluginInfo == null;
    }

    public static void mergeToMaster(JFrame parent, File masterFile, File pluginFile) {
        parentWindow = parent;
        String[] pluginNames = new String[]{masterFile.getName(), pluginFile.getName()};
        MergeTask.mergePlugins(parent, pluginNames, null);
    }

    public static void mergePlugins(JFrame parent, String[] pluginNames, PluginInfo pluginInfo) {
        parentWindow = parent;
        StatusDialog statusDialog = new StatusDialog(parent, " ", "Merge Plugin");
        MergeTask worker = new MergeTask(statusDialog, pluginNames, pluginInfo);
        statusDialog.setWorker(worker);
        worker.start();
        statusDialog.showDialog();
        if (statusDialog.getStatus() == 1) {
            if (worker.masterMerge) {
                JOptionPane.showMessageDialog(parent, String.valueOf(pluginNames[0]) + " updated", "Merge Plugin", 1);
            } else {
                JOptionPane.showMessageDialog(parent, String.valueOf(pluginInfo.getName()) + " created", "Merge Plugin", 1);
            }
        } else {
            JOptionPane.showMessageDialog(parent, "Merge failed", "Merge Plugin", 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int i;
        int selection;
        boolean completed = false;
        Plugin plugin = null;
        Master master = null;
        float version = 0.0f;
        boolean manageMerge = false;
        if (this.masterMerge && (selection = JOptionPane.showConfirmDialog(parentWindow, "<html>Do you wish to manage the merge? Choosing <i>yes</i>\nwill allow for user intervention at points within the merge;\notherwise default merge behavior will take place.", "Manage Merge?", 0, 3)) == 0) {
            manageMerge = true;
        }
        try {
            PluginGroup pluginGroup;
            File mergedFile;
            int count;
            block79: {
                ArrayList<Integer> regionIDs;
                List<Integer> cellRegionList;
                this.plugins = new Plugin[this.pluginNames.length];
                i = 0;
                while (i < this.pluginNames.length) {
                    File inFile = new File(String.valueOf(Main.pluginDirectory) + Main.fileSeparator + this.pluginNames[i]);
                    plugin = new Plugin(inFile);
                    plugin.load(this);
                    this.plugins[i] = plugin;
                    version = Math.max(version, plugin.getVersion());
                    ++i;
                }
                i = 0;
                count = 0;
                while (i < this.plugins.length) {
                    count += this.plugins[i].getMasterList().size();
                    ++i;
                }
                this.mergedMasterList = new ArrayList<String>(count);
                i = 0;
                while (i < this.plugins.length) {
                    List<String> masterList = this.plugins[i].getMasterList();
                    for (String string : masterList) {
                        if (this.mergedMasterList.contains(string) || this.masterMerge && string.equals(this.pluginNames[0])) continue;
                        this.mergedMasterList.add(string);
                    }
                    ++i;
                }
                this.mergedMasterCount = this.mergedMasterList.size();
                this.masters = new Master[this.mergedMasterCount];
                i = 0;
                for (String masterName : this.mergedMasterList) {
                    File masterFile = new File(String.valueOf(Main.pluginDirectory) + Main.fileSeparator + masterName);
                    master = new Master(masterFile);
                    master.load(this);
                    this.masters[i++] = master;
                    version = Math.max(version, master.getVersion());
                }
                if (!this.masterMerge || !manageMerge || (cellRegionList = this.plugins[1].getCellRegionsUsed()).size() <= 0) break block79;
                Vector<String[]> vector = new Vector<String[]>();
                List<String> pluginMasterList = this.plugins[1].getMasterList();
                for (int region : cellRegionList) {
                    String worldspaceName;
                    String regionName;
                    String pluginName;
                    block80: {
                        String WSPluginName;
                        int WSIndex;
                        Object pluginToSearch;
                        int worldspaceID;
                        block78: {
                            int masterIdx;
                            block81: {
                                block82: {
                                    block77: {
                                        pluginName = "<html><i>Plugin Not Found</i><html>";
                                        regionName = "<html><i>Region Not Found</i><html>";
                                        worldspaceName = "<html><i>Worldspace Not Found</i><html>";
                                        if (region == 65535) {
                                            String[] regionInfoArray = new String[]{String.format("%08X", 65535), pluginName, worldspaceName, regionName};
                                            vector.add(regionInfoArray);
                                            continue;
                                        }
                                        masterIdx = region >>> 24;
                                        worldspaceID = -1;
                                        pluginToSearch = null;
                                        if (masterIdx == pluginMasterList.size()) {
                                            pluginToSearch = this.plugins[1];
                                            pluginName = this.plugins[1].getName();
                                        } else {
                                            pluginName = pluginMasterList.get(masterIdx);
                                            int mergedMasterIdx = this.mergedMasterList.indexOf(pluginName);
                                            if (mergedMasterIdx != -1) {
                                                pluginToSearch = this.masters[mergedMasterIdx];
                                            } else if (pluginName.equalsIgnoreCase(this.plugins[0].getName())) {
                                                pluginToSearch = this.plugins[0];
                                            } else {
                                                if (!Main.debugMode) continue;
                                                System.out.print("MergeTask: Plugin " + pluginName + " for region " + String.format("%08X", region) + " not found in merge list\n");
                                                continue;
                                            }
                                        }
                                        PluginRecord pluginRec = null;
                                        if (pluginToSearch instanceof Plugin) {
                                            FormInfo formInfo = ((Plugin)pluginToSearch).getFormMap().get(region);
                                            if (formInfo != null) {
                                                pluginRec = (PluginRecord)formInfo.getSource();
                                            }
                                        } else if (pluginToSearch instanceof Master) {
                                            pluginRec = ((Master)pluginToSearch).getRecord(region);
                                        }
                                        if (pluginRec == null && Main.debugMode) {
                                            System.out.print("MergeTask: Region " + String.format("%08X", region) + " not found in plugin " + pluginName + "\n");
                                        }
                                        if (pluginRec == null) break block80;
                                        regionName = pluginRec.getEditorID();
                                        try {
                                            PluginSubrecord WSRec = pluginRec.getSubrecord("WNAM");
                                            String WSStr = WSRec.getDisplayData();
                                            worldspaceID = Integer.parseInt(WSStr, 16);
                                        }
                                        catch (Exception ex) {
                                            if (!Main.debugMode) break block77;
                                            System.out.print("MergeTask: WNAM not found for region " + String.format("%08X", region) + " in plugin " + pluginName + "\n");
                                        }
                                    }
                                    WSIndex = worldspaceID == -1 ? worldspaceID : worldspaceID >>> 24;
                                    WSPluginName = "";
                                    if (WSIndex == masterIdx || WSIndex == -1) break block81;
                                    if (WSIndex != pluginMasterList.size()) break block82;
                                    pluginToSearch = this.plugins[1];
                                    WSPluginName = this.plugins[1].getName();
                                    break block78;
                                }
                                WSPluginName = pluginMasterList.get(WSIndex);
                                int mergedMasterIdx = this.mergedMasterList.indexOf(WSPluginName);
                                if (mergedMasterIdx != -1) {
                                    pluginToSearch = this.masters[mergedMasterIdx];
                                    break block78;
                                } else if (WSPluginName.equalsIgnoreCase(this.plugins[0].getName())) {
                                    pluginToSearch = this.plugins[0];
                                    break block78;
                                } else {
                                    if (!Main.debugMode) continue;
                                    System.out.print("MergeTask: Plugin " + WSPluginName + " for worldspace " + String.format("%08X", worldspaceID) + " not found in merge list\n");
                                    continue;
                                }
                            }
                            if (WSIndex == masterIdx) {
                                WSPluginName = pluginName;
                            }
                        }
                        if (WSIndex == -1) {
                            pluginToSearch = new String();
                        }
                        FormInfo WSFormInfo = null;
                        if (pluginToSearch instanceof Plugin) {
                            WSFormInfo = ((Plugin)pluginToSearch).getFormMap().get(worldspaceID);
                        } else if (pluginToSearch instanceof Master) {
                            WSFormInfo = ((Master)pluginToSearch).getFormMap().get(worldspaceID);
                        }
                        if (WSFormInfo == null && WSIndex != -1 && WSIndex == 0 && (WSFormInfo = this.plugins[1].getFormMap().get(worldspaceID)) == null && (WSFormInfo = this.plugins[0].getFormMap().get(worldspaceID)) == null) {
                            int j = this.masters.length;
                            while (j >= 0) {
                                WSFormInfo = this.masters[j].getFormMap().get(worldspaceID);
                                if (WSFormInfo != null) break;
                                --j;
                            }
                        }
                        if (WSFormInfo != null) {
                            worldspaceName = WSFormInfo.getEditorID();
                        } else if (Main.debugMode) {
                            System.out.print("MergeTask: Worldspace " + String.format("%08X", worldspaceID) + " not found in plugin " + WSPluginName + "\n");
                        }
                    }
                    String[] regionInfoArray = new String[]{String.format("%08X", region), pluginName, worldspaceName, regionName};
                    vector.add(regionInfoArray);
                }
                String retStr = RegionCellDialog.showDialog(parentWindow, vector);
                String[] resultArray = retStr.split(":");
                if (resultArray[0].equals("All")) {
                    // empty if block
                }
                if (resultArray[0].equals("None")) {
                    this.plugins[1].ignoreAllExteriorCells();
                }
                if (resultArray[0].equals("CancelMerge")) {
                    throw new InterruptedException("Merge canceled");
                }
                if (resultArray[0].equals("Some")) {
                    regionIDs = new ArrayList<Integer>();
                    int j = 1;
                    while (j < resultArray.length) {
                        int regionID = Integer.parseInt(resultArray[j], 16);
                        regionIDs.add(regionID);
                        ++j;
                    }
                    this.plugins[1].ignoreAllExteriorCellsExcept(regionIDs);
                }
                if (resultArray[0].equals("Except")) {
                    regionIDs = new ArrayList();
                    int j = 1;
                    while (j < resultArray.length) {
                        int regionID = Integer.parseInt(resultArray[j], 16);
                        regionIDs.add(regionID);
                        ++j;
                    }
                    this.plugins[1].ignoreAllExteriorCells(regionIDs);
                }
            }
            if (this.masterMerge && manageMerge) {
                int selection2 = JOptionPane.showConfirmDialog(parentWindow, "Do you wish to select a starting start form ID to new objects merged into the master?\n<html>Selecting <i>No</i> or destroying this window will continue the merge as normal.</html>", "Select Starting Form ID", 0, 3);
                if (selection2 == 0) {
                    this.useFloorFormID = true;
                    this.floorFormID = this.getStartFormID(this.highestFormID(this.plugins[0]));
                    if (this.floorFormID == -1) {
                        this.useFloorFormID = false;
                        throw new InterruptedException("Merge canceled");
                    }
                    ++this.floorFormID;
                } else {
                    this.useFloorFormID = false;
                }
            }
            i = 0;
            count = 0;
            while (i < this.plugins.length) {
                count += this.plugins[i].getFormList().size();
                ++i;
            }
            this.mergedFormMap = new HashMap<Integer, FormInfo>(count);
            this.mergedEditorMap = new HashMap<String, FormInfo>(count);
            this.highFormID = this.mergedMasterCount << 24;
            i = 0;
            while (i < this.plugins.length) {
                this.mapPluginRecords(this.plugins[i]);
                if (MergeTask.interrupted()) {
                    throw new InterruptedException("Merge canceled");
                }
                ++i;
            }
            i = 0;
            while (i < this.plugins.length) {
                this.getStatusDialog().updateMessage("Updating references for " + this.pluginNames[i]);
                plugin = this.plugins[i];
                List<String> masterList = plugin.getMasterList();
                int[] nArray = new int[masterList.size()];
                int index = 0;
                while (index < nArray.length) {
                    String masterName = masterList.get(index);
                    int mergedIndex = this.mergedMasterList.indexOf(masterName);
                    nArray[index] = mergedIndex >= 0 ? mergedIndex : this.mergedMasterCount;
                    ++index;
                }
                Map<Integer, FormInfo> formMap = plugin.getFormMap();
                FormAdjust formAdjust = new FormAdjust(nArray, this.mergedMasterCount, formMap);
                List<PluginGroup> groupList = plugin.getGroupList();
                int groupCount = groupList.size();
                int processedCount = 0;
                int currentProgress = 0;
                for (PluginGroup group : groupList) {
                    int newProgress;
                    this.updateGroup(group, formAdjust);
                    if (MergeTask.interrupted()) {
                        throw new InterruptedException("Merge canceled");
                    }
                    if ((newProgress = ++processedCount * 100 / groupCount) < currentProgress + 5) continue;
                    currentProgress = newProgress;
                    this.getStatusDialog().updateProgress(currentProgress);
                }
                ++i;
            }
            if (this.masterMerge) {
                plugin = this.plugins[0];
                mergedFile = new File(String.valueOf(Main.pluginDirectory) + Main.fileSeparator + plugin.getName());
                this.mergedPlugin = new Plugin(mergedFile, plugin.getCreator(), plugin.getSummary(), this.mergedMasterList);
                this.mergedPlugin.setVersion(version);
                this.mergedPlugin.setMaster(true);
            } else {
                mergedFile = new File(String.valueOf(Main.pluginDirectory) + Main.fileSeparator + this.pluginInfo.getName());
                this.mergedPlugin = new Plugin(mergedFile, this.pluginInfo.getCreator(), this.pluginInfo.getSummary(), this.mergedMasterList);
                this.mergedPlugin.setVersion(version);
                this.mergedPlugin.setMaster(false);
            }
            this.mergedPlugin.createInitialGroups();
            this.deletedINFOMap = new HashMap<Integer, List<PluginRecord>>();
            i = this.plugins.length - 1;
            while (i >= 0) {
                this.buildDeletedINFOMap(this.plugins[i], this.deletedINFOMap);
                --i;
            }
            i = 0;
            while (i < this.plugins.length) {
                this.getStatusDialog().updateMessage("Merging " + this.pluginNames[i]);
                this.mergePlugin(this.plugins[i]);
                ++i;
            }
            if (!this.deletedINFOMap.isEmpty() && (pluginGroup = this.mergedPlugin.getTopGroup("DIAL")) != null) {
                pluginGroup.suturePNAMs(this.deletedINFOMap);
            }
            this.mergedPlugin.store(this);
            this.getStatusDialog().updateMessage("Merging voice files");
            String string = String.format("%s%sSound%sVoice%s%s", mergedFile.getParent(), Main.fileSeparator, Main.fileSeparator, Main.fileSeparator, mergedFile.getName());
            if (!this.masterMerge) {
                File voiceDirectory;
                String mergedName = this.mergedPlugin.getName();
                boolean deleteFiles = true;
                i = 0;
                while (i < this.pluginNames.length) {
                    if (mergedName.equalsIgnoreCase(this.pluginNames[i])) {
                        deleteFiles = false;
                        break;
                    }
                    ++i;
                }
                if (deleteFiles && (voiceDirectory = new File(string)).exists()) {
                    if (voiceDirectory.isDirectory()) {
                        this.deleteDirectoryTree(voiceDirectory);
                    } else {
                        voiceDirectory.delete();
                    }
                }
            }
            i = 0;
            while (i < this.plugins.length) {
                String voicePath;
                File voiceDirectory;
                plugin = this.plugins[i];
                if (!this.mergedPlugin.getName().equalsIgnoreCase(plugin.getName()) && (voiceDirectory = new File(voicePath = String.format("%s%sSound%sVoice%s%s", mergedFile.getParent(), Main.fileSeparator, Main.fileSeparator, Main.fileSeparator, plugin.getName()))).exists() && voiceDirectory.isDirectory()) {
                    this.copyVoiceFiles(plugin, voiceDirectory, string);
                }
                ++i;
            }
            completed = true;
        }
        catch (PluginException exc) {
            Main.logException("Plugin Error", exc);
        }
        catch (DataFormatException exc) {
            Main.logException("Compression Error", exc);
        }
        catch (IOException exc) {
            Main.logException("I/O Error", exc);
        }
        catch (InterruptedException exc) {
            WorkerDialog.showMessageDialog(this.getStatusDialog(), "Request canceled", "Interrupted", 0);
        }
        catch (Throwable exc) {
            Main.logException("Exception while merging plugins", exc);
        }
        if (this.mergedPlugin != null) {
            this.mergedPlugin.resetFormList();
            this.mergedPlugin.resetFormMap();
        }
        i = 0;
        while (i < this.plugins.length) {
            this.plugins[i].resetFormList();
            ++i;
        }
        i = 0;
        while (i < this.masters.length) {
            this.masters[i].resetFormList();
            ++i;
        }
        i = 0;
        while (i < this.plugins.length) {
            this.plugins[i].resetFormMap();
            ++i;
        }
        i = 0;
        while (i < this.masters.length) {
            this.masters[i].resetFormMap();
            ++i;
        }
        this.getStatusDialog().closeDialog(completed);
    }

    private void mapPluginRecords(Plugin plugin) throws DataFormatException, IOException, PluginException {
        List<FormInfo> formList = plugin.getFormList();
        List<String> masterList = plugin.getMasterList();
        String pluginName = plugin.getName();
        int masterCount = masterList.size();
        for (FormInfo info : formList) {
            String text;
            String recordType;
            PluginRecord mergedRecord;
            PluginRecord record;
            FormInfo mergedInfo;
            int formID = info.getFormID();
            String editorID = info.getEditorID();
            int masterID = formID >>> 24;
            formID &= 0xFFFFFF;
            boolean masterReference = false;
            boolean updateMap = true;
            if (((PluginRecord)info.getSource()).isIgnored()) continue;
            if (masterID < masterCount) {
                String masterName = masterList.get(masterID);
                if (!this.masterMerge || !masterName.equals(this.pluginNames[0])) {
                    masterReference = true;
                    masterID = this.mergedMasterList.indexOf(masterName);
                }
            }
            if (masterReference) {
                mergedInfo = this.mergedFormMap.get(new Integer(formID |= masterID << 24));
                if (mergedInfo != null) {
                    updateMap = false;
                    record = (PluginRecord)info.getSource();
                    if (record.isIdentical(mergedRecord = (PluginRecord)mergedInfo.getSource())) {
                        recordType = record.getRecordType();
                        if (!(recordType.equals("WRLD") || recordType.equals("CELL") || recordType.equals("DIAL"))) {
                            record.setIgnore(true);
                        }
                    } else if (!record.isDeleted() && editorID.length() != 0 && !mergedInfo.getMergedEditorID().equals(editorID)) {
                        text = String.format("Plugin %s changes merged master record editor ID from %s to %s", plugin.getName(), mergedInfo.getMergedEditorID(), editorID);
                        throw new PluginException(text);
                    }
                }
            } else {
                mergedInfo = this.mergedFormMap.get(new Integer(formID |= this.mergedMasterCount << 24));
                if (mergedInfo != null) {
                    if (this.masterMerge && masterID < masterCount) {
                        record = (PluginRecord)info.getSource();
                        recordType = record.getRecordType();
                        if (!(recordType.equals("WRLD") || recordType.equals("CELL") || recordType.equals("DIAL"))) {
                            mergedRecord = (PluginRecord)mergedInfo.getSource();
                            this.mergedFormMap.remove(new Integer(formID));
                            this.mergedEditorMap.remove(mergedInfo.getMergedEditorID().toLowerCase());
                            mergedRecord.setIgnore(true);
                            if (record.isDeleted()) {
                                record.setIgnore(true);
                                updateMap = false;
                            }
                        } else {
                            updateMap = false;
                            if (!record.isDeleted() && editorID.length() != 0) {
                                if (!mergedInfo.getMergedEditorID().equals(editorID)) {
                                    mergedInfo.setMergedEditorID(editorID);
                                    this.mergedEditorMap.put(editorID.toLowerCase(), info);
                                }
                            } else if (record.isDeleted()) {
                                mergedRecord = (PluginRecord)mergedInfo.getSource();
                                mergedRecord.setIgnore(true);
                                record.setIgnore(true);
                            }
                        }
                    } else {
                        formID = this.masterMerge && this.useFloorFormID && !plugin.isMaster() ? this.floorFormID++ : this.highFormID + 1;
                    }
                } else if (this.masterMerge && this.useFloorFormID && !plugin.isMaster()) {
                    formID = this.floorFormID++;
                }
                if (updateMap && editorID.length() != 0 && (mergedInfo = this.mergedEditorMap.get(editorID.toLowerCase())) != null) {
                    record = (PluginRecord)info.getSource();
                    mergedRecord = (PluginRecord)mergedInfo.getSource();
                    recordType = record.getRecordType();
                    if (record.isIdentical(mergedRecord)) {
                        record.setIgnore(true);
                        formID = mergedInfo.getMergedFormID();
                        updateMap = false;
                    } else if (recordType.equals("GMST")) {
                        if (!mergedRecord.getRecordType().equals("GMST")) {
                            text = String.format("Conflict between GMST record %s (%08X) in plugin %s and %s record %s (%08X) in plugin %s", editorID, record.getFormID(), pluginName, mergedRecord.getRecordType(), editorID, mergedRecord.getFormID(), ((Plugin)mergedInfo.getPlugin()).getName());
                            throw new PluginException(text);
                        }
                        formID = mergedInfo.getMergedFormID();
                        updateMap = false;
                    } else if (recordType.equals("MGEF")) {
                        if (!mergedRecord.getRecordType().equals("MGEF")) {
                            text = String.format("Conflict between MGEF record %s (%08X) in plugin %s and %s record %s (%08X) in plugin %s", editorID, record.getFormID(), pluginName, mergedRecord.getRecordType(), editorID, mergedRecord.getFormID(), ((Plugin)mergedInfo.getPlugin()).getName());
                            throw new PluginException(text);
                        }
                        formID = mergedInfo.getMergedFormID();
                        updateMap = false;
                    } else {
                        String newEditorID = editorID.concat("X");
                        while (this.mergedEditorMap.get(newEditorID.toLowerCase()) != null) {
                            newEditorID = newEditorID.concat("X");
                        }
                        if (!this.yesToAll) {
                            text = String.format("%s record %s (%08X) in '%s' has the same name as %s record %s (%08X) in '%s'", info.getRecordType(), editorID, record.getFormID(), pluginName, mergedInfo.getRecordType(), editorID, mergedRecord.getFormID(), ((Plugin)mergedInfo.getPlugin()).getName());
                            int selection = WorkerDialog.showConfirmDialog(this.getParent(), String.valueOf(text) + ". Do you want to rename it to " + newEditorID + "?", "Error", 0, 0, true);
                            if (selection == 1) {
                                throw new PluginException(text);
                            }
                            if (selection == 2) {
                                this.yesToAll = true;
                            }
                        }
                        editorID = newEditorID;
                    }
                }
            }
            info.setMergedFormID(formID);
            info.setMergedEditorID(editorID);
            if (updateMap) {
                this.mergedFormMap.put(new Integer(formID), info);
                if (editorID.length() != 0) {
                    this.mergedEditorMap.put(editorID.toLowerCase(), info);
                }
            }
            if (formID <= this.highFormID) continue;
            this.highFormID = formID;
        }
    }

    private void updateGroup(PluginGroup group, FormAdjust formAdjust) throws DataFormatException, IOException, PluginException {
        int groupType = group.getGroupType();
        if (groupType == 1 || groupType == 6 || groupType == 8 || groupType == 9 || groupType == 10 || groupType == 7) {
            group.setGroupParentID(formAdjust.adjustFormID(group.getGroupParentID()));
        }
        List<PluginRecord> recordList = group.getRecordList();
        for (PluginRecord record : recordList) {
            if (record instanceof PluginGroup) {
                this.updateGroup((PluginGroup)record, formAdjust);
                continue;
            }
            if (record.isIgnored()) continue;
            this.updateRecord(record, formAdjust);
        }
    }

    private void updateRecord(PluginRecord record, FormAdjust formAdjust) throws DataFormatException, IOException, PluginException {
        String recordType = record.getRecordType();
        int formID = record.getFormID();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        FormInfo info = formAdjust.getFormMap().get(new Integer(formID));
        if (info == null && formID != 0) {
            throw new PluginException(String.format("No mapping for %s record %s (%08X)", recordType, record.getEditorID(), formID));
        }
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("EDID")) {
                if (info == null) continue;
                byte[] idString = info.getMergedEditorID().getBytes();
                subrecordData = new byte[idString.length + 1];
                System.arraycopy(idString, 0, subrecordData, 0, idString.length);
                subrecordData[idString.length] = 0;
                subrecord.setSubrecordData(subrecordData);
                continue;
            }
            int[][] references = subrecord.getReferences();
            if (references == null) continue;
            subrecordData = subrecord.getSubrecordData();
            int i = 0;
            while (i < references.length) {
                int refOffset = references[i][0];
                int refFormID = references[i][1];
                if (refFormID != 0) {
                    int mergedFormID = formAdjust.adjustFormID(refFormID);
                    SerializedElement.setInteger(mergedFormID, subrecordData, refOffset);
                }
                ++i;
            }
            subrecord.setSubrecordData(subrecordData);
        }
        record.setSubrecords(subrecordList);
        if (info != null) {
            record.setFormID(info.getMergedFormID());
        }
    }

    private void mergePlugin(Plugin plugin) throws DataFormatException, IOException, PluginException {
        List<PluginGroup> mergedGroupList = this.mergedPlugin.getGroupList();
        List<PluginGroup> groupList = plugin.getGroupList();
        boolean editLeveledLists = this.masterMerge ? false : this.pluginInfo.shouldEditConflicts();
        for (PluginGroup group : groupList) {
            String groupRecordType = group.getGroupRecordType();
            group.removeIgnoredRecords();
            boolean groupMerged = false;
            for (PluginGroup mergedGroup : mergedGroupList) {
                if (!mergedGroup.getGroupRecordType().equals(groupRecordType)) continue;
                List<PluginRecord> recordList = group.getRecordList();
                List<PluginRecord> mergedRecordList = mergedGroup.getRecordList();
                for (PluginRecord record : recordList) {
                    if (record instanceof PluginGroup) {
                        PluginGroup subgroup = (PluginGroup)record;
                        int subgroupType = subgroup.getGroupType();
                        byte[] subgroupLabel = subgroup.getGroupLabel();
                        boolean subgroupMerged = false;
                        for (PluginRecord mergedRecord : mergedRecordList) {
                            byte[] mergedSubgroupLabel;
                            PluginGroup mergedSubgroup;
                            if (!(mergedRecord instanceof PluginGroup) || (mergedSubgroup = (PluginGroup)mergedRecord).getGroupType() != subgroupType || (mergedSubgroupLabel = mergedSubgroup.getGroupLabel())[0] != subgroupLabel[0] || mergedSubgroupLabel[1] != subgroupLabel[1] || mergedSubgroupLabel[2] != subgroupLabel[2] || mergedSubgroupLabel[3] != subgroupLabel[3]) continue;
                            this.mergeGroup(mergedSubgroup, subgroup);
                            subgroupMerged = true;
                            break;
                        }
                        if (subgroupMerged) continue;
                        if (subgroupType == 2) {
                            PluginGroup mergedSubgroup = new PluginGroup(subgroup.getGroupType(), subgroup.getGroupLabel());
                            mergedRecordList.add(mergedSubgroup);
                            mergedSubgroup.setParent(mergedGroup);
                            this.mergeGroup(mergedSubgroup, subgroup);
                            continue;
                        }
                        mergedRecordList.add(record);
                        record.setParent(mergedGroup);
                        continue;
                    }
                    String recordType = record.getRecordType();
                    int index = mergedRecordList.indexOf(record);
                    if (index < 0) {
                        mergedRecordList.add(record);
                        record.setParent(mergedGroup);
                        continue;
                    }
                    if (record.isDeleted()) continue;
                    PluginRecord mergedRecord = mergedRecordList.get(index);
                    if (recordType.equals("ACTI") || recordType.equals("AMMO") || recordType.equals("APPA") || recordType.equals("ARMO") || recordType.equals("BOOK") || recordType.equals("CLAS") || recordType.equals("CLOT") || recordType.equals("DOOR") || recordType.equals("EYES") || recordType.equals("HAIR") || recordType.equals("LIGH") || recordType.equals("MISC") || recordType.equals("SKIL") || recordType.equals("WEAP")) {
                        this.mergeSubrecords(mergedRecord, record, null);
                        continue;
                    }
                    if (recordType.equals("BSGN")) {
                        this.mergeBirthsign(mergedRecord, record);
                        continue;
                    }
                    if (recordType.equals("CONT")) {
                        this.mergeContainer(mergedRecord, record);
                        continue;
                    }
                    if (recordType.equals("ALCH") || recordType.equals("ENCH") || recordType.equals("INGR") || recordType.equals("SPEL")) {
                        this.mergeEnchantment(mergedRecord, record);
                        continue;
                    }
                    if (recordType.equals("FACT")) {
                        this.mergeFaction(mergedRecord, record);
                        continue;
                    }
                    if (recordType.equals("LVLC") || recordType.equals("LVLI") || recordType.equals("LVSP")) {
                        if (editLeveledLists) {
                            EditLeveledList.showWorkerDialog((JDialog)this.getParent(), mergedRecord, record, this.mergedFormMap, this.masters);
                            continue;
                        }
                        this.mergeLeveledList(mergedRecord, record);
                        continue;
                    }
                    if (recordType.equals("NPC_") || recordType.equals("CREA")) {
                        this.mergeNPC(mergedRecord, record);
                        continue;
                    }
                    if (recordType.equals("RACE")) {
                        this.mergeRace(mergedRecord, record);
                        continue;
                    }
                    if (recordType.equals("DIAL")) {
                        this.mergeDialogTopic(mergedRecord, record);
                        continue;
                    }
                    if (!this.masterMerge && this.pluginInfo.shouldDeleteLastConflict()) continue;
                    mergedRecordList.remove(index);
                    mergedRecordList.add(index, record);
                    record.setParent(mergedGroup);
                }
                groupMerged = true;
                break;
            }
            if (groupMerged) continue;
            throw new PluginException("Merge group " + groupRecordType + " not found");
        }
    }

    private void mergeGroup(PluginGroup mergedGroup, PluginGroup group) throws DataFormatException, IOException, PluginException {
        List<PluginRecord> mergedRecordList = mergedGroup.getRecordList();
        List<PluginRecord> recordList = group.getRecordList();
        ListIterator<PluginRecord> lit = recordList.listIterator();
        while (lit.hasNext()) {
            PluginRecord record = lit.next();
            String recordType = record.getRecordType();
            if (record instanceof PluginGroup) {
                PluginGroup subgroup = (PluginGroup)record;
                int subgroupType = subgroup.getGroupType();
                byte[] subgroupLabel = subgroup.getGroupLabel();
                boolean subgroupMerged = false;
                int index = 0;
                for (PluginRecord mergedRecord : mergedRecordList) {
                    byte[] mergedSubgroupLabel;
                    PluginGroup mergedSubgroup;
                    if (mergedRecord instanceof PluginGroup && (mergedSubgroup = (PluginGroup)mergedRecord).getGroupType() == subgroupType && (mergedSubgroupLabel = mergedSubgroup.getGroupLabel())[0] == subgroupLabel[0] && mergedSubgroupLabel[1] == subgroupLabel[1] && mergedSubgroupLabel[2] == subgroupLabel[2] && mergedSubgroupLabel[3] == subgroupLabel[3]) {
                        if (index > 0 && (subgroupType == 10 || subgroupType == 8)) {
                            mergedRecordList.remove(index);
                            mergedRecordList.add(0, mergedSubgroup);
                        }
                        this.mergeGroup(mergedSubgroup, subgroup);
                        subgroupMerged = true;
                        break;
                    }
                    ++index;
                }
                if (subgroupMerged) continue;
                if (subgroupType == 3) {
                    PluginGroup mergedSubgroup = new PluginGroup(subgroup.getGroupType(), subgroup.getGroupLabel());
                    mergedRecordList.add(mergedSubgroup);
                    mergedSubgroup.setParent(mergedGroup);
                    this.mergeGroup(mergedSubgroup, subgroup);
                    continue;
                }
                if (subgroupType == 10) {
                    if (mergedRecordList.size() > 0) {
                        int insertIndex = 0;
                        PluginGroup firstGroup = (PluginGroup)mergedRecordList.get(0);
                        if (firstGroup.getGroupType() == 8) {
                            insertIndex = 1;
                        }
                        mergedRecordList.add(insertIndex, record);
                    } else {
                        mergedRecordList.add(0, record);
                    }
                    record.setParent(mergedGroup);
                    continue;
                }
                if (subgroupType == 8) {
                    mergedRecordList.add(0, record);
                    record.setParent(mergedGroup);
                    continue;
                }
                mergedRecordList.add(record);
                record.setParent(mergedGroup);
                continue;
            }
            if (recordType.equals("CELL") && ((PluginGroup)record.getParent()).getGroupType() == 3) {
                int index;
                List<PluginRecord> parentRecordList;
                PluginGroup parentGroup;
                int formID = record.getFormID();
                FormInfo formInfo = this.mergedFormMap.get(new Integer(formID));
                PluginRecord mergedRecord = (PluginRecord)formInfo.getSource();
                if (mergedRecord == record) {
                    byte[] groupLabel;
                    int baseFormID = formID & 0xFFFFFF;
                    int block = baseFormID % 10;
                    int subblock = baseFormID / 10 % 10;
                    parentGroup = this.mergedPlugin.createTopGroup("CELL");
                    parentRecordList = parentGroup.getRecordList();
                    PluginGroup subgroup = null;
                    boolean foundGroup = false;
                    for (PluginRecord groupRecord : parentRecordList) {
                        subgroup = (PluginGroup)groupRecord;
                        if (SerializedElement.getInteger(subgroup.getGroupLabel(), 0) != block) continue;
                        foundGroup = true;
                        break;
                    }
                    if (!foundGroup) {
                        groupLabel = new byte[4];
                        SerializedElement.setInteger(block, groupLabel, 0);
                        subgroup = new PluginGroup(2, groupLabel);
                        subgroup.setParent(parentGroup);
                        parentRecordList.add(subgroup);
                    }
                    parentGroup = subgroup;
                    parentRecordList = parentGroup.getRecordList();
                    foundGroup = false;
                    for (PluginRecord groupRecord : parentRecordList) {
                        subgroup = (PluginGroup)groupRecord;
                        if (SerializedElement.getInteger(subgroup.getGroupLabel(), 0) != subblock) continue;
                        foundGroup = true;
                        break;
                    }
                    if (!foundGroup) {
                        groupLabel = new byte[4];
                        SerializedElement.setInteger(subblock, groupLabel, 0);
                        subgroup = new PluginGroup(3, groupLabel);
                        subgroup.setParent(parentGroup);
                        parentRecordList.add(subgroup);
                    }
                    parentGroup = subgroup;
                    parentRecordList = parentGroup.getRecordList();
                    index = parentRecordList.size();
                    record.setParent(parentGroup);
                    parentRecordList.add(record);
                    subgroup = new PluginGroup(6, formID);
                    subgroup.setParent(parentGroup);
                    parentRecordList.add(subgroup);
                } else {
                    parentGroup = (PluginGroup)mergedRecord.getParent();
                    parentRecordList = parentGroup.getRecordList();
                    index = parentRecordList.indexOf(record);
                    if (!(record.isDeleted() || !this.masterMerge && this.pluginInfo.shouldDeleteLastConflict())) {
                        parentRecordList.remove(index);
                        parentRecordList.add(index, record);
                        record.setParent(parentGroup);
                    }
                }
                if (!lit.hasNext()) continue;
                record = lit.next();
                if (record instanceof PluginGroup && ++index < parentRecordList.size()) {
                    mergedRecord = parentRecordList.get(index);
                    if (mergedRecord instanceof PluginGroup) {
                        PluginGroup subgroup = (PluginGroup)record;
                        PluginGroup mergedSubgroup = (PluginGroup)mergedRecord;
                        this.mergeGroup(mergedSubgroup, subgroup);
                        continue;
                    }
                    lit.previous();
                    continue;
                }
                lit.previous();
                continue;
            }
            int index = mergedRecordList.indexOf(record);
            if (recordType.equals("INFO") && !record.isDeleted() && !this.deletedINFOMap.isEmpty() && this.deletedINFOMap.containsKey(group.getGroupParentID())) {
                List<PluginRecord> deletedList = this.deletedINFOMap.get(group.getGroupParentID());
                Collections.reverse(deletedList);
                for (PluginRecord delRec : deletedList) {
                    int delPNAMID = 0;
                    int delFormID = delRec.getFormID();
                    try {
                        PluginSubrecord plSubrec = delRec.getSubrecord("PNAM");
                        byte[] subrecordData = plSubrec.getSubrecordData();
                        delPNAMID = SerializedElement.getInteger(subrecordData, 0);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    try {
                        if (!record.changeSubrecord("PNAM", delFormID, delPNAMID)) continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Collections.reverse(deletedList);
            }
            if (index < 0) {
                if (recordType.equals("INFO")) {
                    this.addTopic(mergedRecordList, record);
                } else {
                    mergedRecordList.add(record);
                }
                record.setParent(mergedGroup);
                continue;
            }
            if (record.isDeleted() || !this.masterMerge && this.pluginInfo.shouldDeleteLastConflict()) continue;
            mergedRecordList.remove(index);
            if (recordType.equals("INFO")) {
                this.addTopic(mergedRecordList, record);
            } else {
                mergedRecordList.add(index, record);
            }
            record.setParent(mergedGroup);
        }
    }

    private void addTopic(List<PluginRecord> recordList, PluginRecord record) throws DataFormatException, IOException, PluginException {
        List<PluginSubrecord> subrecords = record.getSubrecords();
        int prevFormID = 0;
        for (PluginSubrecord subrecord : subrecords) {
            if (!subrecord.getSubrecordType().equals("PNAM")) continue;
            prevFormID = SerializedElement.getInteger(subrecord.getSubrecordData(), 0);
            break;
        }
        if (prevFormID == 0) {
            recordList.add(0, record);
        } else {
            ListIterator<PluginRecord> lit = recordList.listIterator();
            boolean recordInserted = false;
            while (lit.hasNext()) {
                PluginRecord checkRecord = lit.next();
                if (checkRecord.getFormID() != prevFormID) continue;
                lit.add(record);
                if (lit.hasNext()) {
                    checkRecord = lit.next();
                    subrecords = checkRecord.getSubrecords();
                    for (PluginSubrecord subrecord : subrecords) {
                        if (!subrecord.getSubrecordType().equals("PNAM")) continue;
                        byte[] subrecordData = subrecord.getSubrecordData();
                        int checkFormID = SerializedElement.getInteger(subrecordData, 0);
                        if (checkFormID != prevFormID) break;
                        SerializedElement.setInteger(record.getFormID(), subrecordData, 0);
                        subrecord.setSubrecordData(subrecordData);
                        checkRecord.setSubrecords(subrecords);
                        break;
                    }
                }
                recordInserted = true;
                break;
            }
            if (!recordInserted) {
                recordList.add(record);
            }
        }
    }

    private void mergeSubrecords(PluginRecord mergedRecord, PluginRecord record, String[] exclusionList) throws DataFormatException, IOException, PluginException {
        boolean modifiedMergedList = false;
        boolean skipName = false;
        int formID = mergedRecord.getFormID();
        int masterID = formID >>> 24;
        if (masterID >= this.mergedMasterCount) {
            throw new PluginException("Merged master ID " + masterID + " is not valid");
        }
        Master master = this.masters[masterID];
        PluginRecord masterRecord = master.getRecord(formID);
        List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        ListIterator<PluginSubrecord> lit = subrecordList.listIterator();
        while (lit.hasNext()) {
            PluginSubrecord subrecord = lit.next();
            boolean foundSubrecord = false;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("MODB") || subrecordType.equals("MODT") || subrecordType.equals("MO2B") || subrecordType.equals("MO2T") || subrecordType.equals("MO3B") || subrecordType.equals("MO3T") || subrecordType.equals("MO4B") || subrecordType.equals("MO4T") || skipName && subrecordType.equals("FULL")) continue;
            if (subrecordType.equals("EFID")) {
                skipName = true;
            }
            if (exclusionList != null) {
                boolean mergeSubrecord = true;
                String[] stringArray = exclusionList;
                int n = exclusionList.length;
                int n2 = 0;
                while (n2 < n) {
                    String exclusion = stringArray[n2];
                    if (exclusion.equals(subrecordType)) {
                        mergeSubrecord = false;
                        break;
                    }
                    ++n2;
                }
                if (!mergeSubrecord) continue;
            }
            ListIterator<PluginSubrecord> mlit = mergedSubrecordList.listIterator();
            boolean skipMergedName = false;
            while (mlit.hasNext()) {
                PluginSubrecord mergedSubrecord = mlit.next();
                if (!mergedSubrecord.getSubrecordType().equals(subrecordType)) continue;
                if (skipMergedName && subrecordType.equals("FULL")) break;
                if (subrecordType.equals("EFID")) {
                    skipMergedName = true;
                }
                foundSubrecord = true;
                boolean replaceSubrecord = false;
                if (!mergedSubrecord.equals(subrecord)) {
                    int mergedIndex = masterSubrecordList.indexOf(mergedSubrecord);
                    int index = masterSubrecordList.indexOf(subrecord);
                    if (mergedIndex < 0) {
                        if (index < 0 && (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict())) {
                            replaceSubrecord = true;
                        }
                    } else {
                        replaceSubrecord = true;
                    }
                }
                if (!replaceSubrecord) break;
                String modb = null;
                String modt = null;
                if (subrecordType.equals("MODL")) {
                    modb = "MODB";
                    modt = "MODT";
                } else if (subrecordType.equals("MOD2")) {
                    modb = "MO2B";
                    modt = "MO2T";
                } else if (subrecordType.equals("MOD3")) {
                    modb = "MO3B";
                    modt = "MO3T";
                } else if (subrecordType.equals("MOD4")) {
                    modb = "MO4B";
                    modt = "MO4T";
                }
                mlit.set(subrecord);
                if (modb != null && lit.hasNext()) {
                    subrecord = lit.next();
                    if (subrecord.getSubrecordType().equals(modb)) {
                        if (mlit.hasNext()) {
                            mergedSubrecord = mlit.next();
                            if (mergedSubrecord.getSubrecordType().equals(modb)) {
                                mlit.set(subrecord);
                            } else {
                                mlit.previous();
                                mlit.add(subrecord);
                            }
                        } else {
                            mlit.add(subrecord);
                        }
                    } else {
                        lit.previous();
                    }
                }
                if (modt != null && lit.hasNext()) {
                    subrecord = lit.next();
                    if (subrecord.getSubrecordType().equals(modt)) {
                        if (mlit.hasNext()) {
                            mergedSubrecord = mlit.next();
                            if (mergedSubrecord.getSubrecordType().equals(modt)) {
                                mlit.set(subrecord);
                            } else {
                                mlit.previous();
                                mlit.add(subrecord);
                            }
                        } else {
                            mlit.add(subrecord);
                        }
                    } else {
                        lit.previous();
                    }
                }
                modifiedMergedList = true;
                break;
            }
            if (foundSubrecord) continue;
            String modb = null;
            String modt = null;
            if (subrecordType.equals("MODL")) {
                modb = "MODB";
                modt = "MODT";
            } else if (subrecordType.equals("MOD2")) {
                modb = "MO2B";
                modt = "MO2T";
            } else if (subrecordType.equals("MOD3")) {
                modb = "MO3B";
                modt = "MO3T";
            } else if (subrecordType.equals("MOD4")) {
                modb = "MO4B";
                modt = "MO4T";
            }
            if (subrecordType.equals("FULL")) {
                mergedSubrecordList.add(1, subrecord);
            } else {
                mergedSubrecordList.add(subrecord);
            }
            if (modb != null && lit.hasNext()) {
                subrecord = lit.next();
                if (subrecord.getSubrecordType().equals(modb)) {
                    mergedSubrecordList.add(subrecord);
                } else {
                    lit.previous();
                }
            }
            if (modt != null && lit.hasNext()) {
                subrecord = lit.next();
                if (subrecord.getSubrecordType().equals(modt)) {
                    mergedSubrecordList.add(subrecord);
                } else {
                    lit.previous();
                }
            }
            modifiedMergedList = true;
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private boolean mergeArray(String subrecordType, int entrySize, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> subrecordList) throws IOException {
        boolean modifiedMergedList = false;
        for (PluginSubrecord subrecord : subrecordList) {
            if (!subrecord.getSubrecordType().equals(subrecordType)) continue;
            boolean addSubrecord = true;
            boolean replaceSubrecordData = false;
            byte[] subrecordData = subrecord.getSubrecordData();
            for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                if (!mergedSubrecord.getSubrecordType().equals(subrecordType)) continue;
                addSubrecord = false;
                byte[] mergedSubrecordData = mergedSubrecord.getSubrecordData();
                int offset = 0;
                while (offset < subrecordData.length) {
                    boolean addReference = true;
                    int reference = SerializedElement.getInteger(subrecordData, offset);
                    int mergedOffset = 0;
                    while (mergedOffset < mergedSubrecordData.length) {
                        int mergedReference = SerializedElement.getInteger(mergedSubrecordData, mergedOffset);
                        if (reference == mergedReference) {
                            addReference = false;
                            break;
                        }
                        mergedOffset += entrySize;
                    }
                    if (addReference) {
                        int length = mergedSubrecordData.length;
                        byte[] newSubrecordData = new byte[length + entrySize];
                        System.arraycopy(mergedSubrecordData, 0, newSubrecordData, 0, length);
                        System.arraycopy(subrecordData, offset, newSubrecordData, length, entrySize);
                        mergedSubrecordData = newSubrecordData;
                        replaceSubrecordData = true;
                    }
                    offset += entrySize;
                }
                if (!replaceSubrecordData) break;
                mergedSubrecord.setSubrecordData(mergedSubrecordData);
                modifiedMergedList = true;
                break;
            }
            if (!addSubrecord) break;
            mergedSubrecordList.add(subrecord);
            modifiedMergedList = true;
            break;
        }
        modifiedMergedList = true;
        return true;
    }

    private boolean mergeList(String subrecordType, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> subrecordList) throws IOException {
        boolean modifiedMergedList = false;
        for (PluginSubrecord subrecord : subrecordList) {
            if (!subrecord.getSubrecordType().equals(subrecordType)) continue;
            byte[] subrecordData = subrecord.getSubrecordData();
            int subrecordID = SerializedElement.getInteger(subrecordData, 0);
            boolean insertSubrecord = true;
            boolean foundSubrecord = false;
            int index = 0;
            for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                if (mergedSubrecord.getSubrecordType().equals(subrecordType)) {
                    foundSubrecord = true;
                    subrecordData = mergedSubrecord.getSubrecordData();
                    int mergedSubrecordID = SerializedElement.getInteger(subrecordData, 0);
                    if (subrecordID == mergedSubrecordID) {
                        insertSubrecord = false;
                        break;
                    }
                } else if (foundSubrecord) break;
                ++index;
            }
            if (!insertSubrecord) continue;
            mergedSubrecordList.add(index, subrecord);
            modifiedMergedList = true;
        }
        return modifiedMergedList;
    }

    private void mergeBirthsign(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        boolean modifiedMergedList = false;
        String[] exclusionList = new String[]{"SPLO"};
        this.mergeSubrecords(mergedRecord, record, exclusionList);
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        if (this.mergeList("SPLO", mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private void mergeDialogTopic(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        boolean modifiedMergedList = false;
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
            PluginSubrecord newSubFULL;
            PluginSubrecord oldSubFULL;
            String newEDID;
            String oldEDID = mergedRecord.getEditorID();
            if (!oldEDID.equals(newEDID = record.getEditorID())) {
                modifiedMergedList = true;
                mergedRecord.setEditorID(record.getEditorID());
            }
            if (!(oldSubFULL = mergedRecord.getSubrecord("FULL")).equals(newSubFULL = record.getSubrecord("FULL"))) {
                modifiedMergedList = true;
                mergedRecord.changeSubrecord("FULL", oldSubFULL.getSubrecordData(), newSubFULL.getSubrecordData());
            }
        }
        if (this.mergeList("QSTI", mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private void mergeContainer(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        boolean modifiedMergedList = false;
        String[] exclusionList = new String[]{"CNTO"};
        this.mergeSubrecords(mergedRecord, record, exclusionList);
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        if (this.mergeList("CNTO", mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private void mergeEnchantment(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        String recordType = record.getRecordType();
        boolean modifiedMergedList = false;
        int pluginField1 = 0;
        int pluginField2 = 0;
        boolean autoCalculate = true;
        String[] exclusionList = new String[]{"EFID", "EFIT", "ENIT", "SCIT", "SPIT"};
        this.mergeSubrecords(mergedRecord, record, exclusionList);
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        ListIterator<PluginSubrecord> lit = subrecordList.listIterator();
        while (lit.hasNext()) {
            byte[] subrecordData;
            PluginSubrecord subrecord = lit.next();
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("ENIT")) {
                subrecordData = subrecord.getSubrecordData();
                if (recordType.equals("ALCH") || recordType.equals("INGR")) {
                    pluginField1 = SerializedElement.getInteger(subrecordData, 0);
                    if ((subrecordData[4] & 1) == 0) continue;
                    autoCalculate = false;
                    continue;
                }
                pluginField1 = SerializedElement.getInteger(subrecordData, 4);
                pluginField2 = SerializedElement.getInteger(subrecordData, 8);
                if ((subrecordData[12] & 1) == 0) continue;
                autoCalculate = false;
                continue;
            }
            if (subrecordType.equals("SPIT")) {
                subrecordData = subrecord.getSubrecordData();
                pluginField1 = SerializedElement.getInteger(subrecordData, 4);
                pluginField2 = SerializedElement.getInteger(subrecordData, 8);
                if ((subrecordData[12] & 1) == 0) continue;
                autoCalculate = false;
                continue;
            }
            if (!subrecordType.equals("EFIT")) continue;
            subrecordData = subrecord.getSubrecordData();
            boolean addEffect = true;
            String effectName = new String(subrecordData, 0, 4);
            int effectSubtype = 0;
            int scriptID = 0;
            PluginSubrecord scitSubrecord = null;
            PluginSubrecord fullSubrecord = null;
            if (effectName.equals("DGAT") || effectName.equals("DRAT") || effectName.equals("DRSK") || effectName.equals("FOAT") || effectName.equals("FOSK") || effectName.equals("REAT") || effectName.equals("ABAT") || effectName.equals("ABSK")) {
                effectSubtype = SerializedElement.getInteger(subrecordData, 20);
            }
            if (effectName.equals("SEFF")) {
                if (lit.hasNext()) {
                    scitSubrecord = lit.next();
                    if (scitSubrecord.getSubrecordType().equals("SCIT")) {
                        byte[] scitSubrecordData = scitSubrecord.getSubrecordData();
                        scriptID = SerializedElement.getInteger(scitSubrecordData, 0);
                        if (lit.hasNext() && !(fullSubrecord = lit.next()).getSubrecordType().equals("FULL")) {
                            lit.previous();
                            fullSubrecord = null;
                        }
                    } else {
                        scitSubrecord = null;
                    }
                }
                if (scitSubrecord == null) {
                    throw new PluginException("SCIT subrecord missing for script effect");
                }
            }
            ListIterator<PluginSubrecord> mlit = mergedSubrecordList.listIterator();
            while (mlit.hasNext()) {
                PluginSubrecord mergedSubrecord = mlit.next();
                if (!mergedSubrecord.getSubrecordType().equals("EFIT")) continue;
                byte[] mergedSubrecordData = mergedSubrecord.getSubrecordData();
                String mergedEffectName = new String(mergedSubrecordData, 0, 4);
                int mergedEffectSubtype = 0;
                if (!mergedEffectName.equals(effectName)) continue;
                if (mergedEffectName.equals("DGAT") || mergedEffectName.equals("DRAT") || mergedEffectName.equals("DRSK") || mergedEffectName.equals("FOAT") || mergedEffectName.equals("FOSK") || mergedEffectName.equals("REAT") || mergedEffectName.equals("ABAT") || mergedEffectName.equals("ABSK")) {
                    mergedEffectSubtype = SerializedElement.getInteger(mergedSubrecordData, 20);
                }
                if (effectName.equals("SEFF")) {
                    PluginSubrecord mscitSubrecord = null;
                    if (mlit.hasNext()) {
                        mscitSubrecord = mlit.next();
                        if (mscitSubrecord.getSubrecordType().equals("SCIT")) {
                            mergedSubrecordData = mscitSubrecord.getSubrecordData();
                            int mergedScriptID = SerializedElement.getInteger(mergedSubrecordData, 0);
                            if (mergedScriptID == scriptID) {
                                addEffect = false;
                                break;
                            }
                        } else {
                            mscitSubrecord = null;
                        }
                    }
                    if (mscitSubrecord != null) continue;
                    throw new PluginException("SCIT subrecord missing for script effect");
                }
                if (mergedEffectSubtype != effectSubtype) continue;
                addEffect = false;
                break;
            }
            if (!addEffect) continue;
            byte[] mergedSubrecordData = new byte[]{subrecordData[0], subrecordData[1], subrecordData[2], subrecordData[3]};
            mergedSubrecordList.add(new PluginSubrecord(recordType, "EFID", mergedSubrecordData));
            mergedSubrecordList.add(subrecord);
            if (scitSubrecord != null) {
                mergedSubrecordList.add(scitSubrecord);
                if (fullSubrecord != null) {
                    mergedSubrecordList.add(fullSubrecord);
                }
            }
            modifiedMergedList = true;
        }
        if (modifiedMergedList) {
            for (PluginSubrecord subrecord : mergedSubrecordList) {
                String subrecordType = subrecord.getSubrecordType();
                if (!subrecordType.equals("ENIT") && !subrecordType.equals("SPIT")) continue;
                byte[] subrecordData = subrecord.getSubrecordData();
                if (recordType.equals("ALCH") || recordType.equals("INGR")) {
                    int mergedField1 = SerializedElement.getInteger(subrecordData, 0);
                    mergedField1 = Math.max(pluginField1, mergedField1);
                    SerializedElement.setInteger(mergedField1, subrecordData, 0);
                    if (autoCalculate) break;
                    subrecordData[4] = (byte)(subrecordData[4] | 1);
                    break;
                }
                int mergedField1 = SerializedElement.getInteger(subrecordData, 4);
                int mergedField2 = SerializedElement.getInteger(subrecordData, 8);
                mergedField1 = Math.max(pluginField1, mergedField1);
                mergedField2 = Math.max(pluginField2, mergedField2);
                SerializedElement.setInteger(mergedField1, subrecordData, 4);
                SerializedElement.setInteger(mergedField2, subrecordData, 8);
                if (autoCalculate) break;
                subrecordData[12] = (byte)(subrecordData[12] | 1);
                break;
            }
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private void mergeFaction(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        boolean modifiedMergedList = false;
        String[] exclusionList = new String[]{"FNAM", "INAM", "MNAM", "RNAM", "XNAM"};
        this.mergeSubrecords(mergedRecord, record, exclusionList);
        int formID = mergedRecord.getFormID();
        int masterID = formID >>> 24;
        if (masterID >= this.mergedMasterCount) {
            throw new PluginException("Merged master ID " + masterID + " is not valid");
        }
        Master master = this.masters[masterID];
        PluginRecord masterRecord = master.getRecord(formID);
        List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        int ranks = 0;
        int mergedRanks = 0;
        int masterRanks = 0;
        for (PluginSubrecord subrecord : subrecordList) {
            if (!subrecord.getSubrecordType().equals("RNAM")) continue;
            ++ranks;
        }
        for (PluginSubrecord subrecord : mergedSubrecordList) {
            if (!subrecord.getSubrecordType().equals("RNAM")) continue;
            ++mergedRanks;
        }
        for (PluginSubrecord subrecord : masterSubrecordList) {
            if (!subrecord.getSubrecordType().equals("RNAM")) continue;
            ++masterRanks;
        }
        boolean keepFirst = true;
        if (mergedRanks == masterRanks) {
            if (ranks != masterRanks) {
                keepFirst = false;
            } else if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                keepFirst = false;
            }
        } else if (ranks != masterRanks && (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict())) {
            keepFirst = false;
        }
        if (!keepFirst) {
            modifiedMergedList = true;
            ListIterator<PluginSubrecord> lit = mergedSubrecordList.listIterator();
            while (lit.hasNext()) {
                PluginSubrecord subrecord = lit.next();
                String subrecordType = subrecord.getSubrecordType();
                if (!subrecordType.equals("RNAM") && !subrecordType.equals("MNAM") && !subrecordType.equals("FNAM") && !subrecordType.equals("INAM")) continue;
                lit.remove();
            }
            for (PluginSubrecord subrecord : subrecordList) {
                String subrecordType = subrecord.getSubrecordType();
                if (!subrecordType.equals("RNAM") && !subrecordType.equals("MNAM") && !subrecordType.equals("FNAM") && !subrecordType.equals("INAM")) continue;
                mergedSubrecordList.add(subrecord);
            }
        }
        for (PluginSubrecord subrecord : subrecordList) {
            if (!subrecord.getSubrecordType().equals("XNAM")) continue;
            byte[] subrecordData = subrecord.getSubrecordData();
            int faction = SerializedElement.getInteger(subrecordData, 0);
            boolean insertSubrecord = true;
            boolean foundSubrecord = false;
            int index = 0;
            for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                if (mergedSubrecord.getSubrecordType().equals("XNAM")) {
                    foundSubrecord = true;
                    subrecordData = mergedSubrecord.getSubrecordData();
                    int mergedFaction = SerializedElement.getInteger(subrecordData, 0);
                    if (faction == mergedFaction) {
                        if (subrecord.equals(mergedSubrecord)) {
                            insertSubrecord = false;
                            break;
                        }
                        if (masterSubrecordList.indexOf(mergedSubrecord) < 0) {
                            if (masterSubrecordList.indexOf(subrecord) < 0) {
                                if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                                    mergedSubrecordList.remove(index);
                                    break;
                                }
                                insertSubrecord = false;
                                break;
                            }
                            insertSubrecord = false;
                            break;
                        }
                        mergedSubrecordList.remove(index);
                        break;
                    }
                } else if (foundSubrecord) break;
                ++index;
            }
            if (!insertSubrecord) continue;
            mergedSubrecordList.add(index, subrecord);
            modifiedMergedList = true;
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private void mergeLeveledList(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        String recordType = record.getRecordType();
        int formID = mergedRecord.getFormID();
        int masterID = formID >>> 24;
        if (masterID >= this.mergedMasterCount) {
            throw new PluginException("Merged leveled list master ID " + masterID + " is not valid");
        }
        Master master = this.masters[masterID];
        PluginRecord masterRecord = master.getRecord(formID);
        List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        boolean foundFlags = false;
        int chanceIndex = -1;
        int subrecordIndex = 0;
        for (PluginSubrecord masterSubrecord : masterSubrecordList) {
            if (masterSubrecord.getSubrecordType().equals("LVLF")) {
                foundFlags = true;
                break;
            }
            if (masterSubrecord.getSubrecordType().equals("LVLD")) {
                chanceIndex = subrecordIndex;
            }
            ++subrecordIndex;
        }
        if (!foundFlags) {
            byte[] chanceData;
            if (chanceIndex < 0) {
                byte[] flagsData = new byte[]{0};
                masterSubrecordList.add(new PluginSubrecord(recordType, "LVLF", flagsData));
                chanceData = new byte[]{0};
                masterSubrecordList.add(new PluginSubrecord(recordType, "LVLD", chanceData));
            } else {
                PluginSubrecord chanceSubrecord = masterSubrecordList.get(chanceIndex);
                chanceData = chanceSubrecord.getSubrecordData();
                byte[] flagsData = new byte[]{(byte)((chanceData[0] & 0xFF) >>> 7)};
                chanceData[0] = (byte)(chanceData[0] & 0x7F);
                masterSubrecordList.add(new PluginSubrecord(recordType, "LVLF", flagsData));
            }
        }
        for (PluginSubrecord subrecord : subrecordList) {
            boolean foundSubrecord = false;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("LVLO")) continue;
            for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                if (!mergedSubrecord.getSubrecordType().equals(subrecordType)) continue;
                foundSubrecord = true;
                boolean replaceSubrecord = false;
                if (!mergedSubrecord.equals(subrecord)) {
                    int mergedIndex = masterSubrecordList.indexOf(mergedSubrecord);
                    int index = masterSubrecordList.indexOf(subrecord);
                    if (mergedIndex < 0) {
                        if (index < 0 && (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict())) {
                            replaceSubrecord = true;
                        }
                    } else {
                        replaceSubrecord = true;
                    }
                }
                if (!replaceSubrecord) break;
                int index = mergedSubrecordList.indexOf(mergedSubrecord);
                mergedSubrecordList.remove(index);
                mergedSubrecordList.add(index, subrecord);
                break;
            }
            if (foundSubrecord) continue;
            mergedSubrecordList.add(subrecord);
        }
        for (PluginSubrecord subrecord : subrecordList) {
            if (!subrecord.getSubrecordType().equals("LVLO")) continue;
            byte[] subrecordData = subrecord.getSubrecordData();
            int itemLevel = SerializedElement.getShort(subrecordData, 0);
            int itemID = SerializedElement.getInteger(subrecordData, 4);
            boolean duplicate = false;
            int index = 0;
            for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                if (mergedSubrecord.getSubrecordType().equals("LVLO")) {
                    byte[] mergedSubrecordData = mergedSubrecord.getSubrecordData();
                    int mergedItemLevel = SerializedElement.getShort(mergedSubrecordData, 0);
                    int mergedItemID = SerializedElement.getInteger(mergedSubrecordData, 4);
                    if (mergedItemLevel > itemLevel) break;
                    if (mergedItemLevel == itemLevel && mergedItemID == itemID) {
                        duplicate = true;
                        break;
                    }
                }
                ++index;
            }
            if (duplicate) continue;
            mergedSubrecordList.add(index, subrecord);
        }
        mergedRecord.setSubrecords(mergedSubrecordList);
    }

    private void mergeNPC(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        boolean modifiedMergedList = false;
        String[] exclusionList = new String[]{"CNTO", "CSDC", "CSDI", "CSDT", "PKID", "SNAM", "SPLO"};
        this.mergeSubrecords(mergedRecord, record, exclusionList);
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        if (this.mergeList("CNTO", mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (this.mergeList("PKID", mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (this.mergeList("SNAM", mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (this.mergeList("SPLO", mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (record.getRecordType().equals("CREA") && (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict())) {
            ListIterator<PluginSubrecord> lit = subrecordList.listIterator();
            while (lit.hasNext()) {
                PluginSubrecord subrecord = lit.next();
                if (!subrecord.getSubrecordType().equals("CSDT")) continue;
                int soundIndex = SerializedElement.getInteger(subrecord.getSubrecordData(), 0);
                boolean foundSound = false;
                ListIterator<PluginSubrecord> mlit = mergedSubrecordList.listIterator();
                while (mlit.hasNext()) {
                    int mergedIndex;
                    PluginSubrecord mergedSubrecord = mlit.next();
                    if (!mergedSubrecord.getSubrecordType().equals("CSDT") || (mergedIndex = SerializedElement.getInteger(mergedSubrecord.getSubrecordData(), 0)) != soundIndex) continue;
                    foundSound = true;
                    mlit.set(subrecord);
                    mlit.next();
                    mlit.set(lit.next());
                    mlit.next();
                    mlit.set(lit.next());
                    break;
                }
                if (!foundSound) {
                    mergedSubrecordList.add(subrecord);
                    mergedSubrecordList.add(lit.next());
                    mergedSubrecordList.add(lit.next());
                }
                modifiedMergedList = true;
            }
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private void mergeRace(PluginRecord mergedRecord, PluginRecord record) throws DataFormatException, IOException, PluginException {
        List<PluginSubrecord> subrecordList;
        boolean modifiedMergedList = false;
        String[] exclusionList = new String[]{"ENAM", "FNAM", "HNAM", "ICON", "INDX", "MNAM", "MODB", "MODL", "NAM0", "NAM1", "SPLO", "XNAM"};
        this.mergeSubrecords(mergedRecord, record, exclusionList);
        int formID = mergedRecord.getFormID();
        int masterID = formID >>> 24;
        if (masterID >= this.mergedMasterCount) {
            throw new PluginException("Merged master ID " + masterID + " is not valid");
        }
        Master master = this.masters[masterID];
        PluginRecord masterRecord = master.getRecord(formID);
        List<PluginSubrecord> masterSubrecordList = masterRecord.getSubrecords();
        List<PluginSubrecord> mergedSubrecordList = mergedRecord.getSubrecords();
        if (this.mergeList("SPLO", mergedSubrecordList, subrecordList = record.getSubrecords())) {
            modifiedMergedList = true;
        }
        for (PluginSubrecord subrecord : subrecordList) {
            if (!subrecord.getSubrecordType().equals("XNAM")) continue;
            byte[] subrecordData = subrecord.getSubrecordData();
            int raceID = SerializedElement.getInteger(subrecordData, 0);
            int modifier = SerializedElement.getInteger(subrecordData, 4);
            boolean insertSubrecord = true;
            boolean foundSubrecord = false;
            int index = 0;
            for (PluginSubrecord mergedSubrecord : mergedSubrecordList) {
                if (mergedSubrecord.getSubrecordType().equals("XNAM")) {
                    foundSubrecord = true;
                    subrecordData = mergedSubrecord.getSubrecordData();
                    int mergedRaceID = SerializedElement.getInteger(subrecordData, 0);
                    int mergedModifier = SerializedElement.getInteger(subrecordData, 4);
                    if (raceID == mergedRaceID) {
                        if (subrecord.equals(mergedSubrecord)) {
                            insertSubrecord = false;
                            break;
                        }
                        if (masterSubrecordList.indexOf(mergedSubrecord) < 0) {
                            if (masterSubrecordList.indexOf(subrecord) < 0) {
                                if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                                    mergedSubrecordList.remove(index);
                                    break;
                                }
                                insertSubrecord = false;
                                break;
                            }
                            insertSubrecord = false;
                            break;
                        }
                        mergedSubrecordList.remove(index);
                        break;
                    }
                } else if (foundSubrecord) break;
                ++index;
            }
            if (!insertSubrecord) continue;
            mergedSubrecordList.add(index, subrecord);
            modifiedMergedList = true;
        }
        if (this.mergeArray("ENAM", 4, mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (this.mergeArray("HNAM", 4, mergedSubrecordList, subrecordList)) {
            modifiedMergedList = true;
        }
        if (this.mergeFaceData(subrecordList, mergedSubrecordList, masterSubrecordList)) {
            modifiedMergedList = true;
        }
        if (this.mergeBodyData(subrecordList, mergedSubrecordList, masterSubrecordList)) {
            modifiedMergedList = true;
        }
        if (modifiedMergedList) {
            mergedRecord.setSubrecords(mergedSubrecordList);
        }
    }

    private boolean mergeFaceData(List<PluginSubrecord> subrecordList, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> masterSubrecordList) throws PluginException {
        String subrecordType;
        boolean modifiedMergedList = false;
        boolean foundList = false;
        int count = 0;
        for (PluginSubrecord subrecord : subrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("NAM1")) {
                if (foundList) break;
                throw new PluginException("Face data does not precede body data");
            }
            if (!foundList) {
                if (!subrecordType.equals("NAM0")) continue;
                foundList = true;
                continue;
            }
            if (!subrecordType.equals("INDX")) continue;
            ++count;
        }
        PluginSubrecord[] indx = new PluginSubrecord[count];
        PluginSubrecord[] modl = new PluginSubrecord[count];
        PluginSubrecord[] modb = new PluginSubrecord[count];
        PluginSubrecord[] icon = new PluginSubrecord[count];
        int index = -1;
        foundList = false;
        for (PluginSubrecord subrecord : subrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (!foundList) {
                if (!subrecordType.equals("NAM0")) continue;
                foundList = true;
                continue;
            }
            if (subrecordType.equals("INDX")) {
                indx[++index] = subrecord;
                continue;
            }
            if (subrecordType.equals("MODL")) {
                modl[index] = subrecord;
                continue;
            }
            if (subrecordType.equals("MODB")) {
                modb[index] = subrecord;
                continue;
            }
            if (!subrecordType.equals("ICON")) break;
            icon[index] = subrecord;
        }
        foundList = false;
        count = 0;
        for (PluginSubrecord subrecord : mergedSubrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("NAM1")) {
                if (foundList) break;
                throw new PluginException("Face data does not precede body data");
            }
            if (!foundList) {
                if (!subrecordType.equals("NAM0")) continue;
                foundList = true;
                continue;
            }
            if (!subrecordType.equals("INDX")) continue;
            ++count;
        }
        PluginSubrecord[] mindx = new PluginSubrecord[count];
        PluginSubrecord[] mmodl = new PluginSubrecord[count];
        PluginSubrecord[] mmodb = new PluginSubrecord[count];
        PluginSubrecord[] micon = new PluginSubrecord[count];
        index = -1;
        foundList = false;
        for (PluginSubrecord subrecord : mergedSubrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (!foundList) {
                if (!subrecordType.equals("NAM0")) continue;
                foundList = true;
                continue;
            }
            if (subrecordType.equals("INDX")) {
                mindx[++index] = subrecord;
                continue;
            }
            if (subrecordType.equals("MODL")) {
                mmodl[index] = subrecord;
                continue;
            }
            if (subrecordType.equals("MODB")) {
                mmodb[index] = subrecord;
                continue;
            }
            if (!subrecordType.equals("ICON")) break;
            micon[index] = subrecord;
        }
        foundList = false;
        count = 0;
        for (PluginSubrecord subrecord : masterSubrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("NAM1")) {
                if (foundList) break;
                throw new PluginException("Face data does not precede body data");
            }
            if (!foundList) {
                if (!subrecordType.equals("NAM0")) continue;
                foundList = true;
                continue;
            }
            if (!subrecordType.equals("INDX")) continue;
            ++count;
        }
        PluginSubrecord[] xindx = new PluginSubrecord[count];
        PluginSubrecord[] xmodl = new PluginSubrecord[count];
        PluginSubrecord[] xmodb = new PluginSubrecord[count];
        PluginSubrecord[] xicon = new PluginSubrecord[count];
        index = -1;
        foundList = false;
        for (PluginSubrecord subrecord : masterSubrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (!foundList) {
                if (!subrecordType.equals("NAM0")) continue;
                foundList = true;
                continue;
            }
            if (subrecordType.equals("INDX")) {
                xindx[++index] = subrecord;
                continue;
            }
            if (subrecordType.equals("MODL")) {
                xmodl[index] = subrecord;
                continue;
            }
            if (subrecordType.equals("MODB")) {
                xmodb[index] = subrecord;
                continue;
            }
            if (!subrecordType.equals("ICON")) break;
            xicon[index] = subrecord;
        }
        if (indx.length != mindx.length || indx.length != xindx.length) {
            throw new PluginException("Face data maximum index values are not the same");
        }
        boolean rebuildMergedData = false;
        int i = 0;
        while (i < indx.length) {
            if (!indx[i].equals(mindx[i]) || !indx[i].equals(xindx[i])) {
                throw new PluginException("Incorrect face data index progression");
            }
            if (modl[i] != null) {
                if (mmodl[i] != null) {
                    if (!modl[i].equals(mmodl[i])) {
                        if (xmodl[i] != null) {
                            if (!modl[i].equals(xmodl[i])) {
                                if (!mmodl[i].equals(xmodl[i])) {
                                    if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                                        mmodl[i] = modl[i];
                                        rebuildMergedData = true;
                                    }
                                } else {
                                    mmodl[i] = modl[i];
                                    rebuildMergedData = true;
                                }
                            }
                        } else if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                            mmodl[i] = modl[i];
                            rebuildMergedData = true;
                        }
                    }
                } else {
                    mmodl[i] = modl[i];
                    rebuildMergedData = true;
                }
            }
            if (icon[i] != null) {
                if (micon[i] != null) {
                    if (!icon[i].equals(micon[i])) {
                        if (xicon[i] != null) {
                            if (!icon[i].equals(xicon[i])) {
                                if (!micon[i].equals(xicon[i])) {
                                    if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                                        micon[i] = icon[i];
                                        rebuildMergedData = true;
                                    }
                                } else {
                                    micon[i] = icon[i];
                                    rebuildMergedData = true;
                                }
                            }
                        } else if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                            micon[i] = icon[i];
                            rebuildMergedData = true;
                        }
                    }
                } else {
                    micon[i] = icon[i];
                    rebuildMergedData = true;
                }
            }
            ++i;
        }
        if (rebuildMergedData) {
            modifiedMergedList = true;
            index = 0;
            foundList = false;
            ListIterator<PluginSubrecord> lit = mergedSubrecordList.listIterator();
            while (lit.hasNext()) {
                PluginSubrecord subrecord = lit.next();
                subrecordType = subrecord.getSubrecordType();
                if (foundList) {
                    if (!subrecordType.equals("INDX") && !subrecordType.equals("MODL") && !subrecordType.equals("MODB") && !subrecordType.equals("ICON")) break;
                    lit.remove();
                    continue;
                }
                if (subrecordType.equals("NAM0")) {
                    foundList = true;
                    lit.remove();
                    continue;
                }
                ++index;
            }
            int i2 = mindx.length - 1;
            while (i2 >= 0) {
                if (micon[i2] != null) {
                    mergedSubrecordList.add(index, micon[i2]);
                }
                if (mmodb[i2] != null) {
                    mergedSubrecordList.add(index, mmodb[i2]);
                }
                if (mmodl[i2] != null) {
                    mergedSubrecordList.add(index, mmodl[i2]);
                }
                mergedSubrecordList.add(index, mindx[i2]);
                --i2;
            }
            byte[] subrecordData = new byte[]{};
            mergedSubrecordList.add(index, new PluginSubrecord("RACE", "NAM0", subrecordData));
        }
        return modifiedMergedList;
    }

    private boolean mergeBodyData(List<PluginSubrecord> subrecordList, List<PluginSubrecord> mergedSubrecordList, List<PluginSubrecord> masterSubrecordList) throws PluginException {
        String subrecordType;
        String subrecordType2;
        boolean modifiedMergedList = false;
        boolean foundList = false;
        boolean foundFace = false;
        int count = 0;
        for (PluginSubrecord subrecord : subrecordList) {
            String subrecordType3 = subrecord.getSubrecordType();
            if (!foundList) {
                if (subrecordType3.equals("NAM0")) {
                    foundFace = true;
                    continue;
                }
                if (!subrecordType3.equals("NAM1")) continue;
                if (!foundFace) {
                    throw new PluginException("Face data does not precede body data");
                }
                foundList = true;
                continue;
            }
            if (!subrecordType3.equals("INDX")) continue;
            ++count;
        }
        PluginSubrecord[] indx = new PluginSubrecord[count];
        PluginSubrecord[] icon = new PluginSubrecord[count];
        PluginSubrecord[] modl = new PluginSubrecord[2];
        PluginSubrecord[] modb = new PluginSubrecord[2];
        int index = -1;
        int femaleIndex = -1;
        boolean foundFemale = false;
        foundList = false;
        for (PluginSubrecord subrecord : subrecordList) {
            subrecordType2 = subrecord.getSubrecordType();
            if (!foundList) {
                if (!subrecordType2.equals("NAM1")) continue;
                foundList = true;
                continue;
            }
            if (subrecordType2.equals("INDX")) {
                indx[++index] = subrecord;
                continue;
            }
            if (subrecordType2.equals("ICON")) {
                icon[index] = subrecord;
                continue;
            }
            if (subrecordType2.equals("MNAM")) {
                if (!foundFemale) continue;
                throw new PluginException("Female body data does not follow male body data");
            }
            if (subrecordType2.equals("FNAM")) {
                foundFemale = true;
                femaleIndex = index + 1;
                continue;
            }
            if (subrecordType2.equals("MODL")) {
                if (!foundFemale) {
                    modl[0] = subrecord;
                    continue;
                }
                modl[1] = subrecord;
                continue;
            }
            if (!subrecordType2.equals("MODB")) break;
            if (!foundFemale) {
                modb[0] = subrecord;
                continue;
            }
            modb[1] = subrecord;
        }
        if (!foundFemale) {
            throw new PluginException("No female body data");
        }
        foundList = false;
        foundFace = false;
        count = 0;
        for (PluginSubrecord subrecord : mergedSubrecordList) {
            subrecordType2 = subrecord.getSubrecordType();
            if (!foundList) {
                if (subrecordType2.equals("NAM0")) {
                    foundFace = true;
                    continue;
                }
                if (!subrecordType2.equals("NAM1")) continue;
                if (!foundFace) {
                    throw new PluginException("Face data does not precede body data");
                }
                foundList = true;
                continue;
            }
            if (!subrecordType2.equals("INDX")) continue;
            ++count;
        }
        PluginSubrecord[] mindx = new PluginSubrecord[count];
        PluginSubrecord[] micon = new PluginSubrecord[count];
        PluginSubrecord[] mmodl = new PluginSubrecord[2];
        PluginSubrecord[] mmodb = new PluginSubrecord[2];
        index = -1;
        foundList = false;
        foundFemale = false;
        for (PluginSubrecord subrecord : mergedSubrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (!foundList) {
                if (!subrecordType.equals("NAM1")) continue;
                foundList = true;
                continue;
            }
            if (subrecordType.equals("INDX")) {
                mindx[++index] = subrecord;
                continue;
            }
            if (subrecordType.equals("ICON")) {
                micon[index] = subrecord;
                continue;
            }
            if (subrecordType.equals("MNAM")) {
                if (!foundFemale) continue;
                throw new PluginException("Female body data does not follow male body data");
            }
            if (subrecordType.equals("FNAM")) {
                foundFemale = true;
                continue;
            }
            if (subrecordType.equals("MODL")) {
                if (!foundFemale) {
                    mmodl[0] = subrecord;
                    continue;
                }
                mmodl[1] = subrecord;
                continue;
            }
            if (!subrecordType.equals("MODB")) break;
            if (!foundFemale) {
                mmodb[0] = subrecord;
                continue;
            }
            mmodb[1] = subrecord;
        }
        foundList = false;
        foundFace = false;
        count = 0;
        for (PluginSubrecord subrecord : masterSubrecordList) {
            subrecordType = subrecord.getSubrecordType();
            if (!foundList) {
                if (subrecordType.equals("NAM0")) {
                    foundFace = true;
                    continue;
                }
                if (!subrecordType.equals("NAM1")) continue;
                if (!foundFace) {
                    throw new PluginException("Face data does not precede body data");
                }
                foundList = true;
                continue;
            }
            if (!subrecordType.equals("INDX")) continue;
            ++count;
        }
        PluginSubrecord[] xindx = new PluginSubrecord[count];
        PluginSubrecord[] xicon = new PluginSubrecord[count];
        PluginSubrecord[] xmodl = new PluginSubrecord[2];
        PluginSubrecord[] xmodb = new PluginSubrecord[2];
        index = -1;
        foundList = false;
        foundFemale = false;
        for (PluginSubrecord subrecord : masterSubrecordList) {
            String subrecordType4 = subrecord.getSubrecordType();
            if (!foundList) {
                if (!subrecordType4.equals("NAM1")) continue;
                foundList = true;
                continue;
            }
            if (subrecordType4.equals("INDX")) {
                xindx[++index] = subrecord;
                continue;
            }
            if (subrecordType4.equals("ICON")) {
                xicon[index] = subrecord;
                continue;
            }
            if (subrecordType4.equals("MNAM")) {
                if (!foundFemale) continue;
                throw new PluginException("Female body data does not follow male body data");
            }
            if (subrecordType4.equals("FNAM")) {
                foundFemale = true;
                continue;
            }
            if (subrecordType4.equals("MODL")) {
                if (!foundFemale) {
                    xmodl[0] = subrecord;
                    continue;
                }
                xmodl[1] = subrecord;
                continue;
            }
            if (!subrecordType4.equals("MODB")) break;
            if (!foundFemale) {
                xmodb[0] = subrecord;
                continue;
            }
            xmodb[1] = subrecord;
        }
        if (indx.length != mindx.length || indx.length != xindx.length) {
            throw new PluginException("Body data maximum index values are not the same");
        }
        boolean rebuildMergedData = false;
        int i = 0;
        while (i < indx.length) {
            if (!indx[i].equals(mindx[i]) || !indx[i].equals(xindx[i])) {
                throw new PluginException("Incorrect body data index progression");
            }
            if (icon[i] != null) {
                if (micon[i] != null) {
                    if (!icon[i].equals(micon[i])) {
                        if (xicon[i] != null) {
                            if (!icon[i].equals(xicon[i])) {
                                if (!micon[i].equals(xicon[i])) {
                                    if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                                        micon[i] = icon[i];
                                        rebuildMergedData = true;
                                    }
                                } else {
                                    micon[i] = icon[i];
                                    rebuildMergedData = true;
                                }
                            }
                        } else if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                            micon[i] = icon[i];
                            rebuildMergedData = true;
                        }
                    }
                } else {
                    micon[i] = icon[i];
                    rebuildMergedData = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            if (modl[i] != null) {
                if (mmodl[i] != null) {
                    if (xmodl[i] != null) {
                        if (!modl[i].equals(xmodl[i])) {
                            if (!mmodl[i].equals(xmodl[i])) {
                                if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                                    mmodl[i] = modl[i];
                                    mmodb[i] = modb[i];
                                    rebuildMergedData = true;
                                }
                            } else {
                                mmodl[i] = modl[i];
                                mmodb[i] = modb[i];
                                rebuildMergedData = true;
                            }
                        }
                    } else if (this.masterMerge || !this.pluginInfo.shouldDeleteLastConflict()) {
                        mmodl[i] = modl[i];
                        mmodb[i] = modb[i];
                        rebuildMergedData = true;
                    }
                } else {
                    mmodl[i] = modl[i];
                    mmodb[i] = modb[i];
                    rebuildMergedData = true;
                }
            }
            ++i;
        }
        if (rebuildMergedData) {
            modifiedMergedList = true;
            index = 0;
            foundList = false;
            ListIterator<PluginSubrecord> lit = mergedSubrecordList.listIterator();
            while (lit.hasNext()) {
                PluginSubrecord subrecord = lit.next();
                String subrecordType5 = subrecord.getSubrecordType();
                if (foundList) {
                    if (!subrecordType5.equals("INDX") && !subrecordType5.equals("MNAM") && !subrecordType5.equals("FNAM") && !subrecordType5.equals("MODL") && !subrecordType5.equals("MODB") && !subrecordType5.equals("ICON")) break;
                    lit.remove();
                    continue;
                }
                if (subrecordType5.equals("NAM1")) {
                    foundList = true;
                    lit.remove();
                    continue;
                }
                ++index;
            }
            byte[] subrecordData = new byte[]{};
            int i2 = mindx.length - 1;
            while (i2 >= 0) {
                if (micon[i2] != null) {
                    mergedSubrecordList.add(index, micon[i2]);
                }
                mergedSubrecordList.add(index, mindx[i2]);
                if (i2 == femaleIndex) {
                    if (mmodb[1] != null) {
                        mergedSubrecordList.add(index, mmodb[1]);
                    }
                    if (mmodl[1] != null) {
                        mergedSubrecordList.add(index, mmodl[1]);
                    }
                    mergedSubrecordList.add(index, new PluginSubrecord("RACE", "FNAM", subrecordData));
                }
                --i2;
            }
            if (mmodb[0] != null) {
                mergedSubrecordList.add(index, mmodb[0]);
            }
            if (mmodl[0] != null) {
                mergedSubrecordList.add(index, mmodl[0]);
            }
            mergedSubrecordList.add(index, new PluginSubrecord("RACE", "MNAM", subrecordData));
            mergedSubrecordList.add(index, new PluginSubrecord("RACE", "NAM1", subrecordData));
        }
        return modifiedMergedList;
    }

    private void copyVoiceFiles(Plugin plugin, File voiceDirectory, String mergedPath) throws DataFormatException, IOException, PluginException {
        File[] files = voiceDirectory.listFiles();
        List<FormInfo> formList = plugin.getFormList();
        Map<Integer, FormInfo> formMap = plugin.getFormMap();
        int masterID = plugin.getMasterList().size();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                String path = String.valueOf(mergedPath) + Main.fileSeparator + file.getName();
                this.copyVoiceFiles(plugin, file, path);
            } else {
                int infoSep;
                int topicSep;
                String name = file.getName();
                int questSep = name.indexOf(95);
                if (questSep >= 1 && (topicSep = name.indexOf(95, questSep + 1)) >= questSep + 2 && (infoSep = name.indexOf(95, topicSep + 1)) >= topicSep + 2) {
                    FormInfo infoForm;
                    int infoID;
                    try {
                        infoID = Integer.parseInt(name.substring(topicSep + 1, infoSep), 16);
                    }
                    catch (NumberFormatException exc) {
                        infoID = 0;
                    }
                    if (infoID != 0 && (infoForm = formMap.get(new Integer(infoID |= masterID << 24))) != null) {
                        FormInfo topicForm;
                        PluginRecord infoRecord = (PluginRecord)infoForm.getSource();
                        int topicID = infoForm.getParentFormID();
                        if (topicID != 0 && (topicForm = formMap.get(new Integer(topicID))) != null) {
                            String topicName = topicForm.getMergedEditorID();
                            int questID = 0;
                            List<PluginSubrecord> subrecordList = infoRecord.getSubrecords();
                            for (PluginSubrecord subrecord : subrecordList) {
                                if (!subrecord.getSubrecordType().equals("QSTI")) continue;
                                byte[] subrecordData = subrecord.getSubrecordData();
                                questID = SerializedElement.getInteger(subrecordData, 0);
                                break;
                            }
                            if (questID != 0) {
                                FormInfo questForm = formMap.get(new Integer(questID));
                                String questName = questForm == null ? name.substring(0, questSep) : questForm.getMergedEditorID();
                                File mergedDirectory = new File(mergedPath);
                                if (!mergedDirectory.exists()) {
                                    mergedDirectory.mkdirs();
                                }
                                String mergedName = String.format("%s%s%s_%s_%08X_%s", mergedPath, Main.fileSeparator, questName, topicName, infoForm.getMergedFormID() & 0xFFFFFF, name.substring(infoSep + 1));
                                File mergedFile = new File(mergedName);
                                FileInputStream in = new FileInputStream(file);
                                FileOutputStream out = new FileOutputStream(mergedFile);
                                int length = (int)file.length();
                                byte[] buffer = new byte[length];
                                in.read(buffer);
                                out.write(buffer);
                                out.close();
                                in.close();
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void deleteDirectoryTree(File directory) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.deleteDirectoryTree(file);
            } else {
                file.delete();
            }
            ++n2;
        }
        directory.delete();
    }

    public void buildDeletedINFOMap(Plugin plugin, Map<Integer, List<PluginRecord>> deletedMap) {
        PluginGroup dialogueGroup = plugin.getTopGroup("DIAL");
        if (dialogueGroup == null || deletedMap == null) {
            return;
        }
        List<PluginRecord> groupList = dialogueGroup.getRecordList();
        for (PluginRecord dialOrInfo : groupList) {
            int topicID;
            if (!(dialOrInfo instanceof PluginGroup) || !deletedMap.containsKey(topicID = ((PluginGroup)dialOrInfo).getGroupParentID())) continue;
            List<PluginRecord> infoList = ((PluginGroup)dialOrInfo).getRecordList();
            List<PluginRecord> deletedList = deletedMap.get(topicID);
            ListIterator<PluginRecord> lit1 = deletedList.listIterator();
            block1: while (lit1.hasNext()) {
                PluginRecord delRec = lit1.next();
                ListIterator<PluginRecord> lit2 = infoList.listIterator();
                while (lit2.hasNext()) {
                    PluginRecord rec = lit2.next();
                    if (rec.isDeleted() || rec.getFormID() != delRec.getFormID()) continue;
                    lit1.set(rec);
                    continue block1;
                }
            }
        }
        for (PluginRecord dialOrInfo : groupList) {
            if (!(dialOrInfo instanceof PluginGroup)) continue;
            PluginGroup topicGroup = (PluginGroup)dialOrInfo;
            int topicID = topicGroup.getGroupParentID();
            List<PluginRecord> newDelList = topicGroup.getDeletedPluginRecords();
            if (!newDelList.isEmpty() && !deletedMap.containsKey(topicID)) {
                deletedMap.put(topicID, newDelList);
                continue;
            }
            List<PluginRecord> deletedList = deletedMap.get(topicID);
            block4: for (PluginRecord delRec : newDelList) {
                ListIterator<PluginRecord> lit = deletedList.listIterator();
                boolean alreadyPresent = false;
                while (lit.hasNext()) {
                    PluginRecord rec = lit.next();
                    if (rec.getFormID() == delRec.getFormID()) {
                        alreadyPresent = true;
                        continue block4;
                    }
                    if (alreadyPresent) continue;
                    lit.add(delRec);
                }
            }
        }
    }

    private int getStartFormID(int baseID) {
        int retVal = -1;
        String inputID = (String)JOptionPane.showInputDialog(parentWindow, "<html>Please enter the starting form ID <i>in hex</i>\n(Numbering will start at this number plus one):", "New Starting Form ID", -1, null, null, String.format("%08X", baseID));
        if (inputID == null) {
            return retVal;
        }
        try {
            retVal = Integer.parseInt(inputID, 16);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(parentWindow, "Value entered: \"" + inputID + "\" is not a valid number.", "Entry Error", 0);
            return -1;
        }
        if (retVal < baseID) {
            JOptionPane.showMessageDialog(parentWindow, "Number entered: \"" + String.format("%08X", retVal) + "\" is too small.", "Entry Error", 0);
            return -1;
        }
        return retVal;
    }

    private int highestFormID(Plugin pl) {
        List<FormInfo> allForms = pl.getFormList();
        int highFormID = allForms.get(0).getFormID();
        for (FormInfo form : allForms) {
            int formID = form.getFormID();
            if (formID <= highFormID) continue;
            highFormID = formID;
        }
        return highFormID;
    }
}

