/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import java.awt.Color;
import java.util.HashMap;

public final class PluginColorMap {
    private static HashMap<Integer, Color> colorMap = new HashMap();
    private static final Color ThisPlugin = Color.WHITE;
    private static final Color LastESM = Color.YELLOW;
    private static final Color LastMinus1ESM = Color.PINK;
    private static final Color LastMinus2ESM = Color.CYAN;
    private static final Color LastMinus3ESM = Color.ORANGE;
    private static final Color LastMinus4ESM = Color.MAGENTA;
    private static final Color AllOtherESM = Color.GREEN;
    private static Color[] colorArray = new Color[]{ThisPlugin, LastESM, LastMinus1ESM, LastMinus2ESM, LastMinus3ESM, LastMinus4ESM, AllOtherESM};

    private PluginColorMap() {
    }

    public static void setColorMap(int numMasters) {
        colorMap.clear();
        int i = numMasters;
        int j = 0;
        while (i >= 0) {
            colorMap.put(i, j > 6 ? colorArray[6] : colorArray[j]);
            --i;
            ++j;
        }
    }

    public static Color getPluginColor(int modIndex) {
        if (colorMap.containsKey(modIndex)) {
            return colorMap.get(modIndex);
        }
        return AllOtherESM;
    }

    public static Color getPluginColor(String modIndex) {
        Color retColor = null;
        try {
            int idx = Integer.parseInt(modIndex);
            retColor = PluginColorMap.getPluginColor(idx);
        }
        catch (Exception ex) {
            retColor = AllOtherESM;
        }
        return retColor;
    }
}

