/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.Main;
import TES4Gecko.PluginException;
import TES4Gecko.SerializedElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHeader
extends SerializedElement {
    private File pluginFile;
    private float pluginVersion;
    private boolean master;
    private String creator;
    private String summary;
    private int recordCount;
    private List<String> masterList;

    public PluginHeader(File pluginFile) {
        this.pluginFile = pluginFile;
        this.pluginVersion = 0.8f;
        this.master = false;
        this.creator = "DEFAULT";
        this.summary = new String();
        this.masterList = new ArrayList<String>();
    }

    public float getVersion() {
        return this.pluginVersion;
    }

    public void setVersion(float version) {
        this.pluginVersion = version;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public List<String> getMasterList() {
        return this.masterList;
    }

    public void setMasterList(List<String> masterList) {
        this.masterList = masterList;
    }

    public void read(RandomAccessFile in) throws PluginException, IOException {
        byte[] prefix = new byte[20];
        byte[] buffer = new byte[1024];
        int count = in.read(prefix, 0, 20);
        if (count != 20) {
            throw new PluginException(String.valueOf(this.pluginFile.getName()) + ": File is not a TES4 file");
        }
        String type = new String(prefix, 0, 4);
        if (!type.equals("TES4")) {
            throw new PluginException(String.valueOf(this.pluginFile.getName()) + ": File is not a TES4 file");
        }
        this.master = (prefix[8] & 1) != 0;
        int headerLength = PluginHeader.getInteger(prefix, 4);
        while (headerLength >= 6) {
            count = in.read(prefix, 0, 6);
            if (count != 6) {
                throw new PluginException(String.valueOf(this.pluginFile.getName()) + ": Header subrecord prefix truncated");
            }
            int length = PluginHeader.getShort(prefix, 4);
            if (length > (headerLength -= 6)) {
                throw new PluginException(String.valueOf(this.pluginFile.getName()) + ": Subrecord length exceeds header length");
            }
            if (length > buffer.length) {
                buffer = new byte[length];
            }
            if ((count = in.read(buffer, 0, length)) != length) {
                throw new PluginException(String.valueOf(this.pluginFile.getName()) + ": Header subrecord data truncated");
            }
            headerLength -= count;
            type = new String(prefix, 0, 4);
            if (type.equals("HEDR")) {
                if (length < 8) {
                    throw new PluginException(String.valueOf(this.pluginFile.getName()) + ": HEDR subrecord is too small");
                }
                int pluginIntVersion = PluginHeader.getInteger(buffer, 0);
                this.pluginVersion = Float.intBitsToFloat(pluginIntVersion);
                if (Main.debugMode) {
                    System.out.printf("%s: Version %f\n", this.pluginFile.getName(), Float.valueOf(this.pluginVersion));
                }
                this.recordCount = PluginHeader.getInteger(buffer, 4);
                if (!Main.debugMode) continue;
                System.out.printf("%s: %d records\n", this.pluginFile.getName(), this.recordCount);
                continue;
            }
            if (type.equals("CNAM")) {
                if (length <= 1) continue;
                this.creator = new String(buffer, 0, length - 1);
                continue;
            }
            if (type.equals("SNAM")) {
                if (length <= 1) continue;
                this.summary = new String(buffer, 0, length - 1);
                continue;
            }
            if (!type.equals("MAST") || length <= 1) continue;
            this.masterList.add(new String(buffer, 0, length - 1));
        }
        if (headerLength != 0) {
            throw new PluginException(String.valueOf(this.pluginFile.getName()) + ": Header is incomplete");
        }
    }

    public void write(FileOutputStream out) throws IOException {
        byte[] headerRecord = this.buildHeader();
        out.write(headerRecord);
    }

    public void write(RandomAccessFile out) throws IOException {
        byte[] headerRecord = this.buildHeader();
        out.write(headerRecord);
    }

    private byte[] buildHeader() {
        byte[] snamSubrecord;
        int pluginIntVersion = Float.floatToIntBits(this.pluginVersion);
        byte[] hedrSubrecord = new byte[18];
        System.arraycopy("HEDR".getBytes(), 0, hedrSubrecord, 0, 4);
        PluginHeader.setShort(12, hedrSubrecord, 4);
        PluginHeader.setInteger(pluginIntVersion, hedrSubrecord, 6);
        PluginHeader.setInteger(this.recordCount, hedrSubrecord, 10);
        byte[] creatorBytes = this.creator.getBytes();
        int length = creatorBytes.length + 1;
        byte[] cnamSubrecord = new byte[6 + length];
        System.arraycopy("CNAM".getBytes(), 0, cnamSubrecord, 0, 4);
        PluginHeader.setShort(length, cnamSubrecord, 4);
        if (length > 1) {
            System.arraycopy(creatorBytes, 0, cnamSubrecord, 6, creatorBytes.length);
        }
        cnamSubrecord[6 + creatorBytes.length] = 0;
        byte[] summaryBytes = this.summary.getBytes();
        length = summaryBytes.length + 1;
        if (length > 1) {
            snamSubrecord = new byte[6 + length];
            System.arraycopy("SNAM".getBytes(), 0, snamSubrecord, 0, 4);
            PluginHeader.setShort(length, snamSubrecord, 4);
            System.arraycopy(summaryBytes, 0, snamSubrecord, 6, summaryBytes.length);
            snamSubrecord[6 + summaryBytes.length] = 0;
        } else {
            snamSubrecord = new byte[]{};
        }
        byte[][] masterSubrecords = new byte[this.masterList.size()][];
        int count = 0;
        for (String master : this.masterList) {
            byte[] masterBytes = master.getBytes();
            length = masterBytes.length + 1;
            byte[] masterSubrecord = new byte[6 + length];
            System.arraycopy("MAST".getBytes(), 0, masterSubrecord, 0, 4);
            PluginHeader.setShort(length, masterSubrecord, 4);
            if (length > 1) {
                System.arraycopy(masterBytes, 0, masterSubrecord, 6, masterBytes.length);
            }
            masterSubrecord[6 + masterBytes.length] = 0;
            masterSubrecords[count++] = masterSubrecord;
        }
        length = hedrSubrecord.length + cnamSubrecord.length + snamSubrecord.length;
        int i = 0;
        while (i < masterSubrecords.length) {
            length += masterSubrecords[i].length + 14;
            ++i;
        }
        byte[] headerRecord = new byte[20 + length];
        System.arraycopy("TES4".getBytes(), 0, headerRecord, 0, 4);
        PluginHeader.setInteger(length, headerRecord, 4);
        headerRecord[8] = this.master ? (byte)1 : 0;
        int offset = 20;
        System.arraycopy(hedrSubrecord, 0, headerRecord, offset, hedrSubrecord.length);
        System.arraycopy(cnamSubrecord, 0, headerRecord, offset += hedrSubrecord.length, cnamSubrecord.length);
        offset += cnamSubrecord.length;
        if (snamSubrecord.length != 0) {
            System.arraycopy(snamSubrecord, 0, headerRecord, offset, snamSubrecord.length);
            offset += snamSubrecord.length;
        }
        int i2 = 0;
        while (i2 < masterSubrecords.length) {
            System.arraycopy(masterSubrecords[i2], 0, headerRecord, offset, masterSubrecords[i2].length);
            System.arraycopy("DATA".getBytes(), 0, headerRecord, offset += masterSubrecords[i2].length, 4);
            headerRecord[offset + 4] = 8;
            offset += 14;
            ++i2;
        }
        return headerRecord;
    }
}

