/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.ComparisonCode;
import TES4Gecko.DialogueTypeCode;
import TES4Gecko.EmotionCode;
import TES4Gecko.FunctionCode;
import TES4Gecko.FunctionInfo;
import TES4Gecko.Main;
import TES4Gecko.SerializedElement;
import TES4Gecko.SpellEffectType;
import TES4Gecko.SubrecordDataType;
import TES4Gecko.SubrecordInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PluginSubrecord
extends SerializedElement {
    private String recordType;
    private String subrecordType;
    private boolean spillMode = false;
    private long subrecordPosition = -1L;
    private int subrecordLength;
    private byte[] subrecordData;
    private static Map<String, SubrecordInfo> typeMap;
    private static Map<Integer, FunctionInfo> functionMap;
    private static final int[] offsetRepeating4;
    private static final int[] offsetRepeating8;
    private static final int[] offsetRepeating12;
    private static final int[] offsetRepeating52;
    private static final int[] offsetZero;
    private static final int[] offsetFour;
    private static final int[] offsetZeroFour;
    private static final int[] offsetTwelveSixteen;
    private static final SubrecordInfo[] subrecordInfo;
    private static final String[][] subrecordDataTypes;
    private static final FunctionInfo[] functionInfo;

    static {
        offsetRepeating4 = new int[]{-4};
        offsetRepeating8 = new int[]{-8};
        offsetRepeating12 = new int[]{-12};
        offsetRepeating52 = new int[]{-52};
        offsetZero = new int[1];
        offsetFour = new int[]{4};
        int[] nArray = new int[2];
        nArray[1] = 4;
        offsetZeroFour = nArray;
        offsetTwelveSixteen = new int[]{12, 16};
        subrecordInfo = new SubrecordInfo[]{new SubrecordInfo("ANAM", offsetZero, "DOOR"), new SubrecordInfo("ATXT", offsetZero, "LAND"), new SubrecordInfo("BNAM", offsetZero, "DOOR"), new SubrecordInfo("BTXT", offsetZero, "LAND"), new SubrecordInfo("CNAM", offsetZero, "NPC_", "WRLD"), new SubrecordInfo("CNTO", offsetZero), new SubrecordInfo("CSCR", offsetZero, "CREA"), new SubrecordInfo("CSDI", offsetZero, "CREA"), new SubrecordInfo("DATA", offsetRepeating4, "ANIO", "IDLE"), new SubrecordInfo("DNAM", offsetZeroFour, "RACE"), new SubrecordInfo("VNAM", offsetZeroFour, "RACE"), new SubrecordInfo("ENAM", offsetRepeating4, "AMMO", "ARMO", "BOOK", "CLOT", "NPC_", "RACE", "WEAP"), new SubrecordInfo("GNAM", offsetZero, "LTEX"), new SubrecordInfo("HNAM", offsetRepeating4, "NPC_", "RACE"), new SubrecordInfo("INAM", offsetZero, "CREA", "NPC_"), new SubrecordInfo("LNAM", offsetZero, "LSCR"), new SubrecordInfo("LVLO", offsetFour, "LVLC", "LVLI", "LVSP"), new SubrecordInfo("NAME", offsetZero), new SubrecordInfo("NAM2", offsetZero, "WRLD"), new SubrecordInfo("PFIG", offsetZero, "FLOR"), new SubrecordInfo("PKID", offsetZero), new SubrecordInfo("PNAM", offsetZero, "INFO"), new SubrecordInfo("PGRL", offsetZero, "PGRD"), new SubrecordInfo("QNAM", offsetZero, "CONT"), new SubrecordInfo("QSTA", offsetZero, "QUST"), new SubrecordInfo("QSTI", offsetZero), new SubrecordInfo("RDSD", offsetRepeating12, "REGN"), new SubrecordInfo("RDOT", offsetRepeating52, "REGN"), new SubrecordInfo("RDWT", offsetRepeating8, "REGN"), new SubrecordInfo("RNAM", offsetZero, "NPC_"), new SubrecordInfo("SCIT", offsetZero, "ENCH", "INGR", "SPEL"), new SubrecordInfo("SCRI", offsetZero), new SubrecordInfo("SCRO", offsetZero), new SubrecordInfo("SNAM", offsetZero, "ACTI", "CONT", "CREA", "DOOR", "LIGH", "NPC_", "WATR", "WRLD", "WTHR"), new SubrecordInfo("SPLO", offsetZero), new SubrecordInfo("TCLF", offsetZero, "INFO"), new SubrecordInfo("TCLT", offsetZero, "INFO"), new SubrecordInfo("TNAM", offsetZero, "DOOR", "LVLC"), new SubrecordInfo("VNAM", offsetZeroFour, "RACE"), new SubrecordInfo("WLST", offsetRepeating8, "CLMT"), new SubrecordInfo("WNAM", offsetZero, "REGN", "WRLD"), new SubrecordInfo("XCCM", offsetZero, "CELL"), new SubrecordInfo("XCLR", offsetRepeating4, "CELL"), new SubrecordInfo("XCWT", offsetZero, "CELL"), new SubrecordInfo("XESP", offsetZero), new SubrecordInfo("XGLB", offsetZero), new SubrecordInfo("XHRS", offsetZero, "ACHR"), new SubrecordInfo("XLOC", offsetFour, "REFR"), new SubrecordInfo("XMRC", offsetZero, "ACHR"), new SubrecordInfo("XNAM", offsetZero, "FACT", "RACE"), new SubrecordInfo("XOWN", offsetZero), new SubrecordInfo("XPCI", offsetZero), new SubrecordInfo("XRTM", offsetZero, "REFR"), new SubrecordInfo("XTEL", offsetZero, "REFR"), new SubrecordInfo("ZNAM", offsetZero)};
        subrecordDataTypes = new String[0][];
        functionInfo = new FunctionInfo[]{new FunctionInfo("CanHaveFlames", 153, false, false), new FunctionInfo("CanPayCrimeGold", 127, false, false), new FunctionInfo("GetActorValue", 14, true, false), new FunctionInfo("GetAlarmed", 61, false, false), new FunctionInfo("GetAmountSoldStolen", 190, false, false), new FunctionInfo("GetAngle", 8, true, false), new FunctionInfo("GetArmorRating", 81, false, false), new FunctionInfo("GetArmorRatingUpperBody", 274, false, false), new FunctionInfo("GetAttacked", 63, false, false), new FunctionInfo("GetBarterGold", 264, false, false), new FunctionInfo("GetBaseActorValue", 277, true, false), new FunctionInfo("GetClassDefaultMatch", 229, false, false), new FunctionInfo("GetClothingValue", 41, false, false), new FunctionInfo("GetCrime", 122, true, true), new FunctionInfo("GetCrimeGold", 116, false, false), new FunctionInfo("GetCurrentAIPackage", 110, false, false), new FunctionInfo("GetCurrentAIProcedure", 143, false, false), new FunctionInfo("GetCurrentTime", 18, false, false), new FunctionInfo("GetCurrentWeatherPercent", 148, false, false), new FunctionInfo("GetDayOfWeek", 170, false, false), new FunctionInfo("GetDead", 46, false, false), new FunctionInfo("GetDeadCount", 84, true, false), new FunctionInfo("GetDestroyed", 203, false, false), new FunctionInfo("GetDetected", 45, true, false), new FunctionInfo("GetDetectionLevel", 180, true, false), new FunctionInfo("GetDisabled", 35, false, false), new FunctionInfo("GetDisease", 39, false, false), new FunctionInfo("GetDisposition", 76, true, false), new FunctionInfo("GetDistance", 1, true, false), new FunctionInfo("GetDoorDefaultOpen", 215, false, false), new FunctionInfo("GetEquipped", 182, true, false), new FunctionInfo("GetFactionRank", 73, true, false), new FunctionInfo("GetFactionRankDifference", 60, true, true), new FunctionInfo("GetFatiguePercentage", 128, false, false), new FunctionInfo("GetFriendHit", 288, true, false), new FunctionInfo("GetFurnitureMarkerID", 160, false, false), new FunctionInfo("GetGlobalValue", 74, true, false), new FunctionInfo("GetGold", 48, false, false), new FunctionInfo("GetHeadingAngle", 99, true, false), new FunctionInfo("GetIdleDoneOnce", 318, false, false), new FunctionInfo("GetIgnoreFriendlyHits", 338, false, false), new FunctionInfo("GetInCell", 67, true, false), new FunctionInfo("GetInCellParam", 230, true, true), new FunctionInfo("GetInFaction", 71, true, false), new FunctionInfo("GetInSameCell", 32, true, false), new FunctionInfo("GetInWorldspace", 310, true, false), new FunctionInfo("GetInvestmentGold", 305, false, false), new FunctionInfo("GetIsAlerted", 91, false, false), new FunctionInfo("GetIsClass", 68, true, false), new FunctionInfo("GetIsClassDefault", 228, true, false), new FunctionInfo("GetIsCreature", 64, false, false), new FunctionInfo("GetIsCurrentPackage", 161, true, false), new FunctionInfo("GetIsCurrentWeather", 149, true, false), new FunctionInfo("GetIsGhost", 237, false, false), new FunctionInfo("GetIsID", 72, true, false), new FunctionInfo("GetIsPlayableRace", 254, false, false), new FunctionInfo("GetIsPlayerBirthsign", 224, true, false), new FunctionInfo("GetIsRace", 69, true, false), new FunctionInfo("GetIsReference", 136, true, false), new FunctionInfo("GetIsSex", 70, true, false), new FunctionInfo("GetIsUsedItem", 246, true, false), new FunctionInfo("GetIsUsedItemType", 247, true, false), new FunctionInfo("GetItemCount", 47, true, false), new FunctionInfo("GetKnockedState", 107, false, false), new FunctionInfo("GetLevel", 80, false, false), new FunctionInfo("GetLineOfSight", 27, true, false), new FunctionInfo("GetLockLevel", 65, false, false), new FunctionInfo("GetLocked", 5, false, false), new FunctionInfo("GetNoRumors", 320, false, false), new FunctionInfo("GetOffersServicesNow", 255, false, false), new FunctionInfo("GetOpenState", 157, false, false), new FunctionInfo("GetPCExpelled", 193, true, false), new FunctionInfo("GetPCFactionAttack", 199, true, false), new FunctionInfo("GetPCFactionMurder", 195, true, false), new FunctionInfo("GetPCFactionSteal", 197, true, false), new FunctionInfo("GetPCFactionSubmitAuthority", 201, true, false), new FunctionInfo("GetPCFame", 249, false, false), new FunctionInfo("GetPCInFaction", 132, true, false), new FunctionInfo("GetPCInfamy", 251, false, false), new FunctionInfo("GetPCIsClass", 129, true, false), new FunctionInfo("GetPCIsRace", 130, true, false), new FunctionInfo("GetPCIsSex", 131, true, false), new FunctionInfo("GetPCMiscStat", 312, true, false), new FunctionInfo("GetPersuasionNumber", 225, false, false), new FunctionInfo("GetPlayerControlsDisabled", 98, false, false), new FunctionInfo("GetPlayerHasLastRiddenHorse", 362, false, false), new FunctionInfo("GetPlayerInSEWorld", 365, false, false), new FunctionInfo("GetPos", 6, true, false), new FunctionInfo("GetQuestRunning", 56, true, false), new FunctionInfo("GetQuestVariable", 79, true, true), new FunctionInfo("GetRandomPercent", 77, false, false), new FunctionInfo("GetRestrained", 244, false, false), new FunctionInfo("GetScale", 24, false, false), new FunctionInfo("GetScriptVariable", 53, true, true), new FunctionInfo("GetSecondsPassed", 12, false, false), new FunctionInfo("GetShouldAttack", 66, true, false), new FunctionInfo("GetSitting", 159, false, false), new FunctionInfo("GetSleeping", 49, false, false), new FunctionInfo("GetStage", 58, true, false), new FunctionInfo("GetStageDone", 59, true, true), new FunctionInfo("GetStartingAngle", 11, true, false), new FunctionInfo("GetStartingPos", 10, true, false), new FunctionInfo("GetTalkedToPC", 50, false, false), new FunctionInfo("GetTalkedToPCParam", 172, true, false), new FunctionInfo("GetTimeDead", 361, false, false), new FunctionInfo("GetTotalPersuasionNumber", 315, false, false), new FunctionInfo("GetTrespassWarningLevel", 144, false, false), new FunctionInfo("GetUnconscious", 242, false, false), new FunctionInfo("GetUsedItemActivate", 259, false, false), new FunctionInfo("GetUsedItemLevel", 258, false, false), new FunctionInfo("GetVampire", 40, false, false), new FunctionInfo("GetWalkSpeed", 142, false, false), new FunctionInfo("GetWeaponAnimType", 108, false, false), new FunctionInfo("GetWeaponSkillType", 109, false, false), new FunctionInfo("GetWindSpeed", 147, false, false), new FunctionInfo("HasFlames", 154, false, false), new FunctionInfo("HasMagicEffect", 214, true, false), new FunctionInfo("HasVampireFed", 227, false, false), new FunctionInfo("IsActor", 353, false, false), new FunctionInfo("IsActorAVictim", 314, false, false), new FunctionInfo("IsActorEvil", 313, false, false), new FunctionInfo("IsActorUsingATorch", 306, false, false), new FunctionInfo("IsCellOwner", 280, true, true), new FunctionInfo("IsCloudy", 267, false, false), new FunctionInfo("IsContinuingPackagePCNear", 150, false, false), new FunctionInfo("IsCurrentFurnitureObj", 163, true, false), new FunctionInfo("IsCurrentFurnitureRef", 162, true, false), new FunctionInfo("IsEssential", 354, false, false), new FunctionInfo("IsFacingUp", 106, false, false), new FunctionInfo("IsGuard", 125, false, false), new FunctionInfo("IsHorseStolen", 282, false, false), new FunctionInfo("IsIdlePlaying", 112, false, false), new FunctionInfo("IsInCombat", 289, false, false), new FunctionInfo("IsInDangerousWater", 332, false, false), new FunctionInfo("IsInInterior", 300, false, false), new FunctionInfo("IsInMyOwnedCell", 146, false, false), new FunctionInfo("IsLeftUp", 285, false, false), new FunctionInfo("IsOwner", 278, true, false), new FunctionInfo("IsPCAMurderer", 176, false, false), new FunctionInfo("IsPCSleeping", 175, false, false), new FunctionInfo("IsPlayerInJail", 171, false, false), new FunctionInfo("IsPlayerMovingIntoNewSpace", 358, false, false), new FunctionInfo("IsPlayersLastRiddenHorse", 339, false, false), new FunctionInfo("IsPleasant", 266, false, false), new FunctionInfo("IsRaining", 62, false, false), new FunctionInfo("IsRidingHorse", 327, false, false), new FunctionInfo("IsRunning", 287, false, false), new FunctionInfo("IsShieldOut", 103, false, false), new FunctionInfo("IsSneaking", 286, false, false), new FunctionInfo("IsSnowing", 75, false, false), new FunctionInfo("IsSpellTarget", 223, true, false), new FunctionInfo("IsSwimming", 185, false, false), new FunctionInfo("IsTalking", 141, false, false), new FunctionInfo("IsTimePassing", 265, false, false), new FunctionInfo("IsTorchOut", 102, false, false), new FunctionInfo("IsTrespassing", 145, false, false), new FunctionInfo("IsTurnArrest", 329, false, false), new FunctionInfo("IsWaiting", 111, false, false), new FunctionInfo("IsWeaponOut", 101, false, false), new FunctionInfo("IsXBox", 309, false, false), new FunctionInfo("IsYielding", 104, false, false), new FunctionInfo("MenuMode", 36, true, false), new FunctionInfo("SameFaction", 42, true, false), new FunctionInfo("SameFactionAsPC", 133, false, false), new FunctionInfo("SameRace", 43, true, false), new FunctionInfo("SameRaceAsPC", 134, false, false), new FunctionInfo("SameSex", 44, true, false), new FunctionInfo("SameSexAsPC", 135, false, false), new FunctionInfo("WhichServiceMenu", 323, false, false)};
    }

    public PluginSubrecord(String recordType, String subrecordType, byte[] subrecordData) {
        Object info;
        int n;
        int n2;
        Object[] objectArray;
        this.recordType = recordType;
        this.subrecordType = subrecordType;
        this.subrecordData = subrecordData;
        if (typeMap == null) {
            typeMap = new HashMap<String, SubrecordInfo>(subrecordInfo.length);
            objectArray = subrecordInfo;
            n2 = subrecordInfo.length;
            n = 0;
            while (n < n2) {
                info = objectArray[n];
                typeMap.put(((SubrecordInfo)info).getSubrecordType(), (SubrecordInfo)info);
                ++n;
            }
        }
        if (functionMap == null) {
            functionMap = new HashMap<Integer, FunctionInfo>(functionInfo.length);
            objectArray = functionInfo;
            n2 = functionInfo.length;
            n = 0;
            while (n < n2) {
                info = objectArray[n];
                functionMap.put(new Integer(((FunctionInfo)info).getCode()), (FunctionInfo)info);
                ++n;
            }
        }
    }

    public void setSpillMode(boolean mode) throws IOException {
        if (mode != this.spillMode) {
            if (this.spillMode) {
                this.subrecordData = Main.pluginSpill.read(this.subrecordPosition, this.subrecordLength);
                this.subrecordPosition = -1L;
                this.subrecordLength = 0;
            } else if (this.subrecordData != null) {
                this.subrecordPosition = Main.pluginSpill.write(this.subrecordData);
                this.subrecordLength = this.subrecordData.length;
                this.subrecordData = null;
            } else {
                this.subrecordPosition = -1L;
                this.subrecordLength = 0;
            }
            this.spillMode = mode;
        }
    }

    public String getSubrecordType() {
        return this.subrecordType;
    }

    public byte[] getSubrecordData() throws IOException {
        if (this.spillMode) {
            return Main.pluginSpill.read(this.subrecordPosition, this.subrecordLength);
        }
        return this.subrecordData;
    }

    public void setSubrecordData(byte[] subrecordData) throws IOException {
        if (this.spillMode) {
            this.subrecordPosition = Main.pluginSpill.write(subrecordData);
            this.subrecordLength = subrecordData.length;
        } else {
            this.subrecordData = subrecordData;
        }
    }

    public int[][] getReferences() throws IOException {
        int[][] references = null;
        if (this.subrecordType.equals("CTDA")) {
            byte[] subrecordData = this.getSubrecordData();
            int functionCode = PluginSubrecord.getInteger(subrecordData, 8);
            FunctionInfo functionInfo = functionMap.get(new Integer(functionCode));
            if (functionInfo != null) {
                references = new int[2][2];
                int index = 0;
                if (functionInfo.isFirstReference() && subrecordData.length >= 16) {
                    references[index][0] = 12;
                    references[index][1] = PluginSubrecord.getInteger(subrecordData, 12);
                    ++index;
                }
                if (functionInfo.isSecondReference() && subrecordData.length >= 20) {
                    references[index][0] = 16;
                    references[index][1] = PluginSubrecord.getInteger(subrecordData, 16);
                }
            }
        } else if (this.subrecordType.equals("DATA") && this.recordType.equals("MGEF")) {
            byte[] subrecordData = this.getSubrecordData();
            int[] mgefOffsets = new int[]{24, 32, 36, 40, 44, 48, 52};
            references = new int[mgefOffsets.length][2];
            int index = 0;
            while (index < mgefOffsets.length) {
                int refOffset = mgefOffsets[index];
                if (refOffset + 4 <= subrecordData.length) {
                    references[index][0] = refOffset;
                    references[index][1] = PluginSubrecord.getInteger(subrecordData, refOffset);
                    ++index;
                    continue;
                }
                break;
            }
        } else if (this.subrecordType.equals("PLDT") && this.recordType.equals("PACK")) {
            byte[] subrecordData = this.getSubrecordData();
            int type = PluginSubrecord.getInteger(subrecordData, 0);
            if (type == 0 || type == 1 || type == 4) {
                references = new int[1][2];
                references[0][0] = 4;
                references[0][1] = PluginSubrecord.getInteger(subrecordData, 4);
            }
        } else if (this.subrecordType.equals("PTDT") && this.recordType.equals("PACK")) {
            byte[] subrecordData = this.getSubrecordData();
            int type = PluginSubrecord.getInteger(subrecordData, 0);
            if (type == 0 || type == 1) {
                references = new int[1][2];
                references[0][0] = 4;
                references[0][1] = PluginSubrecord.getInteger(subrecordData, 4);
            }
        } else {
            boolean returnReferences = false;
            SubrecordInfo subrecordInfo = typeMap.get(this.subrecordType);
            if (subrecordInfo != null) {
                String[] recordTypes = subrecordInfo.getRecordTypes();
                if (recordTypes.length == 0) {
                    returnReferences = true;
                } else {
                    int i = 0;
                    while (i < recordTypes.length) {
                        if (this.recordType.equals(recordTypes[i])) {
                            returnReferences = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (returnReferences) {
                boolean repeating;
                byte[] subrecordData = this.getSubrecordData();
                int[] refOffsets = subrecordInfo.getReferenceOffsets();
                int refOffset = 0;
                int refSize = 4;
                int i = -1;
                int index = 0;
                if (refOffsets[0] < 0) {
                    repeating = true;
                    refSize = -refOffsets[0];
                    refOffset = -refSize;
                    references = new int[subrecordData.length / refSize][2];
                } else {
                    repeating = false;
                    references = new int[refOffsets.length][2];
                }
                while (true) {
                    if (repeating) {
                        refOffset += refSize;
                    } else {
                        if (++i == refOffsets.length) break;
                        refOffset = refOffsets[i];
                    }
                    if (refOffset + refSize > subrecordData.length) break;
                    references[index][0] = refOffset;
                    references[index][1] = PluginSubrecord.getInteger(subrecordData, refOffset);
                    ++index;
                }
            }
        }
        return references;
    }

    public static FunctionInfo getFunctionInfo(int funcCode) {
        if (functionMap == null) {
            functionMap = new HashMap<Integer, FunctionInfo>(functionInfo.length);
            FunctionInfo[] functionInfoArray = functionInfo;
            int n = functionInfo.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionInfo info = functionInfoArray[n2];
                functionMap.put(new Integer(info.getCode()), info);
                ++n2;
            }
        }
        return functionMap.get(new Integer(funcCode));
    }

    public String getDisplayDataTypeLabel() {
        int dataType = SubrecordDataType.getDataType(this.subrecordType);
        if (dataType == 1000 && (dataType = SubrecordDataType.getDataType(String.valueOf(this.subrecordType) + "-" + this.recordType)) == -1) {
            dataType = SubrecordDataType.getDataType(String.valueOf(this.subrecordType) + "-" + "OTHER");
        }
        String retStr = SubrecordDataType.getDataTypeLabel(dataType);
        if (dataType == 999) {
            retStr = String.valueOf(this.subrecordType) + " " + retStr;
        }
        return retStr;
    }

    public String getDisplayData() {
        byte[] subrecordData = null;
        int dataType = SubrecordDataType.getDataType(this.subrecordType);
        if (dataType == 1000 && (dataType = SubrecordDataType.getDataType(String.valueOf(this.subrecordType) + "-" + this.recordType)) == -1) {
            dataType = SubrecordDataType.getDataType(String.valueOf(this.subrecordType) + "-" + "OTHER");
        }
        String retStr = "";
        try {
            subrecordData = this.getSubrecordData();
        }
        catch (IOException exc) {
            Main.logException("Exception while getting subrecord data", exc);
            subrecordData = new byte[]{};
            dataType = 0;
        }
        switch (dataType) {
            case 2: {
                retStr = this.getDisplayDataFormID(subrecordData);
                break;
            }
            case 4: {
                retStr = this.getDisplayDataFloat(subrecordData);
                break;
            }
            case 3: {
                retStr = this.getDisplayDataInteger(subrecordData);
                break;
            }
            case 5: {
                retStr = this.getDisplayDataShort(subrecordData);
                break;
            }
            case 6: {
                retStr = this.getDisplayDataByte(subrecordData);
                break;
            }
            case 1: {
                retStr = this.getDisplayDataString(subrecordData);
                break;
            }
            case 7: {
                retStr = this.getDisplayDataStringNoNull(subrecordData);
                break;
            }
            case 19: {
                retStr = this.getDisplayDataStringArray(subrecordData);
                break;
            }
            case 8: {
                retStr = this.getDisplayDataXYCoordinates(subrecordData);
                break;
            }
            case 9: {
                retStr = this.getDisplayDataContainerItem(subrecordData);
                break;
            }
            case 10: {
                retStr = this.getDisplayDataCondition(subrecordData);
                break;
            }
            case 11: {
                retStr = this.getDisplayDataEmotion(subrecordData);
                break;
            }
            case 16: {
                retStr = this.getDisplayDataLeveledItem(subrecordData);
                break;
            }
            case 12: {
                retStr = this.getDisplayDataPositionRotation(subrecordData);
                break;
            }
            case 13: {
                retStr = this.getDisplayDataSpellEffectName(subrecordData);
                break;
            }
            case 14: {
                retStr = this.getDisplayDataSpellEffectData(subrecordData);
                break;
            }
            case 15: {
                retStr = this.getDisplayDataFormIDArray(subrecordData);
                break;
            }
            case 17: {
                retStr = this.getDisplayDataCellLightingInfo(subrecordData);
                break;
            }
            case 18: {
                retStr = this.getDisplayDataFlags(subrecordData);
                break;
            }
            case 20: {
                retStr = this.getDisplayDataActorConfig(subrecordData);
                break;
            }
            case 21: {
                retStr = this.getDisplayDataFactionInfo(subrecordData);
                break;
            }
            case 22: {
                retStr = this.getDisplayDataAIInfo(subrecordData);
                break;
            }
            case 23: {
                retStr = this.getDisplayDataPGNodeArray(subrecordData);
                break;
            }
            case 24: {
                retStr = this.getDisplayDataPGConnsInt(subrecordData);
                break;
            }
            case 25: {
                retStr = this.getDisplayDataPGConnsExt(subrecordData);
                break;
            }
            case 26: {
                retStr = this.getDisplayDataLSTexture(subrecordData);
                break;
            }
            case 100: {
                retStr = this.getDisplayDataDATAforINFO(subrecordData);
                break;
            }
            case 101: {
                retStr = this.getDisplayDataDATAforCREA(subrecordData);
                break;
            }
            default: {
                retStr = this.getDisplayDataByteArray(subrecordData);
            }
        }
        return retStr;
    }

    public String getDisplayDataAsBytes() {
        byte[] subrecordData = null;
        String retStr = "";
        try {
            subrecordData = this.getSubrecordData();
        }
        catch (IOException exc) {
            Main.logException("Exception while getting subrecord data", exc);
            subrecordData = new byte[]{};
        }
        retStr = this.getDisplayDataByteArray(subrecordData);
        return retStr;
    }

    private String getDisplayDataFormID(byte[] subrecordData) {
        int formID = SerializedElement.getInteger(subrecordData, 0);
        return String.format("%08X", formID);
    }

    private String getDisplayDataFloat(byte[] subrecordData) {
        int floatBits = SerializedElement.getInteger(subrecordData, 0);
        return String.format("%.3f", Float.valueOf(Float.intBitsToFloat(floatBits)));
    }

    private String getDisplayDataInteger(byte[] subrecordData) {
        int intBits = SerializedElement.getInteger(subrecordData, 0);
        return String.format("%d", intBits);
    }

    private String getDisplayDataShort(byte[] subrecordData) {
        int intBits = SerializedElement.getShort(subrecordData, 0);
        return String.format("%d", intBits);
    }

    private String getDisplayDataByte(byte[] subrecordData) {
        byte firstByte = subrecordData[0];
        return String.format("%d", firstByte);
    }

    private String getDisplayDataString(byte[] subrecordData) {
        return new String(subrecordData, 0, subrecordData.length - 1);
    }

    private String getDisplayDataStringNoNull(byte[] subrecordData) {
        return new String(subrecordData, 0, subrecordData.length);
    }

    private String getDisplayDataStringArray(byte[] subrecordData) {
        String firstStr = new String(subrecordData, 0, subrecordData.length - 2);
        String retstr = firstStr.replace('\u0000', '\n');
        return retstr;
    }

    private String getDisplayDataByteArray(byte[] subrecordData) {
        StringBuilder dumpData = new StringBuilder(128 + 3 * subrecordData.length + 6 * (subrecordData.length / 16));
        dumpData.append(String.format("%s subrecord: Data length x'%X'\n", this.getSubrecordType(), subrecordData.length));
        dumpData.append("\n       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F\n");
        StringBuilder dumpHex = new StringBuilder(48);
        StringBuilder dumpLine = new StringBuilder(16);
        int i = 0;
        while (i < subrecordData.length) {
            int j = 0;
            while (j < 16) {
                int offset = i + j;
                if (offset == subrecordData.length) break;
                dumpHex.append(String.format(" %02X", subrecordData[offset]));
                if (subrecordData[offset] >= 32 && subrecordData[offset] < 127) {
                    dumpLine.append(new String(subrecordData, offset, 1));
                } else {
                    dumpLine.append(".");
                }
                ++j;
            }
            while (dumpHex.length() < 48) {
                dumpHex.append("   ");
            }
            while (dumpLine.length() < 16) {
                dumpLine.append(" ");
            }
            dumpData.append(String.format("%04X:", i));
            dumpData.append((CharSequence)dumpHex);
            dumpData.append("  *");
            dumpData.append((CharSequence)dumpLine);
            dumpData.append("*");
            if (i + 16 < subrecordData.length) {
                dumpData.append("\n");
            }
            dumpHex.delete(0, 48);
            dumpLine.delete(0, 16);
            i += 16;
        }
        return dumpData.toString();
    }

    private String getDisplayDataXYCoordinates(byte[] subrecordData) {
        int x = SerializedElement.getInteger(subrecordData, 0);
        int y = SerializedElement.getInteger(subrecordData, 4);
        String retStr = String.valueOf(x) + ", " + y;
        return retStr;
    }

    private String getDisplayDataContainerItem(byte[] subrecordData) {
        int itemFormID = SerializedElement.getInteger(subrecordData, 0);
        int itemCount = SerializedElement.getInteger(subrecordData, 4);
        return String.format("Item form ID: %08X\nItem count: %d", itemFormID, itemCount);
    }

    private String getDisplayDataLeveledItem(byte[] subrecordData) {
        int formIDPos = subrecordData.length == 12 ? 4 : 2;
        int countPos = subrecordData.length == 12 ? 8 : 6;
        int itemLevel = SerializedElement.getShort(subrecordData, 0);
        int itemFormID = SerializedElement.getInteger(subrecordData, formIDPos);
        int itemCount = SerializedElement.getShort(subrecordData, countPos);
        return String.format("Item level: %d\nItem form ID: %08X\nItem count: %d", itemLevel, itemFormID, itemCount);
    }

    private String getDisplayDataCondition(byte[] subrecordData) {
        int subFuncCode = SerializedElement.getInteger(subrecordData, 8);
        FunctionInfo funcInfo = PluginSubrecord.getFunctionInfo(subFuncCode);
        boolean usesFirst = false;
        boolean usesSecond = false;
        if (funcInfo != null) {
            usesFirst = funcInfo.isFirstReference();
            usesSecond = funcInfo.isSecondReference();
        }
        int subCompFlags = subrecordData[0] & 0xF;
        int subCompCode = (subrecordData[0] & 0xF0) >>> 4;
        int subCompValueInt = SerializedElement.getInteger(subrecordData, 4);
        float subCompValue = Float.intBitsToFloat(subCompValueInt);
        int param1 = 0;
        int param2 = 0;
        if (usesFirst) {
            param1 = SerializedElement.getInteger(subrecordData, 12);
        }
        if (usesSecond) {
            param1 = SerializedElement.getInteger(subrecordData, 16);
        }
        String paramList = "()";
        if (usesFirst) {
            paramList = String.format("(%08X)", param1);
        }
        if (usesSecond) {
            paramList = String.format("(%08X, %08X)", param1, param2);
        }
        String retStr = String.valueOf(FunctionCode.getFuncCodeName(subFuncCode)) + paramList + " " + ComparisonCode.getCompCodeSymbol(subCompCode) + " " + subCompValue;
        if ((subCompFlags & 1) != 0) {
            retStr = String.valueOf(retStr) + "\n - Is ORed to next condition";
        }
        if ((subCompFlags & 2) != 0) {
            retStr = String.valueOf(retStr) + "\n - Executes on target";
        }
        if ((subCompFlags & 4) != 0) {
            retStr = String.valueOf(retStr) + "\n - Uses global variables";
        }
        return retStr;
    }

    private String getDisplayDataEmotion(byte[] subrecordData) {
        int emotionCode = SerializedElement.getInteger(subrecordData, 0);
        int emotionValue = SerializedElement.getInteger(subrecordData, 4);
        byte responseNum = subrecordData[12];
        String retStr = "Type: " + EmotionCode.getString(emotionCode) + "\nValue: " + emotionValue + "\nResponse number: " + responseNum;
        return retStr;
    }

    private String getDisplayDataPositionRotation(byte[] subrecordData) {
        int XPosBits = SerializedElement.getInteger(subrecordData, 0);
        int YPosBits = SerializedElement.getInteger(subrecordData, 4);
        int ZPosBits = SerializedElement.getInteger(subrecordData, 8);
        int XRotBits = SerializedElement.getInteger(subrecordData, 12);
        int YRotBits = SerializedElement.getInteger(subrecordData, 16);
        int ZRotBits = SerializedElement.getInteger(subrecordData, 20);
        float XPos = Float.intBitsToFloat(XPosBits);
        float YPos = Float.intBitsToFloat(YPosBits);
        float ZPos = Float.intBitsToFloat(ZPosBits);
        float XRot = Float.intBitsToFloat(XRotBits) * 180.0f / (float)Math.PI;
        float YRot = Float.intBitsToFloat(YRotBits) * 180.0f / (float)Math.PI;
        float ZRot = Float.intBitsToFloat(ZRotBits) * 180.0f / (float)Math.PI;
        String retStr = "Position: (" + XPos + ", " + YPos + ", " + ZPos + ")\n" + "Rotation: (" + XRot + "\u00b0, " + YRot + "\u00b0, " + ZRot + "\u00b0)";
        return retStr;
    }

    private String getDisplayDataCellLightingInfo(byte[] subrecordData) {
        byte ambRed = subrecordData[0];
        byte ambGreen = subrecordData[1];
        byte ambBlue = subrecordData[2];
        byte dirRed = subrecordData[4];
        byte dirGreen = subrecordData[5];
        byte dirBlue = subrecordData[6];
        byte fogRed = subrecordData[8];
        byte fogGreen = subrecordData[9];
        byte fogBlue = subrecordData[10];
        int fogNearBits = SerializedElement.getInteger(subrecordData, 12);
        int fogFarBits = SerializedElement.getInteger(subrecordData, 16);
        float fogNear = Float.intBitsToFloat(fogNearBits);
        float fogFar = Float.intBitsToFloat(fogFarBits);
        int XYRot = SerializedElement.getInteger(subrecordData, 20);
        int ZRot = SerializedElement.getInteger(subrecordData, 24);
        int dirFadeBits = SerializedElement.getInteger(subrecordData, 28);
        int fogClipBits = SerializedElement.getInteger(subrecordData, 32);
        float dirFade = Float.intBitsToFloat(dirFadeBits);
        float fogClip = Float.intBitsToFloat(fogClipBits);
        String retStr = "Ambient RGB: (" + ambRed + ", " + ambGreen + ", " + ambBlue + ")\n" + "Directional RGB: (" + dirRed + ", " + dirGreen + ", " + dirBlue + ")\n" + "Fog RGB: (" + fogRed + ", " + fogGreen + ", " + fogBlue + ")\n" + "Fog Near: " + fogNear + ", Fog Far: " + fogFar + "\n" + "XY Rotation: " + XYRot + "\u00b0, Z Rotation: " + ZRot + "\u00b0\n" + "Directional Fade: " + dirFade + ", Fog Clip: " + fogClip + "\n";
        return retStr;
    }

    private String getDisplayDataSpellEffectName(byte[] subrecordData) {
        return SpellEffectType.getSpellEffectName(new String(subrecordData, 0, subrecordData.length));
    }

    private String getDisplayDataSpellEffectData(byte[] subrecordData) {
        String effectName = SpellEffectType.getSpellEffectName(new String(subrecordData, 0, 4));
        int effectMagnitude = SerializedElement.getInteger(subrecordData, 4);
        int effectArea = SerializedElement.getInteger(subrecordData, 8);
        int effectDuration = SerializedElement.getInteger(subrecordData, 12);
        int effectType = SerializedElement.getInteger(subrecordData, 16);
        int effectActorValue = SerializedElement.getInteger(subrecordData, 4);
        return "Name: " + effectName + "\nMagnitude: " + effectMagnitude + "\nArea: " + effectArea + "\nDuration: " + effectDuration + "\nType: " + effectType + "\nActor Value: " + effectActorValue;
    }

    private String getDisplayDataDATAforINFO(byte[] subrecordData) {
        byte dialogueType = subrecordData[0];
        byte dialogueFlags = subrecordData[2];
        String retStr = "Type: " + DialogueTypeCode.getString(dialogueType);
        if ((dialogueFlags & 1) != 0) {
            retStr = String.valueOf(retStr) + "\n - Goodbye";
        }
        if ((dialogueFlags & 2) != 0) {
            retStr = String.valueOf(retStr) + "\n - Random";
        }
        if ((dialogueFlags & 4) != 0) {
            retStr = String.valueOf(retStr) + "\n - Say Once";
        }
        if ((dialogueFlags & 0x10) != 0) {
            retStr = String.valueOf(retStr) + "\n - Info Refusal";
        }
        if ((dialogueFlags & 0x20) != 0) {
            retStr = String.valueOf(retStr) + "\n - Random End";
        }
        if ((dialogueFlags & 0x40) != 0) {
            retStr = String.valueOf(retStr) + "\n - Run for Rumors";
        }
        return retStr;
    }

    private String getDisplayDataDATAforCREA(byte[] subrecordData) {
        String[] soulgemTypes = new String[]{"None", "Petty", "Lesser", "Common", "Greater", "Grand"};
        byte combatSkill = subrecordData[1];
        byte magicSkill = subrecordData[2];
        byte stealthSkill = subrecordData[3];
        byte soulgemIdx = subrecordData[4];
        byte strength = subrecordData[12];
        byte intelligence = subrecordData[13];
        byte willpower = subrecordData[14];
        byte agility = subrecordData[15];
        byte speed = subrecordData[16];
        byte endurance = subrecordData[17];
        byte personality = subrecordData[18];
        byte luck = subrecordData[19];
        int healthPoints = SerializedElement.getShort(subrecordData, 6);
        int attackDamage = SerializedElement.getShort(subrecordData, 10);
        return "Combat Skill: " + combatSkill + "\nMagic Skill: " + magicSkill + "\nStealth Skill: " + stealthSkill + "\nSoulgem Type: " + this.getIndexedString(soulgemIdx, soulgemTypes) + "\nHealth Points: " + healthPoints + "\nAttack Damage: " + attackDamage + "\nStrength: " + strength + "\nIntelligence: " + intelligence + "\nWillpower: " + willpower + "\nAgility: " + agility + "\nSpeed: " + speed + "\nEndurance: " + endurance + "\nPersonality: " + personality + "\nLuck: " + luck;
    }

    private String getDisplayDataFormIDArray(byte[] subrecordData) {
        String retStr = "";
        int numFormIDs = subrecordData.length / 4;
        int i = 0;
        while (i < numFormIDs) {
            int formID = SerializedElement.getInteger(subrecordData, i * 4);
            retStr = i == 0 ? String.valueOf(retStr) + String.format("%08X", formID) : (i % 5 == 0 ? String.valueOf(retStr) + ",\n" + String.format("%08X", formID) : String.valueOf(retStr) + ", " + String.format("%08X", formID));
            ++i;
        }
        return retStr;
    }

    private String getDisplayDataFlags(byte[] subrecordData) {
        String retStr = "";
        int i = subrecordData.length - 1;
        while (i >= 0) {
            byte flagByte = subrecordData[i];
            retStr = String.valueOf(retStr) + ((flagByte & 0x80) == 0 ? "0" : "1");
            retStr = String.valueOf(retStr) + ((flagByte & 0x40) == 0 ? "0" : "1");
            retStr = String.valueOf(retStr) + ((flagByte & 0x20) == 0 ? "0" : "1");
            retStr = String.valueOf(retStr) + ((flagByte & 0x10) == 0 ? "0" : "1");
            retStr = String.valueOf(retStr) + ((flagByte & 8) == 0 ? "0" : "1");
            retStr = String.valueOf(retStr) + ((flagByte & 4) == 0 ? "0" : "1");
            retStr = String.valueOf(retStr) + ((flagByte & 2) == 0 ? "0" : "1");
            retStr = String.valueOf(retStr) + ((flagByte & 1) == 0 ? "0" : "1");
            --i;
        }
        return retStr;
    }

    private String getDisplayDataActorConfig(byte[] subrecordData) {
        byte[] flagPart = new byte[3];
        System.arraycopy(subrecordData, 0, flagPart, 0, 3);
        String flagBits = this.getDisplayDataFlags(flagPart);
        int baseSpell = SerializedElement.getShort(subrecordData, 4);
        int fatigue = SerializedElement.getShort(subrecordData, 6);
        int barterGold = SerializedElement.getShort(subrecordData, 8);
        int level = SerializedElement.getShort(subrecordData, 10);
        int calcMin = SerializedElement.getShort(subrecordData, 12);
        int calcMax = SerializedElement.getShort(subrecordData, 14);
        String retStr = "Flags: " + flagBits + "\nBase Spell Points: " + baseSpell + "\nFatigue: " + fatigue + "\nBarter Gold: " + barterGold + "\nLevel/Offset Level: " + level + "\nCalc Min: " + calcMin + "\nCalc Max: " + calcMax;
        return retStr;
    }

    private String getDisplayDataAIInfo(byte[] subrecordData) {
        byte[] flagPart = new byte[3];
        String[] skillNames = new String[]{"Armorer", "Athletics", "Blade", "Block", "Blunt", "Hand to Hand", "Heavy Armor", "Alchemy", "Alteration", "Conjuration", "Destruction", "Illusion", "Mysticism", "Restoration", "Acrobatics", "Light Armor", "Marskman", "Mercantile", "Security", "Sneak", "Speechcraft"};
        System.arraycopy(subrecordData, 4, flagPart, 0, 3);
        String flagBits = this.getDisplayDataFlags(flagPart);
        int allFlags = SerializedElement.getInteger(subrecordData, 4);
        byte aggression = subrecordData[0];
        byte confidence = subrecordData[1];
        byte energyLevel = subrecordData[2];
        byte responsibility = subrecordData[3];
        byte trainingSkill = subrecordData[8];
        byte trainingLevel = subrecordData[9];
        String retStr = "Aggression: " + aggression + "\nConfidence: " + confidence + "\nEnergy Level: " + energyLevel + "\nResponsibility: " + responsibility + "\nFlags: " + flagBits;
        if ((allFlags & 0x4000) != 0) {
            retStr = String.valueOf(retStr) + "\nTraining Skill: " + this.getIndexedString(trainingSkill, skillNames) + "\nTraining Level: " + trainingLevel;
        }
        return retStr;
    }

    private String getDisplayDataFactionInfo(byte[] subrecordData) {
        int factionID = SerializedElement.getInteger(subrecordData, 0);
        byte factionRank = subrecordData[4];
        return String.format("Faction form ID: %08X\nFaction rank: %d", factionID, (int)factionRank);
    }

    private String getDisplayDataPGNodeArray(byte[] subrecordData) {
        String retStr = "";
        int numPGNodes = subrecordData.length / 16;
        int i = 0;
        while (i < numPGNodes) {
            int XPosBits = SerializedElement.getInteger(subrecordData, i * 16);
            int YPosBits = SerializedElement.getInteger(subrecordData, i * 16 + 4);
            int ZPosBits = SerializedElement.getInteger(subrecordData, i * 16 + 8);
            float XPos = Float.intBitsToFloat(XPosBits);
            float YPos = Float.intBitsToFloat(YPosBits);
            float ZPos = Float.intBitsToFloat(ZPosBits);
            String nodeIdx = String.format("%02d", i);
            String flags = String.format("%d", subrecordData[i * 16 + 12]);
            retStr = String.valueOf(retStr) + "Node " + nodeIdx + " XYZ: (" + XPos + ", " + YPos + ", " + ZPos + "), Connections:  " + flags + "\n";
            ++i;
        }
        return retStr;
    }

    private String getDisplayDataPGConnsInt(byte[] subrecordData) {
        String retStr = "";
        int numPGConns = subrecordData.length / 4;
        int i = 0;
        while (i < numPGConns) {
            int node1 = SerializedElement.getShort(subrecordData, i * 4);
            int node2 = SerializedElement.getShort(subrecordData, i * 4 + 2);
            String node1Idx = String.format("%02d", node1);
            String node2Idx = String.format("%02d", node2);
            String connIdx = String.format("%02d", i);
            retStr = String.valueOf(retStr) + "PG Connection " + connIdx + ": [" + node1Idx + " to " + node2Idx + "]\n";
            ++i;
        }
        return retStr;
    }

    private String getDisplayDataPGConnsExt(byte[] subrecordData) {
        String retStr = "";
        int numPGConnsExt = subrecordData.length / 16;
        int i = 0;
        while (i < numPGConnsExt) {
            byte intNode = subrecordData[i * 16];
            int XPosBits = SerializedElement.getInteger(subrecordData, i * 16 + 4);
            int YPosBits = SerializedElement.getInteger(subrecordData, i * 16 + 8);
            int ZPosBits = SerializedElement.getInteger(subrecordData, i * 16 + 12);
            float XPos = Float.intBitsToFloat(XPosBits);
            float YPos = Float.intBitsToFloat(YPosBits);
            float ZPos = Float.intBitsToFloat(ZPosBits);
            String connIdx = String.format("%02d", i);
            String nodeIdx = String.format("%02d", intNode);
            String flags = String.format("%d", subrecordData[i * 16 + 12]);
            retStr = String.valueOf(retStr) + "PG External Connection " + connIdx + ": Node " + nodeIdx + " to (" + XPos + ", " + YPos + ", " + ZPos + ")\n";
            ++i;
        }
        return retStr;
    }

    private String getDisplayDataLSTexture(byte[] subrecordData) {
        String retStr = "";
        int LSTexID = SerializedElement.getInteger(subrecordData, 0);
        String quad = subrecordData[4] > 1 ? "Top " : "Bottom ";
        quad = String.valueOf(quad) + (subrecordData[4] % 2 == 0 ? "Left" : "Right");
        int layer = SerializedElement.getShort(subrecordData, 6);
        String layerString = layer == 65535 ? "Base" : String.format("%d", layer);
        retStr = String.valueOf(retStr) + "Landscape texture: " + String.format("%08X", LSTexID) + "\nQuadrant: " + quad + "\nLayer: " + layerString;
        return retStr;
    }

    private String getIndexedString(int idx, String[] strArray) {
        if (idx < 0) {
            return "Below lower bound";
        }
        if (idx >= strArray.length) {
            return "Above upper bound";
        }
        return strArray[idx];
    }

    public boolean equals(Object object) {
        boolean areEqual;
        block29: {
            PluginSubrecord objSubrecord;
            areEqual = false;
            if (object instanceof PluginSubrecord && (objSubrecord = (PluginSubrecord)object).getSubrecordType().equals(this.subrecordType)) {
                try {
                    byte[] subrecordData = this.getSubrecordData();
                    byte[] objSubrecordData = objSubrecord.getSubrecordData();
                    if (objSubrecordData.length != subrecordData.length) break block29;
                    if ((this.subrecordType.equals("ATXT") || this.subrecordType.equals("BTXT")) && subrecordData.length == 8) {
                        if (subrecordData[0] == objSubrecordData[0] && subrecordData[1] == objSubrecordData[1] && subrecordData[2] == objSubrecordData[2] && subrecordData[3] == objSubrecordData[3] && subrecordData[4] == objSubrecordData[4] && subrecordData[6] == objSubrecordData[6] && subrecordData[7] == objSubrecordData[7]) {
                            areEqual = true;
                        }
                        break block29;
                    }
                    if (this.subrecordType.equals("EFIT") && subrecordData.length == 24) {
                        String effectName = new String(subrecordData, 0, 4);
                        int count = 20;
                        if (effectName.equals("DGAT") || effectName.equals("DRAT") || effectName.equals("DRSK") || effectName.equals("FOAT") || effectName.equals("FOSK") || effectName.equals("REAT") || effectName.equals("ABAT") || effectName.equals("ABSK")) {
                            count = 24;
                        }
                        areEqual = true;
                        int i = 0;
                        while (i < count) {
                            if (subrecordData[i] != objSubrecordData[i]) {
                                areEqual = false;
                                break block29;
                            }
                            ++i;
                        }
                        break block29;
                    }
                    if (this.subrecordType.equals("LVLO") && subrecordData.length == 12) {
                        if (subrecordData[0] == objSubrecordData[0] && subrecordData[1] == objSubrecordData[1] && subrecordData[4] == objSubrecordData[4] && subrecordData[5] == objSubrecordData[5] && subrecordData[6] == objSubrecordData[6] && subrecordData[7] == objSubrecordData[7] && subrecordData[8] == objSubrecordData[8] && subrecordData[9] == objSubrecordData[9]) {
                            areEqual = true;
                        }
                        break block29;
                    }
                    if (this.subrecordType.equals("PGRP") && subrecordData.length % 16 == 0) {
                        areEqual = true;
                        int i = 0;
                        while (i < subrecordData.length) {
                            int j = 0;
                            while (j < 13) {
                                if (subrecordData[i + j] != objSubrecordData[i + j]) {
                                    areEqual = false;
                                    break;
                                }
                                ++j;
                            }
                            if (areEqual) {
                                i += 16;
                                continue;
                            }
                            break block29;
                        }
                        break block29;
                    }
                    if (this.subrecordType.equals("PKDT") && subrecordData.length == 8) {
                        if (subrecordData[0] == objSubrecordData[0] && subrecordData[1] == objSubrecordData[1] && subrecordData[2] == objSubrecordData[2] && subrecordData[3] == objSubrecordData[3] && subrecordData[4] == objSubrecordData[4]) {
                            areEqual = true;
                        }
                        break block29;
                    }
                    if (this.subrecordType.equals("QSTA") && subrecordData.length == 8) {
                        if (subrecordData[0] == objSubrecordData[0] && subrecordData[1] == objSubrecordData[1] && subrecordData[2] == objSubrecordData[2] && subrecordData[3] == objSubrecordData[3] && subrecordData[4] == objSubrecordData[4] && subrecordData[5] == objSubrecordData[5]) {
                            areEqual = true;
                        }
                        break block29;
                    }
                    if (this.subrecordType.equals("XCLR") && subrecordData.length % 4 == 0) {
                        int i = 0;
                        while (i < subrecordData.length) {
                            areEqual = false;
                            int formID = PluginSubrecord.getInteger(subrecordData, i);
                            int j = 0;
                            while (j < subrecordData.length) {
                                int objFormID = PluginSubrecord.getInteger(objSubrecordData, j);
                                if (objFormID == formID) {
                                    areEqual = true;
                                    break;
                                }
                                j += 4;
                            }
                            if (areEqual) {
                                i += 4;
                                continue;
                            }
                            break block29;
                        }
                        break block29;
                    }
                    if (this.subrecordType.equals("XLOC") && subrecordData.length == 12) {
                        if (subrecordData[0] == objSubrecordData[0] && subrecordData[1] == objSubrecordData[1] && subrecordData[2] == objSubrecordData[2] && subrecordData[3] == objSubrecordData[3] && subrecordData[4] == objSubrecordData[4] && subrecordData[5] == objSubrecordData[5] && subrecordData[6] == objSubrecordData[6] && subrecordData[7] == objSubrecordData[7] && subrecordData[8] == objSubrecordData[8]) {
                            areEqual = true;
                        }
                        break block29;
                    }
                    areEqual = true;
                    int i = 0;
                    while (i < subrecordData.length) {
                        if (subrecordData[i] != objSubrecordData[i]) {
                            areEqual = false;
                            break;
                        }
                        ++i;
                    }
                }
                catch (IOException exc) {
                    areEqual = false;
                }
            }
        }
        return areEqual;
    }

    public String toString() {
        return String.valueOf(this.subrecordType) + " subrecord";
    }
}

