/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.FormInfo;
import TES4Gecko.Main;
import TES4Gecko.Plugin;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginRecord;
import TES4Gecko.StatusDialog;
import TES4Gecko.WorkerDialog;
import TES4Gecko.WorkerTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CleanTask
extends WorkerTask {
    private File pluginFile;
    private Plugin plugin;
    private List<PluginGroup> pluginGroupList;
    private List<String> pluginMasterList;
    private Plugin master;
    private Map<Integer, FormInfo> masterFormMap;
    private int masterCount;
    private int masterIndex;
    private boolean pluginModified = false;

    public CleanTask(StatusDialog statusDialog, File pluginFile) {
        super(statusDialog);
        this.pluginFile = pluginFile;
    }

    public static void cleanPlugin(JFrame parent, File pluginFile) {
        StatusDialog statusDialog = new StatusDialog(parent, "Cleaning " + pluginFile.getName(), "Clean Plugin");
        CleanTask worker = new CleanTask(statusDialog, pluginFile);
        statusDialog.setWorker(worker);
        worker.start();
        statusDialog.showDialog();
        if (statusDialog.getStatus() == 1) {
            JOptionPane.showMessageDialog(parent, String.valueOf(pluginFile.getName()) + " cleaned", "Clean Plugin", 1);
        } else {
            JOptionPane.showMessageDialog(parent, "Unable to clean " + pluginFile.getName(), "Clean Plugin", 1);
        }
    }

    public void run() {
        boolean completed = false;
        try {
            this.plugin = new Plugin(this.pluginFile);
            this.plugin.load(this);
            this.pluginGroupList = this.plugin.getGroupList();
            this.pluginMasterList = this.plugin.getMasterList();
            int pluginMasterCount = this.pluginMasterList.size();
            this.masterIndex = 0;
            while (this.masterIndex < pluginMasterCount) {
                String masterName = this.pluginMasterList.get(this.masterIndex);
                File masterFile = new File(String.valueOf(Main.pluginDirectory) + Main.fileSeparator + masterName);
                this.master = new Plugin(masterFile);
                this.master.load(this);
                this.masterFormMap = this.master.getFormMap();
                this.masterCount = this.master.getMasterList().size();
                this.getStatusDialog().updateMessage("Comparing '" + this.plugin.getName() + "' to '" + masterName + "'");
                int processedCount = 0;
                int currentProgress = 0;
                for (PluginGroup pluginGroup : this.pluginGroupList) {
                    this.compareGroup(pluginGroup);
                    int newProgress = ++processedCount * 100 / this.pluginGroupList.size();
                    if (newProgress < currentProgress + 5) continue;
                    currentProgress = newProgress;
                    this.getStatusDialog().updateProgress(currentProgress);
                }
                ++this.masterIndex;
            }
            if (this.pluginModified) {
                this.plugin.store(this);
            }
            completed = true;
        }
        catch (PluginException exc) {
            Main.logException("Plugin Error", exc);
        }
        catch (DataFormatException exc) {
            Main.logException("Compression Error", exc);
        }
        catch (IOException exc) {
            Main.logException("I/O Error", exc);
        }
        catch (InterruptedException exc) {
            WorkerDialog.showMessageDialog(this.getStatusDialog(), "Request canceled", "Interrupted", 0);
        }
        catch (Throwable exc) {
            Main.logException("Exception while cleaning plugin", exc);
        }
        this.getStatusDialog().closeDialog(completed);
    }

    private void compareGroup(PluginGroup pluginGroup) {
        List<PluginRecord> recordList = pluginGroup.getRecordList();
        for (PluginRecord pluginRecord : recordList) {
            if (!(pluginRecord instanceof PluginGroup)) continue;
            this.compareGroup((PluginGroup)pluginRecord);
        }
        int recordCount = recordList.size();
        int recordIndex = 0;
        while (recordIndex < recordCount) {
            PluginRecord pluginRecord = recordList.get(recordIndex);
            if (!(pluginRecord instanceof PluginGroup)) {
                String recordType = pluginRecord.getRecordType();
                int formID = pluginRecord.getFormID();
                int modIndex = formID >>> 24;
                if (modIndex == this.masterIndex && !pluginRecord.isDeleted()) {
                    int masterFormID = formID & 0xFFFFFF | this.masterCount << 24;
                    Integer formIndex = new Integer(masterFormID);
                    FormInfo masterFormInfo = this.masterFormMap.get(formIndex);
                    if (masterFormInfo == null) {
                        if (Main.debugMode) {
                            System.out.printf("%s: Record %08X not found\n", this.master.getName(), masterFormID);
                        }
                    } else {
                        PluginRecord masterRecord = (PluginRecord)masterFormInfo.getSource();
                        if (pluginRecord.isIdentical(masterRecord)) {
                            PluginGroup cmpGroup;
                            PluginRecord cmpRecord;
                            int groupIndex;
                            boolean ignoreRecord = true;
                            if ((recordType.equals("WRLD") || recordType.equals("CELL") || recordType.equals("DIAL")) && (groupIndex = recordIndex + 1) < recordCount && (cmpRecord = recordList.get(groupIndex)) instanceof PluginGroup && (cmpGroup = (PluginGroup)cmpRecord).getGroupParentID() == pluginRecord.getFormID()) {
                                cmpGroup.removeIgnoredRecords();
                                if (!cmpGroup.isEmpty()) {
                                    ignoreRecord = false;
                                    if (Main.debugMode) {
                                        System.out.printf("Keeping %s record %s (%08X)\n", recordType, pluginRecord.getEditorID(), pluginRecord.getFormID());
                                    }
                                }
                            }
                            if (ignoreRecord) {
                                pluginRecord.setIgnore(true);
                                this.pluginModified = true;
                                if (Main.debugMode) {
                                    System.out.printf("Ignoring %s record %s (%08X)\n", recordType, pluginRecord.getEditorID(), pluginRecord.getFormID());
                                }
                            }
                        }
                    }
                }
            }
            ++recordIndex;
        }
    }
}

