/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.FormInfo;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormAdjust {
    private int[] masterMap;
    private int masterCount;
    private Map<Integer, FormInfo> formMap;

    public FormAdjust() {
    }

    public FormAdjust(int[] masterMap, int masterCount) {
        this.masterMap = masterMap;
        this.masterCount = masterCount;
    }

    public FormAdjust(int[] masterMap, int masterCount, Map<Integer, FormInfo> formMap) {
        this.masterMap = masterMap;
        this.masterCount = masterCount;
        this.formMap = formMap;
    }

    public int[] getMasterMap() {
        return this.masterMap;
    }

    public int getMasterCount() {
        return this.masterCount;
    }

    public Map<Integer, FormInfo> getFormMap() {
        return this.formMap;
    }

    public int adjustFormID(int formID) {
        FormInfo formInfo;
        if (this.masterMap == null || formID == 0) {
            return formID;
        }
        int masterID = formID >>> 24;
        if (masterID < this.masterMap.length) {
            masterID = this.masterMap[masterID];
            return formID & 0xFFFFFF | masterID << 24;
        }
        int newFormID = formID & 0xFFFFFF;
        newFormID = this.formMap == null ? (newFormID |= this.masterCount << 24) : ((formInfo = this.formMap.get(new Integer(formID))) == null ? (newFormID |= this.masterCount << 24) : formInfo.getMergedFormID());
        return newFormID;
    }

    public String adjustEditorID(int formID) {
        FormInfo formInfo;
        String editorID = null;
        if (this.formMap != null && (formInfo = this.formMap.get(new Integer(formID))) != null) {
            editorID = formInfo.getMergedEditorID();
        }
        return editorID;
    }
}

