/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.FormInfo;
import TES4Gecko.Main;
import TES4Gecko.Master;
import TES4Gecko.Plugin;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginNPC;
import TES4Gecko.PluginQuest;
import TES4Gecko.PluginRace;
import TES4Gecko.PluginRecord;
import TES4Gecko.PluginSubrecord;
import TES4Gecko.PluginTopic;
import TES4Gecko.SerializedElement;
import TES4Gecko.StatusDialog;
import TES4Gecko.WorkerDialog;
import TES4Gecko.WorkerTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateTask
extends WorkerTask {
    private File pluginFile;
    private Plugin plugin;
    private byte[] voiceData;
    private Map<Integer, byte[]> voiceDataMap;
    private Map<Integer, byte[]> lipSynchDataMap;
    private static final int maxSecondsSilence = 20;
    private static final int wordsPerSecondSilence = 3;
    private static final int bogusNPCFormID = 66947;
    private List<PluginRace> raceList;
    private Map<Integer, PluginRace> raceMap;
    private List<PluginNPC> npcList;
    private Map<Integer, PluginNPC> npcMap;
    private List<PluginRecord> questList;
    private Map<Integer, PluginRecord> questMap;
    private List<PluginTopic> topicList;
    private Map<Integer, PluginTopic> topicMap;
    private static JFrame parentWindow;
    private static int numInfosProcessed;
    private static int numFilesCreated;

    static {
        numInfosProcessed = 0;
        numFilesCreated = 0;
    }

    public GenerateTask(StatusDialog statusDialog, File pluginFile) {
        super(statusDialog);
        this.pluginFile = pluginFile;
    }

    public static void generateResponses(JFrame parent, File pluginFile) {
        parentWindow = parent;
        StatusDialog statusDialog = new StatusDialog(parent, " ", "Create Silent Voice Files");
        GenerateTask worker = new GenerateTask(statusDialog, pluginFile);
        statusDialog.setWorker(worker);
        worker.start();
        statusDialog.showDialog();
        if (statusDialog.getStatus() == 1) {
            JOptionPane.showMessageDialog(parent, "Silent voice files created for " + pluginFile.getName() + "\n" + numFilesCreated + " files created for " + numInfosProcessed + " INFO records.", "Create Silent Voice Files", 1);
        } else {
            JOptionPane.showMessageDialog(parent, "Unable to create silent voice files for " + pluginFile.getName(), "Create Silent Voice Files", 1);
        }
    }

    @Override
    public void run() {
        boolean completed = false;
        numInfosProcessed = 0;
        numFilesCreated = 0;
        try {
            PluginTopic topic;
            PluginQuest quest;
            PluginNPC npc;
            PluginRace race;
            URI fileURI;
            File voiceFile;
            int selection = JOptionPane.showConfirmDialog(parentWindow, "<html>This operation will remove <b>all</b> of the files currently in the voice \ndirectory of this plugin. Even if this is the desired behavior, that\nvoice directory should be backed up before executing this action.\nDo you still want to do this?", "Create Silent Voice Files: " + this.pluginFile.getName(), 0, 3);
            if (selection != 0) {
                return;
            }
            URL fileURL = Main.class.getResource("Main.class");
            String geckoPath = "Gecko path: " + fileURL.getFile() + "\n";
            if (fileURL == null) {
                throw new IOException("Unable to locate Main class");
            }
            String filePath = fileURL.getPath();
            int sep = filePath.indexOf(58);
            if (sep < 1) {
                throw new IOException("Main class path is not valid");
            }
            String protocol = fileURL.getProtocol();
            if (!protocol.equals("file") && !protocol.equals("jar")) {
                throw new IOException("Main class path protocol is not valid");
            }
            String firstCut = filePath.substring(0, filePath.indexOf("/Main.class"));
            String uriString = firstCut.substring(firstCut.indexOf(47));
            if (uriString.contains("!")) {
                uriString = uriString.substring(0, uriString.lastIndexOf(33));
                uriString = uriString.substring(0, uriString.lastIndexOf(47));
            }
            if (!(voiceFile = new File(String.valueOf(filePath = (fileURI = new URI(uriString)).getPath().substring(1)) + Main.fileSeparator + "TES4Gecko-Silence.mp3")).exists() || !voiceFile.isFile()) {
                throw new IOException("'" + voiceFile.getPath() + "' does not exist");
            }
            this.voiceData = new byte[(int)voiceFile.length()];
            FileInputStream in = new FileInputStream(voiceFile);
            in.read(this.voiceData);
            in.close();
            this.voiceDataMap = new HashMap<Integer, byte[]>();
            this.lipSynchDataMap = new HashMap<Integer, byte[]>();
            int i = 1;
            while (i <= 20) {
                String silenceFilePath = String.format(String.valueOf(filePath) + "/TES4Gecko-Silence%02d.mp3", i);
                File silenceFile = new File(silenceFilePath);
                String lipSynchFilePath = String.format(String.valueOf(filePath) + "/TES4Gecko-Silence%02d.lip", i);
                File lipSynchFile = new File(lipSynchFilePath);
                if (!silenceFile.exists() || !silenceFile.isFile()) {
                    this.voiceDataMap.clear();
                    this.lipSynchDataMap.clear();
                    break;
                }
                byte[] silenceData = new byte[(int)silenceFile.length()];
                FileInputStream inSilence = new FileInputStream(silenceFile);
                inSilence.read(silenceData);
                inSilence.close();
                this.voiceDataMap.put(i, silenceData);
                byte[] lipSynchData = new byte[lipSynchFile.exists() && lipSynchFile.isFile() ? (int)lipSynchFile.length() : 1];
                if (lipSynchData.length > 1) {
                    FileInputStream inLipSynch = new FileInputStream(lipSynchFile);
                    inLipSynch.read(lipSynchData);
                    inLipSynch.close();
                }
                this.lipSynchDataMap.put(i, lipSynchData);
                ++i;
            }
            this.plugin = new Plugin(this.pluginFile);
            this.plugin.load(this);
            int numInfos = this.getNumberInfos(this.plugin);
            List<PluginGroup> groupList = this.plugin.getGroupList();
            List<String> masterList = this.plugin.getMasterList();
            Master[] masters = new Master[masterList.size()];
            int index = 0;
            for (String masterName : masterList) {
                File masterFile = new File(String.valueOf(this.pluginFile.getParent()) + Main.fileSeparator + masterName);
                Master master = new Master(masterFile);
                master.load(this);
                masters[index++] = master;
            }
            this.raceList = new ArrayList<PluginRace>(32);
            this.raceMap = new HashMap<Integer, PluginRace>(32);
            this.npcList = new ArrayList<PluginNPC>(3072);
            this.npcMap = new HashMap<Integer, PluginNPC>(3072);
            this.questList = new ArrayList<PluginRecord>(512);
            this.questMap = new HashMap<Integer, PluginRecord>(512);
            this.topicList = new ArrayList<PluginTopic>(4096);
            this.topicMap = new HashMap<Integer, PluginTopic>(4096);
            File voiceBase = new File(String.valueOf(this.pluginFile.getParent()) + Main.fileSeparator + "Sound" + Main.fileSeparator + "Voice" + Main.fileSeparator + this.plugin.getName());
            if (voiceBase.exists()) {
                this.getStatusDialog().updateMessage("Deleting existing voice files");
                if (voiceBase.isDirectory()) {
                    this.deleteDirectoryTree(voiceBase);
                } else {
                    voiceBase.delete();
                }
            }
            this.getStatusDialog().updateMessage("Building cross-reference lists");
            for (PluginGroup group : groupList) {
                String groupRecordType = group.getGroupRecordType();
                List<PluginRecord> recordList = group.getRecordList();
                if (groupRecordType.equals("RACE")) {
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("RACE") || record.isIgnored()) continue;
                        if (record.isDeleted()) {
                            race = new PluginRace(record.getFormID());
                            race.setDelete(true);
                        } else {
                            race = this.buildRaceEntry(record);
                        }
                        this.raceList.add(race);
                        this.raceMap.put(new Integer(race.getFormID()), race);
                    }
                    continue;
                }
                if (groupRecordType.equals("NPC_")) {
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("NPC_") || record.isIgnored()) continue;
                        if (record.isDeleted()) {
                            npc = new PluginNPC(record.getFormID());
                            npc.setDelete(true);
                        } else {
                            npc = this.buildNPCEntry(record);
                        }
                        this.npcList.add(npc);
                        this.npcMap.put(new Integer(npc.getFormID()), npc);
                    }
                    continue;
                }
                if (groupRecordType.equals("QUST")) {
                    for (PluginRecord record : recordList) {
                        if (!record.getRecordType().equals("QUST") || record.isIgnored()) continue;
                        if (record.isDeleted()) {
                            quest = new PluginQuest(record.getFormID());
                            quest.setDelete(true);
                        } else {
                            quest = this.buildQuestEntry(record);
                        }
                        this.questList.add(record);
                        this.questMap.put(new Integer(quest.getFormID()), record);
                    }
                    continue;
                }
                if (!groupRecordType.equals("DIAL")) continue;
                for (PluginRecord record : recordList) {
                    if (!record.getRecordType().equals("DIAL") || record.isIgnored()) continue;
                    if (record.isDeleted()) {
                        topic = new PluginTopic(record.getFormID());
                        topic.setDelete(true);
                    } else {
                        topic = this.buildTopicEntry(record);
                    }
                    this.topicList.add(topic);
                    this.topicMap.put(new Integer(topic.getFormID()), topic);
                }
            }
            List<String> masterListInCaps = this.plugin.getMasterList();
            ListIterator<String> lit = masterListInCaps.listIterator();
            while (lit.hasNext()) {
                String tmpMaster = lit.next();
                lit.set(tmpMaster.toUpperCase());
            }
            int masterID = masters.length - 1;
            while (masterID > -1) {
                Master master = masters[masterID];
                List<FormInfo> formList = master.getFormList();
                List<String> masterListforMaster = master.getMasterList();
                for (FormInfo formInfo : formList) {
                    PluginRecord record;
                    int formID;
                    Integer objFormID;
                    int formMasterID;
                    int newMasterID = masterID;
                    String recordType = formInfo.getRecordType();
                    if ((recordType.equals("RACE") || recordType.equals("NPC_") || recordType.equals("QUST") || recordType.equals("DIAL")) && (formMasterID = (formInfo.getFormID() & 0xFF000000) >> 24) < masterListforMaster.size()) {
                        String formMasterName = masterListforMaster.get(formMasterID);
                        String raceFormID = String.format("%08X", formInfo.getFormID());
                        int pluginMasterIdx = masterListInCaps.indexOf(formMasterName.toUpperCase());
                        if (pluginMasterIdx == -1) {
                            if (Main.debugMode) {
                                System.out.printf("GenerateTask: Form ID %08X is modified in <%s> from the original in <%s>;  but <%s> is not in the master list for plugin <%s>.\n", formInfo.getFormID(), master.getName(), formMasterName, formMasterName, this.plugin.getName());
                            }
                        } else {
                            newMasterID = pluginMasterIdx;
                        }
                    }
                    if (recordType.equals("RACE")) {
                        PluginRecord record2 = master.getRecord(formInfo.getFormID());
                        race = this.buildRaceEntry(record2);
                        int formID2 = race.getFormID() & 0xFFFFFF | newMasterID << 24;
                        objFormID = new Integer(formID2);
                        if (this.raceMap.get(objFormID) != null) continue;
                        this.raceList.add(race);
                        this.raceMap.put(objFormID, race);
                        continue;
                    }
                    if (recordType.equals("NPC_")) {
                        PluginRecord record3 = master.getRecord(formInfo.getFormID());
                        npc = this.buildNPCEntry(record3);
                        int formID3 = npc.getFormID() & 0xFFFFFF | newMasterID << 24;
                        objFormID = new Integer(formID3);
                        if (this.npcMap.get(objFormID) != null) continue;
                        this.npcList.add(npc);
                        this.npcMap.put(objFormID, npc);
                        continue;
                    }
                    if (recordType.equals("QUST")) {
                        PluginRecord record4 = master.getRecord(formInfo.getFormID());
                        quest = this.buildQuestEntry(record4);
                        int formID4 = quest.getFormID() & 0xFFFFFF | newMasterID << 24;
                        objFormID = new Integer(formID4);
                        if (this.questMap.get(objFormID) != null) continue;
                        this.questList.add(record4);
                        this.questMap.put(objFormID, record4);
                        continue;
                    }
                    if (!recordType.equals("DIAL") || this.topicMap.get(objFormID = new Integer(formID = (topic = this.buildTopicEntry(record = master.getRecord(formInfo.getFormID()))).getFormID() & 0xFFFFFF | newMasterID << 24)) != null) continue;
                    this.topicList.add(topic);
                    this.topicMap.put(objFormID, topic);
                }
                --masterID;
            }
            this.getStatusDialog().updateMessage("Creating silent voice files for " + this.pluginFile.getName());
            for (PluginGroup group : groupList) {
                String groupRecordType = group.getGroupRecordType();
                if (!groupRecordType.equals("DIAL")) continue;
                List<PluginRecord> recordList = group.getRecordList();
                for (PluginRecord record : recordList) {
                    if (!record.getRecordType().equals("GRUP")) continue;
                    PluginGroup infoGroup = (PluginGroup)record;
                    int topicID = infoGroup.getGroupParentID();
                    List<PluginRecord> infoList = infoGroup.getRecordList();
                    for (PluginRecord infoRecord : infoList) {
                        int masterID2;
                        if (!infoRecord.getRecordType().equals("INFO") || infoRecord.isIgnored() || infoRecord.isDeleted() || (masterID2 = infoRecord.getFormID() >>> 24) < masterList.size()) continue;
                        numFilesCreated += this.createResponseFiles(topicID, infoRecord);
                        if (++numInfosProcessed % 100 != 0) continue;
                        this.getStatusDialog().updateProgress(100 * numInfosProcessed / numInfos);
                    }
                }
            }
            completed = true;
        }
        catch (PluginException exc) {
            Main.logException("Plugin Error", exc);
        }
        catch (DataFormatException exc) {
            Main.logException("Compression Error", exc);
        }
        catch (IOException exc) {
            Main.logException("I/O Error", exc);
        }
        catch (InterruptedException exc) {
            WorkerDialog.showMessageDialog(this.getStatusDialog(), "Request canceled", "Interrupted", 0);
        }
        catch (Throwable exc) {
            Main.logException("Exception while generating responses", exc);
        }
        this.getStatusDialog().closeDialog(completed);
    }

    private PluginRace buildRaceEntry(PluginRecord record) throws DataFormatException, IOException, PluginException {
        int raceFormID;
        int maleFormID = raceFormID = record.getFormID();
        int femaleFormID = raceFormID;
        boolean playableRace = false;
        String raceName = null;
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("FULL")) {
                subrecordData = subrecord.getSubrecordData();
                if (subrecordData.length <= 1) continue;
                raceName = new String(subrecordData, 0, subrecordData.length - 1);
                continue;
            }
            if (subrecordType.equals("VNAM")) {
                int formID;
                subrecordData = subrecord.getSubrecordData();
                if (subrecordData.length >= 4 && (formID = SerializedElement.getInteger(subrecordData, 0)) != 0) {
                    maleFormID = formID;
                }
                if (subrecordData.length < 8 || (formID = SerializedElement.getInteger(subrecordData, 4)) == 0) continue;
                femaleFormID = formID;
                continue;
            }
            if (!subrecordType.equals("DATA") || (subrecordData = subrecord.getSubrecordData()).length < 33 || (subrecordData[32] & 1) == 0) continue;
            playableRace = true;
        }
        if (raceName == null) {
            raceName = record.getEditorID();
        }
        return new PluginRace(raceFormID, record.getEditorID(), raceName, playableRace, maleFormID, femaleFormID);
    }

    private PluginNPC buildNPCEntry(PluginRecord record) throws DataFormatException, IOException, PluginException {
        int formID = record.getFormID();
        int raceID = 0;
        boolean female = false;
        List<PluginSubrecord> subrecordList = record.getSubrecords();
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("RNAM")) {
                subrecordData = subrecord.getSubrecordData();
                if (subrecordData.length < 4) continue;
                raceID = SerializedElement.getInteger(subrecordData, 0);
                continue;
            }
            if (!subrecordType.equals("ACBS") || (subrecordData = subrecord.getSubrecordData()).length < 1 || (subrecordData[0] & 1) == 0) continue;
            female = true;
        }
        return new PluginNPC(formID, record.getEditorID(), raceID, female);
    }

    private PluginQuest buildQuestEntry(PluginRecord record) {
        return new PluginQuest(record.getFormID(), record.getEditorID());
    }

    private PluginTopic buildTopicEntry(PluginRecord record) {
        return new PluginTopic(record.getFormID(), record.getEditorID());
    }

    private int createResponseFiles(int topicID, PluginRecord infoRecord) throws DataFormatException, IOException, PluginException {
        Object subrecordData;
        String text;
        String text2;
        List<PluginSubrecord> subrecordList = infoRecord.getSubrecords();
        int infoID = infoRecord.getFormID() & 0xFFFFFF;
        int responseCount = 0;
        int questID = 0;
        int npcID = 0;
        int raceID = 0;
        ArrayList<Integer> respNums = new ArrayList<Integer>();
        ArrayList<Integer> voiceIdx = new ArrayList<Integer>();
        HashMap responseNPCs = new HashMap();
        ArrayList<Integer> responseIncludedNPCs = new ArrayList<Integer>();
        ArrayList<Integer> responseExcludedRaces = new ArrayList<Integer>();
        ArrayList<Integer> responseIncludedRaces = new ArrayList<Integer>();
        for (PluginSubrecord subrecord : subrecordList) {
            byte[] subrecordData2;
            String subrecordType = subrecord.getSubrecordType();
            if (subrecordType.equals("QSTI")) {
                subrecordData2 = subrecord.getSubrecordData();
                questID = SerializedElement.getInteger(subrecordData2, 0);
                continue;
            }
            if (subrecordType.equals("CTDA")) {
                subrecordData2 = subrecord.getSubrecordData();
                int code = SerializedElement.getInteger(subrecordData2, 8);
                if (subrecordData2[0] != 0 || code != 72 && code != 69) continue;
                int bits = SerializedElement.getInteger(subrecordData2, 4);
                float value = Float.intBitsToFloat(bits);
                int formID = SerializedElement.getInteger(subrecordData2, 12);
                if ((double)value == 1.0) {
                    if (code == 72) {
                        npcID = formID;
                        responseIncludedNPCs.add(npcID);
                        continue;
                    }
                    raceID = formID;
                    responseIncludedRaces.add(raceID);
                    continue;
                }
                if ((double)value != 0.0 || code != 1157) continue;
                int raceIDEx = formID;
                responseExcludedRaces.add(raceIDEx);
                continue;
            }
            if (subrecordType.equals("TRDT")) {
                ++responseCount;
                subrecordData2 = subrecord.getSubrecordData();
                respNums.add(new Integer(subrecordData2[12]));
                continue;
            }
            if (!subrecordType.equals("NAM1")) continue;
            if (this.voiceDataMap.size() == 0) {
                voiceIdx.add(0);
                continue;
            }
            subrecordData2 = subrecord.getSubrecordData();
            String respLine = new String(subrecordData2, 0, subrecordData2.length - 1).trim();
            if (respLine.equals("")) {
                voiceIdx.add(1);
                continue;
            }
            String[] numWords = respLine.split("[^\\w'\\-]+");
            int secsOfSilence = numWords.length / 3;
            secsOfSilence = secsOfSilence + 1 < 20 ? secsOfSilence + 1 : 20;
            voiceIdx.add(secsOfSilence);
        }
        if (responseCount == 0 || questID == 0) {
            return 0;
        }
        PluginTopic topic = this.topicMap.get(new Integer(topicID));
        if (topic == null) {
            text2 = String.format("Topic %08X not found", new Object[0]);
            throw new PluginException(text2);
        }
        if (topic.isDeleted()) {
            text2 = String.format("Topic %08X is deleted", topicID);
            throw new PluginException(text2);
        }
        String topicName = topic.getEditorID();
        PluginRecord quest = this.questMap.get(new Integer(questID));
        if (quest == null) {
            text = String.format("Quest %08X not found for dialog topic %s", questID, topicName);
            throw new PluginException(text);
        }
        if (quest.isDeleted()) {
            text = String.format("Quest %08X is deleted", questID);
            throw new PluginException(text);
        }
        int filesCreated = 0;
        String questName = quest.getEditorID();
        List<PluginSubrecord> questSubrecordList = quest.getSubrecords();
        ArrayList<Integer> questIncludedNPCs = new ArrayList<Integer>();
        ArrayList<Integer> questExcludedRaces = new ArrayList<Integer>();
        ArrayList<Integer> questIncludedRaces = new ArrayList<Integer>();
        for (PluginSubrecord subrecord : questSubrecordList) {
            String subrecordType = subrecord.getSubrecordType();
            if (!subrecordType.equals("CTDA")) continue;
            subrecordData = subrecord.getSubrecordData();
            int code = SerializedElement.getInteger((byte[])subrecordData, 8);
            if (subrecordData[0] != 0 || code != 72 && code != 69) continue;
            int bits = SerializedElement.getInteger((byte[])subrecordData, 4);
            float value = Float.intBitsToFloat(bits);
            int formID = SerializedElement.getInteger((byte[])subrecordData, 12);
            if ((double)value == 1.0) {
                if (code == 72) {
                    questIncludedNPCs.add(formID);
                    continue;
                }
                questIncludedRaces.add(formID);
                continue;
            }
            if ((double)value != 0.0 || code != 1157) continue;
            questExcludedRaces.add(formID);
        }
        ArrayList<PluginRace> racesQuestLevel = new ArrayList<PluginRace>();
        if (questIncludedNPCs.size() == 0) {
            if (questIncludedRaces.size() > 0) {
                for (PluginRace race : this.raceList) {
                    if (race.isDeleted() || !questIncludedRaces.contains(race.getFormID())) continue;
                    racesQuestLevel.add(race);
                }
            } else if (questExcludedRaces.size() > 0) {
                for (PluginRace race : this.raceList) {
                    if (!race.isPlayableRace() || race.isDeleted() || questExcludedRaces.contains(race.getFormID())) continue;
                    racesQuestLevel.add(race);
                }
            } else {
                for (PluginRace race : this.raceList) {
                    if (!race.isPlayableRace() || race.isDeleted()) continue;
                    racesQuestLevel.add(race);
                }
            }
        }
        ArrayList<PluginRace> racesResponseLevel = new ArrayList<PluginRace>();
        if (questIncludedNPCs.size() == 0 && responseIncludedNPCs.size() == 0) {
            if (responseIncludedRaces.size() > 0) {
                subrecordData = racesQuestLevel.iterator();
                while (subrecordData.hasNext()) {
                    PluginRace race = (PluginRace)subrecordData.next();
                    if (!responseIncludedRaces.contains(race.getFormID())) continue;
                    racesResponseLevel.add(race);
                }
            } else if (responseExcludedRaces.size() > 0) {
                for (PluginRace race : racesQuestLevel) {
                    if (responseExcludedRaces.contains(race.getFormID())) continue;
                    racesResponseLevel.add(race);
                }
            } else {
                racesResponseLevel = racesQuestLevel;
            }
        }
        ArrayList<Integer> intersectNPCList = new ArrayList<Integer>();
        if (questIncludedNPCs.size() == 0 && responseIncludedNPCs.size() > 0) {
            intersectNPCList = responseIncludedNPCs;
        } else if (questIncludedNPCs.size() > 0 && responseIncludedNPCs.size() == 0) {
            intersectNPCList = questIncludedNPCs;
        } else {
            Iterator iterator = questIncludedNPCs.iterator();
            while (iterator.hasNext()) {
                int npc = (Integer)iterator.next();
                if (!responseIncludedNPCs.contains(npc)) continue;
                intersectNPCList.add(npc);
            }
        }
        for (PluginRace race : racesResponseLevel) {
            filesCreated += this.copyVoiceData(questName, topicName, infoID, race, false, respNums, voiceIdx);
            filesCreated += this.copyVoiceData(questName, topicName, infoID, race, true, respNums, voiceIdx);
        }
        Iterator iterator = intersectNPCList.iterator();
        while (iterator.hasNext()) {
            int tmpNPCID = (Integer)iterator.next();
            PluginNPC npc = this.npcMap.get(new Integer(tmpNPCID));
            if (npc == null) {
                String text3 = "";
                if (npcID != 66947) {
                    text3 = String.format("NPC %08X not found for dialog topic %s (%08X) in quest %s (%08X)\n", tmpNPCID, topicName, infoID, questName, questID);
                    System.out.printf(text3, new Object[0]);
                }
                if (npcID == 66947) continue;
                throw new PluginException(text3);
            }
            if (npc.isDeleted()) {
                String text4 = String.format("NPC %08X is deleted", npcID);
                throw new PluginException(text4);
            }
            raceID = npc.getRaceID();
            PluginRace race = this.raceMap.get(raceID);
            if (race == null) {
                String text5 = String.format("Race %08X not found for NPC %s", raceID, npc.getEditorID());
                throw new PluginException(text5);
            }
            if (race.isDeleted()) {
                String text6 = String.format("Race %08X is deleted", raceID);
                throw new PluginException(text6);
            }
            if (racesQuestLevel.size() > 0 && responseIncludedNPCs.size() > 0) {
                if (!racesQuestLevel.contains(race) && race.isPlayableRace()) continue;
                filesCreated += this.copyVoiceData(questName, topicName, infoID, race, npc.isFemale(), respNums, voiceIdx);
                continue;
            }
            filesCreated += this.copyVoiceData(questName, topicName, infoID, race, npc.isFemale(), respNums, voiceIdx);
        }
        return filesCreated;
    }

    private void copyVoiceData(String questName, String topicName, int infoID, PluginRace race, boolean female, int count) throws IOException, PluginException {
        int voiceID = female ? race.getFemaleVoiceID() : race.getMaleVoiceID();
        PluginRace voiceRace = this.raceMap.get(new Integer(voiceID));
        if (voiceRace == null) {
            String text = String.format("Voice race %08X not found for race %s", voiceID, race.getName());
            throw new PluginException(text);
        }
        if (voiceRace.isDeleted()) {
            String text = String.format("Voice race %08X is deleted", voiceID);
            throw new PluginException(text);
        }
        String filePath = String.format("%s\\Sound\\Voice\\%s\\%s\\%s", this.pluginFile.getParent(), this.plugin.getName(), voiceRace.getName(), female ? "F" : "M");
        File voiceDirectory = new File(filePath);
        if (!voiceDirectory.exists()) {
            voiceDirectory.mkdirs();
        }
        int response = 1;
        while (response <= count) {
            String fileName = String.format("%s_%s_%08X_%d.mp3", questName, topicName, infoID, response);
            File voiceFile = new File(String.valueOf(filePath) + "\\" + fileName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(voiceFile);
                out.write(this.voiceData);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            ++response;
        }
    }

    private int copyVoiceData(String questName, String topicName, int infoID, PluginRace race, boolean female, List<Integer> respNums, List<Integer> voiceIdx) throws IOException, PluginException {
        int voiceID = female ? race.getFemaleVoiceID() : race.getMaleVoiceID();
        PluginRace voiceRace = this.raceMap.get(new Integer(voiceID));
        if (voiceRace == null) {
            String text = String.format("Voice race %08X not found for race %s", voiceID, race.getName());
            throw new PluginException(text);
        }
        if (voiceRace.isDeleted()) {
            String text = String.format("Voice race %08X is deleted", voiceID);
            throw new PluginException(text);
        }
        int filesCreated = 0;
        String filePath = String.format("%s\\Sound\\Voice\\%s\\%s\\%s", this.pluginFile.getParent(), this.plugin.getName(), voiceRace.getName(), female ? "F" : "M");
        File voiceDirectory = new File(filePath);
        if (!voiceDirectory.exists()) {
            voiceDirectory.mkdirs();
        }
        int i = 0;
        while (i < respNums.size()) {
            int response = respNums.get(i);
            int silenceIdx = voiceIdx.get(i);
            String fileName = String.format("%s_%s_%08X_%d.mp3", questName, topicName, infoID, response);
            String lipSynchFileName = String.format("%s_%s_%08X_%d.lip", questName, topicName, infoID, response);
            File voiceFile = new File(String.valueOf(filePath) + "\\" + fileName);
            if (!voiceFile.exists()) {
                File lipSynchFile = new File(String.valueOf(filePath) + "\\" + lipSynchFileName);
                FileOutputStream out = null;
                FileOutputStream lipSynchOut = null;
                try {
                    out = new FileOutputStream(voiceFile);
                    out.write(silenceIdx == 0 ? this.voiceData : this.voiceDataMap.get(silenceIdx));
                    ++filesCreated;
                    if (silenceIdx > 0 && this.lipSynchDataMap.get(silenceIdx).length > 1) {
                        lipSynchOut = new FileOutputStream(lipSynchFile);
                        lipSynchOut.write(this.lipSynchDataMap.get(silenceIdx));
                        ++filesCreated;
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (lipSynchOut != null) {
                        lipSynchOut.close();
                    }
                }
            }
            ++i;
        }
        return filesCreated;
    }

    private int getNumberInfos(Plugin pl) {
        int numInfos = 0;
        List<FormInfo> allForms = pl.getFormList();
        for (FormInfo form : allForms) {
            if (!form.getRecordType().equals("INFO")) continue;
            ++numInfos;
        }
        return numInfos;
    }

    private void deleteDirectoryTree(File directory) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.deleteDirectoryTree(file);
            } else {
                file.delete();
            }
            ++n2;
        }
        directory.delete();
    }
}

