/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.FormAdjust;
import TES4Gecko.FormInfo;
import TES4Gecko.GroupNode;
import TES4Gecko.Plugin;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginRecord;
import TES4Gecko.RecordNode;
import TES4Gecko.StatusDialog;
import TES4Gecko.WorkerTask;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginNode
extends DefaultMutableTreeNode {
    private List<TreePath> distinctPaths;
    private FormAdjust formAdjust;

    public PluginNode(Plugin plugin) {
        super(plugin);
    }

    public Plugin getPlugin() {
        return (Plugin)this.getUserObject();
    }

    public List<TreePath> getDistinctPaths() {
        return this.distinctPaths;
    }

    public void setDistinctPaths(List<TreePath> distinctPaths) {
        this.distinctPaths = distinctPaths;
    }

    public FormAdjust getFormAdjust() {
        return this.formAdjust;
    }

    public void setFormAdjust(FormAdjust formAdjust) {
        this.formAdjust = formAdjust;
    }

    public void insert(GroupNode groupNode) {
        int count = this.getChildCount();
        int index = 0;
        while (index < count) {
            if (groupNode.compareTo((GroupNode)this.getChildAt(index)) < 0) break;
            ++index;
        }
        this.insert(groupNode, index);
    }

    public void buildNodes(WorkerTask task) throws InterruptedException {
        StatusDialog statusDialog = task != null ? task.getStatusDialog() : null;
        List<PluginGroup> groupList = this.getPlugin().getGroupList();
        int groupCount = groupList.size();
        int processedCount = 0;
        int currentProgress = 0;
        if (statusDialog != null) {
            statusDialog.updateMessage("Creating tree for " + this.getPlugin().getName());
        }
        this.removeAllChildren();
        for (PluginGroup group : groupList) {
            int newProgress;
            GroupNode groupNode = new GroupNode(group);
            this.createGroupChildren(groupNode, group);
            this.insert(groupNode);
            if (task != null && WorkerTask.interrupted()) {
                throw new InterruptedException("Request canceled");
            }
            if ((newProgress = ++processedCount * 100 / groupCount) < currentProgress + 5) continue;
            currentProgress = newProgress;
            if (statusDialog == null) continue;
            statusDialog.updateProgress(currentProgress);
        }
    }

    private void createGroupChildren(GroupNode groupNode, PluginGroup group) {
        Map<Integer, FormInfo> formMap = this.getPlugin().getFormMap();
        List<PluginRecord> recordList = group.getRecordList();
        for (PluginRecord record : recordList) {
            int groupType;
            FormInfo formInfo;
            if (record instanceof PluginGroup) {
                PluginGroup subgroup = (PluginGroup)record;
                GroupNode subgroupNode = new GroupNode(subgroup);
                this.createGroupChildren(subgroupNode, subgroup);
                groupNode.add(subgroupNode);
                continue;
            }
            RecordNode recordNode = new RecordNode(record);
            if (record.getRecordLength() != 0) {
                recordNode.add(new DefaultMutableTreeNode(null));
            }
            if ((formInfo = formMap.get(new Integer(record.getFormID()))) != null) {
                formInfo.setRecordNode(recordNode);
            }
            if ((groupType = group.getGroupType()) == 0) {
                String recordType = group.getGroupRecordType();
                if (recordType.equals("CELL") || recordType.equals("DIAL") || recordType.equals("WRLD")) {
                    groupNode.add(recordNode);
                    continue;
                }
                groupNode.insert(recordNode);
                continue;
            }
            if (groupType == 10 || groupType == 8 || groupType == 9) {
                groupNode.insert(recordNode);
                continue;
            }
            groupNode.add(recordNode);
        }
    }
}

