/*
 * Decompiled with CFR 0.152.
 */
package TES4Gecko;

import TES4Gecko.FormInfo;
import TES4Gecko.Main;
import TES4Gecko.Master;
import TES4Gecko.Plugin;
import TES4Gecko.PluginException;
import TES4Gecko.PluginGroup;
import TES4Gecko.PluginRecord;
import TES4Gecko.PluginSubrecord;
import TES4Gecko.SerializedElement;
import TES4Gecko.StatusDialog;
import TES4Gecko.WorkerDialog;
import TES4Gecko.WorkerTask;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WorldspaceTask
extends WorkerTask {
    private boolean insertPlaceholders = false;
    private boolean pluginModified = false;
    private File pluginFile;
    private Plugin plugin;
    private int pluginIndex;
    private Master[] masters;
    private List<FormInfo> worldspaceList;
    private List<String> worldspaceNames;
    private Map<Integer, Integer> worldspaceMap;
    private List<Integer> distantList;
    private int baseFormID;

    public WorldspaceTask(StatusDialog statusDialog, File pluginFile, int options) {
        super(statusDialog);
        this.pluginFile = pluginFile;
        if ((options & 1) == 1) {
            this.insertPlaceholders = true;
        }
    }

    public static void moveWorldspaces(JFrame parent, File pluginFile, int options) {
        StatusDialog statusDialog = new StatusDialog(parent, "Moving worldspaces for " + pluginFile.getName(), "Move Worldspaces");
        WorldspaceTask worker = new WorldspaceTask(statusDialog, pluginFile, options);
        statusDialog.setWorker(worker);
        worker.start();
        statusDialog.showDialog();
        if (statusDialog.getStatus() == 1) {
            JOptionPane.showMessageDialog(parent, String.valueOf(pluginFile.getName()) + " updated", "Move Worldspaces", 1);
        } else {
            JOptionPane.showMessageDialog(parent, "Unable to move worldspaces for " + pluginFile.getName(), "Move Worldspaces", 1);
        }
    }

    public void run() {
        boolean completed = false;
        this.worldspaceList = new ArrayList<FormInfo>(50);
        this.worldspaceNames = new ArrayList<String>(50);
        this.worldspaceMap = new HashMap<Integer, Integer>(50);
        this.distantList = new ArrayList<Integer>(50);
        try {
            this.plugin = new Plugin(this.pluginFile);
            this.plugin.load(this);
            List<String> masterList = this.plugin.getMasterList();
            this.pluginIndex = masterList.size();
            if (this.pluginIndex > 0) {
                this.masters = new Master[this.pluginIndex];
                int i = 0;
                while (i < this.pluginIndex) {
                    String masterName = masterList.get(i);
                    File masterFile = new File(String.valueOf(Main.pluginDirectory) + Main.fileSeparator + masterName);
                    this.masters[i] = new Master(masterFile);
                    this.masters[i].load(this);
                    ++i;
                }
            }
            Date date = new Date();
            this.baseFormID = (int)(date.getTime() / 1000L - 1176047100L) % 0xE00000 + 0x200000;
            if (Main.debugMode) {
                System.out.printf("Base worldspace form ID is %08X\n", this.baseFormID);
            }
            this.getStatusDialog().updateMessage("Moving worldspaces for " + this.plugin.getName());
            if (this.pluginIndex > 0) {
                String dirPath;
                File dirFile;
                this.mapWorldspaces();
                String lodPath = String.format("%s%sDistantLOD", Main.pluginDirectory, Main.fileSeparator);
                File lodDir = new File(lodPath);
                if (lodDir.exists() && lodDir.isDirectory()) {
                    this.mapDistantStatics(lodDir);
                }
                this.relocateWorldspaces();
                this.updateReferences();
                if (lodDir.exists() && lodDir.isDirectory()) {
                    this.updateDistantStatics(lodDir);
                }
                if (this.insertPlaceholders) {
                    this.createPlaceholders();
                }
                if ((dirFile = new File(dirPath = String.format("%s%sMeshes%sLandscape%sLOD", Main.pluginDirectory, Main.fileSeparator, Main.fileSeparator, Main.fileSeparator))).exists() && dirFile.isDirectory()) {
                    this.renameFiles(dirFile);
                }
                if ((dirFile = new File(dirPath = String.format("%s%sTextures%sLandscapeLOD%sGenerated", Main.pluginDirectory, Main.fileSeparator, Main.fileSeparator, Main.fileSeparator))).exists() && dirFile.isDirectory()) {
                    this.renameFiles(dirFile);
                }
            }
            if (this.pluginModified) {
                this.plugin.store(this);
            }
            completed = true;
        }
        catch (PluginException exc) {
            Main.logException("Plugin Error", exc);
        }
        catch (DataFormatException exc) {
            Main.logException("Compression Error", exc);
        }
        catch (IOException exc) {
            Main.logException("I/O Error", exc);
        }
        catch (InterruptedException exc) {
            WorkerDialog.showMessageDialog(this.getStatusDialog(), "Request canceled", "Interrupted", 0);
        }
        catch (Throwable exc) {
            Main.logException("Exception while moving worldspaces", exc);
        }
        this.getStatusDialog().closeDialog(completed);
    }

    private void mapWorldspaces() throws DataFormatException, IOException, PluginException {
        List<FormInfo> formList = this.plugin.getFormList();
        Map<Integer, FormInfo> formMap = this.plugin.getFormMap();
        Map<Integer, FormInfo> masterFormMap = this.masters[0].getFormMap();
        for (FormInfo formInfo : formList) {
            PluginRecord checkRecord;
            String editorID;
            int checkFormID;
            Master checkMaster;
            String recordType = formInfo.getRecordType();
            int formID = formInfo.getFormID();
            int modIndex = formID >>> 24;
            if (recordType.equals("WRLD")) {
                if (modIndex >= this.pluginIndex) {
                    this.worldspaceList.add(formInfo);
                } else if (modIndex > 0) {
                    String editorID2;
                    PluginRecord checkRecord2;
                    Master checkMaster2 = this.masters[modIndex];
                    int checkFormID2 = formID & 0xFFFFFF | checkMaster2.getMasterList().size() << 24;
                    FormInfo checkFormInfo = checkMaster2.getFormMap().get(new Integer(checkFormID2));
                    if (checkFormInfo != null && (checkRecord2 = checkMaster2.getRecord(checkFormID2)).getRecordType().equals("BOOK") && (editorID2 = checkRecord2.getEditorID()).length() == 17 && editorID2.substring(0, 9).equals("TES4Gecko")) {
                        this.worldspaceList.add(formInfo);
                    }
                }
                this.worldspaceNames.add(formInfo.getEditorID().toLowerCase());
                continue;
            }
            if (!recordType.equals("REFR") && !recordType.equals("ACHR") && !recordType.equals("ACRE")) continue;
            PluginRecord record = (PluginRecord)formInfo.getSource();
            int recordFlags = record.getRecordFlags();
            int baseFormID = 0;
            List<PluginSubrecord> subrecords = record.getSubrecords();
            for (PluginSubrecord subrecord : subrecords) {
                if (!subrecord.getSubrecordType().equals("NAME")) continue;
                byte[] subrecordData = subrecord.getSubrecordData();
                baseFormID = SerializedElement.getInteger(subrecordData, 0);
                break;
            }
            int baseModIndex = baseFormID >>> 24;
            if (baseFormID == 0 || baseModIndex <= 0) continue;
            Integer lookupFormID = new Integer(baseFormID);
            FormInfo baseFormInfo = formMap.get(lookupFormID);
            if (baseFormInfo == null) {
                if (baseModIndex >= this.pluginIndex) continue;
                checkMaster = this.masters[baseModIndex];
                checkFormID = baseFormID & 0xFFFFFF | checkMaster.getMasterList().size() << 24;
                baseFormInfo = checkMaster.getFormMap().get(new Integer(checkFormID));
                if (baseFormInfo == null) continue;
                PluginRecord checkRecord3 = checkMaster.getRecord(checkFormID);
                boolean relocated = false;
                if (checkRecord3.getRecordType().equals("BOOK") && (editorID = checkRecord3.getEditorID()).length() == 17 && editorID.substring(0, 9).equals("TES4Gecko")) {
                    relocated = true;
                }
                if (!relocated && (recordFlags & 0x8000) == 0) continue;
                FormInfo relocFormInfo = new FormInfo(baseFormInfo.getSource(), baseFormInfo.getRecordType(), baseFormID, baseFormInfo.getEditorID());
                relocFormInfo.setPlugin(baseFormInfo.getPlugin());
                if (this.worldspaceList.contains(relocFormInfo)) continue;
                this.worldspaceList.add(relocFormInfo);
                if (!Main.debugMode) continue;
                System.out.printf("Relocation required for reference %08X to %s base item %s (%08X)\n", formInfo.getFormID(), baseFormInfo.getRecordType(), baseFormInfo.getEditorID(), baseFormID);
                continue;
            }
            if ((recordFlags & 0x8000) != 0 && !this.worldspaceList.contains(baseFormInfo)) {
                this.worldspaceList.add(baseFormInfo);
                if (!Main.debugMode) continue;
                System.out.printf("Relocation required for reference %08X to %s base item %s (%08X)\n", formInfo.getFormID(), baseFormInfo.getRecordType(), baseFormInfo.getEditorID(), baseFormID);
                continue;
            }
            if (baseModIndex >= this.pluginIndex || this.worldspaceList.contains(baseFormInfo)) continue;
            checkMaster = this.masters[baseModIndex];
            checkFormID = baseFormID & 0xFFFFFF | checkMaster.getMasterList().size() << 24;
            FormInfo checkFormInfo = checkMaster.getFormMap().get(new Integer(checkFormID));
            if (checkFormInfo == null || !(checkRecord = checkMaster.getRecord(checkFormID)).getRecordType().equals("BOOK") || (editorID = checkRecord.getEditorID()).length() != 17 || !editorID.substring(0, 9).equals("TES4Gecko")) continue;
            this.worldspaceList.add(baseFormInfo);
            if (!Main.debugMode) continue;
            System.out.printf("Relocation required for reference %08X to %s base item %s (%08X)\n", formInfo.getFormID(), baseFormInfo.getRecordType(), baseFormInfo.getEditorID(), baseFormID);
        }
    }

    private void mapDistantStatics(File dirFile) throws IOException {
        File[] files;
        File[] fileArray = files = dirFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            int length = (int)file.length();
            int pos = name.lastIndexOf(46);
            if (pos > 0 && name.substring(pos).equalsIgnoreCase(".lod") && length > 0 && (pos = name.indexOf(95)) > 0 && this.worldspaceNames.contains(name.substring(0, pos).toLowerCase())) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    byte[] buffer = new byte[length];
                    int count = in.read(buffer);
                    if (count != length) {
                        throw new EOFException("Unexpected end-of-file on " + name);
                    }
                    in.close();
                    in = null;
                    int referenceCount = SerializedElement.getInteger(buffer, 0);
                    int offset = 4;
                    int i = 0;
                    while (i < referenceCount) {
                        Integer objFormID;
                        int formID = SerializedElement.getInteger(buffer, offset);
                        int modIndex = formID >>> 24;
                        count = SerializedElement.getInteger(buffer, offset + 4);
                        offset += 8 + 28 * count;
                        if (modIndex > 0 && !this.distantList.contains(objFormID = new Integer(formID))) {
                            this.distantList.add(new Integer(objFormID));
                        }
                        ++i;
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            ++n2;
        }
        List<FormInfo> formList = this.plugin.getFormList();
        Map<Integer, FormInfo> formMap = this.plugin.getFormMap();
        Map<Integer, FormInfo> masterFormMap = this.masters[0].getFormMap();
        block5: for (FormInfo formInfo : formList) {
            int formID = formInfo.getFormID();
            int modIndex = formID >>> 24;
            if (modIndex < this.pluginIndex) continue;
            for (Integer distantFormID : this.distantList) {
                if (distantFormID != formID) continue;
                if (this.worldspaceList.contains(formInfo)) continue block5;
                this.worldspaceList.add(formInfo);
                if (!Main.debugMode) continue block5;
                System.out.printf("DistantLOD entry maps to %s record %s (%08X)\n", formInfo.getRecordType(), formInfo.getEditorID(), formID);
                continue block5;
            }
        }
    }

    private void relocateWorldspaces() throws DataFormatException, IOException, PluginException {
        for (FormInfo formInfo : this.worldspaceList) {
            int formID;
            int oldFormID = formInfo.getFormID();
            int modIndex = oldFormID >>> 24;
            if (modIndex >= this.pluginIndex) {
                String recordType = formInfo.getRecordType();
                String editorID = formInfo.getEditorID();
                formID = recordType.equals("BOOK") && editorID.length() == 17 && editorID.substring(0, 9).equals("TES4Gecko") ? Integer.parseInt(editorID.substring(9), 16) : this.getBaseFormID();
            } else {
                PluginRecord checkRecord = this.masters[modIndex].getRecord(oldFormID);
                String recordType = checkRecord.getRecordType();
                String editorID = checkRecord.getEditorID();
                if (recordType.equals("BOOK") && editorID.length() == 17 && editorID.substring(0, 9).equals("TES4Gecko")) {
                    formID = Integer.parseInt(editorID.substring(9), 16);
                } else if (formInfo.getPlugin() instanceof Master) {
                    formID = this.getBaseFormID();
                    PluginRecord record = (PluginRecord)checkRecord.clone();
                    editorID = String.format("TES4Gecko%08X", formID);
                    PluginGroup group = this.plugin.createTopGroup(recordType);
                    record.setFormID(formID);
                    record.setEditorID(editorID);
                    record.setParent(group);
                    group.getRecordList().add(record);
                    FormInfo cloneFormInfo = new FormInfo(record, recordType, formID, editorID);
                    cloneFormInfo.setPlugin(this.plugin);
                    this.plugin.getFormList().add(cloneFormInfo);
                    this.plugin.getFormMap().put(new Integer(formID), cloneFormInfo);
                    this.pluginModified = true;
                } else {
                    formID = this.getBaseFormID();
                }
            }
            this.worldspaceMap.put(new Integer(oldFormID), new Integer(formID));
            if (!Main.debugMode) continue;
            System.out.printf("Relocating %s record %s from %08X to %08X\n", formInfo.getRecordType(), formInfo.getEditorID(), oldFormID, formID);
        }
    }

    private int getBaseFormID() throws DataFormatException, IOException, PluginException {
        int formID = 0;
        boolean haveFormID = false;
        block0: while (!haveFormID) {
            if (this.baseFormID >= 0x1000000) {
                this.baseFormID = 0x200000;
            }
            ++this.baseFormID;
            haveFormID = true;
            Integer checkObj = new Integer(formID);
            int i = 0;
            while (i < this.masters.length) {
                if (this.masters[i].getFormMap().get(checkObj) != null) {
                    haveFormID = false;
                    continue block0;
                }
                ++i;
            }
        }
        return formID;
    }

    private void updateReferences() throws DataFormatException, IOException, PluginException {
        List<PluginGroup> groupList = this.plugin.getGroupList();
        int totalCount = groupList.size();
        int processedCount = 0;
        int currentProgress = 0;
        for (PluginGroup group : groupList) {
            this.updateGroupReferences(group);
            int newProgress = ++processedCount * 100 / totalCount;
            if (newProgress <= currentProgress + 5) continue;
            currentProgress = newProgress;
            this.getStatusDialog().updateProgress(currentProgress);
        }
    }

    void updateGroupReferences(PluginGroup group) throws DataFormatException, IOException, PluginException {
        List<PluginRecord> recordList = group.getRecordList();
        for (PluginRecord record : recordList) {
            int formID;
            Integer movedFormID;
            if (record instanceof PluginGroup) {
                int groupParentID;
                Integer movedFormID2;
                PluginGroup subgroup = (PluginGroup)record;
                this.updateGroupReferences(subgroup);
                if (subgroup.getGroupType() != 1 || (movedFormID2 = this.worldspaceMap.get(new Integer(groupParentID = subgroup.getGroupParentID()))) == null) continue;
                subgroup.setGroupParentID(movedFormID2);
                this.pluginModified = true;
                continue;
            }
            List<PluginSubrecord> subrecords = record.getSubrecords();
            boolean recordModified = false;
            for (PluginSubrecord subrecord : subrecords) {
                boolean subrecordModified = false;
                byte[] subrecordData = subrecord.getSubrecordData();
                int[][] references = subrecord.getReferences();
                if (references == null || references.length == 0) continue;
                int i = 0;
                while (i < references.length) {
                    Integer movedFormID3;
                    int offset = references[i][0];
                    int formID2 = references[i][1];
                    if (formID2 != 0 && (movedFormID3 = this.worldspaceMap.get(new Integer(formID2))) != null) {
                        SerializedElement.setInteger(movedFormID3, subrecordData, offset);
                        subrecordModified = true;
                    }
                    ++i;
                }
                if (!subrecordModified) continue;
                subrecord.setSubrecordData(subrecordData);
                recordModified = true;
            }
            if (recordModified) {
                record.setSubrecords(subrecords);
                this.pluginModified = true;
            }
            String recordType = record.getRecordType();
            String editorID = record.getEditorID();
            if (recordType.equals("BOOK") && editorID.length() == 17 && editorID.substring(0, 9).equals("TES4Gecko") || (movedFormID = this.worldspaceMap.get(new Integer(formID = record.getFormID()))) == null) continue;
            record.setFormID(movedFormID);
            this.pluginModified = true;
        }
    }

    private void updateDistantStatics(File dirFile) throws IOException {
        File[] files;
        File[] fileArray = files = dirFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            int length = (int)file.length();
            int pos = name.lastIndexOf(46);
            if (pos > 0 && name.substring(pos).equalsIgnoreCase(".lod") && length > 0 && (pos = name.indexOf(95)) > 0 && this.worldspaceNames.contains(name.substring(0, pos).toLowerCase())) {
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(file);
                    byte[] buffer = new byte[length];
                    int count = in.read(buffer);
                    if (count != length) {
                        throw new EOFException("Unexpected end-of-file on " + name);
                    }
                    in.close();
                    in = null;
                    boolean fileUpdated = false;
                    int referenceCount = SerializedElement.getInteger(buffer, 0);
                    int offset = 4;
                    int i = 0;
                    while (i < referenceCount) {
                        int formID = SerializedElement.getInteger(buffer, offset);
                        Integer movedFormID = this.worldspaceMap.get(new Integer(formID));
                        if (movedFormID != null) {
                            SerializedElement.setInteger(movedFormID, buffer, offset);
                            fileUpdated = true;
                        }
                        count = SerializedElement.getInteger(buffer, offset + 4);
                        offset += 8 + 28 * count;
                        ++i;
                    }
                    if (fileUpdated) {
                        out = new FileOutputStream(file);
                        out.write(buffer);
                        out.close();
                        out = null;
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
            ++n2;
        }
    }

    private void createPlaceholders() throws DataFormatException, IOException, PluginException {
        Map<Integer, FormInfo> formMap = this.plugin.getFormMap();
        PluginGroup group = this.plugin.createTopGroup("BOOK");
        List<PluginRecord> groupList = group.getRecordList();
        Set<Map.Entry<Integer, Integer>> mapSet = this.worldspaceMap.entrySet();
        for (Map.Entry<Integer, Integer> entry : mapSet) {
            int oldFormID = entry.getKey();
            int newFormID = entry.getValue();
            if (oldFormID >>> 24 < this.pluginIndex) continue;
            FormInfo formInfo = formMap.get(entry.getKey());
            if (formInfo != null) {
                String recordType = formInfo.getRecordType();
                String editorID = formInfo.getEditorID();
                if (recordType.equals("BOOK") && editorID.length() == 17 && editorID.substring(0, 9).equals("TES4Gecko")) continue;
            }
            ArrayList<PluginSubrecord> subrecords = new ArrayList<PluginSubrecord>(10);
            byte[] fullData = String.format("Moved %08X\u0000", oldFormID).getBytes();
            PluginSubrecord fullSubrecord = new PluginSubrecord("BOOK", "FULL", fullData);
            subrecords.add(fullSubrecord);
            byte[] descData = String.format("Moved %08X to %08X\u0000", oldFormID, newFormID).getBytes();
            PluginSubrecord descSubrecord = new PluginSubrecord("BOOK", "DESC", descData);
            subrecords.add(descSubrecord);
            byte[] dataData = new byte[]{1, -1, 0, 0, 0, 0, 0, 0, 0, 0};
            PluginSubrecord dataSubrecord = new PluginSubrecord("BOOK", "DATA", dataData);
            subrecords.add(dataSubrecord);
            byte[] modlData = "Clutter\\Books\\Scroll01.nif\u0000".getBytes();
            PluginSubrecord modlSubrecord = new PluginSubrecord("BOOK", "MODL", modlData);
            subrecords.add(modlSubrecord);
            byte[] modbData = new byte[]{-83, 60, -37, 65};
            PluginSubrecord modbSubrecord = new PluginSubrecord("BOOK", "MODB", modbData);
            subrecords.add(modbSubrecord);
            byte[] iconData = "Clutter\\IconScroll1.dds\u0000".getBytes();
            PluginSubrecord iconSubrecord = new PluginSubrecord("BOOK", "ICON", iconData);
            subrecords.add(iconSubrecord);
            PluginRecord record = new PluginRecord("BOOK", oldFormID);
            record.setSubrecords(subrecords);
            record.setEditorID(String.format("TES4Gecko%08X", newFormID));
            groupList.add(record);
            this.pluginModified = true;
            if (!Main.debugMode) continue;
            System.out.printf("Added %s record %s (%08X)\n", record.getRecordType(), record.getEditorID(), record.getFormID());
        }
    }

    private void renameFiles(File dirFile) {
        File[] files;
        File[] fileArray = files = dirFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            int sep;
            String fileName;
            File file = fileArray[n2];
            if (file.isFile() && Character.isDigit((fileName = file.getName()).charAt(0)) && (sep = fileName.indexOf(46)) > 0) {
                String prefix = fileName.substring(0, sep);
                try {
                    Integer checkID = new Integer(prefix);
                    Integer mappedID = this.worldspaceMap.get(checkID);
                    if (mappedID != null) {
                        String mappedFileName = String.valueOf(mappedID.toString()) + fileName.substring(sep);
                        File mappedFile = new File(String.valueOf(dirFile.getPath()) + Main.fileSeparator + mappedFileName);
                        if (!mappedFile.exists()) {
                            file.renameTo(mappedFile);
                            if (Main.debugMode) {
                                System.out.printf("Renamed %s to %s\n", file.getPath(), mappedFile.getPath());
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }
}

